

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBListForDeletedMP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBListForDeletedMP.sp,v $ $Id: MMGetDDBListForDeletedMP.sp,v 1.1.2.2 2020/06/24 05:44:47 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMGetDDBListForDeletedMP"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
    MountpathIds xml format
    <MountPathIdList><MountPath id=""/></MountPathIdList>
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetDDBListForDeletedMP')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDDBListForDeletedMP <<<'
	drop procedure MMGetDDBListForDeletedMP
END
IF EXISTS (select * from GxQscripts where name='MMGetDDBListForDeletedMP')
	delete from GxQscripts where name = 'MMGetDDBListForDeletedMP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBListForDeletedMP')
	delete from GXDBVersions where aliasname = 'MMGetDDBListForDeletedMP'
GO
print '... Creating Procedure: MMGetDDBListForDeletedMP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetDDBListForDeletedMP
  @i_MountpathXML XML
AS
  DECLARE @o_SIDBStoreId INTEGER
  DECLARE @o_CopyId INTEGER
  DECLARE @o_StoragePolicyId INTEGER
  DECLARE @o_HasReference INTEGER
DECLARE @MountPathsList TABLE(MountPathId INTEGER)
IF @i_MountpathXML.exist('/MountPathIdList') = 1
BEGIN
    INSERT INTO @MountPathsList
    SELECT T.item.value('@id','INT')
         FROM @i_MountpathXML.nodes('/MountPathIdList/MountPath') T(item)
END
DECLARE @DDBListForMP TABLE(SIDBStoreId INT, CopyId INT, StoragePolicyId INT, HasRef INT)
INSERT INTO @DDBListForMP
	SELECT DISTINCT SIDBStoreId, 0, 0, 0 FROM MMDeletedMPToDDB MP2DDB WITH (NOLOCK)
	INNER JOIN @MountPathsList TMP ON MP2DDB.MountpathId = TMP.MountPathId
UPDATE TMP
	SET TMP.CopyId = AGC.id,
	TMP.StoragePolicyId = AGC.archGroupId
FROM @DDBListForMP TMP
INNER JOIN archCopySIDBStore CS WITH(NOLOCK) ON TMP.SIDBStoreId = CS.SIDBStoreId
INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = CS.CopyId AND (AGC.dedupeFlags & 134217728) = 0
UPDATE TMP
	SET TMP.HasRef =  1
FROM @DDBListForMP TMP
INNER JOIN MMVolume MV WITH (NOLOCK) ON MV.SIDBStoreId = TMP.SIDBStoreId
SELECT * from @DDBListForMP
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBListForDeletedMP')
	delete from GxQscripts where name = 'MMGetDDBListForDeletedMP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBListForDeletedMP')
	delete from GXDBVersions where aliasname = 'MMGetDDBListForDeletedMP'
GO

insert into GXDBVersions values(2, 'MMGetDDBListForDeletedMP',  '00010001000200020000', 'MMGetDDBListForDeletedMP', '00010001000200020000')
GO

