

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBHostsWithoutDDBSubClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBHostsWithoutDDBSubClient.sp,v $ $Id: MMGetDDBHostsWithoutDDBSubClient.sp,v 1.5.198.6 2018/09/29 23:12:53 aselvanayagam Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetDDBHostsWithoutDDBSubClient <<<'

IF EXISTS (select * from sysobjects where name='MMGetDDBHostsWithoutDDBSubClient')
	drop procedure MMGetDDBHostsWithoutDDBSubClient
IF EXISTS (select * from GxQscripts where name='MMGetDDBHostsWithoutDDBSubClient')
	delete from GxQscripts where name = 'MMGetDDBHostsWithoutDDBSubClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBHostsWithoutDDBSubClient')
	delete from GXDBVersions where aliasname = 'MMGetDDBHostsWithoutDDBSubClient'
GO
print '... Creating Procedure: MMGetDDBHostsWithoutDDBSubClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDDBHostsWithoutDDBSubClient
  @i_CommCellId integer,
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MAClientId integer
  DECLARE @o_MAClientName nvarchar(256)
  DECLARE @o_subClientStatusFlag integer
  DECLARE @o_archGroupIdToAssign integer
  DECLARE @o_copyIdToAssign integer
	declare @l_DDBMAs table (ddbMAClientId integer, name nvarchar(max), subclientFlag integer, archGroupId integer, copyId integer)
    declare @assignSecCopy INT = 0
    SET @assignSecCopy = ISNULL((SELECT value FROM MMConfigs WITH (readuncommitted) WHERE name = 'MMCONFIG_DEDUP_DDB_SUBCLIENT_TO_SEC_COPY'), 0)
    insert into @l_DDBMAs
    select distinct substore.ClientId, '', 0, 0, 0
    from IdxSIDBSubStore substore with (readuncommitted)
    inner join IdxSIDBStore store with (readuncommitted) on substore.SIDBStoreId = store.SIDBStoreId
    inner join archCopySIDBStore archtostore with (readuncommitted) on store.SIDBStoreId = archtostore.SIDBStoreId
    inner join archGroupCopy AC with (readuncommitted) on archtostore.CopyId = AC.id
where (store.flags & 256) = 0 and store.SealedTime = 0
and (AC.dedupeFlags & (33554432 | 67108864)) > 0
	IF @assignSecCopy = 0
	BEGIN
	-- clean up those which already has DDB subclient configured.
	delete from @l_DDBMAs where ddbMAClientId IN (
    select T.ddbMAClientId--distinct ddbMAClientId, CL.name
    from @l_DDBMAs T
		inner join APP_client CL with (readuncommitted) on T.ddbMAClientId = CL.id
		inner join APP_Application APP with (readuncommitted) on APP.clientId = CL.id
		inner join APP_SubClientProp ASCP with (readuncommitted) on APP.id = ASCP.componentNameId AND ASCP.attrName = 'DDB Backup' and ASCP.attrVal = 1
		left outer join APP_SubClientProp ASCP1 with (readuncommitted) on APP.id = ASCP1.componentNameId AND ASCP1.attrName = 'DDB Backup SubClient Type'
	WHERE  (
APP.subclientStatus & (CAST(0x00002 AS int) | CAST(0x00004 AS int)) = 0
	AND CL.releaseId > 13
	AND APP.dataArchGrpID > 1
	AND ((ASCP1.id IS NULL) OR (ASCP1.attrVal = 0))
	)
	OR CL.releaseId <= 13 	-- not to consider pre 9.0 version MAs
	)
	END
	ELSE
	BEGIN
		delete T
		FROM @l_DDBMAs T
			INNER JOIN APP_Client CL WITH (READUNCOMMITTED) ON T.ddbMAClientId = CL.id
			INNER JOIN APP_Application APP WITH (READUNCOMMITTED) ON APP.clientId = CL.id
			INNER JOIN APP_SubClientProp ASCP WITH (READUNCOMMITTED) on APP.id = ASCP.componentNameId AND ASCP.attrName = 'DDB Backup' and ASCP.attrVal = 1
			LEFT OUTER JOIN APP_SubClientProp ASCP1 WITH (READUNCOMMITTED) on APP.id = ASCP1.componentNameId AND ASCP1.attrName = 'DDB Backup SubClient Type'
			LEFT OUTER JOIN APP_SubClientProp ASCCopy WITH (READUNCOMMITTED) on APP.id = ASCCopy.componentNameId AND ASCCopy.attrName = 'DDB Backup CopyId'
			LEFT OUTER JOIN archGroupCopy C WITH (READUNCOMMITTED) ON ASCCopy.attrVal = C.id
WHERE (APP.subclientStatus & (CAST(0x00002 AS int) | CAST(0x00004 AS int)) = 0
		AND CL.releaseId > 13
		AND ((APP.dataArchGrpID > 1 AND ASCCopy.id IS NULL)
			OR (APP.dataArchGrpID > 1 AND ASCCopy.id IS NOT NULL AND C.id IS NOT NULL))
		AND ((ASCP1.id IS NULL) OR (ASCP1.attrVal = 0))
		)
		OR CL.releaseId <= 13  -- not to consider pre 9.0 version MAs
	END
	update @l_DDBMAs
	set name = AC.name
	from @l_DDBMAs T, APP_Client AC with (readuncommitted)
	where T.ddbMAClientId = AC.id
	update @l_DDBMAs
	set subclientFlag = 1
	from @l_DDBMAs T, APP_Application APP with (readuncommitted), APP_SubClientProp SC with (readuncommitted)
	where T.ddbMAClientId = APP.clientId
	and APP.id = SC.componentNameId
	and SC.attrName = 'DDB Backup'
	and SC.attrVal = 1
	and APP.dataArchGrpID = 1
	and APP.subclientStatus = 0
	update @l_DDBMAs
	set archGroupId = AG.id
	from @l_DDBMAs T
	inner join IdxSIDBSubStore substore with (readuncommitted) on T.ddbMAClientId = substore.ClientId
    	inner join archCopySIDBStore archtostore with (readuncommitted) on substore.SIDBStoreId = archtostore.SIDBStoreId
    	inner join archGroupCopy AC with (readuncommitted) on archtostore.CopyId = AC.id
    	inner join archGroup AG with (readuncommitted) on AG.id = AC.archGroupId
where AC.dedupeFlags & 268435456 = 0 and AC.id = AG.defaultCopy
AND AG.flags & (64 | 262144 |1 | 16384 | 256 | 8388608) = 0
AND AG.type = 1
	update @l_DDBMAs
	set archGroupId = AG.id
	from @l_DDBMAs T
	inner join MMDataPath M with (readuncommitted) on T.ddbMAClientId = M.HostClientId
	inner join archGroupCopy AC with (readuncommitted) on M.CopyId = AC.id
	inner join archGroup AG with (readuncommitted) on AG.id = AC.archGroupId
where AC.dedupeFlags & 268435456 = 0 and AC.id = AG.defaultCopy
AND AG.flags & (64 | 262144 |1 | 16384 | 256 | 8388608) = 0
AND M.Flag & (4) > 0
AND AG.type = 1
	AND T.archGroupId = 0
	IF @assignSecCopy > 0
	BEGIN
		UPDATE @l_DDBMAs
		SET archGroupId = AC.archGroupId,
		copyId = AC.id
		FROM @l_DDBMAs T
		INNER JOIN IdxSIDBSubStore S WITH (READUNCOMMITTED) ON T.ddbMAClientId = S.ClientId
		INNER JOIN archCopySIDBStore CS WITH (READUNCOMMITTED) ON S.SIDBStoreId = CS.SIDBStoreId
		INNER JOIN archGroupCopy AC WITH (READUNCOMMITTED) ON CS.CopyId = AC.id
		INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON AC.archGroupId = AG.id
WHERE AC.dedupeFlags & 268435456 = 0
AND AG.flags & (64 | 262144 |1 | 16384 | 256 | 8388608) = 0
AND AG.type = 1
AND (AC.type = 1 OR AC.type = 2)
AND AC.flags & 524288 = 0
		AND T.archGroupId = 0
		-- Give preference to LAN Free?
		UPDATE @l_DDBMAs
		SET archGroupId = AC.archGroupId,
		copyId = AC.id
		FROM @l_DDBMAs T
		INNER JOIN MMDataPath M WITH (READUNCOMMITTED) ON T.ddbMAClientId = M.HostClientId
		INNER JOIN archGroupCopy AC WITH (READUNCOMMITTED) ON M.CopyId = AC.id
		INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON AC.archGroupId = AG.id
WHERE AC.dedupeFlags & 268435456 = 0
AND AG.flags & (64 | 262144 |1 | 16384 | 256 | 8388608) = 0
AND M.Flag & (4) > 0
AND AG.type = 1
AND (AC.type = 1 OR AC.type = 2)
AND AC.flags & 524288 = 0
		AND T.archGroupId = 0
	END
	select * from @l_DDBMAs
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBHostsWithoutDDBSubClient')
	delete from GxQscripts where name = 'MMGetDDBHostsWithoutDDBSubClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBHostsWithoutDDBSubClient')
	delete from GXDBVersions where aliasname = 'MMGetDDBHostsWithoutDDBSubClient'
GO

insert into GXDBVersions values(2, 'MMGetDDBHostsWithoutDDBSubClient',  '00010005019800060000', 'MMGetDDBHostsWithoutDDBSubClient', '00010005019800060000')
GO

