

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBEnginesONMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBEnginesONMA.sp,v $ $Id: MMGetDDBEnginesONMA.sp,v 1.2.198.4 2018/03/20 00:09:20 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMGetDDBEnginesONMA"
--	|
--	| This is for getting a list of associated Dedup partitions On MA
--	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetDDBEnginesONMA <<<'

IF EXISTS (select * from sysobjects where name='MMGetDDBEnginesONMA')
	drop procedure MMGetDDBEnginesONMA
IF EXISTS (select * from GxQscripts where name='MMGetDDBEnginesONMA')
	delete from GxQscripts where name = 'MMGetDDBEnginesONMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBEnginesONMA')
	delete from GXDBVersions where aliasname = 'MMGetDDBEnginesONMA'
GO
print '... Creating Procedure: MMGetDDBEnginesONMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDDBEnginesONMA
  @hostClientId integer,
  @commcellId integer
AS
  DECLARE @sidbStoreId integer	
  DECLARE @sealedTime integer
  DECLARE @archGroupId integer
  DECLARE @archCopyId integer
  DECLARE @freeSpaceInMB bigint
  DECLARE @archGroupName NVARCHAR(255)
  DECLARE @archGroupCopyName NVARCHAR(255)
  DECLARE @ddbPath NVARCHAR(255)
		DECLARE @DDBEnginesOnMA TABLE (
			sidbStoreId integer,
			sealedTime integer,
			archGroupId integer,
			archCopyId integer,
			freeSpaceInMB bigint,
			archGroupName NVARCHAR(255),
			archGroupCopyName NVARCHAR(255),
			ddbPath NVARCHAR(255)
			)
	DECLARE @hiddenSPtbl TABLE (
	        archGroupId  INTEGER)
	DECLARE  @showHiddenSPConfig INTEGER = 0
	----------------------------------------------
	-- Get 'MMCONFIG_SHOW_HIDDEN_STORAGE_POLICIES' value from MMConfigs
	----------------------------------------------
	SELECT @showHiddenSPConfig = value
    FROM    MMConfigs WITH (NOLOCK)
    WHERE NAME = 'MMCONFIG_SHOW_HIDDEN_STORAGE_POLICIES' AND nConfigSubSystemId = 1
	-- Insert all SIDBS based on HostId
	INSERT INTO  @DDBEnginesOnMA
	SELECT b.SIDBStoreId,b.SealedTime,0,0, j.FreeDiskSpaceMB,'','',a.Path
	FROM IdxAccessPath a WITH (NOLOCK), idxsidbsubstore b WITH (NOLOCK),IdxCache j WITH (NOLOCK)
	WHERE a.ClientId = @hostClientId
	AND b.IdxAccessPathId = a.IdxAccessPathId
	AND b.IdxCacheId = j.IdxCacheId
	AND b.commCellId = @commcellId
	-- Setting CopyId,CopyName,StoragePolicyId
	UPDATE @DDBEnginesOnMA
	SET archCopyId = b.CopyId,
		archGroupCopyName = C.name ,
		archGroupId = c.archGroupId,
		archGroupName = archGroup.name
	FROM @DDBEnginesOnMA a, archCopySIDBStore b WITH (NOLOCK), archGroupCopy c WITH (NOLOCK), archGroup archGroup WITH (NOLOCK)
	WHERE a.sidbStoreId = b.SIDBStoreId AND b.CopyId =c.id AND c.archGroupId = archgroup.id
AND (c.dedupeFlags & 134217728 = 0)
	IF @showHiddenSPConfig = 0
	BEGIN
	   INSERT INTO @hiddenSPtbl
SELECT id from archGroup WITH (NOLOCK) INNER JOIN @DDBEnginesOnMA ON id=archGroupId AND flags&64 > 0
	   -- Delete Store of hidden storage policies
	   DELETE FROM @DDBEnginesOnMA WHERE archGroupId IN(SELECT archGroupId FROM @hiddenSPtbl)
	END
	SELECT * FROM 	@DDBEnginesOnMA
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBEnginesONMA')
	delete from GxQscripts where name = 'MMGetDDBEnginesONMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBEnginesONMA')
	delete from GXDBVersions where aliasname = 'MMGetDDBEnginesONMA'
GO

insert into GXDBVersions values(2, 'MMGetDDBEnginesONMA',  '00010002019800040000', 'MMGetDDBEnginesONMA', '00010002019800040000')
GO

