

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBEngines.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBEngines.sp,v $ $Id: MMGetDDBEngines.sp,v 1.17.12.33 2020/08/21 16:13:05 pveeravalli Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetDDBEngines')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDDBEngines <<<'
	drop procedure MMGetDDBEngines
END
IF EXISTS (select * from GxQscripts where name='MMGetDDBEngines')
	delete from GxQscripts where name = 'MMGetDDBEngines'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBEngines')
	delete from GXDBVersions where aliasname = 'MMGetDDBEngines'
GO
print '... Creating Procedure: MMGetDDBEngines'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDDBEngines
  @i_userId int,
  @i_propertyLevel int=0,
  @i_storagepolicyId int=0,
  @i_copyId int=0,
  @i_SIDBStoreId int=0,
  @i_flags int=0
AS
  DECLARE @o_CommCellId integer
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBStoreName NVARCHAR(256)
  DECLARE @o_SIDBStoreAliasName NVARCHAR(256)
  DECLARE @o_spId integer
  DECLARE @o_spName NVARCHAR(255)
  DECLARE @o_copyId integer
  DECLARE @o_copyName NVARCHAR(64)
  DECLARE @o_totalDataSize bigint
  DECLARE @o_sizeOnMedia bigint
  DECLARE @o_totalAppSize bigint
  DECLARE @o_deDupSavingSize bigint
  DECLARE @o_pendingLogicalPruning integer
  DECLARE @o_MaintenanceReason integer
  DECLARE @o_jobCount integer
  DECLARE @o_baseLineSize bigint
  DECLARE @o_freeSpaceOnLibrary bigint
  DECLARE @o_retentionDaysForCopy integer
  DECLARE @o_retentionCycleForCopy integer
  DECLARE @o_copyMediaAgentId integer
  DECLARE @o_SealedTime integer
  DECLARE @o_CreatedTime integer
  DECLARE @o_NumPartitions integer
  DECLARE @o_AvgQITime bigint
  DECLARE @o_UniqueBlocks bigint
  DECLARE @o_DedupeFlags integer
  DECLARE @o_primaryRecordsPercentage integer
  DECLARE @o_ddbVersion integer
  DECLARE @o_MaxAvgQITime bigint
  DECLARE @o_StoreFlags int
  DECLARE @o_DDBLimitFlag int
  DECLARE @o_AvgQITime14Days int
  DECLARE @o_maxAllowedConnections integer
  DECLARE @o_DDB_LastVerifiedOn integer
  DECLARE @o_DDB_JobsLastVerifiedOn integer
  DECLARE @o_ApplicationBaselineSize bigint
  DECLARE @o_SizeOfFragmentedSpace bigint
  DECLARE @o_ActiveStreams integer
  DECLARE @o_EnableAfterDelayTimeZone integer
  DECLARE @o_EnableAfterDelayTime integer
  DECLARE @o_SizeOffDiskMB bigint
  DECLARE @o_SizeToBeInSiloMB bigint
  DECLARE @o_SizeInSiloMB bigint
  DECLARE @o_SizeOfBackup bigint
  DECLARE @o_deDupSavingPercent varchar(20)
  DECLARE @o_extendedFlags bigint
  DECLARE @o_TotalSizeOfUniqueBlocks bigint
SET NOCOUNT ON
	IF @i_SIDBStoreId > 0 AND @i_copyId = 0
		SELECT 	@i_copyId = copyId
		FROM 	ArchGroupCopy AGC WITH(READUNCOMMITTED),
				ArchCopySIDBStore ACS WITH(READUNCOMMITTED)
		WHERE 	ACS.SIDBStoreId = @i_SIDBStoreId
				AND AGC.id = ACS.copyId
AND	AGC.dedupeFlags & 134217728 = 0
	IF @i_copyId > 0 AND @i_storagePolicyId = 0
		SELECT @i_storagePolicyId = archGroupId FROM ArchGroupCopy WITH(READUNCOMMITTED) WHERE id = @i_copyId
	IF @i_propertyLevel = 0
		SET @i_propertyLevel = 30
	----------------------------------------------
	--------------- Security Check ---------------
	----------------------------------------------
	IF OBJECT_ID('tempdb..#lt_StoragePolicies') IS NOT NULL DROP TABLE #lt_StoragePolicies
	CREATE TABLE #lt_StoragePolicies (StoragePolicyId INT)
	IF @i_userId > 0
	BEGIN
		IF @i_storagepolicyId > 0
		BEGIN
			DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @i_userId, 0, @userHasCapability OUTPUT, 17, @i_storagepolicyId
			IF @userHasCapability = 0
				RETURN
			INSERT INTO #lt_StoragePolicies
			SELECT @i_storagepolicyId
		END
		ELSE
		BEGIN
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 17, 0, '#lt_StoragePolicies'
			IF NOT EXISTS(SELECT 1 FROM #lt_StoragePolicies)
				RETURN
		END
	END
	----------------------------------------------
	-- Get 'MMCONFIG_SHOW_HIDDEN_STORAGE_POLICIES' value from MMConfigs
	----------------------------------------------
	DECLARE @showHiddenSPConfig INT = 0
	SELECT @showHiddenSPConfig = value
    FROM    MMConfigs WITH (NOLOCK)
    WHERE NAME = 'MMCONFIG_SHOW_HIDDEN_STORAGE_POLICIES'
	IF object_id('tempdb.dbo.#tblSIDBStore') is not null DROP TABLE #tblSIDBStore
	IF object_id('tempdb.dbo.#tblStores') is not null DROP TABLE #tblStores
	CREATE TABLE #tblSIDBStore (
		  CommCellId 			int 	DEFAULT 0,
		  SIDBStoreId 			int 	DEFAULT 0,
SIDBStoreName 		nvarchar(256) 	DEFAULT '',
SIDBStoreAliasName 	nvarchar(256) 	DEFAULT '',
		  copyId 				int,
copyName  			nvarchar(64),
		  archGroupId 			integer,
		  archGroupName 		nvarchar(256),
		  GDSPId				int 	DEFAULT 0,
		  dedupeFlags  			integer DEFAULT 0,
		  CopyExtendedFlags		INT		DEFAULT 0,
		  totalDataSize 		bigint 	DEFAULT 0,
		  sizeOnMedia 			bigint 	DEFAULT 0,
		  Flags 				INT 	DEFAULT 0,
		  MaintenanceReason 	INT 	DEFAULT 0,
		  freeSpaceOnLibrary 	BIGINT 	DEFAULT 0,
		  baseLineSize 			BIGINT 	DEFAULT 0,
		  retentionDaysForCopy 	INT 	DEFAULT 0,
		  retentionCyclesForCopy INT 	DEFAULT 0,
		  sealedTime    		INT 	DEFAULT 0,
		  copyMediaAgentId 		INT 	DEFAULT 0,
		  totalAppSize 			BIGINT 	DEFAULT 0,
		  deDupSavingSize 		BIGINT 	DEFAULT 0,
		  deletedAFCount 		INT 	DEFAULT 0,
		  jobCount 				INT 	DEFAULT 0,
		  CreatedTime 			INT 	DEFAULT 0,
		  SubstoreCount 		INT 	DEFAULT 0,
		  AvgQITime 			INT 	DEFAULT 0,
		  AvgQITime14Days 		INT 	DEFAULT 0,
		  MaxAvgQITime 			INT 	DEFAULT 0,
		  UniqueBlocks 			BIGINT 	DEFAULT 0,
		  PrimaryRecPercent		INT		DEFAULT 0,
		  Version				INT		DEFAULT 0,
		  LimitFlag				INT		DEFAULT 0,
		  MaxAllowedConnections	INT		DEFAULT 0,
		  LastVerifiedOn		BIGINT	DEFAULT 0,
		  JobsLastVerifiedOn	BIGINT	DEFAULT 0,
		  AppBaselineSize		BIGINT	DEFAULT 0,
		  SizeOfFragmentedSpace BIGINT	DEFAULT 0,
		  ActiveStreams			INT		DEFAULT 0,
		  TotalDataSizeBytes	BIGINT	DEFAULT 0,
		  EnableAfterDelayTimeZone INT	DEFAULT 0,
		  EnableAfterDelayTime	INT		DEFAULT 0,
		  SizeOffDiskMB			BIGINT 	DEFAULT 0,
		  SizeToBeInSiloMB		BIGINT 	DEFAULT 0,
		  SizeInSiloMB			BIGINT 	DEFAULT 0,
		  SizeOfBackup			BIGINT	DEFAULT 0,
		  deDupSavingPercent	VARCHAR(20)	DEFAULT '0',
		  extendedFlags 		BIGINT DEFAULT 0,
		  AppTypeGroupId 		INT		DEFAULT 0,
		  TotalSizeOfUniqueBlocks       BIGINT	DEFAULT 0,
		  primary key (SIDBStoreId, copyId)
	)
	CREATE TABLE #tblStores(
		  SIDBStoreId INT, SealedTime INT, primary key (SIDBStoreId)
	)
	--
	-- Get the list of dedupe copies
	--
	INSERT INTO #tblSIDBStore (copyId, copyName, archGroupId, archGroupName, dedupeFlags, CopyExtendedFlags)
	SELECT 	AGC.id, AGC.name, AG.id, AG.name, AGC.dedupeFlags, AGC.extendedFlags
	FROM 	archGroupCopy AGC WITH (READUNCOMMITTED),
			archGroup AG WITH (READUNCOMMITTED)
	WHERE 	AGC.archGroupId = AG.id
AND		AGC.type <> 5
AND		AGC.dedupeFlags & 262144 > 0
AND		AGC.dedupeFlags & 134217728 = 0
	AND		( @i_storagePolicyId = 0 OR AG.id = @i_storagePolicyId )
	AND		( @i_copyId = 0 OR AGC.id = @i_copyId )
AND		( @showHiddenSPConfig > 0 OR ( @showHiddenSPConfig = 0 AND AG.flags & 64 = 0 ))
	AND		( @i_SIDBStoreId = 0 OR EXISTS(SELECT 1 FROM ArchCopySIDBStore WITH(READUNCOMMITTED) WHERE SIDBStoreId = @i_SIDBStoreId AND copyId = AGC.id ))
	AND		( @i_userId = 0 OR EXISTS(SELECT 1 FROM #lt_StoragePolicies SEC WHERE AG.id = SEC.StoragePolicyId) )
	IF @i_propertyLevel = 1 /*App_ListPropertyLevels::ListOnly*/
	BEGIN
		--
		-- Get Maintenance Reason
		--
		UPDATE 	#tblSIDBStore
		SET 	MaintenanceReason = T.MaintenanceReason
		FROM	#tblSIDBStore ST,
				(
					SELECT	C.copyId, MAX(intVal) MaintenanceReason
					FROM  	#tblSIDBStore C
							INNER JOIN archCopySIDBStore CS WITH(READUNCOMMITTED) ON C.copyId = CS.copyId
							INNER JOIN IdxSIDBStore STORE WITH(READUNCOMMITTED)	ON CS.SIDBStoreId = STORE.SIDBStoreId
							LEFT JOIN MMEntityProp PROP WITH (READUNCOMMITTED)
								ON PROP.EntityId = STORE.SIDBStoreId AND
PROP.EntityType = 3 AND
									PROP.PropertyName = 'DDBMaintenanceReason' AND
									PROP.CommcellId = 2
WHERE	STORE.Flags & 16777216 > 0
AND STORE.Flags & 33554432 = 0
AND PROP.intVal IN (1, 3)
					GROUP BY C.copyId
				) T
		WHERE	ST.copyId = T.copyId
	END
	ELSE IF 	@i_propertyLevel > 1 /*App_ListPropertyLevels::ListOnly*/
	BEGIN
IF 	@i_flags & 2 > 0
		BEGIN
			--
			-- Get MediaAgentId
			--
			UPDATE 	S
			SET		copyMediaAgentId = DPool.clientId
			FROM	#tblSIDBStore S,
					MMDataPath DPath WITH(READUNCOMMITTED),
					MMDrivePool DPool WITH(READUNCOMMITTED)
			WHERE	S.CopyId = DPath.copyId
AND DPath.flag & 1 > 0
					AND DPath.DrivePoolId = DPool.DrivePoolId
		END
		DECLARE @l_MaxAllowedConnections INT =
		(
			select value
			from MMConfigs WITH (READUNCOMMITTED)
			where name = 'MMCONFIG_RESOURCEMANAGER_MAXIMUM_ALLOWED_CONNECTION_PER_DDB'
		)
		--
		-- Get the list of Stores
		--
		INSERT INTO #tblSIDBStore(commCellid, SIDBStoreId, SIDBStoreName, SIDBStoreAliasName,
				copyId, copyName, archGroupId, archGroupName, dedupeFlags, LimitFlag,
				Flags, MaintenanceReason, SealedTime, CreatedTime,
				SubStoreCount, MaxAllowedConnections,
				Version,
				LastVerifiedOn, JobsLastVerifiedOn, copyMediaAgentId, TotalDataSizeBytes, extendedFlags, AppTypeGroupId)
		SELECT 	S.commCellId, S.SIDBStoreId, S.SIDBStoreName, S.SIDBStoreAliasName,
T.copyId, T.copyName, T.archGroupId, T.archGroupName, T.dedupeFlags, SIGN(T.copyExtendedFlags & 128),
S.Flags, 0, S.SealedTime, S.CreatedTime,
				S.SubstoreCount, ISNULL(NULLIF(S.MaxAllowedConnections, 0), @l_MaxAllowedConnections),
				CASE
					WHEN S.version < 2 THEN
						CASE WHEN S.version = -1 THEN S.version
						WHEN S.version =  0 OR S.version = 1 THEN 8
						END
					ELSE
						S.Version+7
				END,
				S.LastDDBVerificationTime, S.LastDataVerificationTime,T.copyMediaAgentId, S.TotalDataSizeBytes, S.extendedFlags, S.AppTypeGroupId
		FROM 	#tblSIDBStore T, archCopySIDBStore ACS WITH (READUNCOMMITTED),
				IdxSIDBStore S WITH (READUNCOMMITTED)
		WHERE 	T.copyId = ACS.CopyId
		AND		ACS.SIDBStoreId = S.SIDBStoreId
		AND		( @i_SIDBStoreId = 0 OR ACS.SIDBStoreId = @i_SIDBStoreId )
AND 	( @i_flags & 32768 = 0 OR S.SealedTime > 0)
		IF @@ROWCOUNT = 0
			RETURN
IF 	@i_flags & 1 > 0
		BEGIN
			--
			-- Get list of copies for which user has visibility
			-- Get dependent copies..used in copy level summary page
			--
		   IF OBJECT_ID('tempdb..#lt_StoragePolicyCopies') IS NOT NULL DROP TABLE #lt_StoragePolicyCopies
		      CREATE TABLE #lt_StoragePolicyCopies (CopyId INT)
		       IF @i_userId > 0
			      BEGIN
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 18, 0, '#lt_StoragePolicyCopies'
				  END
			INSERT INTO #tblSIDBStore(commCellid, SIDBStoreId, SIDBStoreName, SIDBStoreAliasName,
					copyId, copyName, archGroupId, archGroupName, dedupeFlags, LimitFlag,
					Flags, MaintenanceReason, SealedTime, CreatedTime,
					SubStoreCount, MaxAllowedConnections, Version,
					LastVerifiedOn, JobsLastVerifiedOn, copyMediaAgentId, TotalDataSizeBytes)
			SELECT 	S.commCellId, S.SIDBStoreId, S.SIDBStoreName, S.SIDBStoreAliasName,
					AGC.id copyId, AGC.name copyName, AG.id archGroupId, AG.name archGroupName, AGC.dedupeFlags, S.LimitFlag,
					S.Flags, S.MaintenanceReason, S.SealedTime, S.CreatedTime,
					S.SubstoreCount, S.MaxAllowedConnections, S.Version,
					S.LastVerifiedOn, S.JobsLastVerifiedOn, S.copyMediaAgentId, S.TotalDataSizeBytes
			FROM 	#tblSIDBStore S,#lt_StoragePolicyCopies lt,
					archCopySIDBStore GP WITH (READUNCOMMITTED),
					archGroupCopy AGC WITH (READUNCOMMITTED),
					archGroup AG WITH (READUNCOMMITTED)
			WHERE 	S.SIDBStoreId = GP.SIDBStoreId
					AND GP.copyId = lt.CopyId
AND S.dedupeFlags & 268435456 > 0
					AND GP.copyId = AGC.id
					AND AGC.archGroupId = AG.id
AND	AGC.dedupeFlags & 134217728 > 0
					AND S.SIDBStoreId > 0
		IF OBJECT_ID('tempdb..#lt_StoragePolicyCopies') IS NOT NULL DROP TABLE #lt_StoragePolicyCopies
		END
		INSERT INTO #tblStores
		SELECT SIDBStoreId, SealedTime
		FROM	#tblSIDBStore
		WHERE	SIDBStoreId > 0
		GROUP BY SIDBStoreId, SealedTime
IF 	@i_flags & 4 > 0
		BEGIN
			--
			-- Get Maintenance Reason
			--
			UPDATE #tblSIDBStore
			SET MaintenanceReason = (
				CASE
				-- Store is not in maintenance or already marked for resync. Disable the GUI option to resync
WHEN (STORE.Flags & 16777216) = 0
					-- MaintenanceReason - Naming is a little ugly.
					-- When the store is marked for resync, a maintenance reason will definitely be there.
					-- But IDX_SIDBSTORE_MAINTENANCE_REASON_INVALID is being returned.
					-- Basically MaintenanceReason is used to show if there are any stores that can be marked for resync.
					-- Because a store doesnt have to be marked for resync again when it already was marked,
					-- IDX_SIDBSTORE_MAINTENANCE_REASON_INVALID is sent up.
OR (STORE.Flags & 33554432) <> 0	THEN 0
				-- Maintenance reason allows resync. Enable the GUI option.
WHEN PROP.intVal IN (1, 3)
																						THEN PROP.intVal
				-- Partial state. Store is in maintenance. But there is no reason. Disable the GUI option.
WHEN PROP.intVal IS NULL												THEN 0
				-- None of the above. Disable the GUI option.
ELSE																	0
				END)
			FROM  #tblSIDBStore STORE LEFT JOIN MMEntityProp PROP WITH (READUNCOMMITTED)
				ON PROP.EntityId = STORE.SIDBStoreId AND
PROP.EntityType = 3 AND
					PROP.PropertyName = 'DDBMaintenanceReason' AND
					PROP.CommcellId = 2
			WHERE	STORE.SIDBStoreId > 0
		END
IF 	@i_flags & 8 > 0
		BEGIN
			--
			-- Get Size On Disk
			--
			IF object_id('tempdb.dbo.#tblSidbSizeInfo') is not null DROP TABLE #tblSidbSizeInfo
			CREATE TABLE #tblSidbSizeInfo
			(SIDBStoreId int,
			 copyId int,
			 totalDataSizeMB bigint,
			 sizeOffDiskMB bigint,
			 SizeToBeInSiloMB bigint,
			 SizeInSiloMB bigint,
			 primary key (SIDBStoreId, copyId))
			INSERT INTO #tblSidbSizeInfo
			SELECT  V.SIDBStoreId,
					ISNULL(ST.archGroupCopyId, 0),
					SUM(CAST(V.PhysicalBytesMB AS BIGINT)),
					SUM(CASE WHEN V.SiloStatus = 3 THEN CAST(V.PhysicalBytesMB AS BIGINT) ELSE 0 END),
					SUM(CASE WHEN V.SiloStatus = 1 THEN CAST(V.PhysicalBytesMB AS BIGINT) ELSE 0 END),
					SUM(CASE WHEN V.SiloStatus = 2 THEN CAST(V.PhysicalBytesMB AS BIGINT) ELSE 0 END)
			FROM 	MMVolume V WITH (READUNCOMMITTED)
					INNER JOIN #tblStores S ON  V.SIDBStoreId = S.SIDBStoreId
					LEFT OUTER JOIN archStream ST ON V.MediaGroupId = ST.MediaGroupId
			WHERE 	V.PhysicalBytesMB > 0
			GROUP BY V.SIDBStoreId, ST.archGroupCopyId
			IF @i_SIDBStoreId > 0
			BEGIN
				--
				-- Size for GDSP and standalone copies
				--
				UPDATE 	S
				SET 	totalDataSize = B.totalDataSizeMB* 1024 * 1024 ,
						sizeOnMedia = (B.totalDataSizeMB - B.sizeOffDiskMB) * 1024 * 1024,
						SizeOffDiskMB = B.SizeOffDiskMB,
						SizeToBeInSiloMB = B.SizeToBeInSiloMB,
						SizeInSiloMB = B.SizeInSiloMB,
						SizeOfFragmentedSpace =
						(
CASE WHEN S.Flags & 2097152 > 0 THEN -1
								WHEN (B.totalDataSizeMB - S.TotalDataSizeBytes/1024.0/1024.0) < 0 THEN 0
								ELSE (B.totalDataSizeMB - S.TotalDataSizeBytes/1024.0/1024.0)
							END
						)
				FROM 	#tblSIDBStore S,
						(
							SELECT	SIDBStoreId,
									SUM(totalDataSizeMB) totalDataSizeMB,
									SUM(sizeOffDiskMB) sizeOffDiskMB,
									SUM(SizeToBeInSiloMB) SizeToBeInSiloMB,
									SUM(SizeInSiloMB) SizeInSiloMB
							FROM 	#tblSidbSizeInfo
							GROUP BY SIDBStoreId
						) B
				WHERE 	S.SIDBStoreId = B.SIDBStoreId
AND S.dedupeFlags & 134217728 = 0
			END
			ELSE
			BEGIN
				--
				-- Size for GDSP and standalone copies
				--
				UPDATE 	S
				SET 	totalDataSize = B.totalDataSizeMB* 1024 * 1024 ,
						sizeOnMedia = (B.totalDataSizeMB - B.sizeOffDiskMB) * 1024 * 1024,
						SizeOffDiskMB = B.SizeOffDiskMB,
						SizeToBeInSiloMB = B.SizeToBeInSiloMB,
						SizeInSiloMB = B.SizeInSiloMB
				FROM 	#tblSIDBStore S,
						(
							SELECT	SIDBStoreId,
									SUM(totalDataSizeMB) totalDataSizeMB,
									SUM(sizeOffDiskMB) sizeOffDiskMB,
									SUM(SizeToBeInSiloMB) SizeToBeInSiloMB,
									SUM(SizeInSiloMB) SizeInSiloMB
							FROM 	#tblSidbSizeInfo
							GROUP BY SIDBStoreId
						) B
				WHERE 	S.SIDBStoreId = B.SIDBStoreId
AND S.dedupeFlags & 134217728 = 0
IF 	@i_flags & 1 > 0
				BEGIN
					--
					-- Size for dependent copies
					--
					UPDATE 	S
					SET 	totalDataSize = B.totalDataSizeMB* 1024 * 1024 ,
							sizeOnMedia = (B.totalDataSizeMB - B.sizeOffDiskMB) * 1024 * 1024,
							SizeOffDiskMB = B.SizeOffDiskMB,
							SizeToBeInSiloMB = B.SizeToBeInSiloMB,
							SizeInSiloMB = B.SizeInSiloMB
					FROM 	#tblSIDBStore S, #tblSidbSizeInfo B
					WHERE 	S.SIDBStoreId = B.SIDBStoreId
							AND S.copyId = B.copyId
AND S.dedupeFlags & 134217728 > 0
				END
			END
		END
IF 	@i_flags & 16 > 0
		BEGIN
			--
			-- Get App Size
			--
			IF object_id('tempdb.dbo.#tblSiloApps') is not null DROP TABLE #tblSiloApps
			IF object_id('tempdb.dbo.#tblSIDBJob') is not null DROP TABLE #tblSIDBJob
			IF object_id('tempdb.dbo.#tmpJobSizeInfo') is not null DROP TABLE #tmpJobSizeInfo
			CREATE TABLE #tblSiloApps(
              SiloAppId INT, primary key (SiloAppId)
            )
			CREATE TABLE #tblSIDBJob (
              JobId int,
              CommCellId int,
              SIDBStoreId int,
			  copyId int,
              totalAppSize bigint,
              totalBackupSize BIGINT,
			  deDupSavingSize BIGINT,
              Primary Key (JobId, CommCellId, SIDBStoreId, copyId)
            )
			CREATE TABLE #tmpJobSizeInfo (
			  JobId INT,
              CommCellId INT,
              totalBackupSize BIGINT,
              totalAppSize BIGINT,
              totalIndexSize BIGINT
			  PRIMARY KEY (JobId, CommCellId)
			)
			INSERT 	INTO #tblSiloApps
			SELECT 	AGC.siloAppId
			FROM 	archGroupCopy AGC WITH (READUNCOMMITTED), #tblStores S, archCopySIDBStore ACS WITH (READUNCOMMITTED)
			WHERE  	AGC.siloAppId > 0
					AND AGC.id = ACS.copyId
					AND ACS.SIDBStoreId = S.SIDBStoreId
			GROUP BY AGC.siloAppId
			INSERT 	INTO #tblSIDBJob
			SELECT	T.JobId, T.commCellId, T.SIDBStoreId, T.archCopyId,
					(CASE WHEN MIN(T.totalAppSize) = -1 THEN -1 ELSE SUM(T.totalAppSize) END) totalAppSize,
					SUM(T.totalBackupSize),
					SUM(T.deDupSavingSize)
			FROM
				(SELECT	AFCD.JobId, AFCD.commCellId, AFCD.SIDBStoreId, AFCD.archCopyId, AFCD.archFileId, AFCD.deDupSavingSize,
						(CASE WHEN MIN(ACM.unCompSize) = -1 THEN -1 ELSE SUM(ACM.unCompSize) END) totalAppSize,
						SUM(ACM.physicalSize) totalBackupSize
				FROM
						(SELECT AF.JobId, AF.CommCellId, AFD.SIDBStoreId, AFD.archCopyId, AFD.archFileId,
								(AFD.secondaryObjSize + AFD.secondaryMetaDataSize + AFD.primaryMetaDataSize) deDupSavingSize
						FROM   	archFileCopyDedup AFD WITH (READUNCOMMITTED), #tblStores S, archFile AF WITH (READUNCOMMITTED)
								LEFT OUTER JOIN #tblSiloApps AGC ON AGC.siloAppId = AF.appId
						WHERE  AFD.SIDBStoreId = S.SIDBStoreId
								AND AFD.archFileId = AF.id
								AND AFD.commCellId = AF.commCellId
								AND AF.isValid = 1
								AND AGC.siloAppId is null) AFCD
						INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON AFCD.archFileId = ACM.archFileId AND AFCD.CommCellId = ACM.commCellId AND AFCD.archCopyId = ACM.archCopyId
				GROUP BY AFCD.JobId, AFCD.commCellId, AFCD.SIDBStoreId, AFCD.archCopyId, AFCD.archFileId, AFCD.deDupSavingSize) T
			GROUP BY T.JobId, T.commCellId, T.SIDBStoreId, T.archCopyId
			INSERT INTO #tmpJobSizeInfo
			SELECT  DISTINCT jobId, CommCellId, 0, 0, 0
			FROM    #tblSIDBJob
			WHERE   totalAppSize = -1
			IF @@ROWCOUNT > 0
			BEGIN
				EXEC  archGetJobSizeInfo 0
				UPDATE 	J
				SET     totalAppSize =
						(
							CASE WHEN J.totalBackupSize > 0
								THEN CAST(((1.0 * (J.totalAppSize + J.totalIndexSize) * S.totalBackupSize) / J.totalBackupSize) AS BIGINT)
								ELSE S.totalBackupSize
							END
						)
				FROM    #tblSIDBJob S, #tmpJobSizeInfo J
				WHERE   S.JobId = J.JobId
						AND S.CommCellId = J.CommCellId
						AND S.totalAppSize = -1
			END
			--
			-- Set App size and job count for GDSPs and and standalone copies
			--
			UPDATE	S
			SET 	totalAppSize = J.totalAppSize,
					jobCount = J.jobCount,
					deDupSavingSize = J.deDupSavingSize,
					SizeOfBackup = J.SizeOfBackup
			FROM	#tblSIDBStore S,
					(
						SELECT 	SIDBStoreId,
								SUM(totalAppSize) totalAppSize,
								COUNT(DISTINCT JobId) jobCount,
								SUM(deDupSavingSize) deDupSavingSize,
								SUM(totalBackupSize) SizeOfBackup
						FROM 	#tblSIDBJob
						GROUP BY SIDBStoreId
					) AS J
			WHERE	S.SIDBStoreId = J.SIDBStoreId
AND S.dedupeFlags & 134217728 = 0
IF 	@i_flags & 1 > 0
			BEGIN
				--
				-- Set App Size for dependent copies
				--
				UPDATE	S
				SET 	totalAppSize = J.totalAppSize,
						jobCount = J.jobCount,
						deDupSavingSize = J.deDupSavingSize,
						SizeOfBackup = J.SizeOfBackup
				FROM	#tblSIDBStore S,
						(
							SELECT 	SIDBStoreId, copyId,
									SUM(totalAppSize) totalAppSize,
									COUNT(DISTINCT JobId) jobCount,
									SUM(deDupSavingSize) deDupSavingSize,
									SUM(totalBackupSize) SizeOfBackup
							FROM 	#tblSIDBJob
							GROUP BY SIDBStoreId, copyId
						) AS J
				WHERE	S.SIDBStoreId = J.SIDBStoreId
						AND S.copyId = J.copyId
AND S.dedupeFlags & 134217728 > 0
			END
		END
		--
		-- Get Baseline
		--
IF 	@i_flags & 32 > 0
		BEGIN
			IF object_id('tempdb.dbo.#SIAppID') is not null DROP TABLE #SIAppID
			IF object_id('tempdb.dbo.#tblAppID') is not null DROP TABLE #tblAppID
			CREATE TABLE #SIAppID(
              SIDBStoreId INT, appId INT, archGrpId INT
            )
			CREATE TABLE #tblAppID(
              appId INT, MaxFullJobId INT, BaseLineSize BIGINT, AppBaseLineSize BIGINT,
			  primary key (appId)
            )
			--
			-- Get associated subclients to calculate baseline
			--
			;WITH ValidStores AS
			(
				SELECT	SIDBStoreId
				FROM	#tblStores S
				WHERE	S.SealedTime = 0 --active store
						AND EXISTS  --has valid AFs
						(
							SELECT 	1
							FROM	archFile AF WITH(READUNCOMMITTED), archFileCopyDedup AFD WITH(READUNCOMMITTED)
							WHERE	AF.id = AFD.archFileId AND AF.commCellId = AFD.commCellId AND AF.isValid = 1
									AND AFD.SIDBStoreId = S.SIDBStoreId
						)
			)
			INSERT 	INTO #SIAppID
			SELECT 	B.SIDBStoreId, A.appId, A.archGrpId
			FROM 	JMJobDatastats A WITH (READUNCOMMITTED),
					archSubclientCopyDDBMap ACS WITH (READUNCOMMITTED), ValidStores B
			WHERE 	ACS.SIDBStoreId = B.SIDBStoreId
					AND A.appId = ACS.appId
					AND A.archGrpCopyId = ACS.copyId
					AND A.status IN (100, 101, 102, 103)
					AND (A.disabled & (1 + 256)) = 0
			GROUP BY B.SIDBStoreId, A.appId, A.archGrpId
			INSERT 	INTO #tblAppID
			SELECT	A.id, 0, 0, 0
			FROM	APP_Application A WITH (READUNCOMMITTED), #SIAppID S
			WHERE	S.appId = A.id
					AND (S.archGrpId = A.dataArchGrpID OR S.archGrpId = A.logArchGrpID)
			GROUP BY A.id
			UPDATE	A
			SET		MaxFullJobID = T.MaxFullJobID
			FROM	#tblAppID A,
					(
						SELECT 	A.appId, MAX(BS.jobId) MaxFullJobID
						FROM	JMBkpStats BS WITH (NOLOCK), #tblAppID A
						WHERE	BS.bkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000)
								AND BS.status IN (1, 3, 14)
								AND BS.appId = A.appId
						GROUP BY A.appId
					) T
			WHERE	A.appId = T.appId
			UPDATE	A
			SET		BaseLineSize = BS.totalBackupSize,
					AppBaseLineSize = case when BS.totalUncompBytes > 0 then BS.totalUncompBytes else BS.totalBackupSize end
			FROM	JMBkpStats BS WITH (READUNCOMMITTED), #tblAppID A
			WHERE	BS.appId = A.appId
					AND BS.jobId = A.MaxFullJobID
			--
			-- Set baseline size for GDSPs and standalone copies.
			--
			UPDATE	S
			SET 	baseLineSize = B.baseLineSize * 1.2,
					AppBaseLineSize = B.AppBaseLineSize
			FROM	#tblSIDBStore S,
					(
						SELECT	SA.SIDBStoreId,
								SUM(A.baseLineSize) baseLineSize,
								SUM(AppBaseLineSize) AppBaseLineSize
						FROM	#tblAppID A, (SELECT DISTINCT SIDBStoreId, appId FROM #SIAppID) SA
						WHERE	A.appId = SA.appId
						GROUP BY SA.SIDBStoreId
					) B
			WHERE	S.SIDBStoreId = B.SIDBStoreId
AND S.dedupeFlags & 134217728 = 0
		END
IF 	@i_flags & 64 > 0
		BEGIN
			--
			-- Get free space on library
			--
			IF OBJECT_ID('tempdb..#lt_LibFreeSpace') IS NOT NULL DROP TABLE #lt_LibFreeSpace
			CREATE TABLE #lt_LibFreeSpace ( copyId INT, MediaSideId INT, FreeBytesMB BIGINT)
			INSERT INTO #lt_LibFreeSpace
			SELECT 	S.copyId, MS.MediaSideId, MAX(MS.FreeBytesMB)
			FROM 	#tblSIDBStore S,
					MMDataPath D WITH (READUNCOMMITTED),
					MMDrivePool DP WITH (READUNCOMMITTED),
					MMMountPath MP WITH (READUNCOMMITTED),
					MMMediaSide MS WITH (READUNCOMMITTED)
			WHERE	S.copyId = D.CopyId
					AND D.DrivePoolId = DP.DrivePoolId
					AND DP.MasterPoolId = MP.MasterPoolId
					AND MP.MediaSideId = MS.MediaSideId
					AND S.SIDBStoreId = 0
AND S.dedupeFlags & 134217728 = 0
			GROUP BY S.copyId, MS.MediaSideId
			UPDATE 	S
			SET	 	freeSpaceOnLibrary =  freespace.FreeBytesMB
			FROM	#tblSIDBStore S ,
					(
						SELECT  copyId, SUM(FreeBytesMB) FreeBytesMB
						FROM  	#lt_LibFreeSpace
						GROUP BY copyId
					) freespace
			WHERE  S.copyId = freespace.copyId
		END
IF 	@i_flags & 128 > 0
		BEGIN
			--
			-- Retention for dependent and standalone copies
			--
			UPDATE 	S
			SET 	retentionDaysForCopy =   R.retentionDays,
					retentionCyclesForCopy = R.fullCycles
			FROM 	#tblSIDBStore S, archAgingRule R  WITH (READUNCOMMITTED)
			WHERE 	S.copyId = R.copyId
					AND S.SIDBStoreId = 0
AND S.dedupeFlags & 268435456 = 0
		END
IF 	@i_flags & 256 > 0
		BEGIN
			--
			-- Get pending deleted AF count
			--
			UPDATE 	T
			SET 	deletedAFCount = M.mmdeletedAFCount
			FROM	#tblSIDBStore T,
					(
						SELECT 	S.SIDBStoreId, COUNT(1) AS mmdeletedAFCount
						FROM 	#tblStores S
								INNER JOIN MMDeletedAF MMDAF WITH (READUNCOMMITTED) ON S.SIDBStoreId = MMDAF.SIDBStoreId
						GROUP BY S.SIDBStoreId
					) AS M
			WHERE 	T.SIDBStoreId = M.SIDBStoreId
		END
IF 	@i_flags & (512 | 65536) > 0
		BEGIN
			--
			-- Compute consolidated values at copy level
			-- Rows with StoreId = 0 indicates copy level summary
			--
			UPDATE 	S
			SET		totalDataSize = T.totalDataSize,
					sizeOnMedia = T.sizeOnMedia,
					baseLineSize = T.baseLineSize,
					totalAppSize = T.totalAppSize,
					deDupSavingSize = T.deDupSavingSize,
					deletedAFCount = T.deletedAFCount,
					jobCount = T.jobCount,
					SizeOffDiskMB = T.SizeOffDiskMB,
					SizeToBeInSiloMB = T.SizeToBeInSiloMB,
					SizeInSiloMB = T.SizeInSiloMB,
					SizeOfBackup = T.SizeOfBackup
			FROM 	#tblSIDBStore S,
					(
						SELECT  copyId,
								SUM(totalDataSize) totalDataSize,
								SUM(sizeOnMedia) sizeOnMedia,
								SUM(baseLineSize) baseLineSize,
								SUM(totalAppSize) totalAppSize,
								SUM(deDupSavingSize) deDupSavingSize,
								SUM(deletedAFCount) deletedAFCount,
								SUM(jobCount) jobCount,
								SUM(SizeOffDiskMB) SizeOffDiskMB,
								SUM(SizeToBeInSiloMB) SizeToBeInSiloMB,
								SUM(SizeInSiloMB) SizeInSiloMB,
								SUM(SizeOfBackup) SizeOfBackup
						FROM	#tblSIDBStore
						WHERE	SIDBStoreId > 0
						GROUP BY copyId
					) T
			WHERE 	S.copyId = T.copyId
					AND S.SIDBStoreId = 0
IF 	@i_flags & 65536 > 0
				DELETE #tblSIDBStore WHERE SIDBStoreId > 0
		END
		ELSE
		BEGIN
			DELETE #tblSIDBStore WHERE SIDBStoreId = 0
		END
IF 	@i_flags & 16384 > 0
		BEGIN
			DELETE #tblSIDBStore WHERE SealedTime > 0
		END
IF 	@i_flags & (8 | 16) = (8 | 16)
		BEGIN
			--
			-- Compute Dedupe Savings Percent
			--
			UPDATE 	#tblSIDBStore
			SET		deDupSavingPercent =  CAST( CAST((100 - totalDataSize * 1.0 / totalAppSize * 100) AS DECIMAL(10, 2)) AS VARCHAR(10) )
			WHERE	totalDataSize > 0 AND totalAppSize > 0 AND totalDataSize < totalAppSize
		END
IF 	@i_flags & 1024 > 0
		BEGIN
			--
			-- AvgQITime
			--
			DECLARE @l_MaxAvgQITime bigint =
			ISNULL(
			(
				SELECT value
				FROM	MMConfigs WITH (READUNCOMMITTED)
				WHERE	name = 'MMCONFIG_MAX_AVGQITIME_FOR_SIDB'
), 2000)
			UPDATE 	S
			SET		AvgQiTime 			= dbo.GetCurrentAvgQITimeMedian(S.SIDBStoreId, 0 /*SubStoreId*/, S.commCellId, 3),
					AvgQiTime14Days 	= dbo.GetCurrentAvgQITimeMedian(S.SIDBStoreId, 0 /*SubStoreId*/, S.commCellId,
14),
					MaxAvgQiTime 		= @l_MaxAvgQITime
			FROM	#tblSIDBStore S
		END
IF 	@i_flags & 2048 > 0
		BEGIN
			declare @tblLatestUsage table (SIDBStoreId int, substoreId int, commCellId int, modifiedTime int, PrimaryEntries bigint, primaryDataSize bigint)
			declare @nRows int = 0
			DECLARE @l_MaxPrimaryRecs bigint =
			ISNULL(
			(
				SELECT CAST(value AS bigint)*1000000
				FROM MMConfigs WITH (READUNCOMMITTED)
				WHERE name ='MMCONFIG_MAX_PRIMARYRECS_IN_SIDB_MIL'
),1000)
			insert 	into @tblLatestUsage
			select 	U.SIDBStoreId, U.SubstoreId, U.CommCellId, MAX(U.modifiedTime), 0, 0
			from 	IdxSIDBUsageHistory U WITH (READUNCOMMITTED), #tblStores S
			where 	U.SIDBStoreId = S.SIDBStoreId and U.PrimaryEntries > 0
			group by U.SIDBStoreId, U.SubStoreId, U.CommCellId
			SET @nRows = @@ROWCOUNT
			update 	@tblLatestUsage
			set 	PrimaryEntries = b.PrimaryEntries, primaryDataSize = b.PrimaryDataSize
			from 	@tblLatestUsage a, IdxSIDBUsageHistory b WITH (READUNCOMMITTED)
			where 	a.SIDBStoreId = b.SIDBStoreId and a.substoreId = b.substoreId and a.commCellId = b.commCellId
					and a.modifiedTime = b.modifiedTime and b.PrimaryEntries > 0
			UPDATE 	S
			SET		UniqueBlocks = T.UniqueBlocks,
					TotalSizeOfUniqueBlocks  = T.TotalUniqueBlocks,
					PrimaryRecPercent = (T.UniqueBlocks * 100)/(@l_MaxPrimaryRecs * S.SubStoreCount)
			FROM	#tblSIDBStore S
					INNER JOIN
					(
						select SIDBStoreId, sum(PrimaryEntries) UniqueBlocks, sum(primaryDataSize)/(1024*1024) TotalUniqueBlocks
						from @tblLatestUsage
						where PrimaryEntries > 0
						group by SIDBStoreId
					) T ON S.SIDBStoreId = T.SIDBStoreId
		END
IF 	@i_flags & 4096 > 0
		BEGIN
			UPDATE 	S
			SET		ActiveStreams = A.ActiveStreams
			FROM	#tblSIDBStore S
					INNER JOIN
					(
						SELECT 	T.SIDBStoreId, COUNT(1) ActiveStreams
						FROM 	#tblStores T, archCopySIDBStore ACS WITH (READUNCOMMITTED),
								MMResource R WITH (NOLOCK)
						WHERE	T.SIDBStoreId = ACS.SIDBStoreId
								AND R.CopyId = ACS.copyId
								AND R.StreamId > 0
						GROUP BY T.SIDBStoreId
					) A ON S.SIDBStoreId = A.SIDBStoreId
		END
IF 	@i_flags & 8192 > 0
		BEGIN
			UPDATE 	S
			SET		EnableAfterDelayTimeZone 	= EnableTimeZone,
					EnableAfterDelayTime		= UNCEnableTime
			FROM	#tblSIDBStore S, MMEntityAction A
			WHERE	EntityId = S.SIDBStoreId
AND EntityType = 3
AND OperationType = 536870912
		END
	END --propertyLevel > 1
	--
	-- RETURN results
	--
	IF OBJECT_ID('tempdb..#lt_MMGetDDBEnginesOutput') IS NOT NULL
		INSERT INTO #lt_MMGetDDBEnginesOutput
		SELECT  CommCellId,
				SIDBStoreId,
				SIDBStoreName,
				SIDBStoreAliasName,
				archGroupId,
				archGroupName,
				copyId,
				copyName,
				totalDataSize,
				sizeOnMedia,
				totalAppSize,
				deDupSavingSize,
				deletedAFCount,
				MaintenanceReason,
				jobCount,
				baseLineSize,
				freeSpaceOnLibrary,
				retentionDaysForCopy,
				retentionCyclesForCopy,
				copyMediaAgentId,
				sealedTime,
				CreatedTime,
				SubStoreCount,
				AvgQITime,
				UniqueBlocks,
				DedupeFlags,
				PrimaryRecPercent,
				Version,
				MaxAvgQITime,
				Flags,
				LimitFlag,
				AvgQITime14Days,
				MaxAllowedConnections,
				LastVerifiedOn,
				JobsLastVerifiedOn,
				AppBaselineSize,
				SizeOfFragmentedSpace,
				ActiveStreams,
				EnableAfterDelayTimeZone,
				EnableAfterDelayTime,
				SizeOffDiskMB,
				SizeToBeInSiloMB,
				SizeInSiloMB,
				SizeOfBackup,
				deDupSavingPercent,
				extendedFlags,
				TotalSizeOfUniqueBlocks
		FROM 	#tblSIDBStore
	ELSE
		SELECT  CommCellId,
				SIDBStoreId,
				SIDBStoreName,
				SIDBStoreAliasName,
				archGroupId,
				archGroupName,
				copyId,
				copyName,
				totalDataSize,
				sizeOnMedia,
				totalAppSize,
				deDupSavingSize,
				deletedAFCount,
				MaintenanceReason,
				jobCount,
				baseLineSize,
				freeSpaceOnLibrary,
				retentionDaysForCopy,
				retentionCyclesForCopy,
				copyMediaAgentId,
				sealedTime,
				CreatedTime,
				SubStoreCount,
				AvgQITime,
				UniqueBlocks,
				DedupeFlags,
				PrimaryRecPercent,
				Version,
				MaxAvgQITime,
				Flags,
				LimitFlag,
				AvgQITime14Days,
				MaxAllowedConnections,
				LastVerifiedOn,
				JobsLastVerifiedOn,
				AppBaselineSize,
				SizeOfFragmentedSpace,
				ActiveStreams,
				EnableAfterDelayTimeZone,
				EnableAfterDelayTime,
				SizeOffDiskMB,
				SizeToBeInSiloMB,
				SizeInSiloMB,
				SizeOfBackup,
				deDupSavingPercent,
				extendedFlags,
				TotalSizeOfUniqueBlocks
		FROM 	#tblSIDBStore
		ORDER BY  CommCellId, archGroupName, copyName, sealedTime, AppTypeGroupId, SIDBStoreId DESC
	IF object_id('tempdb.dbo.#tblSIDBStore') is not null DROP TABLE #tblSIDBStore
	IF object_id('tempdb.dbo.#tblSIDBJob') is not null DROP TABLE #tblSIDBJob
	IF object_id('tempdb.dbo.#SIAppID') is not null DROP TABLE #SIAppID
	IF object_id('tempdb.dbo.#tblAppID') is not null DROP TABLE #tblAppID
	IF object_id('tempdb.dbo.#tmpJobSizeInfo') is not null DROP TABLE #tmpJobSizeInfo
	IF object_id('tempdb.dbo.#tblSidbSizeInfo') is not null DROP TABLE #tblSidbSizeInfo
	IF OBJECT_ID('tempdb..#lt_StoragePolicies') IS NOT NULL DROP TABLE #lt_StoragePolicies
	IF object_id('tempdb.dbo.#tblSiloApps') is not null DROP TABLE #tblSiloApps
	IF OBJECT_ID('tempdb..#lt_LibFreeSpace') IS NOT NULL DROP TABLE #lt_LibFreeSpace
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBEngines')
	delete from GxQscripts where name = 'MMGetDDBEngines'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBEngines')
	delete from GXDBVersions where aliasname = 'MMGetDDBEngines'
GO

insert into GXDBVersions values(2, 'MMGetDDBEngines',  '00010017001200330000', 'MMGetDDBEngines', '00010017001200330000')
GO

