

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetDDBEngineDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetDDBEngineDetails.sp,v $ $Id: MMGetDDBEngineDetails.sp,v 1.31.2.9 2018/10/16 05:44:40 kjaiswal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetDDBEngineDetails')
BEGIN
	print '>>> Drop Stored Procedure: MMGetDDBEngineDetails <<<'
	drop procedure MMGetDDBEngineDetails
END
IF EXISTS (select * from GxQscripts where name='MMGetDDBEngineDetails')
	delete from GxQscripts where name = 'MMGetDDBEngineDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBEngineDetails')
	delete from GXDBVersions where aliasname = 'MMGetDDBEngineDetails'
GO
print '... Creating Procedure: MMGetDDBEngineDetails'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetDDBEngineDetails
  @i_commcellId integer,
  @i_storeId integer
AS
  DECLARE @o_CommCellId integer
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBStoreName varchar(256)
  DECLARE @o_SIDBStoreAliasName NVARCHAR(256)
  DECLARE @o_CreatedTime integer
  DECLARE @o_SealedTime integer
  DECLARE @o_BaselineSize bigint
  DECLARE @o_TotalDataSize bigint
  DECLARE @o_SizeOnMedia bigint
  DECLARE @o_TotalAppSize bigint
  DECLARE @o_DeDupSavingSize bigint
  DECLARE @o_NumPartitions integer
  DECLARE @o_AvgQITime bigint
  DECLARE @o_UniqueBlocks bigint
  DECLARE @o_DedupeFlags integer
  DECLARE @o_primaryRecordsPercentage integer
  DECLARE @o_NumberOfJobs integer
  DECLARE @o_ddbVersion integer
  DECLARE @o_MaxAvgQITime bigint
  DECLARE @o_StoreFlags int
  DECLARE @o_ReserveField1 int
  DECLARE @o_ReserveField2 int
  DECLARE @o_ReserveField3 varchar(255)
  DECLARE @o_retentionDaysForCopy integer
  DECLARE @o_retentionCycleForCopy integer
  DECLARE @o_freeSpaceOnLibrary bigint
  DECLARE @o_maxAllowedConnections integer
  DECLARE @o_DDB_LastVerifiedOn integer
  DECLARE @o_DDB_JobsLastVerifiedOn integer
  DECLARE @o_ApplicationBaselineSize bigint
  DECLARE @o_SizeOfFragmentedSpace bigint
  DECLARE @o_ActiveStreams integer
SET NOCOUNT ON
	IF object_id('tempdb.dbo.#tblSIDBStore') is not null DROP TABLE #tblSIDBStore
	DECLARE @l_ApplicationBaselineSize bigint
	DECLARE @l_BaselineSize bigint
	DECLARE @l_SizeOnMedia bigint
	DECLARE @l_noOfPartitions int
	DECLARE @l_avgQITime bigint
	DECLARE @l_uniqueBlocks bigint
	DECLARE @l_MaxPrimaryRecs bigint
DECLARE @l_MaxAvgQITime bigint = 2000
DECLARE @thresholdDaysToConsider int = 14
	DECLARE @l_SizeOfFragmentedSpace	BIGINT = 0
	set @l_avgQITime = dbo.GetCurrentAvgQITimeMedian(@i_storeId, 0 /*SubStoreId*/, @i_commCellId, 3) --Hardcode since in GUI we show for 3 days
	set @l_uniqueBlocks = 0
SELECT	TOP 1 @l_MaxAvgQITime = ISNULL(value, 2000)
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_MAX_AVGQITIME_FOR_SIDB'
	/*Hardcoded 14 in GUI so comment this. Uncomment in v11 and pass this value to tip
SELECT	TOP 1 @thresholdDaysToConsider = ISNULL(value, 14)
	FROM	MMConfigs WITH (READUNCOMMITTED)
	WHERE	name = 'MMCONFIG_STORE_AVG_QI_TIME_LIMIT_DAYS_TO_CONSIDER'
	*/
	set @o_ReserveField2 = dbo.GetCurrentAvgQITimeMedian(@i_storeId, 0 /*SubStoreId*/, @i_commCellId, @thresholdDaysToConsider /*DaysToConsider*/) --Using ReserveField2 to send 14 days avg of QITime
	declare @tblLatestUsage table (SIDBStoreId int, substoreId int, commCellId int, modifiedTime int, avgQITime bigint, PrimaryEntries bigint)
	insert into @tblLatestUsage
	select SIDBStoreId, substoreId, commCellId, MAX(modifiedTime), 0, 0
	from IdxSIDBUsageHistory WITH (READUNCOMMITTED)
	where SIDBStoreId = @i_storeId and commCellId = @i_commCellId
	group by SIDBStoreId, SubStoreId, commCellId
	update @tblLatestUsage
	set avgQITime = b.avgQITime, PrimaryEntries = b.PrimaryEntries
	from @tblLatestUsage a, IdxSIDBUsageHistory b WITH (READUNCOMMITTED)
	where a.SIDBStoreId = b.SIDBStoreId and a.substoreId = b.substoreId and a.commCellId = b.commCellId and a.modifiedTime = b.modifiedTime
	/* Using function GetCurrentAvgQITimeMedian to get the avgQITime for the store, so commenting out below code.
	-- if there are some substores for which latest update has recorded value as 0 then do this.
	if exists (select * from @tblLatestUsage where avgQITime = 0)
	begin
		-- if latest update contains 0 then get the last good recorded value.
		update @tblLatestUsage
		set avgQITime = ISNULL((select top 1 b.avgQITime from IdxSIDBUsageHistory b WITH (NOLOCK)
								where a.SIDBStoreId = b.SIDBStoreId and a.substoreId = b.substoreId and a.commCellId = b.commCellId and b.AvgQITime > 0
								order by modifiedTime desc ), 0)
		from @tblLatestUsage a
        where avgQITime = 0
	end
	set @l_avgQITime = (select sum(avgQITime)/COUNT(*) from @tblLatestUsage where avgQITime > 0)
	*/
	-- if there are some substores for which latest update has recorded value as 0 then do this.
	if exists (select * from @tblLatestUsage where PrimaryEntries = 0)
	begin
		-- if latest update contains 0 then get the last good recorded value.
		update @tblLatestUsage
		set PrimaryEntries = ISNULL((select top 1 b.PrimaryEntries from IdxSIDBUsageHistory b WITH (NOLOCK)
								where a.SIDBStoreId = b.SIDBStoreId and a.substoreId = b.substoreId and a.commCellId = b.commCellId and b.PrimaryEntries > 0
								order by modifiedTime desc ), 0)
		from @tblLatestUsage a
        where PrimaryEntries = 0
	end
    set @l_uniqueBlocks = (select sum(PrimaryEntries) from @tblLatestUsage where PrimaryEntries > 0)
	set @l_noOfPartitions = (select isnull(count(*), 0) from IdxSIDBSubStore WITH (READUNCOMMITTED)
									where SIDBStoreId = @i_storeId and commCellId = @i_commCellId)
	DECLARE @tblStoreCopies TABLE (CopyID int primary key)
	INSERT INTO @tblStoreCopies
	SELECT CopyID FROM archCopySIDBStore WITH (READUNCOMMITTED)
		WHERE SIDBStoreId = @i_storeId and commCellId = @i_commCellId
	DECLARE @tblAppId TABLE (appID int primary key)
	INSERT INTO @tblAppId
	SELECT DISTINCT appId FROM JMJobDatastats WITH (READUNCOMMITTED) INNER JOIN @tblStoreCopies ON  archGrpCopyId = CopyId
	INNER JOIN APP_Application A WITH (READUNCOMMITTED) ON appId = A.id AND (A.dataArchGrpID = archGrpId OR A.logArchGrpID = archGrpId )
	WHERE status IN (100, 101, 102, 103) AND (disabled & (1 + 256)) = 0
	SELECT	@l_BaselineSize = SUM(totalBackupSize), @l_ApplicationBaselineSize = SUM(case when totalUncompBytes > 0 then totalUncompBytes else totalBackupSize end)
	FROM	JMBkpStats BSL  WITH (READUNCOMMITTED),
			(SELECT	BSL.appId, MAX(BSL.jobId) AS MaxFullJobID
			 FROM	JMBkpStats BSL WITH (READUNCOMMITTED),
					@tblAppId AppIdTemp, archFile AF WITH (READUNCOMMITTED), archFileCopyDedup AFD WITH (READUNCOMMITTED)
			WHERE	BSL.bkpLevel IN (1, 0x40, 0x80, 0x400, 0x1000, 0x4000, 0x8000)
					AND BSL.status IN (1, 3, 14)
					AND BSL.appId = AppIdTemp.appID
					AND AF.jobID = BSL.jobID AND AF.commcellId = BSL.commCellId
					AND AFD.archFileID = AF.id AND AFD.commCellId = AF.commCellId AND AFD.SIDBStoreId = @i_storeId
			GROUP BY BSL.appId
			) T
	WHERE	BSL.appId = T.appId
			AND BSL.jobId = MaxFullJobID
	SET		@l_BaselineSize	= @l_BaselineSize * 1.2
	/*SET		@l_SizeOnMedia =
			isnull((
					select SUM(CAST(PhysicalBytesMB AS BIGINT))
					FROM MMVolume
					WHERE SIDBStoreId = @i_storeId
					 and origCCcommCellID = @i_commCellId
			), 0)*/
---- Reference code from MMGetDDBEngines.sp---
	CREATE TABLE #tblSIDBStore (
	CommCellId int,
	SIDBStoreId int primary key,
	copyId int ,
	dedupeFlags int,
	totalDataSize bigint,
	sizeOnMedia bigint,
	totalAppSize bigint,
	dedupSavingSize bigint,
	numberOfJobs int,
	ddbVersion    int,
	extendedFlags bigint,
	retentionDaysForCopy int,
	retentionCyclesForCopy int,
	freeSpaceOnLibray bigint,
SIDBStoreName varchar(256),
SIDBStoreAliasName NVARCHAR(256),
	CreatedTime bigint, SealedTime bigint,
	flags     int,
	MaxAllowedConnections bigint,
	LastDDBVerificationTime bigint,
	LastDataVerificationTime bigint
	)
	INSERT INTO #tblSIDBStore
	SELECT DISTINCT a.commCellId, b.SIDBStoreId,b.CopyId , c.dedupeFlags, 0, 0, 0, 0, 0,
	CASE
		WHEN a.version < 2 THEN
	  		CASE WHEN a.version = -1 THEN a.version
			WHEN a.version =  0 OR a.version = 1 THEN 8
			END
		ELSE
			a.Version+7
	END,
	c.extendedFlags,0,0,0,
	a.SIDBStoreName,a.SIDBStoreAliasName,a.CreatedTime,a.SealedTime,
	a.flags,a.MaxAllowedConnections,a.LastDDBVerificationTime,a.LastDataVerificationTime
	FROM IdxSIDBStore a WITH (READUNCOMMITTED), archCopySIDBStore b WITH (READUNCOMMITTED), archGroupCopy c WITH (READUNCOMMITTED)
	WHERE a.SIDBStoreId = b.SIDBStoreId
AND c.type <> 5
AND b.CopyId = c.id AND c.dedupeFlags & 134217728  = 0
	AND a.SIDBStoreId  = @i_storeId
	AND a.CommCellId   = @i_commCellId
 	DECLARE @tblSidbSizeInfo table (SIDBStoreId int, totalDataSizeMB bigint, sizeOffDiskMB bigint)
	INSERT INTO @tblSidbSizeInfo
	SELECT	V.SIDBStoreId, SUM(CAST(V.PhysicalBytesMB AS BIGINT)), SUM(CASE WHEN SiloStatus = 3 THEN CAST(PhysicalBytesMB AS BIGINT) ELSE 0 END)
	FROM	MMVolume V WITH (NOLOCK), #tblSIDBStore S
	WHERE	V.SIDBStoreId = S.SIDBStoreId
	GROUP	BY V.SIDBStoreId
	UPDATE #tblSIDBStore SET totalDataSize = B.totalDataSizeMB * 1024 * 1024, sizeOnMedia = (B.totalDataSizeMB - B.sizeOffDiskMB) * 1024 * 1024
	FROM #tblSIDBStore A, @tblSidbSizeInfo B
	WHERE A.SIDBStoreId = B.SIDBStoreId
        UPDATE #tblSIDBStore
        SET numberOfJobs = (select count(distinct AF.jobId) from archFile AF with (nolock), archFileCOpy AFC with (nolock), archFileCopyDedup AFD with (nolock)
      	where AF.id = AFD.archFileId
        and AFD.archFileId = AFC.archFileId
        and AFD.archCopyId = AFC.archCopyId
		and AFC.lastChunkNumber > 0
        and AFD.SIDBStoreId = @i_storeId
        and AF.commcellId = AFD.commcellId
        and AFD.commcellId = AFC.commcellId
        and AFC.physicalSize > 0)
	UPDATE #tblSIDBStore
		SET retentionCyclesForCopy = fullCycles,
			 retentionDaysForCopy = retentionDays
		FROM #tblSIDBStore t,archAgingRule a WITH (NOLOCK)
		WHERE t.copyId = a.copyId
	UPDATE #tblSIDBStore set freeSpaceOnLibray =  freespace.FreeBytesMB
		FROM (SELECT CopyId,SUM(FreeBytesMB) AS FreeBytesMB
                FROM (SELECT  DISTINCT D.CopyId ,MS.MediaSideId, MS.FreeBytesMB
                        FROM  archGroupCopy AGC WITH (NOLOCK), MMDataPath D WITH (NOLOCK), MMDrivePool DP WITH (NOLOCK), MMMountPath MP WITH (NOLOCK),
                        MMMediaSide MS WITH (NOLOCK)
                        WHERE AGC.id = D.CopyId
                                    AND AGC.SIDBStoreId > 0
                                    AND D.DrivePoolId = DP.DrivePoolId
                                    AND DP.MasterPoolId = MP.MasterPoolId
                                    AND MP.MediaSideId = MS.MediaSideId)T1
                GROUP BY CopyId) freespace,#tblSIDBStore t
				WHERE freespace.CopyId = t.copyId
/*	DECLARE @tblSIDBJob TABLE (
		SIDBStoreId int,
		JobId int,
		CommCellId int,
		totalAppSize bigint
		)
	INSERT	INTO @tblSIDBJob
	SELECT	distinct AFD.SIDBStoreId, AF.JobId, AF.CommCellId, 0
	FROM	archFile AF WITH (NOLOCK), archFileCopyDedup AFD WITH (NOLOCK)
	WHERE	AF.id = AFD.archFileId AND AF.commCellId = AFD.commCellId AND AF.isValid = 1
	AND AF.appId not in (select siloAppId from archGroupCopy)
	AND AFD.SIDBStoreId = @i_storeId
	UPDATE @tblSIDBJob
	SET		totalAppSize = case when J.totalUncompBytes > 0 then J.totalUncompBytes else J.totalBackupSize end
	FROM	JMBkpStats J WITH (NOLOCK), @tblSIDBJob T
	WHERE	J.jobId = T.jobId AND j.commCellId = T.commCellId AND J.status IN (1, 3, 14) AND J.totalBackupSize > 0
	UPDATE @tblSIDBJob
	SET totalAppSize = case when J.uncompBytes > 0 then J.uncompBytes else J.totalBackupSize end
	FROM	JMAdminJobStatsTable J WITH (NOLOCK), @tblSIDBJob T
	WHERE	J.jobId = T.jobId AND j.commCellId = T.commCellId AND J.status IN (1, 3, 14) AND J.totalBackupSize > 0
	DECLARE @tblAppSize TABLE (
		CommCellId int,
		SIDBStoreId int,
		totalAppSize bigint
		)
	INSERT INTO @tblAppSize
	SELECT CommCellId, SIDBStoreId, SUM(totalAppSize)
	FROM @tblSIDBJob
	GROUP BY CommCellId, SIDBStoreId
	UPDATE #tblSIDBStore SET totalAppSize = B.totalAppSize
	FROM #tblSIDBStore A, @tblAppSize B
	WHERE A.SIDBStoreId = B.SIDBStoreId
	DECLARE @tblDedupSaving TABLE (
		CommCellId int,
		SIDBStoreId int,
		deDupSavingSize bigint
		)
	INSERT INTO @tblDedupSaving
	SELECT	AFD.CommCellId, AFD.SIDBStoreId, SUM(ISNULL(AFD.secondaryObjSize, 0) + ISNULL(AFD.secondaryMetaDataSize, 0) + ISNULL(AFD.primaryMetaDataSize, 0))
	FROM archFileCopyDedup AFD WITH (READUNCOMMITTED)
	WHERE SIDBStoreId = @i_storeId
	GROUP BY AFD.CommCellId, AFD.SIDBStoreId
	UPDATE #tblSIDBStore SET deDupSavingSize = B.deDupSavingSize
	FROM #tblSIDBStore A, @tblDedupSaving B
	WHERE A.SIDBStoreId = B.SIDBStoreId
*/
    SET @o_ActiveStreams =  (SELECT COUNT(*) FROM MMResource AS MM WITH (NOLOCK)
	                              INNER JOIN  archCopySIDBStore AS t WITH (READUNCOMMITTED)
	                              ON MM.CopyId = t.copyId AND t.SIDBStoreId =@i_storeId AND MM.StreamId > 0)
	SET @l_MaxPrimaryRecs = ISNULL((SELECT CAST(value AS bigint)*1000000*@l_noOfPartitions FROM mmconfigs WHERE name ='MMCONFIG_MAX_PRIMARYRECS_IN_SIDB_MIL'),0)
	DECLARE @l_SiloEnabled INT = 0
SELECT @l_SiloEnabled = CASE WHEN flags & 2097152 > 0 THEN 1 ELSE 0 END FROM IdxSIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = @i_storeId
	SELECT @l_SizeOfFragmentedSpace = ISNULL((CASE WHEN @l_SiloEnabled > 0 THEN -1
									   WHEN (SUM(MV.PhysicalBytesMB) - MAX(TotalDataSizeBytes)/1024.0/1024.0) < 0 THEN 0
									   ELSE (SUM(MV.PhysicalBytesMB) - MAX(TotalDataSizeBytes)/1024.0/1024.0)
									   END), 0)
	FROM   IdxSIDBStore I WITH (READUNCOMMITTED) INNER JOIN MMVolume MV  WITH (READUNCOMMITTED) ON I.SIDBStoreId = MV.SIDBStoreId
	WHERE  I.SIDBStoreId = @i_storeId
	SELECT	b.commcellId, b.SIDBStoreId, b.SIDBStoreName, b.SIDBStoreAliasName,
			b.CreatedTime, b.SealedTime,
			@l_BaselineSize, b.totalDataSize, b.sizeOnMedia, b.totalAppSize, b.dedupSavingSize,
			@l_noOfPartitions, @l_avgQITime, @l_uniqueBlocks,
			b.dedupeFlags,
			ISNULL( (@l_uniqueBlocks*100)/@l_MaxPrimaryRecs, 0),b.numberOfJobs As TotalJobs ,b.ddbVersion As ddbVersion,
			@l_MaxAvgQITime, b.flags,
(CASE WHEN b.extendedFlags & 128 = 128
			THEN 1
	ELSE 0 END), @o_ReserveField2, '',
            b.retentionDaysForCopy,
            b.retentionCyclesForCopy,
			b.freeSpaceOnLibray As 'Free Space(MB) On Library',
		    (CASE WHEN b.MaxAllowedConnections = 0
			 THEN (select value from MMConfigs where name = 'MMCONFIG_RESOURCEMANAGER_MAXIMUM_ALLOWED_CONNECTION_PER_DDB')
			 ELSE b.MaxAllowedConnections END)  As 'MaxAllowedConnections',
			 b.LastDDBVerificationTime,
			 b.LastDataVerificationTime,
			 @l_ApplicationBaselineSize As 'Application Baseline Size',
			 @l_SizeOfFragmentedSpace As 'Size Of Fragmented Space',
			 @o_ActiveStreams As 'Active Streams'
	FROM #tblSIDBStore  b WHERE
	b.SIDBStoreId = @i_storeId
	AND b.CommCellId = @i_commCellId
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetDDBEngineDetails')
	delete from GxQscripts where name = 'MMGetDDBEngineDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetDDBEngineDetails')
	delete from GXDBVersions where aliasname = 'MMGetDDBEngineDetails'
GO

insert into GXDBVersions values(2, 'MMGetDDBEngineDetails',  '00010031000200090000', 'MMGetDDBEngineDetails', '00010031000200090000')
GO

