

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetControllerNodesForScaleOut.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetControllerNodesForScaleOut')
BEGIN
	print '>>> Drop Stored Procedure: MMGetControllerNodesForScaleOut <<<'
	drop procedure MMGetControllerNodesForScaleOut
END
IF EXISTS (select * from GxQscripts where name='MMGetControllerNodesForScaleOut')
	delete from GxQscripts where name = 'MMGetControllerNodesForScaleOut'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetControllerNodesForScaleOut')
	delete from GXDBVersions where aliasname = 'MMGetControllerNodesForScaleOut'
GO
print '... Creating Procedure: MMGetControllerNodesForScaleOut'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMGetControllerNodesForScaleOut
  @i_storagePoolName NVARCHAR(512)
AS
  DECLARE @clientId INTEGER
  DECLARE @isDDBDiskConfigured INTEGER
  DECLARE @isNewlyAdded INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
IF (OBJECT_ID ('temp.dbo.#deviceIds')) IS NOT NULL	DROP TABLE #deviceIds
CREATE TABLE #deviceIds (deviceId INT)
INSERT INTO #deviceIds
SELECT MD.DeviceId
FROM MMSDSStoragePool SDS WITH(NOLOCK)
INNER JOIN MMMountPath MP WITH (NOLOCK) ON SDS.LibraryId = MP.LibraryId
INNER JOIN MMMountPathToStorageDevice MSD WITH (NOLOCK) ON MSD.MountPathId = MP.MountPathId
INNER JOIN MMDevice MD WITH (NOLOCK) ON MSD.DeviceId = MD.DeviceId
WHERE StoragePoolName = @i_storagePoolName
;WITH maxBlockNumber_cte(maxBlockNumber)
AS (
	SELECT MAX(D.blockNumber)
	FROM MMDiskHWInfo D WITH (NOLOCK)
	INNER JOIN #deviceIds TMP ON D.deviceId = TMP.deviceId
),
hostList_cte
AS (
	SELECT DISTINCT D.hostId
	FROM MMDiskHWInfo D WITH (NOLOCK)
	INNER JOIN #deviceIds TMP ON D.deviceId = TMP.deviceId
),
controllerList_cte
AS (
	SELECT DISTINCT D.hostId
	FROM MMDiskHWInfo D WITH (NOLOCK)
	INNER JOIN #deviceIds TMP ON D.deviceId = TMP.deviceId
	WHERE mountPathUsageType = 1 --MOUNTPATH_DDB
),
newlyAddedNode_cte
AS (
	SELECT DISTINCT D.hostId
	FROM MMDiskHWInfo D WITH (NOLOCK)
		INNER JOIN maxBlockNumber_cte MBN ON MBN.maxBlockNumber = D.blockNumber
	INNER JOIN #deviceIds TMP ON D.deviceId = TMP.deviceId
)
SELECT H.hostId, ISNULL(C.hostId,0), ISNULL(N.hostId,0)
FROM hostList_cte H
	LEFT JOIN controllerList_cte C ON C.hostId =  H.hostId
	LEFT JOIN newlyAddedNode_cte N ON N.hostId = H.hostId
IF (OBJECT_ID ('temp.dbo.#deviceIds')) IS NOT NULL	DROP TABLE #deviceIds

IF EXISTS (select * from GxQscripts where name = 'MMGetControllerNodesForScaleOut')
	delete from GxQscripts where name = 'MMGetControllerNodesForScaleOut'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetControllerNodesForScaleOut')
	delete from GXDBVersions where aliasname = 'MMGetControllerNodesForScaleOut'
GO

insert into GXDBVersions values(2, 'MMGetControllerNodesForScaleOut',  '00000000000000000000', 'MMGetControllerNodesForScaleOut', '00000000000000000000')
GO

