

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetContentIndexedAFilesToPrune.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetContentIndexedAFilesToPrune.sp,v $ $Id: MMGetContentIndexedAFilesToPrune.sp,v 1.22.2.11 2019/10/11 16:34:18 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetContentIndexedAFilesToPrune')
BEGIN
	print '>>> Drop Stored Procedure: MMGetContentIndexedAFilesToPrune <<<'
	drop procedure MMGetContentIndexedAFilesToPrune
END
IF EXISTS (select * from GxQscripts where name='MMGetContentIndexedAFilesToPrune')
	delete from GxQscripts where name = 'MMGetContentIndexedAFilesToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetContentIndexedAFilesToPrune')
	delete from GXDBVersions where aliasname = 'MMGetContentIndexedAFilesToPrune'
GO
print '... Creating Procedure: MMGetContentIndexedAFilesToPrune'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetContentIndexedAFilesToPrune
  @i_archGroupId integer,
  @i_reserveParam integer = 0
AS
  DECLARE @o_AFileId integer
  DECLARE @o_CommCellNumber integer
  DECLARE @o_CloudId integer
  DECLARE @o_AppId integer
  DECLARE @o_PruneType integer
  DECLARE @o_reserveParam1 integer
  DECLARE @o_reserveParam2 integer
--
SET NOCOUNT ON
--
IF OBJECT_ID('tempdb.dbo.#AllCIEngineServers') IS NOT NULL     DROP TABLE #AllCIEngineServers
CREATE TABLE #AllCIEngineServers
(
	serverName    	NVARCHAR(MAX),
	clientId      	INT,
	clientName    	NVARCHAR(MAX),
	cloudId       	INT,
	hostName  		NVARCHAR(MAX),
	baseport  		INT,
	version       	VARCHAR(1024),
	engineName    	VARCHAR(1024),
	serverType		INT
)
--
declare @SolrCloud table
(
	cloudId int primary key
)
--
declare @FastServers table
(
	cloudId int primary key
)
--
if OBJECT_ID('tempdb..#ResultTable') is not null DROP TABLE #ResultTable
--
create table #ResultTable
(
	AFileId 		int,
	CommCellNumber	int,
	CloudId 		int,
	AppId 			int,
	PruneType		int,
	ReserveParam1 	int default (0),
	ReserveParam2 	int default (0),
	PRIMARY KEY (AFileId, CommCellNumber, CloudId, PruneType)
);
--
IF OBJECT_ID('tempdb.dbo.#SubclientPendingSynthfull') IS NOT NULL DROP TABLE #SubclientPendingSynthfull
CREATE TABLE #SubclientPendingSynthfull
(
		AppId         int,
		CommCellId    int,
		cloudId int,
		Primary Key(AppId, CommCellId, cloudId)
)
DECLARE @retVal			INTEGER = 0
BEGIN TRY
DECLARE @TranCounter INT
SET @TranCounter = @@TRANCOUNT
IF @TranCounter > 0
	SAVE TRANSACTION CI_PRUNE_TRAN
ELSE
	BEGIN TRANSACTION
--
INSERT INTO #AllCIEngineServers(serverName, clientId, clientName, cloudId, hostName, baseport, version, engineName, serverType)
EXEC AppGetFastServerList -- Returns both FAST and SOLR
--
insert into @SolrCloud(cloudId)
select distinct componentId from APP_ComponentProp (NOLOCK) where propertyTypeId = 1014
and componentType = 2 and stringVal LIKE  '%Solr%' and modified = 0
--
insert into @FastServers(cloudId) select distinct cloudId from #AllCIEngineServers
delete from @FastServers where cloudId in (select cloudId from @SolrCloud)
--
declare @ciTurboOption bit = 1
if exists (select 1 from GXGlobalParam (NOLOCK) where name = N'Content Indexing Turbo Option' and value = N'0')
set @ciTurboOption = 0
--
IF @i_archGroupId = 0
BEGIN
	DECLARE @pruneCIForAgedBackupJob INT
	SET @pruneCIForAgedBackupJob = ISNULL ((SELECT value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMS2_CONFIG_CI_AFILES_PRUNE_AGED_BACKUP_JOB'),0)
	-- Run the stored procedure to insert the prunable content indexed archive files
	-- into the archContentIndexingAged table.
	EXEC @retVal = archContentIndexingPrune @pruneCIForAgedBackupJob
	IF @retVal !=0
        GOTO RETURN_PROC
	--
DELETE archContentIndexingAged WHERE CloudId NOT IN (SELECT DISTINCT cloudID FROM #AllCIEngineServers) AND pruneType != 7
	SET @retVal = @@ERROR
	IF @retVal !=0
        GOTO RETURN_PROC
	--
IF EXISTS(SELECT 1 FROM archContentIndexingAged WITH(NOLOCK) WHERE pruneType = 7)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
			DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
		            (     serverURL NVARCHAR(512),
		                  clientId INT,
		                  clientName NVARCHAR(256),
		                  cloudId INT,
		                  hostName NVARCHAR(256),
		                  basePort INT,
		                  engineName  NVARCHAR(256),
		                  serverType INT,
		                  indexServerClientId INT,
		                  internalCloudName NVARCHAR(256)
		            )
		EXEC DM2GetIndexServers NULL, 0, 0, 0, 0, 0
		/*
			This is to get rid of archive files of cloud that doesn't exist any more
		*/
DELETE archContentIndexingAged WHERE cloudId NOT IN (SELECT cloudId FROM #getIndexServers) AND pruneType = 7
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL
			DROP TABLE #getIndexServers
	END
	--
EXEC @retVal = archContentIndexingPruneByOperationType @pruneCIForAgedBackupJob, 1
	IF @retVal !=0
        GOTO RETURN_PROC
	--
	IF @i_reserveParam = 1 BEGIN
		-- We need to return aged items only for FAST clouds.
		insert into #ResultTable(AFileId, CommCellNumber, CloudId, AppId, PruneType, ReserveParam1, ReserveParam2)
		select
			AGEDCI.archFileId, CELL.number, AGEDCI.cloudId, AGEDCI.appId, AGEDCI.pruneType, 0, 0
		from
			archContentIndexingAged AS AGEDCI with (nolock)
		inner join
			APP_CommCell AS CELL with (nolock)
		on
AGEDCI.commCellId = CELL.id AND AGEDCI.operationType = 1
		inner join
			@FastServers FS
		on
			FS.cloudId = AGEDCI.cloudId
where AGEDCI.pruneType != 7
	END
	ELSE BEGIN
		-- We need to return aged items only for FAST & Solr clouds.
		insert into #ResultTable(AFileId, CommCellNumber, CloudId, AppId, PruneType, ReserveParam1, ReserveParam2)
		select
			AGEDCI.archFileId, CELL.number, AGEDCI.cloudId, AGEDCI.appId, AGEDCI.pruneType, 0, 0
		from
			archContentIndexingAged AS AGEDCI with (nolock)
		inner join
			APP_CommCell AS CELL with (nolock)
		on
AGEDCI.commCellId = CELL.id AND AGEDCI.operationType = 1
		inner join
			(select distinct cloudId from #AllCIEngineServers) S
		on
			S.cloudId = AGEDCI.cloudId
where AGEDCI.pruneType != 7
	END
	--
	--Do not send VSA content indexed archive files for CI pruning until entire job is pruned
	INSERT INTO #ResultTable(AFileId, CommCellNumber, CloudId, AppId, PruneType, ReserveParam1, ReserveParam2)
	SELECT AGEDCI.archFileId, AGEDCI.commCellId, AGEDCI.cloudId, AGEDCI.appId, AGEDCI.pruneType, 0, 0
	FROM archContentIndexingAged AS AGEDCI WITH (NOLOCK)
WHERE AGEDCI.pruneType = 7
	AND NOT EXISTS (SELECT 1 FROM JMJobDataStats JDS WITH (NOLOCK) WHERE AGEDCI.jobId = JDS.jobId AND AGEDCI.commcellId = JDS.commcellId AND JDS.status IN(100, 102, 103))
	if @ciTurboOption = 1
	BEGIN
		create nonclustered index IDX_MMGetContentIndexedAFilesToPrune_RESULTTABLE_APPID on #ResultTable (AppId);
		--
		-- We should not send any AGED files for pruning in case a future synthetic full
		-- has not been content indexed for a particular subclient.
		-- Files which need to be pruned for reason where user has DELETED a Content Indexing
		-- job or where a subclient is DELETED should be pruned immediately.
		-- Note: this is applicable only for Solr items.
		IF OBJECT_ID('tempdb.dbo.#SubclientInfoAgedAFs') IS NOT NULL DROP TABLE #SubclientInfoAgedAFs
		create table #SubclientInfoAgedAFs
		(
			AppId 		int,
			CommCellId	int,
			MaxContentIndexedArchFileId int,  -- max archive file per subclient in the aged table
			Primary Key(AppId, CommCellId)
		)
		--
		insert into #SubclientInfoAgedAFs(AppId, CommCellId, MaxContentIndexedArchFileId)
		select
			a.appId, a.commCellId, max(a.archFileId)
		from
			archContentIndexingAged a with (NOLOCK)
		inner join
			@SolrCloud c
		on
c.cloudId = a.cloudId AND a.operationType = 1
		where
a.pruneType = 3
		group by
			commCellId, appId
		-- Get the subclients which have future SF not indexed
		INSERT INTO #SubclientPendingSynthfull (AppId, CommCellId, cloudId )
		SELECT DISTINCT af.AppId,  af.CommCellId, R.cloudId
              FROM  archFile af with (nolock)
              JOIN    JMBkpStats j with (nolock) ON   j.jobId = af.jobId and j.commCellId = af.commCellId
JOIN	  archContentIndexingRules R with (NOLOCK) ON R.archGroupId = af.archGroupId and R.enabled = 1 AND R.operationType = 1
			  JOIN    #SubclientInfoAgedAFs T ON  af.appId = T.AppId
              where  (af.id > T.MaxContentIndexedArchFileId and af.commCellId = T.CommCellId)
                    and j.bkpLevel in (0x40 /*SYNTHETIC_FULL*/, 0x80 /*SYNTHETIC_FULL_AND_INCR*/, 0x4000 /*SYNTHETIC_FULL_AND_INCR_BEFORE*/)
					and af.flags & (16 | 32 | 128) > 0
                    and j.status = 1 -- completed backup jobs
AND AF.FileType = 1
		--Prevent pruning of subclients whose future SF is not indexed
		delete T
		from #ResultTable T
		inner join #SubclientPendingSynthfull P on P.appId = T.AppId and PruneType = 3 and T.CloudId = P.cloudId
		DROP TABLE #SubclientPendingSynthfull
		--
	END
END
ELSE BEGIN
	-- Pick archfile based on the given archGroupid for re-content indexing jobs
	-- Make sure the archfile is in both table archContentIndexingAged and archContentIndexingAF.
	-- Entries in archContentIndexingAged table should already be present when repick jobs for content indexing
	-- Remove the entries in archContentIndexingAged table if the cloud doesn't exist anymore
	--
DELETE archContentIndexingAged WHERE CloudId NOT IN (SELECT DISTINCT cloudID FROM #AllCIEngineServers) AND pruneType != 7
	SET @retVal = @@ERROR
	IF @retVal !=0
        GOTO RETURN_PROC
	--
	insert into #ResultTable(AFileId, CommCellNumber, CloudId, AppId, PruneType, ReserveParam1, ReserveParam2)
	SELECT
		DISTINCT AGEDCI.archFileId, CELL.number, AGEDCI.cloudId, AGEDCI.appId, AGEDCI.pruneType, 0, 0
	FROM
		ArchFile AS AF WITH (NOLOCK)
	INNER JOIN
		archContentIndexingAged AS AGEDCI WITH (NOLOCK)
	ON
		AGEDCI.commCellId = AF.CommCellId
		AND AGEDCI.archFileId = AF.id
AND AGEDCI.operationType = 1
	INNER JOIN
		APP_CommCell AS CELL WITH (NOLOCK)
	ON
		CELL.id = AF.CommCellId
	INNER JOIN
		@SolrCloud CP
	ON
		CP.cloudId = AGEDCI.cloudId
	WHERE
		AF.archGroupId = @i_archGroupId
		AND AGEDCI.agedFlag = 0
AND AF.FileType =1
AND AGEDCI.pruneType != 7
	--
END
IF @TranCounter = 0
	COMMIT TRANSACTION
ELSE
	COMMIT TRANSACTION CI_PRUNE_TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @retVal = ERROR_NUMBER()
END CATCH
RETURN_PROC:
IF @retVal !=0
BEGIN
	IF @TranCounter = 0
		ROLLBACK TRANSACTION
	ELSE
         IF XACT_STATE() <> -1
			ROLLBACK TRANSACTION CI_PRUNE_TRAN
END
DROP TABLE #AllCIEngineServers
--
--
IF OBJECT_ID('tempdb.dbo.#SubclientInfoAgedAFs') IS NOT NULL DROP TABLE #SubclientInfoAgedAFs
SELECT AFileId, CommCellNumber, CloudId, AppId, PruneType, ReserveParam1, ReserveParam2 FROM #ResultTable ORDER BY AppId, CloudId, AFileId
--
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetContentIndexedAFilesToPrune')
	delete from GxQscripts where name = 'MMGetContentIndexedAFilesToPrune'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetContentIndexedAFilesToPrune')
	delete from GXDBVersions where aliasname = 'MMGetContentIndexedAFilesToPrune'
GO

insert into GXDBVersions values(2, 'MMGetContentIndexedAFilesToPrune',  '00010022000200110000', 'MMGetContentIndexedAFilesToPrune', '00010022000200110000')
GO

