

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetCloudVMsToPowerON.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetCloudVMsToPowerON.sp,v $ $Id: MMGetCloudVMsToPowerON.sp,v 1.1.2.16 2018/03/29 23:25:41 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMGetCloudVMsToPowerON"               			|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
	This will return the list of VMs need to be power on.
	Send power on request again if RequestStatus should be in processing and VM power status in starting but still not powered on more than 5 mins
	If reach max retry count then should not send power on request
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetCloudVMsToPowerON <<<'

IF EXISTS (select * from sysobjects where name='MMGetCloudVMsToPowerON')
	drop procedure MMGetCloudVMsToPowerON
IF EXISTS (select * from GxQscripts where name='MMGetCloudVMsToPowerON')
	delete from GxQscripts where name = 'MMGetCloudVMsToPowerON'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMsToPowerON')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMsToPowerON'
GO
print '... Creating Procedure: MMGetCloudVMsToPowerON'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetCloudVMsToPowerON
AS
  DECLARE @o_HostId Integer
DECLARE @MaxRetrycount INTEGER = 3
DECLARE @RetryAfterTimeLimit INTEGER = 60 --seconds
DECLARE @tmpHostTable TABLE(HostId Integer)
DECLARE @currentUTCTime BIGINT = dbo.GetUnixTime(GetUTCDate())
-- Sending Power on request to requested MAs by RM, JM, GUI, Schedule, Pruning
	INSERT INTO @tmpHostTable
	SELECT DISTINCT VM.HostId FROM MMVMPowerMgmtReq VM WITH (NOLOCK), MMHost H WITH (NOLOCK)
	WHERE VM.HostId = H.ClientId
AND VM.RequestStatus = 1
	--AND H.MmHostSoftState <> 1
	AND H.MmHostEnabled = 1
AND (VM.Flags & 4) = 0
	-- version checks
	-- not in maintenance
-- Handle if the request comes to the same VM but power on request already sent to it. don't send request again and update RequestStatus
	DECLARE @tmpRequestSentList TABLE(HostId INTEGER, PowerStatus INTEGER)
	INSERT INTO @tmpRequestSentList
	SELECT DISTINCT TMP.HostId, PH.PowerStatus FROM @tmpHostTable TMP
	INNER JOIN MMPowerMgmtHost PH WITH (NOLOCK) ON PH.HostId = TMP.HostId
AND PH.PowerStatus IN (1, 2, 3)
	IF EXISTS(SELECT HostId FROM @tmpRequestSentList)
	BEGIN
		DELETE TMPSend
		FROM @tmpHostTable TMPSend
		INNER JOIN @tmpRequestSentList TMP ON TMP.HostID = TMPSend.HostId
		Update VM
SET VM.RequestStatus = 3,
		VM.LastUpdateTime = @currentUTCTime
		FROM MMVMPowerMgmtReq VM
		INNER JOIN @tmpRequestSentList TMP ON TMP.HostId = VM.HostId
WHERE VM.RequestStatus = 1
AND TMP.PowerStatus <> 1
	END
-- Already sent request but still VMs are not powered on, So again sending request to those VMs
	INSERT INTO @tmpHostTable
	SELECT DISTINCT VM.HostId FROM MMVMPowerMgmtReq VM WITH (NOLOCK)
	INNER JOIN MMHost H WITH (NOLOCK) ON H.ClientId = VM.HostId AND H.MmHostSoftState = 0 AND H.MmHostEnabled = 1
	INNER JOIN MMPowerMgmtHost PH WITH (NOLOCK) ON PH.HostId = VM.HostId
WHERE VM.RequestStatus = 2
	AND ( @currentUTCTime - VM.LastUpdateTime) >= @RetryAfterTimeLimit
	AND VM.RetryCount < @MaxRetryCount																-- if retry count >= 3 then won't send
	AND VM.FailureReason = 1
	AND VM.HostId NOT IN (SELECT HostId FROM @tmpHostTable)
AND (VM.Flags & 4) = 0
	DELETE TMP
	FROM @tmpHostTable TMP
INNER JOIN MMPowerMgmtHost PH WITH (NOLOCK) ON PH.HostId = TMP.HostId AND PH.PowerStatus = 4
-- If Powered on failed and tried max times then won't try to power on.
	DECLARE @TmpHostStopTryPowerOn TABLE(HostId INTEGER, RequestId INTEGER)
	INSERT INTO @TmpHostStopTryPowerOn
	SELECT PH.HostId, VM.RequestId FROM MMPowerMgmtHost PH WITH (NOLOCK)
	INNER JOIN MMVMPowerMgmtReq VM WITH (NOLOCK) ON VM.HostId = PH.HostId
WHERE VM.RequestStatus = 2
	AND (VM.RetryCount = @MaxRetryCount  OR VM.RetryCount > @MaxRetryCount)
AND (VM.Flags & 4) = 0
	AND VM.FailureReason = 1
	UPDATE PH
SET PH.PowerStatus = 5
	FROM MMPowerMgmtHost PH
	INNER JOIN @TmpHostStopTryPowerOn TMP ON TMP.HostId = PH.HostId
	UPDATE VM
	SET VM.FailureReason = 2,
VM.RequestStatus = 3,
	VM.RetryCount = CASE WHEN VM.RetryCount < @MaxRetryCount THEN @MaxRetryCount
					ELSE VM.Retrycount
					END,
	VM.LastUpdateTime = @currentUTCTime
	FROM MMVMPowerMgmtReq VM
	INNER JOIN @TmpHostStopTryPowerOn TMP ON TMP.HostId = VM.HostId	AND TMP.RequestId = VM.RequestId
SELECT DISTINCT HostId FROM @tmpHostTable
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetCloudVMsToPowerON')
	delete from GxQscripts where name = 'MMGetCloudVMsToPowerON'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMsToPowerON')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMsToPowerON'
GO

insert into GXDBVersions values(2, 'MMGetCloudVMsToPowerON',  '00010001000200160000', 'MMGetCloudVMsToPowerON', '00010001000200160000')
GO

