

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetCloudVMsToNotifyJM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetCloudVMsToNotifyJM.sp,v $ $Id: MMGetCloudVMsToNotifyJM.sp,v 1.1.4.8 2018/03/19 23:58:32 jiechen Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMGetCloudVMsToNotifyJM"               		|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
	If machines requested by JM to power on, then need to notify back to the JM once all the machines are powered on for the job.
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetCloudVMsToNotifyJM <<<'

IF EXISTS (select * from sysobjects where name='MMGetCloudVMsToNotifyJM')
	drop procedure MMGetCloudVMsToNotifyJM
IF EXISTS (select * from GxQscripts where name='MMGetCloudVMsToNotifyJM')
	delete from GxQscripts where name = 'MMGetCloudVMsToNotifyJM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMsToNotifyJM')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMsToNotifyJM'
GO
print '... Creating Procedure: MMGetCloudVMsToNotifyJM'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetCloudVMsToNotifyJM
  @i_flag integer
AS
  DECLARE @o_ClientGUID VARCHAR(36)
  DECLARE @o_JobId INTEGER
DECLARE @NotifyHostList TABLE (HostId INTEGER)
DECLARE @tmpJobHostMap TABLE (JobId Integer, CommCellId Integer, HostId Integer, isOnline INTEGER)
DECLARE @NoNeedToNotifyAnyMore TABLE (JobId Integer, commCellId Integer, primary key (JobId, commCellId))
DECLARE @WaitingToProcessJobs TABLE (JobId Integer, CommcellId Integer, primary key (JobId, CommcellId))
IF @i_flag = 1
BEGIN
	INSERT INTO @tmpJobHostMap
	SELECT EntityId, EntityCommCellId, HostId, 0 FROM MMPowerMgmtJobToVMMap WITH (NOLOCK)
WHERE (Flag & 16) = 16 AND (Flag & 32) = 0
AND EntityType = 1
	IF EXISTS (SELECT 1 FROM @tmpJobHostMap)
	BEGIN
			-- Delete if power on request not processed for any VM
			INSERT INTO @WaitingToProcessJobs
			SELECT DISTINCT TMP.JobId, TMP.CommCellId FROM @tmpJobHostMap TMP
INNER JOIN MMVMPowerMgmtReq VM ON VM.HostId = TMP.HostId AND VM.RequestStatus <> 3
			DELETE TMP
			FROM @tmpJobHostMap TMP
			INNER JOIN @WaitingToProcessJobs TMP1 ON TMP.JobId = TMP1.JobId AND TMP.CommCellId = TMP1.CommCellId
			INSERT INTO @NoNeedToNotifyAnyMore
			SELECT DISTINCT TMP.JobId, TMP.CommCellId FROM @tmpJobHostMap TMP
			LEFT OUTER JOIN JMJobInfo JM WITH (NOLOCK) ON TMP.JobId = JM.jobId AND TMP.CommCellId = JM.commCellId
			WHERE JM.jobId IS NULL
			--Deleting those host no need to notify anymore will remove from map
			DELETE TMP
			FROM @tmpJobHostMap TMP
			INNER JOIN @NoNeedToNotifyAnyMore NON ON TMP.JobId = NON.JobId AND TMP.CommCellId = NON.commCellId
			-- Updating Flags for those no need to notify anymore
			UPDATE VM
SET VM.Flag = (Flag | 32)
			FROM MMPowerMgmtJobToVMMap VM
INNER JOIN @NoNeedToNotifyAnyMore NON ON NON.JobId = VM.EntityId AND VM.EntityType = 1 AND NON.commCellId = VM.EntityCommCellId
			--Update online status
			UPDATE TMP
			SET TMP.isOnline = H.MmHostSoftState
			FROM @tmpJobHostMap TMP
			INNER JOIN MMHost H WITH (NOLOCK) ON H.ClientId = TMP.HostId
			-- Remove jobs if any one host is not online which are all requested by the job
			DELETE TMP
			FROM @tmpJobHostMap TMP
			INNER JOIN
			(SELECT DISTINCT JobId, CommCellId FROM @tmpJobHostMap WHERE isOnline = 0) NTR ON NTR.JobId = TMP.JobId  AND NTR.CommCellId = TMP.CommCellId
	END
		INSERT INTO @NotifyHostList
		SELECT DISTINCT HostId FROM @tmpJobHostMap
		-- Notify the JM for the hosts which are failed to submit power on request
		INSERT INTO @NotifyHostList
		SELECT DISTINCT PROP.componentNameId  FROM APP_ClientProp PROP WITH (NOLOCK)
		LEFT OUTER JOIN MMPowerMgmtJobToVMMap VM WITH (NOLOCK) ON VM.HostId = PROP.componentNameId
WHERE (VM.Flag & 16) = 16 AND (VM.Flag & 32) = 0
		AND PROP.attrName = 'Cloud VM Managment Power On Pending' AND PROP.modified = 0 AND CAST(PROP.attrVal AS INTEGER) = 1
		AND VM.HostId IS NULL
		--Nofity the JM if the requested hosts failed to power on
		INSERT INTO @NotifyHostList
		SELECT DISTINCT PROP.componentNameId  FROM APP_ClientProp PROP WITH (NOLOCK)
		INNER JOIN MMPowerMgmtJobToVMMap VMMap WITH (NOLOCK) ON VMMap.HostId = PROP.componentNameId
		INNER JOIN MMVMPowerMgmtReq VM WITH (NOLOCK) ON VM.RequestId = VMMap.RequestId AND VM.FailureReason = 2
WHERE (VMMap.Flag & 16) = 16 AND (VMMap.Flag & 32) = 0
		AND PROP.attrName = 'Cloud VM Managment Power On Pending' AND PROP.modified = 0 AND CAST(PROP.attrVal AS INTEGER) = 1
		SELECT DISTINCT CAST(GUID AS VARCHAR(36)),0 FROM APP_Client APP WITH (NOLOCK)
		INNER JOIN @NotifyHostList TMP ON TMP.HostId = APP.id
END
ELSE IF @i_flag = 2
BEGIN
	INSERT INTO @tmpJobHostMap
	SELECT EntityId, EntityCommCellId, HostId, 0 FROM MMPowerMgmtJobToVMMap WITH (NOLOCK)
WHERE (Flag & 1) = 1 AND (Flag & 32) = 0 AND EntityType = 1
	IF EXISTS (SELECT 1 FROM @tmpJobHostMap)
	BEGIN
			-- Delete if power on request not processed for any VM
			INSERT INTO @WaitingToProcessJobs
			SELECT DISTINCT TMP.JobId, TMP.CommCellId FROM @tmpJobHostMap TMP
INNER JOIN MMVMPowerMgmtReq VM ON VM.HostId = TMP.HostId AND VM.RequestStatus <> 3
			DELETE TMP
			FROM @tmpJobHostMap TMP
			INNER JOIN @WaitingToProcessJobs TMP1 ON TMP.JobId = TMP1.JobId AND TMP.CommCellId = TMP1.CommCellId
			INSERT INTO @NoNeedToNotifyAnyMore
			SELECT DISTINCT TMP.JobId, TMP.CommCellId FROM @tmpJobHostMap TMP
			LEFT OUTER JOIN JMJobInfo JM WITH (NOLOCK) ON TMP.JobId = JM.jobId AND TMP.CommCellId = JM.commCellId
			WHERE JM.jobId IS NULL
			--Deleting those host no need to notify anymore will remove from map
			DELETE TMP
			FROM @tmpJobHostMap TMP
			INNER JOIN @NoNeedToNotifyAnyMore NON ON TMP.JobId = NON.JobId AND TMP.CommCellId = NON.commCellId
			-- Updating Flags for those no need to notify anymore
			UPDATE VM
SET VM.Flag = (Flag | 32)
			FROM MMPowerMgmtJobToVMMap VM
INNER JOIN @NoNeedToNotifyAnyMore NON ON NON.JobId = VM.EntityId AND VM.EntityType = 1 AND NON.commCellId = VM.EntityCommCellId
			--Update online status
			UPDATE TMP
			SET TMP.isOnline = H.MmHostSoftState
			FROM @tmpJobHostMap TMP
			INNER JOIN MMHost H WITH (NOLOCK) ON H.ClientId = TMP.HostId
			-- Remove jobs if any one host is not online which are all requested by the job
			DELETE TMP
			FROM @tmpJobHostMap TMP
			INNER JOIN
			(SELECT DISTINCT JobId, CommCellId FROM @tmpJobHostMap WHERE isOnline = 0) NTR ON NTR.JobId = TMP.JobId  AND NTR.CommCellId = TMP.CommCellId
			-- Do not notify if the job is not pending
			DELETE TMP
			FROM @tmpJobHostMap TMP
			INNER JOIN JMJobInfo JM WITH (NOLOCK) ON JM.JobId = TMP.JobId  AND JM.CommCellId = TMP.CommCellId AND JM.state <> 2 --PENDING
	END
	SELECT DISTINCT '', JobId FROM @tmpJobHostMap
END
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetCloudVMsToNotifyJM')
	delete from GxQscripts where name = 'MMGetCloudVMsToNotifyJM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMsToNotifyJM')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMsToNotifyJM'
GO

insert into GXDBVersions values(2, 'MMGetCloudVMsToNotifyJM',  '00010001000400080000', 'MMGetCloudVMsToNotifyJM', '00010001000400080000')
GO

