

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetCloudVMsTOPowerONForScheduleJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetCloudVMsTOPowerONForScheduleJobs.sp,v $ $Id: MMGetCloudVMsTOPowerONForScheduleJobs.sp,v 1.1.2.7 2018/03/20 00:17:56 jiechen Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMGetCloudVMsTOPowerONForScheduleJobs"         |
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
	This will return the list of VMs need to be power on.
	i_purpose - 1 -> Power ON
	i_purpose - 2 -> Power OFF
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetCloudVMsTOPowerONForScheduleJobs <<<'

IF EXISTS (select * from sysobjects where name='MMGetCloudVMsTOPowerONForScheduleJobs')
	drop procedure MMGetCloudVMsTOPowerONForScheduleJobs
IF EXISTS (select * from GxQscripts where name='MMGetCloudVMsTOPowerONForScheduleJobs')
	delete from GxQscripts where name = 'MMGetCloudVMsTOPowerONForScheduleJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMsTOPowerONForScheduleJobs')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMsTOPowerONForScheduleJobs'
GO
print '... Creating Procedure: MMGetCloudVMsTOPowerONForScheduleJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetCloudVMsTOPowerONForScheduleJobs
  @i_purpose INTEGER
AS
  DECLARE @o_HostId INTEGER 
DECLARE @i_timeRange INT = 10
DECLARE @tmpHostTbl TABLE (HostId INTEGER)
IF OBJECT_ID('tempdb.dbo.#subClientList') IS NOT NULL
	DROP TABLE #subClientList
CREATE TABLE #subClientList ( clientId INT, subclientId INT, dataSp INT, logSp INT)
CREATE CLUSTERED INDEX subClientList_subclientID ON #subClientList(subclientId)
CREATE NONCLUSTERED INDEX subClientList_dataSP_logSP ON #subClientList(dataSp, logSp)
DECLARE @CurrentUTCdate datetime = GETUTCDATE()
-- Getting list of subclients which has schedules
INSERT INTO #subClientList
	SELECT  DISTINCT APP.clientId, APP.id, APP.dataArchGrpID, APP.logArchGrpID
	FROM      TM_subTask AS STASK WITH (NOLOCK)
			   INNER JOIN TM_PatternAssoc AS PAS WITH (NOLOCK) ON PAS.subTaskId = STASK.subTaskId
			   INNER JOIN TM_Task TASK WITH (NOLOCK) ON TASK.taskId = STASK.taskId AND TASK.disabled = 0
			   INNER JOIN TM_Pattern AS PAT WITH (NOLOCK) ON PAT.patternId = PAS.patternId
			   INNER JOIN TM_AssocEntity AS ENT WITH (NOLOCK) ON STASK.taskId = ENT.taskId
			   INNER JOIN APP_Application AS APP WITH (NOLOCK) ON APP.clientId = ENT.clientId
					AND APP.appTypeId = CASE WHEN ENT.apptypeId > 0 THEN ENT.apptypeId ELSE APP.appTypeId END
					AND APP.instance = CASE WHEN ENT.instanceId > 0 THEN ENT.instanceId ELSE APP.instance END
					AND APP.backupSet = CASE WHEN ENT.backupsetId > 0 THEN ENT.backupsetId ELSE APP.backupSet END
					AND APP.id = CASE WHEN ENT.subclientId > 0 THEN ENT.subclientId ELSE APP.id END
               INNER JOIN TM_RunTime AS NRT WITH (NOLOCK) ON NRT.patternId = PAS.patternId AND NRT.processed = 0
    WHERE     PAT.deleted = 0 AND datediff(MINUTE, @CurrentUTCdate, NRT.nextRunTime) <= @i_timeRange
IF @i_purpose = 1
BEGIN
INSERT INTO @tmpHostTbl
SELECT DISTINCT MH.ClientId FROM archGroup AG WITH (NOLOCK)
					INNER JOIN #subClientList SC ON ( AG.id = SC.dataSp OR AG.id = SC.logSp )
					INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON ( AGC.id = AG.defaultCopy OR AGC.id = AG.defaultSnapCopy )
					INNER JOIN MMDataPath DP WITH (NOLOCK) ON DP.copyId = AGC.id
					INNER JOIN MMDrivePool DRP WITH (NOLOCK) ON DRP.DrivePoolId = DP.DrivePoolId
					INNER JOIN MMHost MH WITH (NOLOCK) ON DRP.clientId = MH.clientId
WHERE (MH.Attribute & 32768) = 32768 AND MH.MmHostSoftState = 0
END
ELSE IF @i_purpose	= 2
BEGIN
INSERT INTO @tmpHostTbl
SELECT DISTINCT MH.ClientId FROM archGroup AG WITH (NOLOCK)
					INNER JOIN #subClientList SC ON ( AG.id = SC.dataSp OR AG.id = SC.logSp )
					INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON ( AGC.id = AG.defaultCopy OR AGC.id = AG.defaultSnapCopy )
					INNER JOIN MMDataPath DP WITH (NOLOCK) ON DP.copyId = AGC.id
					INNER JOIN MMDrivePool DRP WITH (NOLOCK) ON DRP.DrivePoolId = DP.DrivePoolId
					INNER JOIN MMHost MH WITH (NOLOCK) ON DRP.clientId = MH.clientId
WHERE (MH.Attribute & 32768) = 32768
END
-- DDB MA
IF @i_purpose = 1
BEGIN
	INSERT INTO @tmpHostTbl
	SELECT DISTINCT SUB.ClientID FROM archGroup AG WITH (NOLOCK)
	INNER JOIN #subClientList TMP ON (TMP.dataSp = AG.id OR TMP.logSp = AG.id)
	INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = AG.defaultCopy
	INNER JOIN archCopySIDBStore AG2SIDB WITH (NOLOCK) ON AGC.id = AG2SIDB.CopyId
	INNER JOIN IdxSIDBSubStore SUB WITH (NOLOCK) ON AG2SIDB.SIDBStoreId = SUB.SIDBStoreId
	INNER JOIN MMHost MH WITH (NOLOCK) ON MH.ClientId = SUB.clientId
WHERE (MH.Attribute & 32768) = 32768 AND MH.MmHostSoftState = 0
	AND SUB.clientId NOT IN (SELECT HostId FROM @tmpHostTbl)
END
ELSE IF @i_purpose	= 2
BEGIN
	INSERT INTO @tmpHostTbl
	SELECT DISTINCT SUB.ClientID FROM archGroup AG WITH (NOLOCK)
	INNER JOIN #subClientList TMP ON (TMP.dataSp = AG.id OR TMP.logSp = AG.id)
	INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON AGC.id = AG.defaultCopy
	INNER JOIN archCopySIDBStore AG2SIDB WITH (NOLOCK) ON AGC.id = AG2SIDB.CopyId
	INNER JOIN IdxSIDBSubStore SUB WITH (NOLOCK) ON AG2SIDB.SIDBStoreId = SUB.SIDBStoreId
	INNER JOIN MMHost MH WITH (NOLOCK) ON MH.ClientId = SUB.clientId
WHERE (MH.Attribute & 32768) = 32768
	AND SUB.clientId NOT IN (SELECT HostId FROM @tmpHostTbl)
END
-- If VSA sub clients then need to power on proxy machine also
DECLARE @proxyXMLTable TABLE(AppId INTEGER, proxyList XML)
-- Getting sub client level proxy list
INSERT INTO @proxyXMLTable
SELECT APP.id, CAST(prop.attrVal as XML) FROM APP_Application APP WITH (NOLOCK)
INNER JOIN #subClientList tmp ON tmp.subclientId = APP.id AND APP.appTypeId = 106
	INNER JOIN APP_subClientProp prop WITH (NOLOCK) ON prop.attrName = 'Virtual Server Proxy Client List' and prop.componentNameId = APP.id AND prop.modified = 0
DELETE TMP
FROM @proxyXMLTable TMP
WHERE CAST(TMP.proxyList AS VARCHAR (MAX)) not like '%clientId="%'
and CAST(TMP.proxyList AS VARCHAR (MAX)) not like  '%clientGroupId="%'
-- Getting instance level proxy list
INSERT INTO @proxyXMLTable
SELECT APP.id, CAST(prop.attrVal as XML) FROM APP_Application APP WITH (NOLOCK)
	INNER JOIN #subClientList tmp ON APP.id = tmp.subclientId
	INNER JOIN APP_InstanceProp prop WITH (NOLOCK) ON prop.componentNameId = APP.instance AND prop.attrName = 'Vs Member Servers' AND prop.modified = 0
WHERE APP.appTypeId = 106 AND APP.id not in (SELECT AppId FROM @proxyXMLTable)
DECLARE @proxyXML XML
DECLARE GetProxyCur CURSOR FOR
SELECT proxyList FROM @proxyXMLTable
OPEN GetProxyCur
FETCH NEXT FROM GetProxyCur INTO @proxyXML
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @iXML INTEGER
	DECLARE @clientList TABLE (ClientId INTEGER)
	DECLARE @nodeName NVARCHAR(100)
	EXEC sp_xml_preparedocument @iXML OUTPUT, @proxyXML
	SET @NodeName  = '/App_MemberServers/memberServers/client'
	INSERT INTO @clientList
	SELECT CONVERT(INTEGER,clientId)
	FROM OPENXML(@iXML,@nodeName,1)
	WITH
	(
		clientId NVARCHAR(10) '@clientId'
	)
	INSERT INTO @clientList
	SELECT CLAS.clientId
	FROM OPENXML(@iXML,@nodeName,1)
	WITH
	(
		clientGroupId NVARCHAR(10) '@clientGroupId'
	) XMLTbl
	INNER JOIN APP_ClientGroupAssoc CLAS WITH (NOLOCK) ON CLAS.clientGroupId = XMLTbl.clientGroupId
	IF @i_purpose = 1
	BEGIN
		INSERT INTO @tmpHostTbl
		SELECT MH.ClientId FROM @clientList tmp
		INNER JOIN MMHost MH WITH (NOLOCK) ON MH.clientId = tmp.clientId
		LEFT OUTER JOIN @tmpHostTbl HTMP ON MH.ClientId = HTMP.HostId
WHERE (MH.Attribute & 32768) = 32768 AND MH.MmHostSoftState = 0
		AND HTMP.HostId IS NULL
	END
	ELSE IF @i_purpose	= 2
	BEGIN
		INSERT INTO @tmpHostTbl
		SELECT MH.ClientId FROM @clientList tmp
		INNER JOIN MMHost MH WITH (NOLOCK) ON MH.clientId = tmp.clientId
		LEFT OUTER JOIN @tmpHostTbl HTMP ON MH.ClientId = HTMP.HostId
WHERE (MH.Attribute & 32768) = 32768
		AND HTMP.HostId IS NULL
	END
	FETCH NEXT FROM GetProxyCur INTO @proxyXML
END
CLOSE GetProxyCur
DEALLOCATE GetProxyCur
SELECT HostId FROM @tmpHostTbl
IF OBJECT_ID('tempdb.dbo.#subClientList') IS NOT NULL
	DROP TABLE #subClientList
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetCloudVMsTOPowerONForScheduleJobs')
	delete from GxQscripts where name = 'MMGetCloudVMsTOPowerONForScheduleJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMsTOPowerONForScheduleJobs')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMsTOPowerONForScheduleJobs'
GO

insert into GXDBVersions values(2, 'MMGetCloudVMsTOPowerONForScheduleJobs',  '00010001000200070000', 'MMGetCloudVMsTOPowerONForScheduleJobs', '00010001000200070000')
GO

