

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetCloudVMsNeedToPowerONForPruning.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetCloudVMsNeedToPowerONForPruning.sp,v $ $Id: MMGetCloudVMsNeedToPowerONForPruning.sp,v 1.1.2.12 2019/12/03 21:51:15 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMGetCloudVMsNeedToPowerONForPruning"         	|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
	This will return the list of VMs need to be power on for pruning.
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetCloudVMsNeedToPowerONForPruning')
BEGIN
	print '>>> Drop Stored Procedure: MMGetCloudVMsNeedToPowerONForPruning <<<'
	drop procedure MMGetCloudVMsNeedToPowerONForPruning
END
IF EXISTS (select * from GxQscripts where name='MMGetCloudVMsNeedToPowerONForPruning')
	delete from GxQscripts where name = 'MMGetCloudVMsNeedToPowerONForPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMsNeedToPowerONForPruning')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMsNeedToPowerONForPruning'
GO
print '... Creating Procedure: MMGetCloudVMsNeedToPowerONForPruning'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetCloudVMsNeedToPowerONForPruning
AS
  DECLARE @o_HostFailedToSubmitPowerOn Integer
DECLARE @ErrorCode INTEGER = 0
DECLARE @tmpPowerMgmtEnabledHostTable TABLE(HostId Integer, VolumeCount integer, ArchfileCount integer, SIDBVolumeCount integer, SIDBArchFileCount integer)
	INSERT INTO @tmpPowerMgmtEnabledHostTable
	SELECT MH.ClientId, 0 ,0, 0, 0 FROM MMHost MH WITH (NOLOCK)
	INNER JOIN MMPowerMgmtHost PH ON PH.HostId = MH.ClientId
WHERE (MH.Attribute & 16) = 0 AND (MH.Attribute & 32768) = 32768
if object_id('tempdb.dbo.#MountPathsList') is not null DROP TABLE #MountPathsList
CREATE TABLE #MountPathsList ( MountPathId INTEGER, MediaSideId INTEGER, HostId INTEGER, DeviceId INTEGER, rn INTEGER, DeviceControllerFlags INTEGER, MasterPoolId INTEGER, MountPathTypeId INTEGER, MountPathAttribute INTEGER
										 primary key (MountPathId, HostId)
									)
--Getting online mountpaths list
	INSERT INTO #MountPathsList
	SELECT DISTINCT MP.MountPathId, MP.MediaSideId, TH.HostId, DEV.DeviceId, ROW_NUMBER() OVER (PARTITION BY MP.MountPathId ORDER BY DC.DeviceControllerId), DC.UseCount, MP.MasterPoolId, MP.MountPathTypeId, MP.Attribute FROM MMDeviceController DC WITH (NOLOCK)
	INNER JOIN @tmpPowerMgmtEnabledHostTable TH ON DC.ClientId = TH.HostId AND DC.DeviceControllerEnabled = 1 --AND DC.DeviceAccessible = 1
AND (DC.DeviceAccessType & (2 | 16 | 32 | 128)) = 2
	INNER JOIN MMDevice DEV WITH (NOLOCK) ON DEV.DeviceId = DC.DeviceId AND DEV.DeviceEnabled = 1 AND DEV.DeviceBroken = 0
	INNER JOIN MMMountPathToStorageDevice MP2SD WITH (NOLOCK) ON DEV.DeviceId = MP2SD.DeviceId
	INNER JOIN MMMountPath MP WITH (NOLOCK) ON MP.MountPathId = MP2SD.MountPathId AND MP.MountPathTypeId IN (4 /*MOUNT_PATH_SHARED_STATIC*/, 5 /*MOUNT_PATH_SHARED_REPLICA*/, 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/)
								AND MP.isEnabled = 1 --AND MP.IsOffline = 1
AND (MP.Attribute & 16) = 0 AND (MP.Attribute & 8) = 8
if object_id('tempdb.dbo.#MountPathToDDBMediaAgant') is not null DROP TABLE #MountPathToDDBMediaAgant
CREATE TABLE #MountPathToDDBMediaAgant ( MountPathId INT, HostId INT, SIDBStoreId INT,
											 primary key (MountPathId, HostId, SIDBStoreId)
										)
-- We have all the online available deviceControllers. Now see if there are any controllers which can be specifically used to prune data for particular DDB.
	INSERT INTO #MountPathToDDBMediaAgant
	SELECT distinct M.MountPathId, I.ClientId, I.SIDBStoreId
	FROM    #MountPathsList M ,
	IdxSIDBSubStore I WITH (NOLOCK), archCopySIDBStore AC WITH (NOLOCK),
	MMDataPath D WITH (NOLOCK), MMDrivePool DP WITH (NOLOCK)
	WHERE I.SIDBStoreID = AC.SIDBStoreId AND I.FirstBackupTime > 0
AND I.flags & 256 = 0
	AND I.ClientId = M.HostId
	AND AC.copyId = D.CopyId
	AND D.DrivePoolId = DP.DrivePoolId
	AND M.MasterPoolId = DP.MasterPoolId
	AND M.MountPathTypeId <> 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/-- Device Controller for cloud pruning has to be picked only via useCount check on devCtrl
--Volume level pruning count
if object_id('tempdb.dbo.#tempVolList') is not null DROP TABLE #tempVolList
CREATE TABLE #tempVolList
(
    volumeId    INT,
    HostId  INT,
    DeviceId    INT,
    MountPathId     INT,
    MountPathTypeId INT,
    SIDBStoreId     INT,
    VolAttributes INT,
    FailureErrorCode INT,
    MPAttribute INT,
    CopyId INT,
    IsAgedStore INT
)
CREATE UNIQUE INDEX IX_tempVolList_VolumeId ON #tempVolList(VolumeId) WITH (IGNORE_DUP_KEY = ON)
	--non dedupe
	INSERT  INTO #tempVolList
    SELECT  V.VolumeId, 0, MP.DeviceId, MP.MountPathId,
            MP.MountPathTypeId, V.SIDBStoreId, V.Attributes, V.FailureErrorCode, MP.MountPathAttribute, ISNULL(ASR.ArchGroupCopyId, 0), 0
    FROM        MMVolume V WITH (NOLOCK) INNER JOIN #MountPathsList MP
                ON V.MediaSideId = MP.MediaSideId
                LEFT OUTER JOIN ArchStream ASR WITH (NOLOCK) ON ASR.MediaGroupId = V.MediaGroupId
    WHERE       V.VolumeFlags = 6 AND V.SIDBStoreId = 0
    ORDER BY V.VolumeId desc
	--dedupe
	INSERT  INTO #tempVolList
SELECT  V.VolumeId, 0, MP.DeviceId, MP.MountPathId, MP.MountPathTypeId, V.SIDBStoreId, V.Attributes, V.FailureErrorCode, MP.MountPathAttribute, ISNULL(ASR.ArchGroupCopyId, 0), STORE.flags & 256 /*256*/
    FROM        MMVolume V WITH (NOLOCK) INNER JOIN #MountPathsList MP
        ON V.MediaSideId = MP.MediaSideId
        INNER JOIN IdxSIDBStore STORE WITH (NOLOCK) ON V.SIDBStoreId = STORE.SIDBStoreId AND V.SIDBStoreId > 0
        LEFT OUTER JOIN ArchStream ASR WITH (NOLOCK) ON ASR.MediaGroupId = V.MediaGroupId
    WHERE       V.VolumeFlags = 6 AND NOT (
        -- Pruning is allowed for migrated commcells also
(STORE.CommCellId <> 2 AND (STORE.flags & 256 ) = 0)
        OR
        (
( (STORE.flags & 256 ) = 0 AND STORE.Status = 1 )
            OR
( (V.Attributes & 4) > 0 AND (STORE.flags & 256 ) = 0)
            OR
( (STORE.Flags & 2097152) > 0)
			OR
            (
(STORE.Flags & 536870912) = 0 AND (EXISTS (SELECT CopyId FROM archCopySIDBStore WHERE SIDBStoreId = STORE.SIDBStoreId))
            )
        )
	)
    ORDER BY ABS(V.FailureErrorCode) ASC
	-- update host ids for non cloud mps and based on data path settings
	UPDATE T
    SET HostId = MP.HostId
    FROM #tempVolList T INNER JOIN #MountPathsList MP  ON T.mountPathId = MP.mountPathId
    INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.CopyId = DP.CopyId
    INNER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MountPathAttribute & 256 > 0 AND T.CopyId > 0
AND DP.flag & 4 = 4
	AND MP.MountPathTypeId IN (4,5)
    -- update host ids for non cloud mps and NOT based on data path settings
    UPDATE T
    SET HostId = MP.HostId
    FROM #tempVolList T INNER JOIN #MountPathsList MP ON T.mountPathId = MP.mountPathId
WHERE (MP.MountPathAttribute & 256 = 0 OR T.CopyId = 0)
	AND MP.MountPathTypeId IN (4,5)
	-- update host ids for cloud mps
	--Set device controller based on data path settings if granular pruning is enabled. For aged stores pruner MA flag need not be set
    UPDATE T
    SET HostId = MP.HostId
    FROM #tempVolList T INNER JOIN #MountPathsList MP ON T.mountPathId = MP.mountPathId
    INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.CopyId = DP.CopyId
    INNER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MountPathAttribute & 256 > 0
AND MP.MountPathAttribute & 32 > 0
AND DP.flag & 4 > 0
AND (DP.flag & 64 > 0 OR T.IsAgedStore > 0)
    AND T.CopyId > 0
    AND MP.MountPathTypeId = 7
    --Set device controller based on data path settings if granular pruning is NOT enabled
    UPDATE T
    SET HostId = MP.HostId
    FROM #tempVolList T INNER JOIN #MountPathsList MP ON T.mountPathId = MP.mountPathId
    INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.CopyId = DP.CopyId
    INNER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MountPathAttribute & 256 > 0
AND MP.MountPathAttribute & 32 > 0
AND DP.flag & 4   = 4
    AND T.CopyId > 0
	AND MP.MountPathTypeId = 7
    --Set device controller NOT based on data path settings if granular pruning is enabled or NOT enabled. For aged stores pruner MA flag need not be set
    UPDATE T
    SET HostId = MP.HostId
    FROM #tempVolList T INNER JOIN #MountPathsList MP ON T.mountPathId = MP.mountPathId
WHERE (MP.MountPathAttribute & 256 = 0 OR T.CopyId = 0)
AND (MP.MountPathAttribute & 32  = 0 OR MP.DeviceControllerFlags & 1 > 0 OR T.IsAgedStore > 0)
	AND MP.MountPathTypeId = 7
UPDATE TMPHost
SET VolumeCount = T.VolCount
FROM  @tmpPowerMgmtEnabledHostTable TMPHost
INNER JOIN(SELECT HostId, Count(*) AS VolCount FROM #tempVolList GROUP BY HostId) T ON T.HostId = TMPHost.HostId
-- ArchFile leve pruning
if object_id('tempdb.dbo.#tempVolAFList') is not null DROP TABLE #tempVolAFList
CREATE TABLE #tempVolAFList
(
	volumeId        INT,
	AFileId         INT,
	ArchChunkId     BIGINT,
	HostId          INT,
	DeviceId        INT,
	MountPathId     INT,
	MountPathTypeId INT,
	SIDBStoreId     INT,
	commCellId      INT,
	sidbPruningFlag INT,
	subStoreBitField    INT,
	rn          INT,
	chunkCommCellId INT,
	copyId          INT,
	dc              INT,
	MPAttribute     INT,
	NewId           binary(6)
)
	-- All dedupe and non dedupe
	INSERT INTO #tempVolAFList
    SELECT V.VolumeId, DAF.archFileId, DAF.ArchChunkId, 0, 0, DAF.MountPathId, 0, DAF.SIDBStoreId, DAF.commCellId, DAF.sidbPruningFlag, DAF.subStoreBitField,
                    CASE WHEN DAF.SIDBStoreId > 0  THEN DENSE_RANK() OVER (PARTITION BY DAF.SIDBStoreId ORDER BY (DAF.Status & 2) desc, DAF.archFileId asc) ELSE 0 END,
					chunkCommCellId,
                    CASE WHEN DAF.copyId > 0 THEN DAF.copyId ELSE ISNULL(ASR.archGroupCopyId, 0) END, 0,0,
                    CAST(NEWID() AS binary(6))
    FROM MMDeletedAF DAF WITH (READUNCOMMITTED) INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON DAF.VolumeId = V.VolumeId
            INNER JOIN #MountPathsList MP ON DAF.MountPathId = MP.MountPathId --This is to make sure we get only volumes of eligible mount paths/types
                        LEFT OUTER JOIN MMMediaGroup MGROUP WITH(NOLOCK) ON V.MediaGroupId = MGROUP.MediaGroupId
                        LEFT OUTER JOIN archStream ASR WITH(NOLOCK) ON MGROUP.MediaGroupId = ASR.mediaGroupId
						 WHERE       (DAF.archFileId > 0 OR DAF.ArchChunkId > 0)
	-- insert rows so that AFs with chunkId/volId/MPId = 0 will be processed. Just insert it with MPId here. Below logic will take care of finding MA for the MP.
    INSERT INTO #tempVolAFList
    SELECT DAF.VolumeId, DAF.archFileId, DAF.ArchChunkId, 0, 0, M.MountPathId,
             4/*MOUNT_PATH_SHARED_STATIC*/, DAF.SIDBStoreId, DAF.commcellId, DAF.sidbPruningFlag, DAF.subStoreBitField, 0, DAF.chunkCommCellId, CASE WHEN DAF.copyId > 0 THEN DAF.copyId ELSE AGC.id END, 0, 0, CAST(NEWID() AS binary(6))
    FROM MMDeletedAF DAF WITH (READUNCOMMITTED)
            INNER JOIN archCopySIDBStore ACS WITH (READUNCOMMITTED) ON DAF.SIDBStoreId = ACS.SIDBStoreId
            INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON ACS.copyId = AGC.id
            INNER JOIN MMDataPath D WITH (READUNCOMMITTED) ON ACS.CopyId = D.CopyId
            INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON D.DrivePoolId = DP.DrivePoolId
            INNER JOIN (SELECT MP.MasterPoolId, MIN(MP.MountPathId) AS MountPathId
                            FROM MMMountPath MP WITH (READUNCOMMITTED)
                            INNER JOIN #MountPathsList MS ON MP.MountPathId = MS.MountPathId
                        GROUP BY MP.MasterPoolId) AS M ON DP.MasterPoolId = M.MasterPoolId
    WHERE  DAF.MountPathId = 0
    AND DAF.ArchChunkId = 0
    AND DAF.SIDBStoreId > 0
AND AGC.dedupeFlags & 134217728 = 0
AND D.flag & 1 = 1
	DELETE #tempVolAFList
    FROM #tempVolAFList T, IdxSIDBStore STORE WITH (READUNCOMMITTED)
    WHERE T.SIDBStoreID > 0
    AND T.SIDBStoreId = STORE.SIDBStoreId
    AND
    (
        (STORE.CommCellId <> 2)
        OR
        (
( (STORE.flags & 256) > 0)
                OR
( STORE.Status =  1 )
                OR
( (STORE.Flags & 2097152) > 0)
                OR
            ( NOT EXISTS
                (
                    SELECT CopyId FROM archCopySIDBStore
                    WHERE SIDBStoreId = T.SIDBStoreId
                )
            )
                OR
            (
(STORE.Flags & 536870912) = 0
            )
        )
    )
	DECLARE @doNotUseDDBMAForPruning INT = ISNULL((SELECT value from MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMS2_CONFIG_DONOT_USE_DDB_MA_FOR_PRUNING'), 0)
    --Find if we have DDB MAs that have access to the mount path. This is done only for non-cloud mount path
    IF(@doNotUseDDBMAForPruning = 0)
    BEGIN
        IF OBJECT_ID('tempdb..#tempCopyMPStoreMap') IS NOT NULL
            DROP TABLE #tempCopyMPStoreMap
        CREATE TABLE #tempCopyMPStoreMap (CopyId int, MountPathId int, SIDBStoreId int)
        INSERT #tempCopyMPStoreMap
        SELECT DISTINCT CopyId, MountPathId, SIDBStoreId FROM #tempVolAFList WHERE SIDBStoreId > 0
        ;WITH MAPicker (CopyId, MountPathId, SIDBStoreId, rn, randorder)
        AS
        (
            SELECT T.copyId, MP.mountPathId, T.SIDBStoreId, MP.rn, row_number() over (partition by T.copyId, MP.mountPathId, T.SIDBStoreId order by NEWID()) as randorder
            FROM #tempCopyMPStoreMap T
            INNER JOIN #MountPathsList MP ON T.MountPathId = MP.MountPathId
            INNER JOIN #MountPathToDDBMediaAgant DDBMA ON T.MountPathId = DDBMA.MountPathId AND T.SIDBStoreId = DDBMA.SIDBStoreId AND MP.HostId = DDBMA.HostId
LEFT OUTER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.copyId = DP.copyId AND (DP.flag & 4) = (4)
            LEFT OUTER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MountPathAttribute & 256 = 0 OR (DP.HostClientId IS NOT NULL AND DPOOL.DrivePoolId IS NOT NULL)
			AND MP.MountPathTypeId <> 7
        )
        UPDATE T1
        SET dc =  T2.rn
        FROM #tempVolAFList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId AND T1.SIDBStoreId = T2.SIDBStoreId
        INNER JOIN (SELECT CopyId, MountPathId, SIDBStoreId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId, SIDBStoreId) T3
        ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T1.SIDBStoreId = T3.SIDBStoreId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1
        IF OBJECT_ID('tempdb..#tempCopyMPStoreMap') IS NOT NULL
            DROP TABLE #tempCopyMPStoreMap
    END
	DECLARE @tempCopyMPMap table (CopyId int, MountPathId int)
    INSERT @tempCopyMPMap
    SELECT DISTINCT CopyId, MountPathId FROM #tempVolAFList WHERE dc = 0 --If dc has already been chosen due to DDB MA no need to process them
    --Set device controller based on data path settings
    ;WITH MAPicker (CopyId, MountPathId, rn, randorder)
    AS
    (
        SELECT T.copyId, MP.mountPathId, MP.rn, row_number() over (partition by T.copyId, MP.mountPathId order by NEWID()) as randorder
        FROM @tempCopyMPMap T
        INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.copyId = DP.copyId
        INNER JOIN #MountPathsList MP ON T.MountPathId = MP.MountPathId
        INNER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MountPathAttribute & 256 > 0
AND (	(MP.MountPathTypeId IN (4,5) AND DP.flag & 4  = 4 )
				OR
(MP.MountPathTypeId = 7 AND MP.MountPathAttribute & 32 > 0
AND DP.flag & ( 64 | 4) = ( 64 | 4) )
		)
	)
    UPDATE T1
    SET dc =  T2.rn
    FROM #tempVolAFList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
    INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
    ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1 AND T1.dc = 0 ; --If dc has already been chosen due to DDB MA don't overwrite
	--Set device controller based on data path settings if granular pruning is not enabled (only for cloud mps)
    WITH MAPicker (CopyId, MountPathId, rn, randorder)
    AS
    (
        SELECT T.copyId, MP.mountPathId, MP.rn, row_number() over (partition by T.copyId, MP.mountPathId order by NEWID()) as randorder
        FROM @tempCopyMPMap T
        INNER JOIN MMDataPath DP WITH (READUNCOMMITTED) ON T.copyId = DP.copyId
        INNER JOIN #MountPathsList MP ON T.MountPathId = MP.MountPathId
        INNER JOIN MMDrivePool DPOOL WITH (READUNCOMMITTED) ON DP.DrivePoolId = DPOOL.DrivePoolId AND MP.masterPoolId = DPOOL.MasterPoolId AND DPOOL.ClientId = MP.HostId
WHERE MP.MountPathAttribute & 256 > 0
AND MP.MountPathAttribute & 32 = 0
AND DP.flag & 4  = 4
		AND MP.MountPathTypeId = 7
    )
	UPDATE T1
        SET dc =  T2.rn
        FROM #tempVolAFList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
        INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
        ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1;
    --Set device controller not based on data path settings
    WITH MAPicker (CopyId, MountPathId, rn, randorder)
    AS
    (
        SELECT T.copyId, MP.mountPathId, MP.rn, row_number() over (partition by T.copyId, MP.mountPathId order by NEWID()) as randorder
        FROM @tempCopyMPMap T
        INNER JOIN #MountPathsList MP ON T.MountPathId = MP.MountPathId
WHERE MP.MountPathAttribute & 256 = 0
		AND ( MP.MountPathTypeId IN (4,5)
				OR
				(
MP.MountPathTypeId IN (7) AND (MP.MountPathAttribute & 32 = 0 OR MP.DeviceControllerFlags & 1 > 0)
				)
			)
    )
    UPDATE T1
    SET dc =  T2.rn
    FROM #tempVolAFList T1 INNER JOIN MAPicker T2 ON T1.CopyId = T2.CopyId AND T1.MountPathId = T2.MountPathId
    INNER JOIN (SELECT CopyId, MountPathId, MAX(randorder) maxRowNumber FROM MAPicker GROUP BY copyId, MountPathId) T3
    ON T1.CopyId = T3.CopyId AND T1.MountPathId = T3.MountPathId AND T2.randorder = ABS(T1.newid % T3.maxRowNumber) + 1 AND T1.dc = 0; --If dc has already been chosen due to DDB MA don't overwrite
	--Remove those that do not have a valid device controller to prune
    DELETE #tempVolAFList WHERE dc = 0
	 UPDATE T
    SET HostId = MP.HostId,
    MountPathTypeId = MP.MountPathTypeId,
    MPAttribute = MP.MountPathAttribute
    FROM #tempVolAFList T
    INNER JOIN #MountPathsList MP ON T.MountPathId = MP.MountPathId AND T.dc = MP.rn
    WHERE T.HostId = 0
    --Remove those that do not have a valid MA to prune
    DELETE #tempVolAFList WHERE HostId = 0
	 -- Delete those rows which have valid AF entry in archFileCopy table.
    DELETE #tempVolAFList
    FROM #tempVolAFList T
            INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON AGC.SIDBStoreId = T.sidbStoreId
            INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON T.AFileId = AFC.archFileId AND AGC.id = AFC.archCopyId AND AFC.lastChunkNumber > 0
    WHERE T.sidbStoreId > 0
    -- Delete those rows with AFs which have auxcopy job running. (For backup it has to be prevented in DA itself, since by the time in comes to DAF, we have lost AF-job relation)
    DELETE T
    FROM #tempVolAFList T
        INNER JOIN archChunkToReplicate ACR WITH (READUNCOMMITTED) ON T.AFileId = ACR.archFileId AND T.copyId = ACR.DestCopyId AND T.commCellId = ACR.commCellId
        INNER JOIN JMJobInfo JM WITH (READUNCOMMITTED) ON ACR.adminJobId = JM.jobId
    WHERE T.sidbStoreId > 0
AND ACR.Status IN (1)
    AND JM.state NOT IN (4, 5, 9, 10, 12, 19)
    /*COMPLETE, STOPPED, COMPLETEDSUCCESS, COMPLETEDFAIL, COMPLETEDPARTIAL, COMPLETEDWITHWARNINGS*/
	-- Enable granular pruning on cloud targets
    --
    -- For Cloud mountpaths, we only do store-level pruning, so remove rows here that belong to SIDB stores.
    DELETE #tempVolAFList
    FROM #tempVolAFList T
    WHERE T.SIDBStoreId > 0
AND (T.MPAttribute & 32) = 0
	AND T.MountPathTypeId = 7
UPDATE TMPHost
SET ArchfileCount = T.ArchfileCount
FROM  @tmpPowerMgmtEnabledHostTable TMPHost
INNER JOIN(SELECT HostId, Count(*) AS ArchfileCount FROM #tempVolAFList GROUP BY HostId) T ON T.HostId = TMPHost.HostId
	-- Get DDB MediaAgants for DP MediaAgents
	DECLARE @HostToStoreMap TABLE (HostId Integer,SIDBStoreId INTEGER)
	INSERT INTO @HostToStoreMap
	SELECT DISTINCT HostId,SIDBStoreId
	FROM #tempVolAFList WHERE SIDBStoreId > 0
	INSERT INTO @HostToStoreMap
	SELECT DISTINCT TMP.HostId, TMP.SIDBStoreId
	FROM #tempVolList TMP
	LEFT OUTER JOIN @HostToStoreMap H2MAP ON H2MAP.HostId = TMP.HostId AND H2MAP.SIDBStoreId = TMP.SIDBStoreId
	WHERE TMP.SIDBStoreId > 0 AND H2MAP.HostId IS NULL AND H2MAP.SIDBStoreId IS NULL
	-- DP MA is online and DDB MA is offline
	DECLARE @DDBMAPowerMgmtNotDPMAListToPrune TABLE(SIDBStoreId INTEGER, VolumeCount INTEGER, AFCount INTEGER)
	INSERT INTO @DDBMAPowerMgmtNotDPMAListToPrune
	SELECT DISTINCT MV.SIDBStoreId, COUNT(MV.SIDBStoreId),0 FROM MMVolume MV WITH (NOLOCK)
INNER JOIN IdxSIDBStore STORE WITH (NOLOCK) ON MV.SIDBStoreId = STORE.SIDBStoreId AND MV.SIDBStoreId > 0 AND MV.VolumeFlags = 6 AND (MV.attributes & 4) = 0
	GROUP BY MV.SIDBStoreId
	INSERT INTO @DDBMAPowerMgmtNotDPMAListToPrune
	SELECt DISTINCT DF.SIDBStoreId, 0,COUNT(DF.SIDBStoreId) FROM MMDeletedAF DF WITH (NOLOCK)
	INNER JOIN IdxSIDBStore STORE WITH (NOLOCK) ON DF.SIDBStoreId = STORE.SIDBStoreId AND DF.SIDBStoreId > 0
	GROUP BY DF.SIDBStoreId
	DELETE FROM @DDBMAPowerMgmtNotDPMAListToPrune
    FROM @DDBMAPowerMgmtNotDPMAListToPrune T, IdxSIDBStore STORE WITH (READUNCOMMITTED)
    WHERE T.SIDBStoreId = STORE.SIDBStoreId
    AND
    (
        (STORE.CommCellId <> 2)
        OR
        (
( (STORE.flags & 256) > 0)
                OR
( STORE.Status =  1 )
                OR
( (STORE.Flags & 2097152) > 0)
                OR
            ( NOT EXISTS
                (
                    SELECT CopyId FROM archCopySIDBStore WITH (NOLOCK)
                    WHERE SIDBStoreId = T.SIDBStoreId
                )
            )
                OR
            (
(STORE.Flags & 536870912) = 0
            )
        )
    )
	UPDATE TMPPM
	SET TMPPM.SIDBVolumeCount = CASE WHEN TMP.VolumeCount > TMPPM.SIDBVolumeCount THEN TMP.VolumeCount ELSE TMPPM.SIDBVolumeCount
								END,
	     TMPPM.SIDBArchFileCount = CASE WHEN TMP.AFCount > TMPPM.SIDBArchFileCount THEN TMP.AFCount ELSE TMPPM.SIDBArchFileCount
								END
	FROM @DDBMAPowerMgmtNotDPMAListToPrune TMP
	INNER JOIN IdxSIDBSubStore SUB WITH (NOLOCK) ON TMP.SIDBStoreId = SUB.SIDBStoreId
	INNER JOIN @tmpPowerMgmtEnabledHostTable TMPPM ON TMPPM.HostId = SUB.ClientId
	DECLARE @tmpUpperThresholdReachedMediaAgents TABLE(HostId INTEGER,isDPMA INTEGER)
DECLARE @MinThresholdArchFileCount INTEGER = ISNULL((SELECT value from MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_START_PRUNE_REACH_MIN_ARCHFILE_COUNT'), 500)
DECLARE @MinThresholdVolumeCount INTEGER = ISNULL((SELECT value from MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_START_PRUNE_REACH_MIN_VOLUME_COUNT'), 300)
DECLARE @MaxThresholdVolumeCount INT = ISNULL((SELECT value from MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_START_PRUNE_REACH_MAX_VOLUME_COUNT'), 2000)
DECLARE @MaxThresholdArchFileCount INT = ISNULL((SELECT value from MMConfigs WITH(READUNCOMMITTED) WHERE name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_START_PRUNE_REACH_MAX_ARCHFILE_COUNT'), 5000)
	-- Getting Datapath MediaAgents reached upper limit
	INSERT INTO @tmpUpperThresholdReachedMediaAgents
	SELECT DISTINCT HostId, 1 FROM @tmpPowerMgmtEnabledHostTable WHERE VolumeCount >= @MaxThresholdVolumeCount OR ArchfileCount >= @MaxThresholdArchFileCount
	-- Getting DDB MediaAgents which is required for selected DataPAth MediaAgents
	INSERT INTO @tmpUpperThresholdReachedMediaAgents
	SELECT DISTINCT SUB.ClientId, 0 FROM @HostToStoreMap TMPMAP
	INNER JOIN @tmpUpperThresholdReachedMediaAgents TMPMAX ON TMPMAX.HostId = TMPMAP.HostId AND TMPMAX.isDPMA = 1
	INNER JOIN IdxSIDBSubStore SUB WITH (NOLOCK) ON SUB.SIDBStoreId = TMPMAP.SIDBStoreId
	INNER JOIN @tmpPowerMgmtEnabledHostTable TMPPEN ON SUB.ClientId = TMPPEN.HostId
	WHERE SUB.ClientId NOT IN (SELECT HostId FROM @tmpUpperThresholdReachedMediaAgents)
	-- Getting DDB MediaAgents reaches upper limit
	INSERT INTO @tmpUpperThresholdReachedMediaAgents
	SELECT DISTINCT TMPPEN.HostId, 0 FROM @tmpPowerMgmtEnabledHostTable TMPPEN
	LEFT OUTER JOIN @tmpUpperThresholdReachedMediaAgents TMPMAX ON TMPPEN.HostId = TMPMAX.HostId
	WHERE TMPPEN.SIDBVolumeCount >= @MaxThresholdVolumeCount OR TMPPEN.SIDBArchFileCount >= @MaxThresholdArchFileCount
	AND TMPMAX.HostId IS NULL
	--Getting DP MediaAgents which is required for DDB MediaAgents
	INSERT INTO @tmpUpperThresholdReachedMediaAgents
	SELECT TMPMAP.HostId,0
	FROM @HostToStoreMap TMPMAP
	INNER JOIN IdxSIDBSubStore SUB WITH (NOLOCK) ON TMPMAP.SIDBStoreId = SUB.SIDBStoreId
	INNER JOIN @tmpPowerMgmtEnabledHostTable TMPPM ON TMPPM.HostId = SUB.ClientId
	LEFT OUTER JOIN @tmpUpperThresholdReachedMediaAgents TMPMAX ON TMPMAP.HostId = TMPMAX.HostId
	WHERE TMPPM.SIDBVolumeCount >= @MaxThresholdVolumeCount OR TMPPM.SIDBArchFileCount >= @MaxThresholdArchFileCount
	AND TMPMAX.HostId IS NULL
	-- Un Marking flag for the MediaAgents which reached lower threshold value
	UPDATE PMH
SET PMH.Flags = Flags & ~4
	FROM MMPowerMgmtHost PMH
	INNER JOIN @tmpPowerMgmtEnabledHostTable TMPPEN  ON PMH.HostId = TMPPEN.HostId
	LEFT OUTER JOIN @tmpUpperThresholdReachedMediaAgents TMPMAX ON TMPPEN.HostId = TMPMAX.HostId
	WHERE TMPMAX.HostId IS NULL AND TMPPEN.VolumeCount <= @MinThresholdVolumeCount AND TMPPEN.SIDBVolumeCount <= @MinThresholdVolumeCount AND TMPPEN.ArchfileCount <= @MinThresholdArchFileCount AND TMPPEN.SIDBArchFileCount <= @MinThresholdArchFileCount
AND (PMH.Flags & 4) > 0
	-- Marking flag for the MediaAgents which reached upper threshold value
	UPDATE PMH
SET PMH.Flags = (Flags | 4)
	FROM MMPowerMgmtHost PMH
	INNER JOIN @tmpUpperThresholdReachedMediaAgents TMPMAX  ON PMH.HostId = TMPMAX.HostId
WHERE (PMH.Flags & 4) = 0
	DECLARE @HostId INTEGER
	DECLARE @tmpGetReturnCode TABLE (ErrorCode INTEGER)
	DECLARE @tmpFailedToPowerOnHostList TABLE (HostId INTEGER)
	DECLARE Host_PowerOn CURSOR FOR
		SELECT MH.ClientId FROM MMHost MH
		INNER JOIN @tmpUpperThresholdReachedMediaAgents TMP ON  MH.ClientId = TMP.HostId
		AND MH.MmHostSoftState = 0 AND MH.MmHostEnabled = 1
		AND MH.OfflineReason = 7 /* HOST_STATUS_POWER_MANAGED_VM */
	OPEN Host_PowerOn
	FETCH NEXT FROM Host_PowerOn INTO @HostId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO @tmpGetReturnCode
EXEC dbo.MMPowerOnIfCloudVM @HostId, -1, 64, 0, 0
		SET @ErrorCode = @@ERROR
IF EXISTS(SELECT 1 FROM @tmpGetReturnCode WHERE ErrorCode = 66503)
		BEGIN
SET @ErrorCode = 66503
		END
		DELETE FROM @tmpGetReturnCode
		IF @ErrorCode != 0
			INSERT INTO @tmpFailedToPowerOnHostList SELECT @HostId
		FETCH NEXT FROM Host_PowerOn INTO @HostId
	END
CX_EXIT:
	if object_id('tempdb.dbo.#MountPathToDDBMediaAgant') is not null DROP TABLE #MountPathToDDBMediaAgant
	if object_id('tempdb.dbo.#MountPathsList') is not null DROP TABLE #MountPathsList
	if object_id('tempdb.dbo.#tempVolList') is not null DROP TABLE #tempVolList
	if object_id('tempdb.dbo.#tempVolAFList') is not null DROP TABLE #tempVolAFList
SELECT HostId FROM @tmpFailedToPowerOnHostList
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetCloudVMsNeedToPowerONForPruning')
	delete from GxQscripts where name = 'MMGetCloudVMsNeedToPowerONForPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMsNeedToPowerONForPruning')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMsNeedToPowerONForPruning'
GO

insert into GXDBVersions values(2, 'MMGetCloudVMsNeedToPowerONForPruning',  '00010001000200120000', 'MMGetCloudVMsNeedToPowerONForPruning', '00010001000200120000')
GO

