

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetCloudVMInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetCloudVMInfo.sp,v $ $Id: MMGetCloudVMInfo.sp,v 1.1.2.12 2020/08/05 00:54:03 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMGetCloudVMInfo"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
This will return VM info to power on and off.
VM_GUID_NOT_FOUND				-	VM unique identify instance Name not found.
VIRTUAL_CLIENT_NOT_ASSOCIATED	-	Power ON and OFF APIs requires virtual client instance id. This association can done from GUI Media Agent properties.
									If association not done, then can't get virtual client instance info to power on and off.
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetCloudVMInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMGetCloudVMInfo <<<'
	drop procedure MMGetCloudVMInfo
END
IF EXISTS (select * from GxQscripts where name='MMGetCloudVMInfo')
	delete from GxQscripts where name = 'MMGetCloudVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMInfo')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMInfo'
GO
print '... Creating Procedure: MMGetCloudVMInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetCloudVMInfo
  @i_HostId Integer
AS
  DECLARE @o_VendorInstanceName VARCHAR(1024)
  DECLARE @o_VmName VARCHAR(1024)
  DECLARE @o_VirtualClientId INTEGER 
  DECLARE @o_VirtualClientName VARCHAR(1024)
  DECLARE @o_InstanceId INTEGER
  DECLARE @o_InstanceType INTEGER
  DECLARE @o_HostSoftState INTEGER
  DECLARE @o_VSADataCenterName NVARCHAR(1024)
  DECLARE @o_ProjectId NVARCHAR(1024)
  DECLARE @o_ErrorCode INTEGER
DECLARE @VendorInstanceName VARCHAR(1024) = ''
DECLARE @VmName VARCHAR(1024) = ''
DECLARE @InstanceId INTEGER = 0
DECLARE @ErrorCode INTEGER = 0
DECLARE @Count INTEGER = 0
DECLARE @virtualClientId INTEGER = 0
DECLARE @virtualClientName VARCHAR(1024) = ''
DECLARE @InstanceType INTEGER = 0
DECLARE @HostSoftState INTEGER = 0
DECLARE @VSADataCenterName VARCHAR(1024) = ''
DECLARE @ProjectId NVARCHAR(1024) = ''
SELECT @VmName = name FROM APP_Client WITH (NOLOCK) WHERE id = @i_HostId
SELECT @VendorInstanceName = attrVal FROM APP_ClientProp PROP WITH (NOLOCK)
WHERE PROP.componentNameId = @i_HostId
AND PROP.attrName = 'Virtual Machine GUID'
AND PROP.modified = 0
IF @VendorInstanceName = ''
BEGIN
	SELECT @ErrorCode = 1  			-- VM_GUID_NOT_FOUND
	goto ERROREXIT
END
SELECT @virtualClientId = ControllerNode FROM MMPowerMgmtHost WITH (NOLOCK) WHERE HostId = @i_HostId
IF @virtualClientId = 0
BEGIN
	SELECT @ErrorCode = 2			-- VIRTUAL_CLIENT_NOT_ASSOCIATED
	goto ERROREXIT
END
SELECT @VSADataCenterName = LOWER(attrVal) FROM APP_ClientProp PROP WITH (NOLOCK)
WHERE PROP.componentNameId = @i_HostId
AND PROP.attrName = 'VSA DataCenter Name'
AND PROP.modified = 0
SELECT @virtualClientName = name FROM APP_Client WITH (NOLOCK) WHERE id = @virtualClientId
SELECT TOP 1 @InstanceId = APP.instance FROM APP_APPLICATION APP WITH (NOLOCK)
WHERE APP.clientId = @virtualClientId AND APP.appTypeId = 106
SELECT @InstanceType = CAST(attrVal as INTEGER) FROM APP_InstanceProp WITH (NOLOCK) WHERE componentNameId = @InstanceId AND attrName = 'Virtual Server Instance Type'
SELECT @HostSoftState = MmHostSoftState FROM MMHOST WITH (NOLOCK) WHERE ClientId = @i_HostId
IF @InstanceType = 1301 -- APP_VIRTSERV_GOOGLE_CLOUD
BEGIN
	SELECT @ProjectId = attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @i_HostId AND attrName = 'VSA Project Id' AND modified = 0
END
ERROREXIT:
	SELECT @VendorInstanceName, @VmName, @virtualClientId, @virtualClientName, @InstanceId, @InstanceType, @HostSoftState, @VSADataCenterName, @ProjectId, @ErrorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetCloudVMInfo')
	delete from GxQscripts where name = 'MMGetCloudVMInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMInfo')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMInfo'
GO

insert into GXDBVersions values(2, 'MMGetCloudVMInfo',  '00010001000200120000', 'MMGetCloudVMInfo', '00010001000200120000')
GO

