

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetCloudVMForLiveSync.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetCloudVMForLiveSync.sp,v $ $Id: MMGetCloudVMForLiveSync.sp,v 1.1.4.13 2020/03/02 18:21:43 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMGetCloudVMForLiveSync"               		|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetCloudVMForLiveSync')
BEGIN
	print '>>> Drop Stored Procedure: MMGetCloudVMForLiveSync <<<'
	drop procedure MMGetCloudVMForLiveSync
END
IF EXISTS (select * from GxQscripts where name='MMGetCloudVMForLiveSync')
	delete from GxQscripts where name = 'MMGetCloudVMForLiveSync'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMForLiveSync')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMForLiveSync'
GO
print '... Creating Procedure: MMGetCloudVMForLiveSync'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetCloudVMForLiveSync
AS
  DECLARE @o_HostId INTEGER
  DECLARE @o_HostSoftState INTEGER
  DECLARE @o_PowerState INTEGER
IF OBJECT_ID('tempdb.dbo.#CloudVMMgmtSyncClientList') IS NOT NULL
	DROP TABLE #CloudVMMgmtSyncClientList
CREATE TABLE #CloudVMMgmtSyncClientList (ClientId INT, MmSoftState INT, PowerStatus INT)
CREATE CLUSTERED INDEX CloudVMMgmtSyncClientList_ClientId ON #CloudVMMgmtSyncClientList(ClientId)
DECLARE @currentUTCTime BIGINT = dbo.GetUnixTime(GetUTCDate())
--If MM service restats while powering off, we left power status as stopping. So taking the VMs to sync power status which is in stopping state more than 5 mins
INSERT INTO #CloudVMMgmtSyncClientList
SELECT DISTINCT MH.ClientId, MH.MmHostSoftState, PH.PowerStatus FROM MMHost MH WITH(NOLOCK)
INNER JOIN MMPowerMGmtHost PH WITH(NOLOCK) ON MH.clientId = PH.HostId
WHERE (MH.Attribute & 32768) = 32768
AND ( (MH.MmHostSoftState = 0 AND PH.PowerStatus = 3)
OR (MH.MmHostSoftState = 1 AND PH.PowerStatus IN (1,2,5))
OR PH.PowerStatus = 0
OR (PH.PowerStatus = 4 AND (@currentUTCTime - PH.PowerStateTransitTime) > (5 * 60))
OR (PH.PowerStatus = 1 AND (@currentUTCTime - PH.PowerStateTransitTime) > (10 * 60))
OR (PH.PowerStatus = 2 AND (@currentUTCTime - PH.PowerStateTransitTime) > (5 * 60))
)
DELETE TMP
FROM #CloudVMMgmtSyncClientList TMP
INNER JOIN MMVMPowerMgmtReq VM WITH (NOLOCK) ON VM.HostId = TMP.ClientId
WHERE VM.RequestStatus IN (1, 2)
AND TMP.PowerStatus NOT IN (1,4)
SELECT * FROM #CloudVMMgmtSyncClientList
IF OBJECT_ID('tempdb.dbo.#CloudVMMgmtSyncClientList') IS NOT NULL
	DROP TABLE #CloudVMMgmtSyncClientList
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetCloudVMForLiveSync')
	delete from GxQscripts where name = 'MMGetCloudVMForLiveSync'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudVMForLiveSync')
	delete from GXDBVersions where aliasname = 'MMGetCloudVMForLiveSync'
GO

insert into GXDBVersions values(2, 'MMGetCloudVMForLiveSync',  '00010001000400130000', 'MMGetCloudVMForLiveSync', '00010001000400130000')
GO

