

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetCloudMPsWithoutPrunerMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetCloudMPsWithoutPrunerMA.sp,v $ $Id: MMGetCloudMPsWithoutPrunerMA.sp,v 1.1.2.7 2020/12/21 10:57:08 anarulkar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetCloudMPsWithoutPrunerMA')
BEGIN
	print '>>> Drop Stored Procedure: MMGetCloudMPsWithoutPrunerMA <<<'
	drop procedure MMGetCloudMPsWithoutPrunerMA
END
IF EXISTS (select * from GxQscripts where name='MMGetCloudMPsWithoutPrunerMA')
	delete from GxQscripts where name = 'MMGetCloudMPsWithoutPrunerMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudMPsWithoutPrunerMA')
	delete from GXDBVersions where aliasname = 'MMGetCloudMPsWithoutPrunerMA'
GO
print '... Creating Procedure: MMGetCloudMPsWithoutPrunerMA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetCloudMPsWithoutPrunerMA
  @i_CommCellId INTEGER,
  @i_reserveParam INTEGER
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_MountPathId INTEGER
  DECLARE @o_NewDeviceControllerId INTEGER
  DECLARE @o_NewMAId INTEGER
  DECLARE @o_SIDBStoreId INTEGER
DECLARE @l_MPs table (
							MountPathId INTEGER,
							LibraryId INTEGER,
							MediaSideId INTEGER,
							DeviceControllerId INTEGER,
							MediaAgentId INTEGER
							)
DECLARE @l_MultiPrunerMPs table (MountPathId INTEGER, LibraryId INTEGER, MediaSideId INTEGER, PrunerMAId INTEGER)
DECLARE @l_MultiPrunerStores table (SIDBStoreId INTEGER)
DECLARE @l_Stores table (MountPathId INTEGER, SIDBStoreId INTEGER, MAId INTEGER)
DECLARE @now int = dbo.getUnixTime(GETUTCDATE())
DECLARE @allowedOfflineTimeHrs INTEGER = 24
SELECT @allowedOfflineTimeHrs = value FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_MEDIAAGENT_PRUNER_OFFLINE_TIME_IN_HRS_LIMIT'
DECLARE @MOUNT_PATH_EXTERNAL_REMOTE_HOST INTEGER = 7
	-- Find if there are any stores writing to mountpaths with multiple pruner MAs configured.
	-- If so, the unset those MAs as pruner and let the below code take care of figuring out the MAs.
	INSERT INTO @l_MultiPrunerMPs
    SELECT MP.MountPathId, MP.LibraryId, MP.MediaSideId, DEVC.ClientId
    FROM MMMountPath MP WITH (READUNCOMMITTED)
	INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MP.MountPathId = MPSD.MountPathId
INNER JOIN MMDeviceController DEVC WITH (READUNCOMMITTED) ON MPSD.DeviceId = DEVC.DeviceId AND (DEVC.UseCount & 1) > 0
    WHERE MP.MountPathTypeId = @MOUNT_PATH_EXTERNAL_REMOTE_HOST
AND MP.Attribute & 32 > 0
AND MP.Attribute & 256 = 0
	-- Unset the pruner MA which are marked
			-- As read only now.
			-- DeviceController is disabled
			-- Device is not accessible
			-- Host is offline for x days
	-- This will allow to set a new write enable pruner MA if available.
	-- Unset the pruner MA which are marked offline for greater than defined allowed timestamp so that any online MA can be picked up next.
	UPDATE DC
SET UseCount = UseCount & ~(1)
	FROM MMDeviceController DC
		INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON DC.DeviceId = MPSD.DeviceId
		INNER JOIN MMHost H WITH (READUNCOMMITTED) ON DC.ClientId = H.ClientId
		INNER JOIN @l_MultiPrunerMPs T ON MPSD.MountPathId = T.MountPathId
WHERE (((DC.DeviceAccessType & 2) = 0) OR (DC.DeviceControllerEnabled = 0) OR (DC.DeviceAccessible = 0)
		OR ((H.MmHostSoftState = 0) AND (H.OfflineTimeStamp < (@now - (@allowedOfflineTimeHrs * 60 * 60))))	)
AND (UseCount & (1)) > 0
	INSERT INTO @l_Stores
	SELECT T.MountPathId, V.SIDBStoreId, T.PrunerMAId
	FROM @l_MultiPrunerMPs T
	INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON T.MediaSideId = V.MediaSideId
	WHERE V.SIDBStoreId > 0
	GROUP BY T.MountPathId, V.SIDBStoreId, T.PrunerMAId
	-- Clean up stores which are corrupt, in move or aged
	DELETE T
	FROM @l_Stores T
		INNER JOIN IdxSIDBStore S WITH (READUNCOMMITTED) ON T.SIDBStoreId = S.SIDBStoreId
WHERE ((S.Status = 1)
OR ((S.flags & 256) > 0)
OR ((S.flags & 536870912) = 0)
	OR NOT EXISTS (SELECT CopyId FROM archCopySIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = S.SIDBStoreId)
	OR (S.CommCellId <> 2)
OR (S.flags & 2097152 > 0) )
	INSERT INTO @l_MultiPrunerStores
	SELECT T.SIDBStoreId
	FROM
	(SELECT S.SIDBStoreId, COUNT(DISTINCT S.MAId) AS PrunerCount
	 FROM @l_Stores S
	 GROUP BY S.SIDBStoreId
	) T
	WHERE T.PrunerCount > 1
	DELETE S
	FROM @l_Stores S
	WHERE S.SIDBStoreId NOT IN (SELECT SIDBStoreId FROM @l_MultiPrunerStores)
	DELETE M
	FROM @l_MultiPrunerMPs M
	WHERE M.MountPathId NOT IN (SELECT MountPathId FROM @l_Stores)
	-- Unset the pruner MAs for MPs which have multiple pruners
	UPDATE DC
SET UseCount = UseCount & ~(1)
	FROM MMDeviceController DC
		INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON DC.DeviceId = MPSD.DeviceId
		INNER JOIN @l_MultiPrunerMPs T ON MPSD.MountPathId = T.MountPathId
	DELETE FROM @l_Stores
    -- 1) Get all the mountpaths which are cloud, enabled with micro pruning, not using datapath pruner setting and does not have a pruner MA.
    INSERT INTO @l_MPs
    SELECT DISTINCT MP.MountPathId, MP.LibraryId, MP.MediaSideId, 0, 0
    FROM MMMountPath MP WITH (READUNCOMMITTED)
	INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MP.MountPathId = MPSD.MountPathId
LEFT OUTER JOIN MMDeviceController DEVC WITH (READUNCOMMITTED) ON MPSD.DeviceId = DEVC.DeviceId AND (DEVC.UseCount & 1) > 0
    WHERE MP.MountPathTypeId = @MOUNT_PATH_EXTERNAL_REMOTE_HOST
AND MP.Attribute & 32 > 0
AND MP.Attribute & 256 = 0
	AND DEVC.DeviceControllerId IS NULL
    -- 2) Get the associated stores also upfront since we want to pick common MAs
    INSERT INTO @l_Stores
    SELECT M.MountPathId, V.SIDBStoreId, 0
    FROM @l_MPs M
	INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON M.MediaSideId = V.MediaSideId
    WHERE V.SIDBStoreId > 0
    GROUP BY M.MountPathId, V.SIDBStoreId
	-- 2a) Get the other mountpaths for these stores
	INSERT INTO @l_Stores
	SELECT M.MountPathId, V.SIDBStoreId, 0
	FROM @l_Stores S
			INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON V.SIDBStoreId = S.SIDBStoreId
			INNER JOIN MMMountPath M WITH (READUNCOMMITTED) ON V.MediaSideId = M.MediaSideId
			LEFT OUTER JOIN @l_Stores T ON T.SIDBStoreId = S.SIDBStoreId AND T.MountPathId = M.MountPathId
	WHERE T.MountPathId IS NULL
	AND V.SIDBStoreId > 0
	GROUP BY M.MountPathId, V.SIDBStoreId
	-- Clean up stores which are corrupt, in move or aged
	DELETE T
	FROM @l_Stores T
		INNER JOIN IdxSIDBStore S WITH (READUNCOMMITTED) ON T.SIDBStoreId = S.SIDBStoreId
WHERE ((S.Status = 1)
OR ((S.flags & 256) > 0)
OR ((S.flags & 536870912) = 0)
	OR NOT EXISTS (SELECT CopyId FROM archCopySIDBStore WITH (READUNCOMMITTED) WHERE SIDBStoreId = S.SIDBStoreId)
	OR (S.CommCellId <> 2)
OR (S.flags & 2097152 > 0) )
    -- 3) Find a new MA to be designated as pruner MA
		-- a) If stores then pick 1 MA per entire store
		-- b) If there are no stores then pick 1 MA for library (if possible)
		-- c) If above 2 are not possible then just pick 1 MA, configuring DDB later will enforce common MAs.
    -- Attempt to find MA based on condition (a)
	-- Find if there are pruner MAs already for other mountpaths.
    UPDATE @l_Stores
    SET MAId = T2.DCMAId
    FROM @l_Stores T,
		(SELECT S.SIDBStoreId, MIN(DC.ClientId) AS DCMAId
		 FROM @l_Stores S
			INNER JOIN MMMountPathToStorageDevice SD WITH (READUNCOMMITTED) ON S.MountPathId = SD.MountPathId
			INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON SD.DeviceId = DC.DeviceId
			INNER JOIN APP_Client AC WITH (READUNCOMMITTED) ON DC.ClientId = AC.id
WHERE DC.DeviceAccessType & 2 = 2
AND AC.releaseId > 15
			AND DC.UseCount = 1
	  	 GROUP BY S.SIDBStoreId
	  ) T2
    WHERE T.SIDBStoreId = T2.SIDBStoreId
	-- Find if there are no pruner MAs already for other mountpaths. Pick any now.
    UPDATE @l_Stores
    SET MAId = T2.DCMAId
    FROM @l_Stores T,
		(SELECT S.SIDBStoreId, MIN(DC.ClientId) AS DCMAId
		 FROM @l_Stores S
			INNER JOIN MMMountPathToStorageDevice SD WITH (READUNCOMMITTED) ON S.MountPathId = SD.MountPathId
			INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON SD.DeviceId = DC.DeviceId
			INNER JOIN MMHost H WITH (READUNCOMMITTED) ON DC.ClientId = H.ClientId
			INNER JOIN APP_Client AC WITH (READUNCOMMITTED) ON DC.ClientId = AC.id
			LEFT OUTER JOIN APP_VMToPMMap MAP ON MAP.VMClientId = AC.Id
LEFT OUTER JOIN SimInstalledPackages PKG ON PKG.ClientId = ISNULL(MAP.PMClientId, AC.Id) AND PKG.simPackageID in (51, 1301, 54, 1305)
WHERE DC.DeviceAccessType & 2 = 2
			AND H.MmHostSoftState > 0 AND H.MmHostEnabled > 0
AND (AC.releaseId > 15 OR (AC.releaseId = 15 AND PKG.HighestSP > 10))
	  	 GROUP BY S.SIDBStoreId
	  ) T2
    WHERE T.SIDBStoreId = T2.SIDBStoreId
	AND T.MAId = 0
    UPDATE @l_MPs
    SET MediaAgentId = T2.MAId
    FROM @l_MPs T
	INNER JOIN @l_Stores T2 ON T.MountPathId = T2.MountPathId
    -- Attempt to find MA based on condition (b)
    UPDATE @l_MPs
    SET MediaAgentId = T2.DCMAId
    FROM @l_MPs T,
		(SELECT M.LibraryId, MIN(DC.ClientId) AS DCMAId
		  FROM @l_MPs M
			INNER JOIN MMMountPathToStorageDevice SD WITH (READUNCOMMITTED) ON M.MountPathId = SD.MountPathId
			INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON SD.DeviceId = DC.DeviceId
			INNER JOIN MMHost H WITH (READUNCOMMITTED) ON DC.ClientId = H.ClientId
			INNER JOIN APP_Client AC WITH (READUNCOMMITTED) ON DC.ClientId = AC.id
			LEFT OUTER JOIN @l_Stores S ON M.MountPathId = S.MountPathId
			LEFT OUTER JOIN APP_VMToPMMap MAP ON MAP.VMClientId = AC.Id
LEFT OUTER JOIN SimInstalledPackages PKG ON PKG.ClientId = ISNULL(MAP.PMClientId, AC.Id) AND PKG.simPackageID in (51, 1301, 54, 1305)
WHERE DC.DeviceAccessType & 2 = 2
		 AND H.MmHostSoftState > 0 AND H.MmHostEnabled > 0
AND (AC.releaseId > 15 OR (AC.releaseId = 15 AND PKG.HighestSP > 10))
		 GROUP BY M.LibraryId
		) T2
    WHERE T.LibraryId = T2.LibraryId
    AND T.MediaAgentId = 0
    -- Attempt to find MA based on condition (c)
    UPDATE @l_MPs
    SET MediaAgentId = T2.DCMAId
    FROM @l_MPs T,
		( SELECT M.MountPathId, MIN(DC.ClientId) AS DCMAId
		  FROM @l_MPs M
			INNER JOIN MMMountPathToStorageDevice SD WITH (READUNCOMMITTED) ON M.MountPathId = SD.MountPathId
			INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON SD.DeviceId = DC.DeviceId
			INNER JOIN MMHost H WITH (READUNCOMMITTED) ON DC.ClientId = H.ClientId
			INNER JOIN APP_Client AC WITH (READUNCOMMITTED) ON DC.ClientId = AC.id
			LEFT OUTER JOIN APP_VMToPMMap MAP ON MAP.VMClientId = AC.Id
LEFT OUTER JOIN SimInstalledPackages PKG ON PKG.ClientId = ISNULL(MAP.PMClientId, AC.Id) AND PKG.simPackageID in (51, 1301, 54, 1305)
WHERE DC.DeviceAccessType & 2 = 2
			AND H.MmHostSoftState > 0 AND H.MmHostEnabled > 0
AND (AC.releaseId > 15 OR (AC.releaseId = 15 AND PKG.HighestSP > 10))
		  GROUP BY M.MountPathId
		) T2
    WHERE T.MountPathId = T2.MountPathId
    AND T.MediaAgentId = 0
    UPDATE T
    SET DeviceControllerId = DC.DeviceControllerId
    FROM @l_MPs T
	INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON T.MountPathId = MPSD.MountPathId
	INNER JOIN MMDeviceController DC WITH (READUNCOMMITTED) ON T.MediaAgentId = DC.ClientId AND MPSD.DeviceId = DC.DeviceId
    SELECT M.MountPathId, M.DeviceControllerId, M.MediaAgentId, ISNULL(S.SIDBStoreId, 0)
    FROM @l_MPs M
		LEFT OUTER JOIN @l_Stores S ON M.MountPathId = S.MountPathId
    ORDER BY M.MountPathId, S.SIDBStoreId
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetCloudMPsWithoutPrunerMA')
	delete from GxQscripts where name = 'MMGetCloudMPsWithoutPrunerMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudMPsWithoutPrunerMA')
	delete from GXDBVersions where aliasname = 'MMGetCloudMPsWithoutPrunerMA'
GO

insert into GXDBVersions values(2, 'MMGetCloudMPsWithoutPrunerMA',  '00010001000200070000', 'MMGetCloudMPsWithoutPrunerMA', '00010001000200070000')
GO

