

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetCloudLibraryInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetCloudLibraryInfo.sp,v $ $Id: MMGetCloudLibraryInfo.sp,v 1.1.2.6 2019/01/29 11:34:29 abhinawkumar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetCloudLibraryInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMGetCloudLibraryInfo <<<'
	drop procedure MMGetCloudLibraryInfo
END
IF EXISTS (select * from GxQscripts where name='MMGetCloudLibraryInfo')
	delete from GxQscripts where name = 'MMGetCloudLibraryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudLibraryInfo')
	delete from GXDBVersions where aliasname = 'MMGetCloudLibraryInfo'
GO
print '... Creating Procedure: MMGetCloudLibraryInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetCloudLibraryInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_libraryId integer
AS
  DECLARE @o_deviceType INTEGER
  DECLARE @o_rootFolder varchar(1024)
  DECLARE @o_userName varchar(1024)
  DECLARE @o_password varchar(2048)
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#tmpOutputTable') IS NOT NULL
DROP TABLE #tmpOutputTable
CREATE TABLE #tmpOutputTable
(
	deviceType INT,
	userName VARCHAR(1024),
	userPassword VARCHAR(2048),
	folder VARCHAR(1024),
	credentialAssocId INT
)
BEGIN
	INSERT INTO #tmpOutputTable ( deviceType, folder, userName, userPassword, credentialAssocId)
	SELECT  TOP 1 D.DeviceTypeId, DC.Folder, DC.UserName, DC.UserPassword, DC.CredentialAssocId
		FROM MMLibrary ML WITH (NOLOCK) JOIN MMMountPath MP WITH (NOLOCK)
			ON ML.LibraryId = MP.LibraryId
		JOIN MMMountPathToStorageDevice MPSD WITH (NOLOCK)
			ON MPSD.MountPathId = MP.MountPathId
		JOIN MMDevice D WITH (NOLOCK)
			ON D.DeviceId = MPSD.DeviceId
		JOIN MMDeviceController DC WITH (NOLOCK)
			ON DC.DeviceId = D.DeviceId
	WHERE MP.LibraryId = @i_libraryId				----Library ID
		  AND ML.LibraryEnabled = 1                 ---- Library is enabled.
AND (NOT(ExtendedAttributes & 512 = 512)) ---- Library is marked for maintenance.
AND (DC.DeviceAccessType & 2 = 2)         ---- Device controller has write flag set.
		  AND (MP.MaxConcurrentWriters > 0)         ---- Mount path is enabled for write.
		  AND MP.IsEnabled = 1						---- Mount Path is enabled.
		  AND MP.MountPathTypeId = 7
	ORDER BY DC.DeviceControllerId
	-- Update user name and password for entries that use credentials
	EXEC MMS2GetDeviceControllerCredentials '#tmpOutputTable', 'credentialAssocId', 'userName', 'userPassword'
END
SELECT  OP.deviceType, OP.folder, OP.userName, OP.userPassword
FROM	#tmpOutputTable OP
IF OBJECT_ID('tempdb.dbo.#tmpOutputTable') IS NOT NULL
DROP TABLE #tmpOutputTable
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetCloudLibraryInfo')
	delete from GxQscripts where name = 'MMGetCloudLibraryInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudLibraryInfo')
	delete from GXDBVersions where aliasname = 'MMGetCloudLibraryInfo'
GO

insert into GXDBVersions values(2, 'MMGetCloudLibraryInfo',  '00010001000200060000', 'MMGetCloudLibraryInfo', '00010001000200060000')
GO

