

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetCloudControllerListForCloudMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetCloudControllerListForCloudMA.sp,v $ $Id: MMGetCloudControllerListForCloudMA.sp,v 1.1.2.6 2020/04/08 10:15:11 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMGetCloudControllerListForCloudMA"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
This stored proc will return list of cloud controller are possible to use
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMGetCloudControllerListForCloudMA')
BEGIN
	print '>>> Drop Stored Procedure: MMGetCloudControllerListForCloudMA <<<'
	drop procedure MMGetCloudControllerListForCloudMA
END
IF EXISTS (select * from GxQscripts where name='MMGetCloudControllerListForCloudMA')
	delete from GxQscripts where name = 'MMGetCloudControllerListForCloudMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudControllerListForCloudMA')
	delete from GXDBVersions where aliasname = 'MMGetCloudControllerListForCloudMA'
GO
print '... Creating Procedure: MMGetCloudControllerListForCloudMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetCloudControllerListForCloudMA
  @i_HostId Integer,
  @i_EntityType INTEGER,
  @i_userId INTEGER = 1
AS
  DECLARE @o_CloudControllerClientId INTEGER 
  DECLARE @o_CloudControllerClientName NVARCHAR(1024)
IF OBJECT_ID('tempdb.dbo.#lt_Clients_UserObjects') IS NOT NULL DROP TABLE #lt_Clients_UserObjects
CREATE TABLE #lt_Clients_UserObjects (clientId INT)
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 3, 0, '#lt_Clients_UserObjects'
IF @i_EntityType = 11
BEGIN
	DECLARE @InstanceType INTEGER = 0
	DECLARE @HyperVisorType INTEGER = 0
	SELECT @HyperVisorType = CAST(attrVal as INTEGER) FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @i_HostId AND attrName = 'VSA HyperVisor Type' AND modified = 0
	IF (@HyperVisorType & 16) = 16			--APP_VIRTSERV_AMAZON, AMAZON_VM
		SET @InstanceType = 301
	ELSE IF (@HyperVisorType & 32)  = 32	--APP_VIRTSERV_AZURE_V2, AZURE_VM
		SET @InstanceType = 402
	ELSE IF (@HyperVisorType & 1) = 1		--APP_VIRTSERV_VIRTUAL_CENTER, VMWARE_VM
		SET @InstanceType = 101
	ELSE IF (@HyperVisorType & 64) = 64		--APP_VIRTSERV_GOOGLE_CLOUD, GOOGLE_CLOUD_VM
		SET @InstanceType = 1301
	SELECT	DISTINCT C.id, C.name
			FROM APP_Client C WITH (NOLOCK)
			INNER JOIN #lt_Clients_UserObjects TMP
			ON C.id = TMP.clientId
			INNER JOIN APP_Application A WITH (NOLOCK)
			ON	C.id = A.clientId
AND A.appTypeId = 106
			INNER JOIN APP_InstanceProp I WITH (NOLOCK)
			ON  A.instance = I.componentNameId
			AND I.attrName = 'Virtual Server Instance Type' AND I.modified = 0
			AND CAST(I.attrVal AS INT) = @InstanceType
END
ELSE IF @i_EntityType = 28
BEGIN
	SELECT	DISTINCT C.id, C.name
		FROM APP_Client C WITH (NOLOCK)
		INNER JOIN #lt_Clients_UserObjects TMP
		ON C.id = TMP.clientId
		INNER JOIN APP_Application A WITH (NOLOCK)
		ON	C.id = A.clientId
AND A.appTypeId = 106
		INNER JOIN APP_InstanceProp I WITH (NOLOCK)
		ON  A.instance = I.componentNameId
		AND I.attrName = 'Virtual Server Instance Type' AND I.modified = 0
		AND CAST(I.attrVal AS INT) IN (101,301,402,1301)
END
IF OBJECT_ID('tempdb.dbo.#lt_Clients_UserObjects') IS NOT NULL DROP TABLE #lt_Clients_UserObjects
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetCloudControllerListForCloudMA')
	delete from GxQscripts where name = 'MMGetCloudControllerListForCloudMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCloudControllerListForCloudMA')
	delete from GXDBVersions where aliasname = 'MMGetCloudControllerListForCloudMA'
GO

insert into GXDBVersions values(2, 'MMGetCloudControllerListForCloudMA',  '00010001000200060000', 'MMGetCloudControllerListForCloudMA', '00010001000200060000')
GO

