

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetCacheMountPathInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetCacheMountPathInfo.sp,v $ $Id: MMGetCacheMountPathInfo.sp,v 1.1.2.2 2020/12/04 18:27:18 anarulkar Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetCacheMountPathInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMGetCacheMountPathInfo <<<'
	drop procedure MMGetCacheMountPathInfo
END
IF EXISTS (select * from GxQscripts where name='MMGetCacheMountPathInfo')
	delete from GxQscripts where name = 'MMGetCacheMountPathInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCacheMountPathInfo')
	delete from GXDBVersions where aliasname = 'MMGetCacheMountPathInfo'
GO
print '... Creating Procedure: MMGetCacheMountPathInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetCacheMountPathInfo
  @i_archFileId integer,
  @i_copyId integer,
  @i_hostId integer
AS
  DECLARE @o_MountPathId INTEGER
  DECLARE @o_MountPathType INTEGER
  DECLARE @o_MountpathName VARCHAR(2048)
  DECLARE @o_userName VARCHAR(1024)
  DECLARE @o_userPassword VARCHAR(2048)
  DECLARE @o_DeviceAccessType INTEGER
  DECLARE @o_FolderPath VARCHAR(1024)
  DECLARE @o_clientId INTEGER
  DECLARE @o_clientName VARCHAR(1024)
  DECLARE @o_MountpathAttributes INTEGER
if object_id('tempdb.dbo.#MountPathList') is not null DROP table #MountPathList
CREATE TABLE #MountPathList(MountPathId int PRIMARY KEY, originalMountPathId int, MountPathType int, MountpathName varchar(2048), userName varchar(1024), userPassword varchar(2048),
								DeviceAccessType int, FolderPath varchar(1024), clientId int, clientName varchar(1024), CredAssocId integer, MountpathAttributes integer)
DECLARE @BackupLibrary TABLE (LibraryId INT)
IF @i_archFileId > 0 AND @i_copyId > 0
BEGIN
	-- First try to find if the AF has chunks created. If so find using the volumes of those chunks.
	INSERT INTO @BackupLibrary
	SELECT MP.LibraryId
	FROM MMMountPath MP WITH (READUNCOMMITTED)
		INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON MP.MediaSideId = V.MediaSideID
		INNER JOIN archChunk AC WITH (READUNCOMMITTED) ON AC.VolumeId = V.VolumeId
		INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON AC.id = ACM.archChunkId AND AC.commCellId = ACM.commCellId
	WHERE ACM.archFileId = @i_archFileId
	AND ACM.archCopyId = @i_copyId
AND ACM.commCellId = 2 -- request has to be for current CC
	GROUP BY MP.LibraryId
	-- if nothing found, then it could be for backup where AF is still being written
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO @BackupLibrary
		SELECT M.LibraryId
		FROM MMMasterPool M WITH (READUNCOMMITTED)
			INNER JOIN MMDrivePool D WITH (READUNCOMMITTED) ON M.MasterPoolId = D.MasterPoolId
			INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AFC.drivePoolId = D.DrivePoolId
		WHERE AFC.archFileId = @i_archFileId
		AND AFC.archCopyId = @i_copyId
		GROUP BY M.LibraryId
	END
	-- Get the cache mountpath for the backup library
	INSERT INTO #MountPathList
	SELECT DISTINCT MPCACHE.MountPathId,MPCACHE.OrigCCMountPathId, MPCACHE.MountPathTypeId, MPCACHE.MountPathName, DEVC.UserName, DEVC.UserPassword, DEVC.DeviceAccessType, DEVC.Folder, DEVC.ClientId, '', DEVC.CredentialAssocId, MPCACHE.attribute
	FROM @BackupLibrary T
		INNER JOIN MMMountPath MPCACHE WITH (READUNCOMMITTED) ON T.LibraryId = MPCACHE.LibraryId
		INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MPCACHE.MountPathId = MPSD.MountPathId
		INNER JOIN MMDeviceController DEVC WITH (READUNCOMMITTED) ON MPSD.DeviceId = DEVC.DeviceId
	WHERE DEVC.ClientId = @i_hostId
	AND MPCACHE.MountPathTypeId = 11 /* MOUNTPATH_CACHE */
	-- If nothing found then fall back to datapath based method by resetting AFId
	IF NOT EXISTS (SELECT * FROM #MountPathList)
		SET @i_archFileId = 0
END
IF @i_copyId > 0 AND @i_archFileId = 0
BEGIN
INSERT INTO #MountPathList
SELECT DISTINCT MPCACHE.MountPathId,MPCACHE.OrigCCMountPathId, MPCACHE.MountPathTypeId, MPCACHE.MountPathName, DEVC.UserName, DEVC.UserPassword, DEVC.DeviceAccessType, DEVC.Folder, DEVC.ClientId, '', DEVC.CredentialAssocId, MPCACHE.attribute
FROM MMDataPath D WITH (READUNCOMMITTED)
	INNER JOIN MMDrivePool DP WITH (READUNCOMMITTED) ON D.DrivePoolId = DP.DrivePoolId
	INNER JOIN MMMountpath MP WITH (READUNCOMMITTED) ON DP.MasterPoolId = MP.MasterPoolId
	INNER JOIN MMMountPath MPCACHE WITH (READUNCOMMITTED) ON MP.LibraryId = MPCACHE.LibraryId
	INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MPCACHE.MountPathId = MPSD.MountPathId
	INNER JOIN MMDeviceController DEVC WITH (READUNCOMMITTED) ON MPSD.DeviceId = DEVC.DeviceId
WHERE D.copyId = @i_copyId
 AND DEVC.ClientId = @i_hostId
 AND MPCACHE.MountPathTypeId = 11 /* MOUNTPATH_CACHE */
END
ELSE
BEGIN
 INSERT INTO #MountPathList
 SELECt DISTINCT MP.MountPathId,MP.OrigCCMountPathId, MP.MountPathTypeId, MP.MountPathName, DEVC.UserName, DEVC.UserPassword, DEVC.DeviceAccessType, DEVC.Folder, DEVC.ClientId, '', DEVC.CredentialAssocId, MP.attribute
 FROM MMMountpath MP WITH (READUNCOMMITTED)
	INNER JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MP.MountPathId = MPSD.MountPathId
	INNER JOIN MMDeviceController DEVC WITH (READUNCOMMITTED) ON MPSD.DeviceId = DEVC.DeviceId
 WHERE DEVC.ClientId = @i_hostId
 AND MP.MountPathTypeId = 11 /* MOUNT_PATH_CACHE */
END
 UPDATE MP
 SET MP.clientId = CL.id, MP.clientName = CL.name
 FROM #MountPathList MP
 inner join APP_Client CL WITH (READUNCOMMITTED) on MP.clientId = CL.id
 --CI Support with HyperScale MountPaths
DECLARE @peerList varchar(1024)
SELECT @peerList = COALESCE(@peerList + '##', '') + T.host
FROM
    (   SELECT DISTINCT C.net_hostname AS host FROM
        APP_Client C(NOLOCK), MMDiskHWInfo(NOLOCK) HW, MMMountPathToStorageDevice MPSD(NOLOCK), #MountPathList TMP
WHERE C.id = HW.hostId AND HW.deviceId = MPSD.DeviceId AND MPSD.MountPathId = TMP.MountPathId AND TMP.MountpathAttributes & 64 > 0
    ) AS T
-- Set the base folder name.
UPDATE  #MountPathList
SET     FolderPath = (CASE WHEN ( ('/' = RIGHT (FolderPath, 1)) OR ('\' = RIGHT (FolderPath, 1)) ) THEN (FolderPath + MountPathName) ELSE (FolderPath + '\' + MountPathName) END)
WHERE   ( (deviceAccessType & (16 | 32 | 128) = 0 ))
-- Data Server - Shared Devices
-- Mount Path Protocol - Access Protocol(iSCSI, FC or IP)|DeviceAccessType|Preferred Data Server Host Id|Preferred Data Server Host Name|Mount Path?s Preferred Device Controller|Disk Library Access Path
UPDATE  TMP
SET     FolderPath = (CASE WHEN TMP.deviceAccessType & 16 > 0 THEN N'IP|' WHEN TMP.deviceAccessType & 32 > 0 THEN N'FC|' ELSE N'ISCSI|' END)
                            + CAST(TMP.deviceAccessType AS NVARCHAR(10)) + N'|'
                            + CAST(DC.ClientId AS NVARCHAR(10)) + N'|'
+ (CASE WHEN TMP.MountpathAttributes & 64 > 0 AND TMP.deviceAccessType & 16 > 0 THEN @peerList + N'|' ELSE CLT.net_hostname + N'|' END)
                            + CAST(TMP.MountPathId AS NVARCHAR(10)) + N'|'
                            + (CASE WHEN ( ('/' = RIGHT (DC.Folder, 1)) OR ('\' = RIGHT (DC.Folder, 1)) ) THEN (DC.Folder + MP.MountPathName) ELSE (DC.Folder + '\' + MP.MountPathName) END),
        userName =  DC.UserName, userPassword = DC.UserPassword, CredAssocId = DC.CredentialAssocId
FROM    #MountPathList TMP INNER JOIN MMMountPathToStorageDevice MPSD WITH(NOLOCK) ON TMP.MountPathId = MPSD.MountPathId
        INNER JOIN MMMountPath MP WITH(NOLOCK) ON TMP.MountPathId = MP.MountPathId
INNER JOIN MMDeviceController DC WITH(NOLOCK) ON MPSD.DeviceId = DC.DeviceId AND DC.DeviceAccessType & 8 > 0
        INNER JOIN APP_Client CLT WITH(NOLOCK) ON DC.ClientId = CLT.id
WHERE   ( (TMP.deviceAccessType & 16 > 0 ) OR
(TMP.deviceAccessType & 32 > 0 ) OR
(TMP.deviceAccessType & 128 > 0 ) )
 EXEC MMS2GetDeviceControllerCredentials '#MountPathList', 'CredAssocId', 'userName', 'userPassword'
 select MountPathId, MountPathType, MountpathName, userName, userPassword, DeviceAccessType, FolderPath, clientId, clientName, MountpathAttributes from #MountPathList
 if object_id('tempdb.dbo.#MountPathList') is not null DROP table #MountPathList
 if object_id('tempdb.dbo.#tempVolumeTable') is not null DROP table #tempVolumeTable
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetCacheMountPathInfo')
	delete from GxQscripts where name = 'MMGetCacheMountPathInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCacheMountPathInfo')
	delete from GXDBVersions where aliasname = 'MMGetCacheMountPathInfo'
GO

insert into GXDBVersions values(2, 'MMGetCacheMountPathInfo',  '00010001000200020000', 'MMGetCacheMountPathInfo', '00010001000200020000')
GO

