

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetCacheMPIdForVolume.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetCacheMPIdForVolume')
BEGIN
	print '>>> Drop Stored Procedure: MMGetCacheMPIdForVolume <<<'
	drop procedure MMGetCacheMPIdForVolume
END
IF EXISTS (select * from GxQscripts where name='MMGetCacheMPIdForVolume')
	delete from GxQscripts where name = 'MMGetCacheMPIdForVolume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCacheMPIdForVolume')
	delete from GXDBVersions where aliasname = 'MMGetCacheMPIdForVolume'
GO
print '... Creating Procedure: MMGetCacheMPIdForVolume'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetCacheMPIdForVolume
-- Pruner is pruning this store currently.
  @StoreId BIGINT,
-- Pruner is pruning a chunk in this volume currently.
  @VolId BIGINT,
-- Number of volume mappings to be returned.
-- Next chunk to be pruned can be in the same volume or its neighborhood.
-- So return volid-diskcachempid mapping for other volumes around this one too.
  @NumVols INTEGER
AS
  DECLARE @VolumeId BIGINT
  DECLARE @CacheMPId BIGINT
SET NOCOUNT ON
DECLARE @lastError integer
DECLARE @localErrorMsg varchar(512)
SET @lastError = 0
SET @localErrorMsg = 'Error getting Cached MPId.'
-- Results will be put into this table.
IF OBJECT_ID('tempdb.dbo.#CACHEMPIDFORVOL') IS NOT NULL
	DROP TABLE #CACHEMPIDFORVOL
CREATE TABLE #CACHEMPIDFORVOL (VolumeId INT, CacheMountpathId INT)
-- If the volume does not exist in MMVolume table, we cannot figure out cacheMPId.
-- So simply treat it as cloud volume to proceed. CacheMPId = 0 will do this.
IF NOT EXISTS (SELECT * FROM MMVolume WHERE VolumeId = @VolId)
BEGIN
	INSERT INTO #CACHEMPIDFORVOL
	VALUES (@VolId, 0)
	GOTO EXIT_END
END
-- If the given volume is not on cloud or doesn't belong to the given store,
-- there is something wrong.
IF NOT EXISTS (SELECT * FROM MMMountpath MP, MMVolume VOL
			   WHERE VOL.VolumeId = @VolId AND
					MP.MountPathId = VOL.CurrMountPathId AND
					MP.MountPathTypeId = 7 /* MOUNT_PATH_EXTERNAL_REMOTE_HOST (enum not #def) */ AND
MP.Attribute & 32 <> 0)
BEGIN
	SET @lastError = 1
	SET @localErrorMsg ='Volume is not on cloud or doesn''t have micro-pruning enabled'
	GOTO EXIT_END
END
IF NOT EXISTS (SELECT * FROM MMVolume WHERE VolumeId = @VolId AND SIDBStoreId = @StoreId)
BEGIN
	SET @lastError = 2
	SET @localErrorMsg ='Unexpected SIDBStoreId associated for volume'
	GOTO EXIT_END
END
-- 1) Return volumes in the neighborhood of @VolId.
-- Half of the returned volumes will be after @VolId.
-- 2) We have to return all cloud volumes in the neighborhood
-- of @VolId, whether hybrid or not.
INSERT INTO #CACHEMPIDFORVOL
SELECT TOP (@NumVols/2)
	VOL.VolumeId,
	ISNULL (MAP.CacheMountPathId, 0)
FROM
	MMVolume VOL
		LEFT OUTER JOIN
	MMCloudVolCacheMountPath MAP ON VOL.VolumeId = MAP.VolumeId
WHERE
	VOL.VolumeId >= @VolId AND
	VOL.SIDBStoreId = @StoreId
ORDER BY
	VOL.VolumeId
-- The rest of the volumes will be before @VolId.
SELECT @NumVols = @NumVols - COUNT(*) FROM #CACHEMPIDFORVOL
INSERT INTO #CACHEMPIDFORVOL
SELECT TOP (@NumVols/2)
	VOL.VolumeId,
	ISNULL (MAP.CacheMountPathId, 0)
FROM
	MMVolume VOL
		LEFT OUTER JOIN
	MMCloudVolCacheMountPath MAP ON VOL.VolumeId = MAP.VolumeId
WHERE
	VOL.VolumeId < @VolId AND
	VOL.SIDBStoreId = @StoreId
ORDER BY
	VOL.VolumeId DESC
-- Done.
EXIT_END:
IF @lastError <> 0
BEGIN
	DROP TABLE #CACHEMPIDFORVOL
	RAISERROR(@localErrorMsg,
				16,	--Severity (>10 to force DOS Error code = 1)
				1 )
END
ELSE
BEGIN
	SELECT * FROM #CACHEMPIDFORVOL
	DROP TABLE #CACHEMPIDFORVOL
END
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetCacheMPIdForVolume')
	delete from GxQscripts where name = 'MMGetCacheMPIdForVolume'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetCacheMPIdForVolume')
	delete from GXDBVersions where aliasname = 'MMGetCacheMPIdForVolume'
GO

insert into GXDBVersions values(2, 'MMGetCacheMPIdForVolume',  '00000000000000000000', 'MMGetCacheMPIdForVolume', '00000000000000000000')
GO

