

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetBadChunksForReviewInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: anarulkar
--	Date:   05/22/2014
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetBadChunksForReviewInfo.sp,v $ $Id: MMGetBadChunksForReviewInfo.sp,v 1.1.2.2 2020/11/30 21:27:15 sjohnson Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='MMGetBadChunksForReviewInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMGetBadChunksForReviewInfo <<<'
	drop procedure MMGetBadChunksForReviewInfo
END
IF EXISTS (select * from GxQscripts where name='MMGetBadChunksForReviewInfo')
	delete from GxQscripts where name = 'MMGetBadChunksForReviewInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetBadChunksForReviewInfo')
	delete from GXDBVersions where aliasname = 'MMGetBadChunksForReviewInfo'
GO
print '... Creating Procedure: MMGetBadChunksForReviewInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure MMGetBadChunksForReviewInfo
  @i_CommCellId integer,
  @i_reserveParam integer
AS
  DECLARE @o_SIDBStoreId integer
  DECLARE @o_SIDBStoreName nvarchar(256)
  DECLARE @o_LibraryId integer
  DECLARE @o_LibraryName nvarchar(128)
  DECLARE @o_MountPathId integer
  DECLARE @o_MountPathName nvarchar(1024)
  DECLARE @o_NumberOfChunks integer
  DECLARE @o_StartTime datetime
  DECLARE @o_EndTime datetime
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @BadChunkReviewInfo table (SIDBStoreId int,
									SIDBStoreName nvarchar(256),
									LibraryId int,
									LibraryName nvarchar(128),
									MountPathId int,
									MountPathName nvarchar(1024),
									NumChunks int,
									StartTime datetime,
									EndTime datetime)
--Collect stores pending bad chunk review along with no of bad chunks
INSERT INTO @BadChunkReviewInfo
SELECT Store.SIDBStoreId, Store.SIDBStoreName, MP.LibraryId, N'', MP.MountPathId, N'', COUNT(DISTINCT archChunkId),
dbo.UTCToClientLocalTime(dbo.GetdateTime(ISNULL(MIN(insertTime), 0)), 2),
dbo.UTCToClientLocalTime(dbo.GetdateTime(ISNULL(MAX(insertTime), 0)), 2)
FROM IdxSIDBStore Store
LEFT OUTER JOIN archChunkDDBDrop ACDrop ON ACDrop.SIDBStoreId = Store.SIDBStoreId
AND (ACDrop.flags & 1) <> 0
LEFT OUTER JOIN archChunk AC ON ACDrop.archChunkId = AC.id AND ACDrop.chunkCommCellId = AC.commcellId
LEFT OUTER JOIN MMVolume V ON AC.VolumeId = V.VolumeId
LEFT OUTER JOIN MMMountPath MP ON V.MediaSideId = MP.MediaSideId --ArchChunkDDBDrop MountPathId may not get set.
WHERE (Store.extendedFlags & 16) <> 0
GROUP BY Store.SIDBStoreId, Store.SIDBStoreName, MP.LibraryId, MP.MountPathId
-- If there are no chunks in archChunkDDBDrop that are pending review, take off store from review pending state
UPDATE Store
SET extendedFlags = extendedFlags & ~(16)
FROM IdxSIDBStore Store
JOIN @BadChunkReviewInfo BCR ON Store.SIDBStoreId = BCR.SIDBStoreId
WHERE NumChunks = 0
/*
TBD if reqd: Approve chunks for bad chunks review if Store is no longer in review pending mode
*/
--Update Library and MountPath Names to be shown for the event
UPDATE BCR
SET LibraryName = L.AliasName
FROM @BadChunkReviewInfo BCR
JOIN MMLibrary L ON BCR.LibraryId = L.LibraryId
UPDATE BCR
SET MountPathName = MPGUI.MountPathName
FROM @BadChunkReviewInfo BCR
JOIN MMS2getMountPathNameGUIView MPGUI ON BCR.MountPathId = MPGUI.MountPathId
SELECT * FROM @BadChunkReviewInfo
WHERE NumChunks > 0
ORDER BY SIDBStoreId, MountPathId

IF EXISTS (select * from GxQscripts where name = 'MMGetBadChunksForReviewInfo')
	delete from GxQscripts where name = 'MMGetBadChunksForReviewInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetBadChunksForReviewInfo')
	delete from GXDBVersions where aliasname = 'MMGetBadChunksForReviewInfo'
GO

insert into GXDBVersions values(2, 'MMGetBadChunksForReviewInfo',  '00010001000200020000', 'MMGetBadChunksForReviewInfo', '00010001000200020000')
GO

