

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetAccessPathBySIDBStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetAccessPathBySIDBStore.sp,v $ $Id: MMGetAccessPathBySIDBStore.sp,v 1.2.208.2 2018/03/20 20:06:01 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "MMGetAccessPathBySIDBStore"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetAccessPathBySIDBStore <<<'

IF EXISTS (select * from sysobjects where name='MMGetAccessPathBySIDBStore')
	drop procedure MMGetAccessPathBySIDBStore
IF EXISTS (select * from GxQscripts where name='MMGetAccessPathBySIDBStore')
	delete from GxQscripts where name = 'MMGetAccessPathBySIDBStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetAccessPathBySIDBStore')
	delete from GXDBVersions where aliasname = 'MMGetAccessPathBySIDBStore'
GO
print '... Creating Procedure: MMGetAccessPathBySIDBStore'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetAccessPathBySIDBStore
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
  @i_SIDBStoreId integer
AS
  DECLARE @o_idxAccessPathId integer
  DECLARE @o_idxCacheId integer
  DECLARE @o_clientId integer
  DECLARE @o_clientName varchar(255)
  DECLARE @o_path varchar(255)
  DECLARE @o_userName varchar(255)
  DECLARE @o_password varchar(255)
  DECLARE @o_enabled integer
  DECLARE @o_softState integer
  DECLARE @o_offlineReason integer
  DECLARE @o_priority integer
	SET NOCOUNT ON
	-- If specified a SIDB Store id, then resturn access path have the same idxCacheId
	-- Otherwise, return all the access path
	IF (@i_SIDBStoreId <> 0)
	BEGIN
		SELECT	IdxAccessPathId,
				IdxCacheId,
				ClientId,
				(SELECT Name FROM App_Client WHERE id = ClientId) AS ClientName,
				Path,
				Username,
				Password,
				Enabled,
				SoftState,
				OfflineReason,
				Priority
		FROM	IdxAccessPath
		WHERE	IdxCacheId in (SELECT IdxCacheId FROM IdxSIDBSubStore WHERE SIDBStoreId = @i_SIDBStoreId)
	END
	ELSE
	BEGIN
		SELECT	IAP.IdxAccessPathId,
				IAP.IdxCacheId,
				IAP.ClientId,
				(SELECT Name FROM App_Client WHERE id = ClientId) AS ClientName,
				IAP.Path,
				IAP.Username,
				IAP.Password,
				IAP.Enabled,
				IAP.SoftState,
				IAP.OfflineReason,
				IAP.Priority
		FROM	IdxAccessPath as IAP, IdxCache as IC
		WHERE	IAP.IdxCacheId = IC.IdxCacheId AND
			IC.IdxCacheType = 2
	END
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetAccessPathBySIDBStore')
	delete from GxQscripts where name = 'MMGetAccessPathBySIDBStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetAccessPathBySIDBStore')
	delete from GXDBVersions where aliasname = 'MMGetAccessPathBySIDBStore'
GO

insert into GXDBVersions values(2, 'MMGetAccessPathBySIDBStore',  '00010002020800020000', 'MMGetAccessPathBySIDBStore', '00010002020800020000')
GO

