

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMGetAGandAGCInfoForDriveId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMGetAGandAGCInfoForDriveId.sp,v $ $Id: MMGetAGandAGCInfoForDriveId.sp,v 1.11.200.4 2018/03/20 19:59:00 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMGetAGandAGCInfoForDriveId"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMGetAGandAGCInfoForDriveId <<<'

IF EXISTS (select * from sysobjects where name='MMGetAGandAGCInfoForDriveId')
	drop procedure MMGetAGandAGCInfoForDriveId
IF EXISTS (select * from GxQscripts where name='MMGetAGandAGCInfoForDriveId')
	delete from GxQscripts where name = 'MMGetAGandAGCInfoForDriveId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetAGandAGCInfoForDriveId')
	delete from GXDBVersions where aliasname = 'MMGetAGandAGCInfoForDriveId'
GO
print '... Creating Procedure: MMGetAGandAGCInfoForDriveId'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMGetAGandAGCInfoForDriveId
  @i_driveId int
AS
  DECLARE @o_mediaId integer
  DECLARE @o_barCode varchar(255)
  DECLARE @o_archiveGroupId integer                  
  DECLARE @o_archiveGroupName NVARCHAR(255)
  DECLARE @o_archiveGroupCopyId integer                  
  DECLARE @o_archiveGroupCopyName NVARCHAR(255)
  DECLARE @o_uniqueId varchar(255)
  DECLARE @o_driveId integer
  DECLARE @o_driveAliasName NVARCHAR(255)
  DECLARE @o_libraryId integer
  DECLARE @o_libraryName NVARCHAR(255)
  DECLARE @o_mediaAttributes integer   
  DECLARE @o_extendedAttributes integer               
  DECLARE @o_containerId integer
  DECLARE @o_containerName NVARCHAR(255)
  DECLARE @o_numberOfExtRetentionJobsOnMedia integer    
  DECLARE @o_numberOfSoftErrors_A integer
  DECLARE @o_numberOfHardErrors_A integer
  DECLARE @o_numberOfSoftErrors_B integer
  DECLARE @o_numberOfHardErrors_B integer
  DECLARE @o_isAged integer       
  DECLARE @o_isInMediaGroup integer       
  DECLARE @o_isPrimaryCopy integer
  DECLARE @o_archStreamNum integer
  DECLARE @o_slotElementAddress integer
  DECLARE @o_DriveOccupied integer
  DECLARE @o_LSCSName nvarchar(256)
  DECLARE @o_mediaStatusReason integer
	SELECT	@o_driveId = @i_driveId,
			@o_mediaId = ISNULL(mm.MediaId, 0),
			@o_barcode = ISNULL(mm.BarCode, ''),
			@o_driveAliasName = ISNULL(md.AliasName, ''),
			@o_slotElementAddress = ISNULL(md.SlotElementAddress, 0),
			@o_DriveOccupied = ISNULL(md.DriveOccupied, 0),
			@o_LSCSName = ISNULL(md.LSCSName, ''),
			@o_mediaStatusReason	=	mm.MediaStatusReason
	FROM	MMMedia as mm, MMDrive as md
	WHERE	md.DriveId = @i_driveId and mm.MediaId = md.MediaId
	SELECT	@o_archiveGroupCopyId = ISNULL(AGC.Id, 0),
			@o_archiveGroupId = ISNULL(AGC.ArchGroupId, 0),
			@o_archiveGroupCopyName = ISNULL(AGC.Name, ''),
			@o_archiveGroupName = ISNULL(AG.Name, ''),
			@o_isPrimaryCopy	= CASE WHEN AG.defaultCopy = AGC.Id THEN 1 ELSE 0 END
	FROM ArchGroupCopy as AGC, ArchGroup as AG
	WHERE	AGC.Id = (SELECT	TOP 1 MD.CopyId
						FROM	MMDataPath AS MD, MMMediaGroup AS MG, MMVolume AS V
						WHERE	V.MediaId = @o_mediaId and MG.MediaGroupId = V.MediaGroupId and MD.DataPathId = MG.DataPathId
					  )
			and AGC.ArchGroupId = AG.Id
	SET @o_archStreamNum =
					ISNULL((SELECT TOP 1 S.Stream
								FROM MMVolume AS MV, ArchStream AS S
								WHERE MV.MediaId = @o_mediaId AND MV.MediaGroupId = S.MediaGroupId
								AND	S.ArchGroupId = @o_archiveGroupId
								AND S.ArchGroupCopyId = @o_archiveGroupCopyId),
								0)
	SELECT	@o_uniqueId = ISNULL(M.UniqueId, ''),
			@o_libraryId = ISNULL(M.LibraryId, 0),
			@o_libraryName = ISNULL(ML.LibraryName, ''),
			@o_mediaAttributes = ISNULL(M.Attributes, 0),
			@o_extendedAttributes = ISNULL(M.ExtendedAttributes, 0),
			@o_containerId = ISNULL(MC.ContainerId, 0),
			@o_containerName = ISNULL(MC.ContainerName, ''),
			@o_isAged = ISNULL(M.IsAged, 0),
			@o_isInMediaGroup = ISNULL(M.IsInMediaGroup, 0)
	FROM MMMedia as M, MMContainer as MC, MMLibrary as ML
	WHERE M.MediaId = @o_MediaId and M.ContainerId = MC.ContainerId and M.LibraryId = ML.LibraryId
	EXEC @o_numberOfExtRetentionJobsOnMedia = dbo.MMS2Func_NumExtRetJobsOnMedia @o_mediaId
	SELECT	TOP 1 @o_numberOfSoftErrors_A = ISNULL(NumberOfSoftErrors, 0),
				  @o_numberOfHardErrors_A = ISNULL(NumberOfHardErrors, 0)
	FROM	MMMediaSide WHERE MediaId = @o_mediaId
	IF (SELECT mt.NumberOfSides
	 	FROM MMMedia as mm, MMMediaType as mt
		WHERE mm.MediaId = @o_mediaId and mm.MediaTypeId = mt.MediaTypeId) > 1
	BEGIN
		SELECT	TOP 2 @o_numberOfSoftErrors_B = ISNULL(NumberOfSoftErrors, 0),
					  @o_numberOfHardErrors_B = ISNULL(NumberOfHardErrors, 0)
		FROM	MMMediaSide
		WHERE	MediaId = @o_mediaId and
				MediaSideId != (SELECT TOP 1 MediaSideId FROM MMMediaSide)
	END
	ELSE
	BEGIN
		SET @o_numberOfSoftErrors_B = 0
		SET @o_numberOfHardErrors_B = 0
	END
	-- Get GUI Attribute
	IF (@o_mediaId > 0)
	BEGIN
		SET @o_mediaAttributes = dbo.MMS2FUNC_GetGuiMediaAttribute(@o_mediaId)
	END
	SELECT	@o_mediaId, @o_barCode, @o_archiveGroupId, @o_archiveGroupName, @o_archiveGroupCopyId,
			@o_archiveGroupCopyName, @o_uniqueId, @o_driveId, @o_driveAliasName,
			@o_libraryId, @o_libraryName, @o_mediaAttributes, @o_extendedAttributes, @o_containerId, @o_containerName,
			@o_numberOfExtRetentionJobsOnMedia,
			@o_numberOfSoftErrors_A, @o_numberOfHardErrors_A,
			@o_numberOfSoftErrors_B, @o_numberOfHardErrors_B,
			@o_isAged, @o_isInMediaGroup,
			@o_isPrimaryCopy, @o_archStreamNum, @o_slotElementAddress, @o_DriveOccupied, @o_LSCSName,@o_mediaStatusReason
	RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'MMGetAGandAGCInfoForDriveId')
	delete from GxQscripts where name = 'MMGetAGandAGCInfoForDriveId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMGetAGandAGCInfoForDriveId')
	delete from GXDBVersions where aliasname = 'MMGetAGandAGCInfoForDriveId'
GO

insert into GXDBVersions values(2, 'MMGetAGandAGCInfoForDriveId',  '00010011020000040000', 'MMGetAGandAGCInfoForDriveId', '00010011020000040000')
GO

