

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMForceResetMAInformation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMForceResetMAInformation.sp,v $ $Id: MMForceResetMAInformation.sp,v 1.1.2.8 2020/01/10 08:48:46 shubhamagrawal Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMForceResetMAInformation')
BEGIN
	print '>>> Drop Stored Procedure: MMForceResetMAInformation <<<'
	drop procedure MMForceResetMAInformation
END
IF EXISTS (select * from GxQscripts where name='MMForceResetMAInformation')
	delete from GxQscripts where name = 'MMForceResetMAInformation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMForceResetMAInformation')
	delete from GXDBVersions where aliasname = 'MMForceResetMAInformation'
GO
print '... Creating Procedure: MMForceResetMAInformation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMForceResetMAInformation
-- Stored Procedure Inputs
  @clientId INTEGER = 0,
  @userId INTEGER
AS
  DECLARE @o_entityType int
  DECLARE @o_intValue int
  DECLARE @o_strValue varchar(2048)
-- GUI AUDIT
DECLARE @opMsgId    INTEGER
DECLARE @opEvMsgId  INTEGER
DECLARE @opId       INTEGER
DECLARE @paramMsgId INTEGER
DECLARE @clientName nvarchar(max)
IF object_id('tempdb.dbo.#tempMAAssociatedEntity') IS NOT NULL DROP TABLE #tempMAAssociatedEntity
CREATE TABLE #tempMAAssociatedEntity(entityType int, intValue int, strValue VARCHAR(2048))
IF object_id('tempdb.dbo.#tempDeviceController') IS NOT NULL DROP TABLE #tempDeviceController
CREATE TABLE #tempDeviceController( deviceControllerId INT PRIMARY KEY, deviceId INT, clientId INT)
IF object_id('tempdb.dbo.#tempCredAssoc') IS NOT NULL DROP TABLE #tempCredAssoc
CREATE TABLE #tempCredAssoc( assocId INT PRIMARY KEY)
IF object_id('tempdb.dbo.#tempLibControllers') IS NOT NULL DROP TABLE #tempLibControllers
CREATE TABLE #tempLibControllers (LibraryId INT PRIMARY KEY, NumberOfControllers INT)
IF object_id('tempdb.dbo.#tempMasterPools') IS NOT NULL DROP TABLE #tempMasterPools
CREATE TABLE #tempMasterPools (masterPoolId INT PRIMARY KEY)
IF object_id('tempdb.dbo.#tempMPForNextJobFull') IS NOT NULL DROP TABLE #tempMPForNextJobFull
CREATE TABLE #tempMPForNextJobFull( mpId INT PRIMARY KEY)
BEGIN TRAN
BEGIN TRY
	IF ISNULL(@clientId, 0) < 2
	BEGIN
INSERT INTO #tempMAAssociatedEntity VALUES(0, 1, 'Error: MediaAgent Id '+ @clientId+' not found')
		GOTO SCRIPT_EXIT
	END
	select @clientName = displayName from APP_Client WHERE Id = @clientId
	IF @clientName IS NULL
	BEGIN
INSERT INTO #tempMAAssociatedEntity VALUES(0, 1, 'Error: Failed to fetch client name for MediaAgent Id' + @clientId)
		GOTO SCRIPT_EXIT
	END
	--Set Operation
SET @opMsgId = (658 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	-- CASE: DDB Partitions
	IF EXISTS(SELECT 1 FROM IdxSIDBSubStore (READUNCOMMITTED) WHERE ClientId = @clientId)
	BEGIN
		/*----------------------------GAT - START ---------------------------- */
		DECLARE @substoreList NVARCHAR(max)
		SELECT @substoreList = COALESCE(@substoreList + '<BR>',' ') + S.SIDBStoreName + ' [' + AP.Path + '][ID: ' + CAST(SS.SubStoreId as varchar(20))+ ']'
		FROM IdxSIDBSubStore ss (READUNCOMMITTED)
			INNER JOIN IdxAccessPath ap (READUNCOMMITTED) on ap.IdxAccessPathId = ss.IdxAccessPathId
			INNER JOIN IdxSIDBStore S (READUNCOMMITTED) ON S.SIDBStoreId = ss.SIDBStoreId
		WHERE ss.ClientId = @clientId
		IF @substoreList IS NOT NULL
		BEGIN
			EXEC EvGuiAuditSetParamData @opId, @clientName, 0
			EXEC EvGuiAuditSetParamData @opId, @substoreList, 0
SET @paramMsgId  = (1772 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		/*----------------------------GAT - END ---------------------------- */
		/* 	Mark each and every store hosted on client being deleted as corrupt, And deassociate accesspath and idx cache.
			Idx tables are cleaned up by CPP, layer while deconfiguring MediaAgent, so no need to delete them here  */
		UPDATE IdxSIDBSubStore
SET IdxAccessPathId = 0, IdxCacheId = 0, ClientId = 1, Status = 1
		WHERE ClientId = @clientId
	END
	-- CASE: DriveControllers
	DELETE FROM MMDriveController WHERE ClientId = @clientId
	-- CASE: DeviceControllers
	--Fetch all device controllers
	INSERT INTO #tempDeviceController
		SELECT DeviceControllerId, DeviceId, ClientId	FROM MMDeviceController (READUNCOMMITTED) WHERE ClientId = @clientId
	IF EXISTS(SELECT 1 FROM #tempDeviceController)
	BEGIN
		--Fetch all dependent data-server device controllers
		INSERT INTO #tempDeviceController
			SELECT DC.DeviceControllerId, DC.DeviceId, DC.ClientId
			FROM MMDeviceController DC (READUNCOMMITTED)
WHERE (DC.DeviceAccessType & (16 | 32 | 128)) >  0 --Data-Server Device controllers
				AND DC.ClientId <> @clientId --other than MA being deleted
				AND EXISTS( SELECT 1 FROM MMDeviceController DC2 (READUNCOMMITTED) WHERE DC2.DeviceId = DC.DeviceId AND DC2.ClientId = @clientId) --Pick only devices which have MA being deleted as a controller
				AND NOT EXISTS(					--And there does not exist any regular controller on device, except the being deleted.
					SELECT 1
					FROM MMDeviceController DC2  (READUNCOMMITTED)
					WHERE DC2.DeviceId = DC.DeviceId AND DC2.ClientId <> @clientId
AND (DC2.DeviceAccessType & (16 | 32 | 128 | 4)) = 4
					)
		INSERT INTO #tempCredAssoc
			SELECT DISTINCT(CredentialAssocId)
			FROM MMDeviceController DC	 (READUNCOMMITTED)
				INNER JOIN #tempDeviceController TDC ON DC.DeviceControllerId = TDC.DeviceControllerId
			WHERE DC.CredentialAssocId > 0
		/*----------------------------GAT - START ---------------------------- */
		DECLARE @mpList nvarchar(max)
		SELECT @mpList = COALESCE(@mpList + '<BR>',' ') + L.AliasName +' '+ MP.MountPathName
		FROM MMLibrary L (READUNCOMMITTED)
			INNER JOIN MMS2getMountPathNameGUIView MP (READUNCOMMITTED) ON MP.LibraryId = L.LibraryId
		WHERE MP.DeviceId IN (SELECT DISTINCT(DeviceId) FROM #tempDeviceController)
		IF @mpList IS NOT NULL
		BEGIN
			EXEC EvGuiAuditSetParamData @opId, @clientName, 0
			EXEC EvGuiAuditSetParamData @opId, @mpList, 0
SET @paramMsgId  = (1771 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		/*----------------------------GAT - END ---------------------------- */
		DELETE DC
		FROM MMDeviceController DC
			INNER JOIN #tempDeviceController TDC ON DC.DeviceControllerId = TDC.DeviceControllerId
		DELETE CRED
		FROM APP_CredentialAssoc CRED
			INNER JOIN #tempCredAssoc TCRED ON CRED.assocId = TCRED.assocId
		IF EXISTS(SELECT 1 FROM #tempDeviceController WHERE ClientId <> @clientId)
		BEGIN
			DECLARE @tempLibraryClientTbl table (LibraryId int, ClientId int)
			--fetch all the libraries and client combination where do not exist any device-controller for that
			INSERT INTO @tempLibraryClientTbl
				SELECT DISTINCT MP.LibraryId, DC.ClientId
				FROM MMMountPath MP (READUNCOMMITTED)
					INNER JOIN MMMountPathToStorageDevice MPSD (READUNCOMMITTED) ON MPSD.MountPathId = MP.MountPathId
					INNER JOIN #tempDeviceController DC ON DC.DeviceId = MPSD.DeviceId
				WHERE DC.ClientId <> @clientId --only dependent data-server device-controllers
					AND NOT EXISTS(  --if there do not exist any device controller for library for that particular client
						SELECT 1
						FROM MMMountPath MP2 (READUNCOMMITTED)
							INNER JOIN MMMountPathToStorageDevice MPSD2 (READUNCOMMITTED) ON MPSD2.MountPathId = MP2.MountPathId
							INNER JOIN MMDeviceController DC2 (READUNCOMMITTED) ON DC2.DeviceId = MPSD2.DeviceId
						WHERE MP2.LibraryId = MP.LibraryId AND DC2.ClientId = DC.ClientId
						)
			--Delete library controllers for dependent data-server device-controllers
			DELETE LC
			FROM MMLibraryController LC
				INNER JOIN @tempLibraryClientTbl L ON LC.LibraryId = L.LibraryId AND LC.ClientId = L.ClientId
			--Delete drive-pools for dependent data-server device-controllers
			INSERT INTO #tempMAAssociatedEntity
SELECT DISTINCT 1, DP.DrivePoolId, ''
				FROM MMDrivePool DP (READUNCOMMITTED)
					INNER JOIN MMMasterPool MPOOL (READUNCOMMITTED) ON MPOOL.MasterPoolId = DP.MasterPoolId
					INNER JOIN @tempLibraryClientTbl L ON MPOOL.LibraryId = L.LibraryId AND DP.ClientId = L.ClientId
		END
		UPDATE MP
		SET IsOffline = 1,
			OfflineReason = 9, --MOUNTPATH_NO_DEVICE_CONTROLLER_LEFT_DUE_TO_MA_DELETE
MountPathOfflineReasonEventId = (1069 | (CAST(POWER(2, 24) AS BIGINT) * 64))
		FROM MMMountPath MP
			INNER JOIN MMMountPathToStorageDevice MPSD ON MPSD.MountPathId = MP.MountPathId
			INNER JOIN #tempDeviceController TDC ON  TDC.deviceId = MPSD.DeviceId
		WHERE  NOT EXISTS (SELECT 1 FROM MMDeviceController DC WHERE DC.DeviceId = TDC.DeviceId)
		INSERT INTO #tempMPForNextJobFull
			SELECT DISTINCT MP.MountPathId
			FROM MMMountPath MP (READUNCOMMITTED)
				INNER JOIN MMMountPathToStorageDevice MPSD ON MPSD.MountPathId = MP.MountPathId
				INNER JOIN #tempDeviceController TDC ON  TDC.deviceId = MPSD.DeviceId
			WHERE  NOT EXISTS (SELECT 1 From MMDeviceController DC WHERE DC.DeviceId = MPSD.DeviceId)
		IF EXISTS (SELECT 1 FROM #tempMPForNextJobFull)
EXEC AppNotifyMountPathChangesToClient 0/*MPID*/, 3 /*opType*/
	END
	-- CASE: DrivePools/Associated-data paths are already delted in cpp layer
	DELETE FROM MMDrivePool WHERE ClientId=@clientId
	-- CASE: MMDrive AND MasterPool
	INSERT INTO #tempLibControllers
		SELECT LibraryId, COUNT(1)
		FROM MMLibraryController  WITH (READUNCOMMITTED)
		GROUP BY LibraryId
	INSERT INTO #tempMasterPools
		SELECT DISTINCT(MasterPoolId)
		FROM MMMasterPool MPL  WITH (READUNCOMMITTED)
			INNER JOIN #tempLibControllers LC ON LC.LibraryId = MPL.LibraryId
			INNER JOIN MMLibraryController MLC  WITH (READUNCOMMITTED) ON MLC.LibraryId = LC.LibraryId
			INNER JOIN MMLibrary ML  WITH (READUNCOMMITTED) ON MLC.LibraryId = ML.LibraryId
WHERE LC.NumberOfControllers = 1 AND MLC.ClientId = @clientId and ML.LibraryTypeId <> 3
	DELETE MD
	FROM MMDrive MD
		INNER JOIN #tempMasterPools MP ON MP.MasterPoolId = MD.MasterPoolId
	DELETE MPL
	FROM MMMasterPool MPL
		INNER JOIN #tempMasterPools MP ON MPL.MasterPoolId = MP.MasterPoolId
	-- CASE: Libraries
	IF EXISTS(
		SELECT 1
		FROM MMLibrary ML
			INNER JOIN #tempLibControllers LC ON LC.LibraryId = ML.LibraryId
			INNER JOIN MMLibraryController MLC  WITH (READUNCOMMITTED) ON MLC.LibraryId = LC.LibraryId
		WHERE LC.NumberOfControllers = 1 AND MLC.ClientId = @clientId
		)
	BEGIN
		DECLARE @libraryList nvarchar(max)
		SELECT @libraryList =  COALESCE(@libraryList + '<BR>',' ') + ML.AliasName
		FROM MMLibrary ML
			INNER JOIN #tempLibControllers LC ON LC.LibraryId = ML.LibraryId
			INNER JOIN MMLibraryController MLC  WITH (READUNCOMMITTED) ON MLC.LibraryId = LC.LibraryId
		WHERE LC.NumberOfControllers = 1 AND MLC.ClientId = @clientId
		IF @libraryList IS NOT NULL
		BEGIN
			EXEC EvGuiAuditSetParamData @opId, @clientName, 0
			EXEC EvGuiAuditSetParamData @opId, @libraryList, 0
SET @paramMsgId  = (1770 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
		INSERT INTO #tempMAAssociatedEntity
SELECT DISTINCT 2, ML.LibraryId, ''
			FROM MMLibrary ML
				INNER JOIN #tempLibControllers LC ON LC.LibraryId = ML.LibraryId
				INNER JOIN MMLibraryController MLC  WITH (READUNCOMMITTED) ON MLC.LibraryId = LC.LibraryId
WHERE LC.NumberOfControllers = 1 and ML.LibraryTypeId <> 3 AND MLC.ClientId=@clientId
		--set the status for non-magnetic libraries if this MA is the only controller
		UPDATE ML
		SET ML.LibraryLicenseType = 0,
ML.LibraryStatusReason = 46013
		FROM MMLibrary ML
			INNER JOIN #tempLibControllers LC ON LC.LibraryId = ML.LibraryId
			INNER JOIN MMLibraryController MLC  WITH (READUNCOMMITTED) ON MLC.LibraryId = LC.LibraryId
WHERE LC.NumberOfControllers = 1 and ML.LibraryTypeId <> 3 AND MLC.ClientId=@clientId
	END
	--Before deleting the library controller for a given MA
	--Identify the libraries with more than one controller and on which the to-be-deleted MA is active controller
	DECLARE @tblLibrariesWithMAActiveController table (LibraryId int)
	INSERT INTO @tblLibrariesWithMAActiveController
		SELECT DISTINCT LibraryId
		FROM MMLibraryController WITH (READUNCOMMITTED)
		WHERE LibraryControllerActive = 1
			AND ClientId=@clientId
			AND LibraryId IN (SELECT LibraryId FROM MMLibraryController  WITH (READUNCOMMITTED) GROUP BY LibraryId HAVING COUNT(*)>1)
	--Get the not active controllers for the libraries in @tblLibrariesWithMAActiveController
	DECLARE @tblNotActiveControllers table (LibraryControllerId int, LibraryId int, ClientId int)
	INSERT INTO @tblNotActiveControllers
		SELECT DISTINCT min(LC.LibraryControllerId), LC.LibraryId, min(LC.ClientId)
		FROM MMLibraryController LC WITH (READUNCOMMITTED)
			INNER JOIN @tblLibrariesWithMAActiveController AC ON LC.LibraryId=AC.LibraryId
		WHERE LC.LibraryControllerActive = 0
		GROUP BY LC.LibraryId
	UPDATE MMLibraryController
	SET LibraryControllerActive = 1
	FROM MMLibraryController LC
		INNER JOIN @tblNotActiveControllers NAC ON LC.LibraryControllerId=NAC.LibraryControllerId
	DELETE LHI
	FROM MMLibraryHostInfo LHI
		INNER JOIN MMLibraryController LC ON LC.LibraryControllerId = LHI.LibraryControllerId
	WHERE LC.ClientId = @clientId
	DELETE FROM MMLibraryController where clientId=@clientId
	--Unset library-server-MA property
	UPDATE MMHOST
SET Attribute = Attribute & (~4096)
	WHERE ClientId = @clientId
	COMMIT TRAN
END TRY
BEGIN CATCH
INSERT INTO #tempMAAssociatedEntity VALUES(0, ERROR_NUMBER(), ERROR_MESSAGE())
DELETE FROM #tempMAAssociatedEntity WHERE entityType <> 0
	ROLLBACK TRAN
END CATCH
SCRIPT_EXIT:
	IF object_id('tempdb.dbo.#tempDeviceController') IS NOT NULL DROP TABLE #tempDeviceController
	IF object_id('tempdb.dbo.#tempCredAssoc') IS NOT NULL DROP TABLE #tempCredAssoc
	IF object_id('tempdb.dbo.#tempLibControllers') IS NOT NULL DROP TABLE #tempLibControllers
	IF object_id('tempdb.dbo.#tempMasterPools') IS NOT NULL DROP TABLE #tempMasterPools
	IF object_id('tempdb.dbo.#tempMPForNextJobFull') IS NOT NULL DROP TABLE #tempMPForNextJobFull
	SELECT * FROM #tempMAAssociatedEntity
	IF object_id('tempdb.dbo.#tempMAAssociatedEntity') IS NOT NULL DROP TABLE #tempMAAssociatedEntity
GO

IF EXISTS (select * from GxQscripts where name = 'MMForceResetMAInformation')
	delete from GxQscripts where name = 'MMForceResetMAInformation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMForceResetMAInformation')
	delete from GXDBVersions where aliasname = 'MMForceResetMAInformation'
GO

insert into GXDBVersions values(2, 'MMForceResetMAInformation',  '00010001000200080000', 'MMForceResetMAInformation', '00010001000200080000')
GO

