

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMExecProactiveProcs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMExecProactiveProcs.sp,v $ $Id: MMExecProactiveProcs.sp,v 1.1.2.1 2017/10/02 19:06:56 jay Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMExecProactiveProcs <<<'

IF EXISTS (select * from sysobjects where name='MMExecProactiveProcs')
	drop procedure MMExecProactiveProcs
IF EXISTS (select * from GxQscripts where name='MMExecProactiveProcs')
	delete from GxQscripts where name = 'MMExecProactiveProcs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMExecProactiveProcs')
	delete from GXDBVersions where aliasname = 'MMExecProactiveProcs'
GO
print '... Creating Procedure: MMExecProactiveProcs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMExecProactiveProcs
AS
  DECLARE @o_errorCode INT				= 0
  DECLARE @o_errorMsg VARCHAR(2048)	= ''
SET NOCOUNT ON
BEGIN TRY
	declare @spName varchar (1024)
	set @spName = ''
	declare @spArgs varchar (max)
	set @spArgs = ''
	declare @procId integer
	set @procId = 0
	declare @errorString varchar (2048)
	set @errorString = ''
	declare @dbErrCode integer
	set @dbErrCode = 0
	declare @sqlToExec nvarchar(max)
	set @sqlToExec = ''
	DECLARE procsToRunCursor CURSOR LOCAL FORWARD_ONLY FOR
		select spname, spargs, ProcId
		from mmprocstorun with (readuncommitted)
	OPEN procsToRunCursor
	FETCH NEXT FROM procsToRunCursor INTO @spName, @spArgs, @procId
		while (@@FETCH_STATUS = 0)
		begin
			set @sqlToExec = 'exec ' + @spName + ' ' + @spArgs
			EXEC SQLAdminUtilExecQuery @sqlToExec,1
			select @dbErrCode = @@ERROR
			if (@dbErrCode <> 0)
			begin
				set @o_errorCode = @dbErrCode
				set @errorString = @errorString + ' ' + @spName + '[' + @spArgs + '], '
			end
			else
			begin
				update mmprocstorun
				set lastRunTime = [dbo].[GetUnixTime](GETUTCDATE())
				where ProcId = @procId
			end
			FETCH NEXT FROM procsToRunCursor INTO @spName, @spArgs, @procId
		end
	CLOSE procsToRunCursor
	DEALLOCATE procsToRunCursor
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errorCode	= ERROR_NUMBER()
    SET @o_errorMsg		= ERROR_MESSAGE()
END CATCH
PROC_EXIT:
SELECT 	@o_errorCode 	AS errorCode,
		(@o_errorMsg + @errorString)	AS errorString;
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMExecProactiveProcs')
	delete from GxQscripts where name = 'MMExecProactiveProcs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMExecProactiveProcs')
	delete from GXDBVersions where aliasname = 'MMExecProactiveProcs'
GO

insert into GXDBVersions values(2, 'MMExecProactiveProcs',  '00010001000200010000', 'MMExecProactiveProcs', '00010001000200010000')
GO

