

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMEnableRansomwareOnMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMEnableRansomwareOnMA.sp
-- 	+-----------------------------------------------------------------------+
--	|Stored Proc: " MMEnableRansomwareOnMA"
--	|Description: Enable Ransomeware option on MediaAgent
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMEnableRansomwareOnMA')
BEGIN
	print '>>> Drop Stored Procedure: MMEnableRansomwareOnMA <<<'
	drop procedure MMEnableRansomwareOnMA
END
IF EXISTS (select * from GxQscripts where name='MMEnableRansomwareOnMA')
	delete from GxQscripts where name = 'MMEnableRansomwareOnMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMEnableRansomwareOnMA')
	delete from GXDBVersions where aliasname = 'MMEnableRansomwareOnMA'
GO
print '... Creating Procedure: MMEnableRansomwareOnMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMEnableRansomwareOnMA
  @i_mediaAgentId integer,
  @i_enable integer = 1,
  @i_forceUpdate integer = 0
AS
SET NOCOUNT ON
  IF @i_forceUpdate=0
   BEGIN
	 --
	 -- Check if mediaagent has any magnetic library and it's first library
	 --
	 IF
	 (
		SELECT  COUNT(DISTINCT lib.libraryid)
		FROM	MMDrivepool md WITH(READUNCOMMITTED)
				INNER JOIN MMMasterPool mp WITH(READUNCOMMITTED) ON md.MasterPoolId = mp.MasterPoolId
				INNER JOIN MMLibrary lib WITH(READUNCOMMITTED) ON mp.LibraryId = lib.LibraryId
		WHERE 	md.ClientId = @i_mediaAgentId
				AND (CASE WHEN LEN(lib.PrivateData) > 3 THEN SUBSTRING(lib.PrivateData, 2, CHARINDEX('|', lib.PrivateData, 2) - 2) ELSE 0 END) = 3  /*CVMACMagLib::eShared*/
	 ) <> 1
	 BEGIN
		RETURN
	 END
    END
	DECLARE @nowTime INTEGER = DATEDIFF(second, '01/01/1970', GETUTCDATE())
	DECLARE @lt_MediaAgents TABLE (clientId INT)
	 -- Checking if its a windows Mediaagent
        INSERT INTO @lt_MediaAgents
         SELECT DISTINCT CN.id
    FROM
         (
SELECT @i_mediaAgentId ClientId
           UNION ALL
          SELECT  VC.PMClientId ClientId
               FROM    APP_VMToPMMap VC WITH(READUNCOMMITTED)
              WHERE   VC.VMClientId = @i_mediaAgentId
) AS C
          INNER JOIN App_Client CN WITH(READUNCOMMITTED) ON CN.id = C.ClientId
          INNER JOIN simInstalledPackages PKG WITH(READUNCOMMITTED) ON CN.id = PKG.ClientId
          INNER JOIN simOperatingSystem OS WITH(READUNCOMMITTED) ON CN.simOperatingSystemId = OS.id
WHERE   PKG.simPackageID IN (51, 1301)
          AND (CN.releaseId > 16 OR (CN.releaseId = 16 AND PKG.HighestSP > 6))
          AND OS.Type = 'Windows'
        IF @@ROWCOUNT > 0
	BEGIN
		BEGIN TRY
			-- Remove existing DLP properties as a safety step.
			DELETE CP
			FROM APP_ClientProp CP, @lt_MediaAgents C
			WHERE CP.componentNameId = C.clientId
			AND (CP.attrName = 'enableDLP' OR CP.attrName = 'dlpEnableAutomaticDecryption')
			INSERT 	INTO APP_Clientprop
			SELECT 	clientId,'enableDLP',2,@i_enable,@nowTime,0,0
			FROM	@lt_MediaAgents
			UNION ALL
			SELECT 	clientId,'dlpEnableAutomaticDecryption',2,@i_enable,@nowTime,0,0
			FROM	@lt_MediaAgents
			INSERT INTO APP_WorkQueueRequest (clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
			SELECT  clientId, -1,11,'',@nowTime,0,0,0
			FROM	@lt_MediaAgents
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			RAISERROR('Failed to enable ransomware', 16, 1)
		END CATCH
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMEnableRansomwareOnMA')
	delete from GxQscripts where name = 'MMEnableRansomwareOnMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMEnableRansomwareOnMA')
	delete from GXDBVersions where aliasname = 'MMEnableRansomwareOnMA'
GO

insert into GXDBVersions values(2, 'MMEnableRansomwareOnMA',  '00000000000000000000', 'MMEnableRansomwareOnMA', '00000000000000000000')
GO

