

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMEnableRansomewareOnMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMEnableRansomewareOnMA.sp
-- 	+-----------------------------------------------------------------------+
--	|Stored Proc: " MMEnableRansomewareOnMA"
--	|Description: Enable Ransomeware option on MediaAgent
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMEnableRansomewareOnMA')
BEGIN
	print '>>> Drop Stored Procedure: MMEnableRansomewareOnMA <<<'
	drop procedure MMEnableRansomewareOnMA
END
IF EXISTS (select * from GxQscripts where name='MMEnableRansomewareOnMA')
	delete from GxQscripts where name = 'MMEnableRansomewareOnMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMEnableRansomewareOnMA')
	delete from GXDBVersions where aliasname = 'MMEnableRansomewareOnMA'
GO
print '... Creating Procedure: MMEnableRansomewareOnMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMEnableRansomewareOnMA
  @i_mediaAgentId integer
AS
  DECLARE @nowTime INTEGER = DATEDIFF(second, '01/01/1970', GETUTCDATE())
  DECLARE @dlpPropertiesCount INTEGER = 0
        -- Checking if its a windows Mediaagent
        IF EXISTS (SELECT DISTINCT MH.ClientId FROM APP_Client INNER JOIN MMHOST MH on id=MH.ClientId
                   INNER JOIN SimInstalledPackages PKG ON PKG.ClientId = MH.ClientId
WHERE simOperatingSystemId in (2,3,
21, 94,
24, 34 ,
62, 65 ,
93, 200,
208, 209,
48, 46,
64,
67, 210,
211)
                   AND ISNULL(PKG.HighestSP, -1)>6
                   AND releaseId=16 AND MH.ClientId = @i_mediaAgentId)
	BEGIN
		SET @dlpPropertiesCount = (SELECT COUNT(*) FROM APP_ClientProp
		WHERE componentNameId = @i_mediaAgentId
		AND (attrName = 'enableDLP' OR attrName = 'dlpEnableAutomaticDecryption')
		AND attrVal='1' AND modified = 0)
		IF (@dlpPropertiesCount != 2) -- if DLP properties are not set
		BEGIN
		    BEGIN TRY
		    BEGIN TRAN
		-- Remove existing DLP properties as a safety step.
			DELETE
			FROM APP_ClientProp
			WHERE componentNameId = @i_mediaAgentId
			AND (attrName = 'enableDLP' OR attrName = 'dlpEnableAutomaticDecryption')
			INSERT INTO APP_Clientprop
			SELECT @i_mediaAgentId,'enableDLP',2,1,@nowTime,0,0
			INSERT INTO APP_Clientprop
			SELECT @i_mediaAgentId,'dlpEnableAutomaticDecryption',2,1,@nowTime,0,0
			INSERT INTO APP_WorkQueueRequest (clientId,remoteClient,workToken,workTokenParams,createTime,lastUpdateTime,retryCount,flag)
			SELECT DISTINCT @i_mediaAgentId, -1,11,'',@nowTime,0,0,0
		     COMMIT TRAN
        	     END TRY
        	     BEGIN CATCH
        		ROLLBACK TRAN
                     END CATCH
		END
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMEnableRansomewareOnMA')
	delete from GxQscripts where name = 'MMEnableRansomewareOnMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMEnableRansomewareOnMA')
	delete from GXDBVersions where aliasname = 'MMEnableRansomewareOnMA'
GO

insert into GXDBVersions values(2, 'MMEnableRansomewareOnMA',  '00000000000000000000', 'MMEnableRansomewareOnMA', '00000000000000000000')
GO

