

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMDoTape2TapeCopyValidation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMDoTape2TapeCopyValidation.sp,v $ $Id: MMDoTape2TapeCopyValidation.sp,v 1.1.2.8 2019/11/20 07:06:06 lviswambharan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMDoTape2TapeCopyValidation"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMDoTape2TapeCopyValidation')
BEGIN
	print '>>> Drop Stored Procedure: MMDoTape2TapeCopyValidation <<<'
	drop procedure MMDoTape2TapeCopyValidation
END
IF EXISTS (select * from GxQscripts where name='MMDoTape2TapeCopyValidation')
	delete from GxQscripts where name = 'MMDoTape2TapeCopyValidation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDoTape2TapeCopyValidation')
	delete from GXDBVersions where aliasname = 'MMDoTape2TapeCopyValidation'
GO
print '... Creating Procedure: MMDoTape2TapeCopyValidation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMDoTape2TapeCopyValidation
  @i_sourceMediaId integer,
  @i_destinationMediaId integer,
  @i_srcLibraryId integer,
  @i_destLibraryId integer,
  @i_mediaAgentId integer,
  @i_jobId integer
AS
  DECLARE @o_errorCode integer
  DECLARE @o_shouldFail integer
--Validation List
--1)The source media is assigned/active.
--2)The destination media is spare.
--3)The assigned & spare media are not reserved at the moment.
--4)The spare media is not over write protected.
--5)Library & active controller are online.
--6)If the library is not standalone, it should have two available drives.
--7)The destination media should have more capacity than size of data on source media.
declare @isAged bit = 0
declare @isInMediaGroup bit = 0
declare @srcLibDriveCount integer = 0
declare @destLibDriveCount integer = 0
declare @isSrcLibraryOnline bit = 0
declare @isDestLibraryOnline bit = 0
declare @sourceMediaTypeId integer = 0
declare @destinationMediaTypeId integer = 0
set @o_errorCode = 0
set @o_shouldFail = 0
IF(@i_sourceMediaId <= 0 OR @i_destinationMediaId <= 0 OR @i_srcLibraryId <= 0 OR @i_destLibraryId <= 0 OR @i_mediaAgentId <= 0)
BEGIN
set @o_errorCode = 44133
	goto proc_exit
END
select @isAged = IsAged, @isInMediaGroup = IsInMediaGroup, @sourceMediaTypeId = MediaTypeId from MMMedia (nolock) where MediaId = @i_sourceMediaId
if(@isAged = 1)
begin
set @o_errorCode = 66301 -- Media is aged
	goto proc_exit
end
if(@isInMediaGroup = 0)
begin
set @o_errorCode = 66302 -- Media do not have valid data.
	goto proc_exit
end
SELECT @isInMediaGroup = IsInMediaGroup, @destinationMediaTypeId = MediaTypeId FROM MMMedia (NOLOCK) WHERE MediaId = @i_destinationMediaId
IF(1 = @isInMediaGroup)
BEGIN
set @o_errorCode = 66303 -- Destination Media is not spare.
	goto proc_exit
END
IF EXISTS (select * from MMResource (nolock) where MediaId = @i_sourceMediaId)
begin
set @o_errorCode = 66318 -- source media is currently reserved.
	goto proc_exit
end
IF EXISTS (select * from MMResource (nolock) where MediaId = @i_destinationMediaId)
begin
set @o_errorCode = 66319 -- destination media is currently reserved.
	goto proc_exit
end
declare @lcReleaseId int = 0
select @lcReleaseId = C.releaseId from APP_Client (nolock) C
where C.id = @i_mediaAgentId
if(@lcReleaseId < 16)
begin
set @o_errorCode = 66311 -- Media agent must be v11 atleast.
	goto proc_exit
end
select @isSrcLibraryOnline = (L.LibrarySoftState &L.LibraryEnabled &  LC.LibraryControllerEnabled & LC.LibraryControllerSoftState & H.MmHostSoftState & H.MmHostEnabled)
	from MMLibrary (nolock) L, MMLibraryController (nolock) LC , MMHost (nolock) H
	where L.LibraryId = LC.LibraryId and LC.LibraryControllerActive = 1 and LC.ClientId = H.ClientId and L.LibraryId = @i_srcLibraryId
select @isDestLibraryOnline = (L.LibrarySoftState &L.LibraryEnabled &  LC.LibraryControllerEnabled & LC.LibraryControllerSoftState & H.MmHostSoftState & H.MmHostEnabled)
	from MMLibrary (nolock) L, MMLibraryController (nolock) LC , MMHost (nolock) H
	where L.LibraryId = LC.LibraryId and LC.LibraryControllerActive = 1 and LC.ClientId = H.ClientId and L.LibraryId = @i_destLibraryId
if(@isSrcLibraryOnline = 0)
begin
set @o_errorCode = 66316 -- source library not online
	goto proc_exit
end
if(@isdestLibraryOnline = 0)
begin
set @o_errorCode = 66317 -- dest library not online
	goto proc_exit
end
select @srcLibDriveCount=COUNT(DC.DriveId) from MMDriveController DC,MMDrivePool DP, MMMasterPool MP
	where MP.LibraryId = @i_srcLibraryId and MP.MasterPoolId = DP.MasterPoolId and DP.ClientId = @i_mediaAgentId and DP.DrivePoolId = DC.DrivePoolId
select @destLibDriveCount=COUNT(DC.DriveId) from MMDriveController DC,MMDrivePool DP, MMMasterPool MP
	where MP.LibraryId = @i_destLibraryId and MP.MasterPoolId = DP.MasterPoolId and DP.ClientId = @i_mediaAgentId and DP.DrivePoolId = DC.DrivePoolId
if(@i_srcLibraryId = @i_destLibraryId AND @srcLibDriveCount < 2)--Copying to a tape in same library requires at least two drives
begin
set @o_errorCode = 66306 -- not enough drives.
	goto proc_exit
end
else if(@srcLibDriveCount < 1)
begin
set @o_errorCode = 66324 -- not enough drives in source drive pool.
	goto proc_exit
end
else if(@destLibDriveCount < 1)
begin
set @o_errorCode = 66325 -- not enough drives in destination drive pool.
	goto proc_exit
end
if(@sourceMediaTypeId <> @destinationMediaTypeId)
begin
	declare @sizeOnDiskMB bigint = 0
	select 	@sizeOnDiskMB = sum(AC.physicalSize)/1024.0/1024.0
	from 	MMVolume V
		inner join archChunk AC on V.VolumeId = AC.volumeId
	where 	V.MediaId = @i_sourceMediaId
	declare @maxCapacityMB int = 0
	select @maxCapacityMB = MaxUncompressCapacityMB from MMMediaType where MediaTypeId in (select M.MediaTypeId from MMMedia M where MediaId = @i_destinationMediaId)
	if(@maxCapacityMB < @sizeOnDiskMB)
	begin
set @o_errorCode = 66312 -- less space on destination
		goto proc_exit
	end
end
if exists(
select * from MMSpareGroup SG (nolock), MMMedia M (nolock)
where sg.SpareGroupId = M.SpareGroupId
and SG.SpareGroupType = 64 and M.MediaId = @i_destinationMediaId
)
begin
set @o_errorCode = 66313 -- spare media is write protected.
	goto proc_exit
end
if exists(select * from MMTapetoTapeCopyInfo where (SourceMediaId = @i_sourceMediaId OR TargetMediaId = @i_sourceMediaId) AND CopyJobStatus = 1 AND JobId <> @i_jobId ) --T2T_COPY_IN_PROGRESS=1
begin
set @o_errorCode = 66320-- Another tape copy job is running on src media
	set @o_shouldFail = 1
	goto proc_exit
end
if exists(select * from MMTapetoTapeCopyInfo where (SourceMediaId = @i_destinationMediaId OR TargetMediaId = @i_destinationMediaId) AND CopyJobStatus = 1 AND JobId <> @i_jobId) --T2T_COPY_IN_PROGRESS=1
begin
set @o_errorCode = 66321--Another tape copy job is running on dest media
	set @o_shouldFail = 1
	goto proc_exit
end
proc_exit:
	select @o_errorCode, @o_shouldFail

IF EXISTS (select * from GxQscripts where name = 'MMDoTape2TapeCopyValidation')
	delete from GxQscripts where name = 'MMDoTape2TapeCopyValidation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDoTape2TapeCopyValidation')
	delete from GXDBVersions where aliasname = 'MMDoTape2TapeCopyValidation'
GO

insert into GXDBVersions values(2, 'MMDoTape2TapeCopyValidation',  '00010001000200080000', 'MMDoTape2TapeCopyValidation', '00010001000200080000')
GO

