

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMDeleteSIDBStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMDeleteSIDBStore.sp,v $ $Id: MMDeleteSIDBStore.sp,v 1.4.276.2 2018/03/20 19:45:45 jiechen Exp $";
--
--  +========================================================================+
--  |      SP:  MMDeleteSIDBStore
--  |
--  | Description:  Delete the SIDB Store for giving copy
--  |
--  |       Input:  copy id
--  |
--  |      Output:  always returns the SIDB Store id, otherwise 0
--  |
--  |      Notes:	None at this time
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   	         cliu
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMDeleteSIDBStore <<<'

IF EXISTS (select * from sysobjects where name='MMDeleteSIDBStore')
	drop procedure MMDeleteSIDBStore
IF EXISTS (select * from GxQscripts where name='MMDeleteSIDBStore')
	delete from GxQscripts where name = 'MMDeleteSIDBStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDeleteSIDBStore')
	delete from GXDBVersions where aliasname = 'MMDeleteSIDBStore'
GO
print '... Creating Procedure: MMDeleteSIDBStore'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMDeleteSIDBStore
  @i_copyId integer
AS
  DECLARE @o_SIDBStoreId integer
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- .. :PARAM input lines
	SET NOCOUNT ON
	-- check whether copy exists
	DECLARE @curIdxCacheId	integer
	DECLARE @curIdxPoolId	integer
	SET @o_SIDBStoreId	= ISNULL((SELECT SIDBStoreId FROM archGroupCopy WHERE id = @i_copyId), 0)
	SET @curIdxCacheId	= (SELECT IdxCacheId FROM IdxSIDBStore WHERE SIDBStoreId = @o_SIDBStoreId)
	SET @curIdxPoolId	= (SELECT IdxPoolId FROM IdxCache WHERE IdxCacheId = @curIdxCacheId)
	-- delete the SIDB Store
	DELETE	IdxSIDBStore
	FROM	IdxSIDBStore A
			INNER JOIN (SELECT SIDBStoreId, commCellId FROM archCopySIDBStore WHERE CopyId = @i_copyId) B
				ON A.SIDBStoreId = B.SIDBStoreId AND A.commCellId = B.commCellId
			LEFT OUTER JOIN archCopySIDBStore C
				ON A.SIDBStoreId = B.SIDBStoreId AND A.commCellId = B.commCellId AND C.CopyId <> @i_copyId
	WHERE	C.CopyId Is Null
	DELETE archCopySIDBStore WHERE CopyId = @i_copyId
	-- delete IdxAccessPath
	DELETE IdxAccessPath WHERE IdxCacheId = @curIdxCacheId
	-- delete IdxCache
	DELETE IdxCache WHERE IdxCacheId = @curIdxCacheId
	-- delete IdxPool
	DELETE IdxPool WHERE IdxPoolId = @curIdxPoolId
	IF @o_SIDBStoreId != 0
	BEGIN
		UPDATE	ArchGroupCopy
SET		Flags = dedupeFlags & (~262144), SIDBStoreId = 0
		WHERE	Id = @i_copyId
	END
	SELECT @o_SIDBStoreId
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMDeleteSIDBStore')
	delete from GxQscripts where name = 'MMDeleteSIDBStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDeleteSIDBStore')
	delete from GXDBVersions where aliasname = 'MMDeleteSIDBStore'
GO

insert into GXDBVersions values(2, 'MMDeleteSIDBStore',  '00010004027600020000', 'MMDeleteSIDBStore', '00010004027600020000')
GO

