

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMDeletePrunedFLAAFileRows.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2013 CommVault Systems, Inc.
--                      All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMDeletePrunedFLAAFileRows.sp,v $ $Id: MMDeletePrunedFLAAFileRows.sp,v 1.3.88.3 2018/04/13 19:03:39 pankajkumar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMDeletePrunedFLAAFileRows <<<'

IF EXISTS (select * from sysobjects where name='MMDeletePrunedFLAAFileRows')
	drop procedure MMDeletePrunedFLAAFileRows
IF EXISTS (select * from GxQscripts where name='MMDeletePrunedFLAAFileRows')
	delete from GxQscripts where name = 'MMDeletePrunedFLAAFileRows'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDeletePrunedFLAAFileRows')
	delete from GXDBVersions where aliasname = 'MMDeletePrunedFLAAFileRows'
GO
print '... Creating Procedure: MMDeletePrunedFLAAFileRows'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMDeletePrunedFLAAFileRows
  @reserveParam integer
AS
  DECLARE @dbErrorCode integer
  DECLARE @mmErrorCode integer
  DECLARE @errorString char(255)
SET NOCOUNT ON
select @dbErrorCode = 0, @mmErrorCode = 0, @errorString = ''
DELETE
	archFLAIndexingAged
FROM
	MMTmpAFilesToPruneFromFlaAgedTbl TCIA
WHERE
	archFileId = TCIA.AFileId
	AND archFLAIndexingAged.CommCellId = TCIA.commCellId
	AND archFLAIndexingAged.AppId = TCIA.appId
	AND archFLAIndexingAged.cloudId = TCIA.CloudId
set @dbErrorCode = @@ERROR
if(@dbErrorCode <> 0)
begin
set @mmErrorCode = 287
	set @errorString = 'Failed to delete the archFLAIndexingAged table.'
	goto error_exit
end
delete archFLAIndexingInfo
from
	archFLAIndexingInfo i
inner join
	MMTmpAFilesToPruneFromFlaAgedTbl t
on
	i.archFileId = t.AFileId
	and i.commCellId = t.CommCellId
	and i.cloudId = t.CloudId
set @dbErrorCode = @@ERROR
if(@dbErrorCode <> 0)
begin
	set @mmErrorCode = 287
	set @errorString = 'Failed to delete the archFLAIndexingInfo table.'
	goto error_exit
end
--since VSA analyzed data is already pruned, mark vm client as not analyzed
IF EXISTS (SELECT TOP 1 1 FROM app_clientprop (nolock) WHERE attrName = 'AnalysisComplete')
	DELETE CP
	FROM APP_ClientProp CP
	WHERE  attrName IN ( 'AnalysisComplete', 'LastAnalysisTime', 'AnalyticsCloudId')
		AND CP.componentNameId NOT IN (SELECT DISTINCT pseudoClientId FROM archFLAIndexingInfo)
error_exit:
	delete from MMTmpAFilesToPruneFromFlaAgedTbl
	select @dbErrorCode, @mmErrorCode, @errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMDeletePrunedFLAAFileRows')
	delete from GxQscripts where name = 'MMDeletePrunedFLAAFileRows'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDeletePrunedFLAAFileRows')
	delete from GXDBVersions where aliasname = 'MMDeletePrunedFLAAFileRows'
GO

insert into GXDBVersions values(2, 'MMDeletePrunedFLAAFileRows',  '00010003008800030000', 'MMDeletePrunedFLAAFileRows', '00010003008800030000')
GO

