

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMDelSpareAndAgedMediaForLib.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMDelSpareAndAgedMediaForLib.sp,v $ $Id: MMDelSpareAndAgedMediaForLib.sp,v 1.12.34.6 2020/04/02 18:59:52 lviswambharan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMDelSpareAndAgedMediaForLib')
BEGIN
	print '>>> Drop Stored Procedure: MMDelSpareAndAgedMediaForLib <<<'
	drop procedure MMDelSpareAndAgedMediaForLib
END
IF EXISTS (select * from GxQscripts where name='MMDelSpareAndAgedMediaForLib')
	delete from GxQscripts where name = 'MMDelSpareAndAgedMediaForLib'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDelSpareAndAgedMediaForLib')
	delete from GXDBVersions where aliasname = 'MMDelSpareAndAgedMediaForLib'
GO
print '... Creating Procedure: MMDelSpareAndAgedMediaForLib'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMDelSpareAndAgedMediaForLib
  @i_libraryId INTEGER,
  @i_reserveParam1 INTEGER,
  @i_reserveParam2 INTEGER,
  @i_reserveStrParam VARCHAR(1024)
AS
  DECLARE @o_ErrorNumber INTEGER
  DECLARE @o_ErrorMessage VARCHAR(1024)
  DECLARE @o_ReserveParam1 INTEGER
  DECLARE @o_ReserveParam2 INTEGER
  DECLARE @o_ReserveStrParam VARCHAR(1024)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- Local Variables
DECLARE	@tblMediaToDel					TABLE (MediaId INT)
DECLARE	@tblVolumeIds					TABLE (VolumeId INT)
DECLARE	@tblMediaSideIds				TABLE (MediaSideId INT)
DECLARE @tblOutVals						TABLE (JobId INT, AppId INT, AppTypeId INT, BackupsetId INT, ForceNextBkpFull INT)
DECLARE @MM_NEWLY_OCCUPIED				INTEGER = 0
-- Variables for ArchDeleteBackupByLibrary
DECLARE @i_seconds						INTEGER
DECLARE @i_cleanDB						INTEGER
DECLARE @AGEDBY							INTEGER
DECLARE @cleanDB						BIT
DECLARE @retVal							INTEGER
DECLARE @l_copyId						INTEGER
DECLARE @l_notAged						INTEGER
DECLARE @isMagnetic						BIT
DECLARE @l_now							INTEGER
DECLARE @magneticBytes					BIGINT
DECLARE @retainScratchMedia				TINYINT
DECLARE @errVal 						INTEGER = 0
DECLARE @rowCnt 						INTEGER = 0
DECLARE @tranStarted					BIT = 0
IF @i_seconds > 0--unintialized variable :/
	SET @AGEDBY = 8192
ELSE
	SET @AGEDBY = 4096
SET @cleanDB = 1
SET @l_copyId = 0
SET @l_notAged = 0
SET @l_now = dbo.GetUnixTime(GetUTCDate())
SET @retVal = 0
SET @retainScratchMedia = 0
DECLARE @maxRowsToPruneInBatch  INTEGER = 2000
SELECT 	@maxRowsToPruneInBatch = ISNULL(value, 2000)
FROM 	MMConfigs
WHERE 	name = 'DA_CONFIG_MAX_JOB_HISTORIES_TO_PRUNE_IN_BATCH'
DECLARE @tblAC	TABLE (
	id bigint, commCellId INT, createTime INT, flags INT,
	PRIMARY KEY (id, commCellId))
DECLARE @tblBCDIndexAF TABLE(
		jobId int, commCellId int, fileType int, copyId int, flags int
		primary key (jobId, commCellId, fileType, copyId) )
DECLARE @tblJobsWithBCDIndex TABLE(
		jobId int, commCellId int, fileType int, copyId int, flags int
		primary key (jobId, commCellId, fileType, copyId) )
-- Check whether the library is present for the given libraryId
IF NOT EXISTS (SELECT LibraryId FROM MMLibrary WITH (NOLOCK) WHERE LibraryId = @i_libraryId)
BEGIN
	SELECT @o_ErrorNumber = 1, @o_ErrorMessage = 'Invalid LibraryId. LibraryId [' + CONVERT(VARCHAR(10), @i_libraryId) + ']'
	GOTO RETURN_EXIT;
END
-- Reset LastWriteLibraryId on all Media in this library
UPDATE	MMMedia
SET		LastWriteLibraryId = 0
WHERE	LastWriteLibraryId = @i_libraryId
SELECT @retainScratchMedia = value FROM MMConfigs WITH (NOLOCK) WHERE name = 'MMS2_CONFIG_DO_NOT_DELETE_SCRATCH_MEDIA_DURING_LIBRARY_DECONFIG'
IF (@retainScratchMedia = 1)
BEGIN
	SELECT @o_ErrorNumber = 0, @o_ErrorMessage = ''
	GOTO RETURN_EXIT;
END
WHILE (1 = 1)
BEGIN
	INSERT	INTO @tblMediaToDel
	SELECT	TOP(@maxRowsToPruneInBatch) MediaId
	FROM	MMMedia M WITH (NOLOCK), MMSpareGroup SG WITH (NOLOCK)
	WHERE	M.LibraryId = @i_libraryId
	AND		M.IsInMediaGroup = 0
	AND		SG.LibraryId = @i_libraryId
	AND		SG.SpareGroupId = M.SpareGroupId
	AND		SG.SpareGroupType & 64 <> 64
	SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
	IF @errVal <> 0
	BEGIN
		SELECT @o_ErrorNumber = 12, @o_ErrorMessage = 'Failed to fetch media entries to delete. DBError['+CAST(@errVal AS VARCHAR(5))+']'
		GOTO RETURN_EXIT;
	END
	IF @rowCnt = 0
		BREAK
	BEGIN TRAN MEDIA_TRAN --SP is not already part of a transaction, in case we end up having to do this as part of an outside tran, check for trancount and begin new only if count is 0
	SET @tranStarted  = 1
	IF @isMagnetic IS NULL
	BEGIN
		IF EXISTS(SELECT 1 FROM MMMedia(NOLOCK) M INNER JOIN @tblMediaToDel TM ON M.MediaId = TM.MediaId WHERE MediaTypeId = 10001)
			SET @isMagnetic = 1
		ELSE
			SET @isMagnetic = 0
	END
	--
	-- From ArchDeleteBackupByLibrary
	--
	BEGIN TRY
		INSERT	INTO @tblVolumeIds
		SELECT	VolumeId
		FROM 	MMVolume WITH (NOLOCK)
		WHERE	MediaId IN (SELECT MediaId FROM @tblMediaToDel)
		INSERT	INTO @tblAC
		SELECT	A.id, A.commCellId, A.createTime, A.flags
		FROM	archChunk A WITH (NOLOCK), @tblVolumeIds B
		WHERE	A.volumeId = B.volumeId
		IF NOT EXISTS (SELECT * FROM @tblAC)
			GOTO CX_EXIT
		ELSE
		IF @i_seconds > 0
		BEGIN
			-- for overwriting a media if all chunks are older than @i_seconds
			IF EXISTS (SELECT * FROM @tblAC WHERE createTime > @i_seconds AND (flags & 256) = 0)
			BEGIN
				SET @l_notAged = 1
				GOTO CX_EXIT
			END
		END
		-- No tombstoning for magnetic media, always deleting aged data.
		-- Used only for deleting content of a mount path!
		IF @isMagnetic = 1
		   SET @cleanDB = 1
		--********************** Create table variables **********************************/
		DECLARE @tblJobCopy TABLE (
			jobId INT, commCellId INT, fileType INT, appId INT,
			archGroupId INT, archCopyId INT, sourceCopyId INT,
			flags INT, isValidAF INT,
			PRIMARY KEY (jobId, commCellId, fileType, archCopyId))
		DECLARE @tblJob TABLE (
			jobId INT, commCellId INT, appId INT, deleted INT, forceNextBkpFull INT)
		IF object_id('tempdb.dbo.#ToBeAgedAFC') IS NOT NULL DROP TABLE #ToBeAgedAFC
		CREATE TABLE #ToBeAgedAFC (
			archFileId INT, commCellId INT, archCopyId INT,
			PRIMARY KEY (archFileId, commCellId, archCopyId))
		--********************** Populate table variables ********************************/
		INSERT	INTO #ToBeAgedAFC
		SELECT	A.archFileId, A.commCellId, A.archCopyId
		FROM	archChunkMapping A WITH (NOLOCK), @tblAC B
		WHERE	A.archChunkId = B.id AND A.chunkCommCellId = B.commCellId
		GROUP BY A.archFileId, A.commCellId, A.archCopyId
		INSERT	INTO @tblJobCopy
		SELECT	A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, B.archCopyId, 0, 0, MAX(A.isValid)
		FROM	archFile A WITH (NOLOCK), #ToBeAgedAFC B
		WHERE	A.id = B.archFileId AND A.commCellId = B.commCellId
		GROUP BY A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, B.archCopyId
		-- Exit if this media contains valid data of a running/active job
		IF EXISTS (
			SELECT	*
			FROM	JMJobInfo A WITH (NOLOCK), @tblJobCopy B
			WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
				AND B.isValidAF <> -1
		)
		BEGIN
			SET @l_notAged = 2
			GOTO CX_EXIT
		END
		-- Exit if this media contains jobs of SILO AppId
		IF EXISTS (
			SELECT	T.*
			FROM	@tblJobCopy T, JMJobDataStats JDS WITH (NOLOCK)
			WHERE	T.jobId = JDS.jobId
			AND 	T.commCellId = JDS.commCellId
			AND		T.archGroupId = JDS.archGrpId
			AND		T.archCopyId = JDS.archGrpCopyId
			AND		JDS.appId IN (SELECT DISTINCT siloAppId FROM archGroupCopy WITH (NOLOCK) WHERE siloAppId > 0)
			AND		JDS.status <> 1000
		)
		BEGIN
			SET @l_notAged = 3
			GOTO CX_EXIT
		END
		TRUNCATE TABLE #ToBeAgedAFC
		INSERT	INTO #ToBeAgedAFC
		SELECT	A.id, A.commCellId, B.archCopyId
		FROM	archFile A WITH (NOLOCK), @tblJobCopy B
		WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId AND A.archGroupId = B.archGroupId
			-- If a valid data or index archive file is aged, the entire job is aged
			-- except for log and replaced index archive files.
			AND (B.fileType NOT IN (4, 34) OR A.fileType = B.fileType)
			-- If the media has only isValidAF=-1 archive file of a job, don't touch other archive files of this job.
			AND (B.isValidAF <> -1 OR A.isValid = -1)
		GROUP BY A.id, A.commCellId, B.archCopyId
		DELETE	@tblJobCopy WHERE isValidAF = -1
		-- Regular Index Archive Files after movement to media
		INSERT INTO @tblBCDIndexAF
		SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, 0
		FROM 		JMJobDataStats JDS WITH (NOLOCK), @tblJobCopy b, archFile AF WITH (NOLOCK)
		WHERE		JDS.jobId = b.jobId
		AND			JDS.commCellId = b.commCellId
		AND			JDS.archGrpCopyId = b.archCopyId
		AND			JDS.jobId = AF.jobId
		AND			JDS.commCellId = AF.commCellId
		AND			JDS.dataType = AF.fileType
		AND 		JDS.dataType IN (2)
		AND			(AF.flags & 4) > 0
		AND			b.fileType IN (1, 4, 2)
		INSERT INTO @tblJobsWithBCDIndex
		SELECT 	DISTINCT JDS.jobId, JDS.commCellId, JDS.dataType, JDS.archGrpCopyId, JDS.disabled & 256
		FROM 		JMJobDataStats JDS WITH (NOLOCK), @tblBCDIndexAF TT
		WHERE		JDS.jobId = TT.jobId
		AND			JDS.commCellId = TT.commCellId
		AND 		JDS.dataType IN (1, 4)
		AND			JDS.archGrpCopyId = TT.copyId
		UPDATE  @tblJobsWithBCDIndex
		SET 		flags = 256
		FROM 		@tblJobsWithBCDIndex TT, @tblJobCopy b
		WHERE		TT.jobId = b.jobId
		AND			TT.commCellId = b.commCellId
		AND 		((TT.fileType = b.fileType) OR b.fileType IN (2))
		AND			TT.copyId = b.archCopyId
		UPDATE  @tblBCDIndexAF
		SET 		flags = ISNULL(b.flags, 256)
		FROM 		@tblBCDIndexAF TT LEFT OUTER JOIN (SELECT jobId, commCellId, copyId, MIN(flags & 256) AS flags
																FROM @tblJobsWithBCDIndex
																GROUP BY jobId, commCellId, copyId) b
		ON			TT.jobId = b.jobId
		AND			TT.commCellId = b.commCellId
		AND			TT.copyId = b.copyId
		--Do not prune BCD/Regular Index Archive File created after Snap movement to media if Data or Log is NOT AGED
		DELETE #ToBeAgedAFC
		FROM #ToBeAgedAFC T, @tblBCDIndexAF TT, archFile A WITH (NOLOCK)
		WHERE	A.jobId = TT.jobId
		AND 	A.commCellId = TT.commCellId
		AND		A.fileType = TT.fileType
		AND		TT.flags & 256 = 0
		AND		T.archCopyId = TT.copyId
		AND		T.archFileId = A.id
		AND		T.commCellId = A.commCellId
		--Prune BCD/Regular Index Archive File created after Snap movement to media if Data and Log are AGED
		INSERT	INTO #ToBeAgedAFC
		SELECT	A.id, A.commCellId, TT.copyId
		FROM	archFile A WITH (NOLOCK), archFileCopy B WITH (NOLOCK), @tblBCDIndexAF TT
		WHERE	A.jobId = TT.jobId
		AND 	A.commCellId = TT.commCellId
		AND		A.fileType = TT.fileType
		AND		TT.flags & 256 = 256
		AND 	A.id = B.archFileId
		AND		A.commCellId = B.commCellId
		AND		B.archCopyId = TT.copyId
		AND		B.flags & 256 = 0
		AND		NOT EXISTS (SELECT * FROM #ToBeAgedAFC as T
								WHERE	T.archFileId = A.id
								AND		T.commCellId = A.commCellId
								AND		T.archCopyId = TT.copyId)
		--Get all jobs that will be AGED
		INSERT	INTO @tblJobCopy
		SELECT	A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, C.archCopyId, 0, 0, MAX(A.isValid)
		FROM	archFile A WITH (NOLOCK), archFileCopy B WITH (NOLOCK), #ToBeAgedAFC C
		WHERE	A.id = B.archFileId
		AND 	A.commCellId = B.commCellId
		AND		A.id = C.archFileId
		AND 	A.commCellId = C.commCellId
		AND		B.archCopyId = C.archCopyId
		AND		NOT EXISTS (SELECT * FROM @tblJobCopy as T
								WHERE T.jobId = A.jobId
								AND 	T.commCellId = A.commCellId
								AND		T.fileType = A.fileType
								AND		T.archCopyId = C.archCopyId)
		GROUP BY A.jobId, A.commCellId, A.fileType, A.appId, A.archGroupId, C.archCopyId
		INSERT	INTO @tblJob
		SELECT	DISTINCT jobId, commCellId, appId, 1, 0
		FROM	@tblJobCopy
		IF @cleanDB = 0--why is this case needed, this variable is never set to 0
		BEGIN
			EXEC @retVal = archFileSetAgedViaTable 4096, @l_now
			IF @retVal <> 0 GOTO CX_EXIT
			-- Tombstone chunks which have no archive file.
			UPDATE	archChunk WITH(PAGLOCK) SET flags = (a.flags | 256), modifiedTime = @l_now, agedBy = @AGEDBY
			FROM	archChunk a, @tblAC b
			WHERE	a.id = b.id AND a.commCellId = b.commCellId AND (a.flags & 256) = 0
			UPDATE	JMJobDataStats WITH(PAGLOCK)
			SET		disabled = (a.disabled | 256), agedTime = @l_now, modifiedTime = @l_now, agedBy = @AGEDBY
			FROM	JMJobDataStats a, @tblJobCopy b
			WHERE	a.jobId = b.jobId AND a.commCellId = b.commCellId
				AND a.archGrpCopyId = b.archCopyId
				AND a.dataType = b.fileType
				AND a.disabled & 256 = 0
		END
		ELSE
		BEGIN
			EXEC @retVal = archFileDeleteViaTable 0, @magneticBytes OUTPUT
			IF @retVal <> 0 GOTO CX_EXIT
			-- Delete chunks which have no archive file.
			DELETE	archChunk WITH(PAGLOCK)
			FROM	archChunk a, @tblAC b
			WHERE	a.id = b.id AND a.commCellId = b.commCellId
			UPDATE	JMJobDataStats WITH(PAGLOCK)
			SET		status = 1000, disabled = (a.disabled | 256), agedBy = @AGEDBY,
					agedTime = @l_now, mediaDeletedTime = @l_now, modifiedTime = @l_now
			FROM	JMJobDataStats a, @tblJobCopy b
			WHERE	a.jobId = b.jobId AND a.commCellId = b.commCellId
				AND a.archGrpCopyId = b.archCopyId
				AND a.dataType = b.fileType
				AND a.status <> 1000
			-- Set dataStatus = 2 when a job has been deleted from media from all copies
			UPDATE	@tblJob
			SET		deleted = 0
			FROM	JMJobDataStats A WITH (NOLOCK), @tblJob B
			WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
				AND A.status NOT IN (101, 1000)
			UPDATE	JMBkpStats WITH (PAGLOCK)
			SET		dataStatus = 2, agedTime = (case when J.agedTime = 0 then @l_now else J.agedTime end),
					mediaDeletedTime = @l_now, modifiedTime = @l_now
			FROM	JMBkpStats J, @tblJob T
			WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
				AND J.dataStatus <> 2 AND T.deleted = 1
			UPDATE	JMAdminJobStatsTable WITH (PAGLOCK)
			SET		dataStatus = 2
			FROM	JMAdminJobStatsTable J, @tblJob T
			WHERE	J.JobId = T.jobId AND J.CommCellID = T.commCellId
				AND J.dataStatus <> 2 AND T.deleted = 1
		END
		SELECT TOP 1 @l_copyId = archCopyId FROM @tblJobCopy
		IF @i_seconds > 0
		BEGIN
			-- for overwriting a media
			-- Disable not fully copied jobs on destination copies.
			IF object_id('tempdb.dbo.#ToBeDisabledJob') IS NOT NULL DROP TABLE #ToBeDisabledJob
			CREATE TABLE #ToBeDisabledJob (
				jobId INT, archGrpId INT, archGrpCopyId INT, dataType INT, commCellId INT,
				PRIMARY KEY (jobId, archGrpCopyId, dataType, commCellId))
			INSERT	INTO #ToBeDisabledJob
			SELECT	jobId, archGroupId, archCopyId, fileType, commCellId
			FROM	@tblJobCopy
			EXEC archDisallowMultipleJobForCopy @l_now
			DROP TABLE #ToBeDisabledJob
		END
		-- Set copy aging rule flags dirty bit to AM_AGING_FLAGS_EXT_DIRTY
		-- This is to indicate the need to calculate retentionFlags in JMJobDataStats table
		UPDATE	ArchAgingRule WITH(PAGLOCK) SET flags = flags | 2
		WHERE	copyId = @l_copyId AND flags & 2 = 0
		IF @@ERROR <> 0 GOTO CX_EXIT
		-- For "Delete Contents"
		IF @i_cleanDB = 0 --this variable is not initialized
		BEGIN
			-- If any valid data which belong to the last full cycle are pruned from primary copy because of
			-- "Delete Contents", the next backup should be a full backup.
			IF EXISTS (SELECT * FROM archGroup WHERE defaultCopy = @l_copyId)
			BEGIN
				UPDATE	@tblJob SET forceNextBkpFull = 1
				FROM	@tblJob a LEFT JOIN
						(SELECT	DISTINCT x.appId
						FROM	(SELECT	appId, MAX(jobId) AS jobId FROM @tblJob GROUP BY appId) x,
								JMBkpStats y WITH (NOLOCK)
						WHERE	y.appId = x.appId AND y.jobId > x.jobId
							AND y.status IN (1, 3) AND y.bkpLevel IN (1, 64, 128, 16384, 1024, 32768)
						) b
					ON	b.appId = a.appId
				WHERE	b.appId IS null
			END
			-- Disallow pruned jobs for copy
			DECLARE @tblCopyToSet TABLE (copyId INT, sourceCopyId INT, defaultCopyId INT, archGroupId INT, flags INT, dedupeFlags INT, maxMultiplex INT, isSnapCopy INT, isMirrorCopy INT)
			INSERT INTO @tblCopyToSet
			EXEC ArchDestinationCopyList @l_copyId
			DELETE FROM @tblCopyToSet WHERE copyId = @l_copyId
			IF EXISTS (SELECT * FROM @tblCopyToSet)
			BEGIN
				INSERT	INTO @tblJobCopy
				SELECT	DISTINCT J.jobId, J.commCellId, J.dataType, B.appId, J.archGrpId, J.archGrpCopyId,
						C.sourceCopyId, 1, 0
				FROM	JMJobDataStats J WITH (NOLOCK), @tblJobCopy B, @tblCopyToSet C
				WHERE	J.jobId = B.jobId AND J.archGrpCopyId = C.copyId
					AND J.dataType = B.fileType
					AND J.commCellId = B.commCellId
					AND J.status IN (101, 102, 103) AND (J.disabled & (1 + 256)) = 0
				IF @@ROWCOUNT > 0
				BEGIN
					DELETE	FROM @tblJobCopy
					WHERE	jobId NOT IN (SELECT DISTINCT jobId FROM @tblJobCopy WHERE flags = 0)
					SELECT	@retVal = 0
					WHILE @@ROWCOUNT > 0
						UPDATE	@tblJobCopy SET flags = 1
						WHERE	flags = 0 AND sourceCopyId IN (SELECT archCopyId FROM @tblJobCopy WHERE flags = 1)
					UPDATE 	JMJobDataStats
					SET		disabled = (J.disabled | 1), modifiedTime = @l_now
					FROM	JMJobDataStats J, @tblJobCopy T
					WHERE	J.jobId = T.jobId AND J.archGrpCopyId = T.archCopyId AND J.commCellId = T.commCellId
						AND J.dataType = T.fileType
						AND T.flags = 1 AND J.archGrpCopyId <> @l_copyId
						AND J.disabled & 1 = 0
				END
			END
			DELETE @tblCopyToSet
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET	@retVal = (SELECT ERROR_NUMBER())
	END CATCH
	--*********************************** Going to exit **********************************/
	CX_EXIT:
		IF object_id('tempdb.dbo.#ToBeAgedAFC') IS NOT NULL DROP TABLE #ToBeAgedAFC
		DELETE @tblAC
		DELETE @tblBCDIndexAF
		DELETE @tblJobsWithBCDIndex
		DELETE @tblJobCopy
		IF @retVal <> 0 OR @l_notAged <> 0
			INSERT INTO @tblOutVals
			SELECT	-1, @retVal, @l_notAged, 0, 0
		ELSE
			INSERT INTO @tblOutVals
			SELECT	T.jobId, T.appId, A.appTypeId, A.backupSet, T.forceNextBkpFull
			FROM	@tblJob T, APP_Application A WITH (NOLOCK)
			WHERE	A.id = T.appId
			ORDER BY T.appId, T.forceNextBkpFull DESC
		DELETE @tblJob
	-- There is a DB error or some jobs are not aged
	IF EXISTS (SELECT JobId FROM @tblOutVals WHERE JobId < 0)
	BEGIN
		-- Here o_appId holds the DB error
		-- IF @AppId <> 0
		IF EXISTS (SELECT AppId FROM @tblOutVals WHERE AppId <> 0)
		BEGIN
			SELECT	@o_ErrorNumber = 2, @o_ErrorMessage = 'Failed to process Media for Library [' + CONVERT(VARCHAR(10), @i_libraryId) + ']. Err-[' + CONVERT(VARCHAR(10), (SELECT TOP 1 AppId FROM @tblOutVals WHERE AppId <> 0)) + '].'
			GOTO RETURN_EXIT;
		END
		-- Here o_appTypeId indicates IsAnyJobNotAged
		-- IF @AppTypeId = 1
		IF EXISTS (SELECT AppTypeId FROM @tblOutVals WHERE AppTypeId = 1)
		BEGIN
			SELECT	@o_ErrorNumber = 3, @o_ErrorMessage = 'Some jobs are not aged for Media belonging to Library [' + CONVERT(VARCHAR(10), @i_libraryId) + ']. No job has been pruned from Media. IsAnyJobNotAged-[1].'
			GOTO RETURN_EXIT;
		END
		-- ELSE IF @AppTypeId = 2
		ELSE IF EXISTS (SELECT AppTypeId FROM @tblOutVals WHERE AppTypeId = 2)
		BEGIN
			SELECT	@o_ErrorNumber = 4, @o_ErrorMessage = 'A Media belonging to Library [' + CONVERT(VARCHAR(10), @i_libraryId) + '] contains valid data of a running job. No job has been pruned from Media. IsAnyJobNotAged-[2].'
			GOTO RETURN_EXIT;
		END
		-- ELSE IF @AppTypeId = 3
		ELSE IF EXISTS (SELECT AppTypeId FROM @tblOutVals WHERE AppTypeId = 3)
		BEGIN
			SELECT	@o_ErrorNumber = 5, @o_ErrorMessage = 'A Media belonging to Library [' + CONVERT(VARCHAR(10), @i_libraryId) + '] contains valid data of silo jobs. No job has been pruned from Media. IsAnyJobNotAged-[3].'
			GOTO RETURN_EXIT;
		END
	END
	DELETE @tblOutVals
	-- Update MMDrive
	UPDATE	MMDrive
	SET		VolumeId = 0, CurrentFileMarker = -1, FileMarkerCacheType = 0, LastUseTime = dbo.GetUnixTime(GetUTCDate())
	WHERE	VolumeId IN (SELECT VolumeId FROM @tblVolumeIds)
	-- Check whether any chunk is referring the volume or not
	IF EXISTS (SELECT TOP 1 AC.id FROM ArchChunk AC WITH (NOLOCK), MMVolume V WITH (NOLOCK)
		WHERE V.VolumeId IN (SELECT VolumeId FROM @tblVolumeIds)
		AND V.RecordingFormatId = 10001
		AND AC.VolumeId = V.VolumeId
		AND NOT (AC.PhysicalSize = 0 AND AC.LogicalSize = 0) AND (AC.Flags & 256) = 0)
	BEGIN
		SELECT @o_ErrorNumber = 6, @o_ErrorMessage = 'Volumes are still referred by chunks'
		GOTO RETURN_EXIT;
	END
	-- Check whether the volume belongs to SILO
	IF EXISTS (SELECT TOP 1 AFSV.SiloVolumeId FROM ArchFileSiloVolume AFSV WITH (READUNCOMMITTED)
		WHERE AFSV.siloVolumeId IN (SELECT VolumeId FROM @tblVolumeIds))
	BEGIN
		SELECT @o_ErrorNumber = 7, @o_ErrorMessage = 'Volume is part of SILO.'
		GOTO RETURN_EXIT;
	END
	/*
	IF EXISTS (SELECT TOP 1 AGC.id FROM ArchGroupCopy AGC WITH (READUNCOMMITTED),
		MMVolume MV WITH (READUNCOMMITTED), IDXSIDBStore SIDB WITH (READUNCOMMITTED)
		WHERE MV.VolumeId IN (SELECT VolumeId FROM @tblVolumeIds)
		AND MV.SIDBStoreId = SIDB.SIDBStoreId
		AND SIDB.CopyId > 0
		AND SIDB.CopyId = AGC.id
		AND ((AGC.flags & 2097152) > 0))
	BEGIN
		SELECT @o_ErrorNumber = 8, @o_ErrorMessage = 'Volume is part of SILO.'
		GOTO RETURN_EXIT;
	END
	*/
	-- Delete the Volumes
	DELETE 	MMVolume
	WHERE	VolumeId IN (SELECT VolumeId FROM @tblVolumeIds)
	DELETE @tblVolumeIds
	--Delete the mediaside
	INSERT	INTO @tblMediaSideIds
	SELECT	MediaSideId
	FROM	MMMediaSide WITH (NOLOCK)
	WHERE	MediaId IN (SELECT MediaId FROM @tblMediaToDel)
	DELETE 	MMMediaSide
	WHERE	MediaSideId IN (SELECT MediaSideId FROM @tblMediaSideIds)
	DELETE @tblMediaSideIds
	-- Undeclare Media from Slots
	UPDATE	MMSlot
	SET		MediaId = 0, ConfidenceLevel = @MM_NEWLY_OCCUPIED, InventoryTimeStamp = 0
	WHERE	MediaId IN (SELECT MediaId FROM @tblMediaToDel)
	-- Unset MediaId for Drives
	UPDATE	MMDrive
	SET		MediaId = 0
	WHERE	MediaId IN (SELECT MediaId FROM @tblMediaToDel)
	-- Delete the Media
	DELETE 	MMMedia
	WHERE	MediaId IN (SELECT MediaId FROM @tblMediaToDel)
	DELETE @tblMediaToDel
	COMMIT TRAN MEDIA_TRAN
	SET @tranStarted = 0
END--end while loop
SELECT  @o_ErrorNumber = 0, @o_ErrorMessage = ''
RETURN_EXIT:
IF @tranStarted = 1
	ROLLBACK TRAN MEDIA_TRAN
SELECT  @o_ErrorNumber, @o_ErrorMessage, 0, 0, ''
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMDelSpareAndAgedMediaForLib')
	delete from GxQscripts where name = 'MMDelSpareAndAgedMediaForLib'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDelSpareAndAgedMediaForLib')
	delete from GXDBVersions where aliasname = 'MMDelSpareAndAgedMediaForLib'
GO

insert into GXDBVersions values(2, 'MMDelSpareAndAgedMediaForLib',  '00010012003400060000', 'MMDelSpareAndAgedMediaForLib', '00010012003400060000')
GO

