

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMDataServerIPControllerValidation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMDataServerIPControllerValidation.sp,v $ $Id: MMDataServerIPControllerValidation.sp,v 1.1.4.8 2018/08/23 14:37:46 aselvanayagam Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMDataServerIPControllerValidation"					|
--	|																		|
--	| Execute the stored procedure to fetch device controller information 	|
--	| .. needed for sharing cloud device controllers						|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMDataServerIPControllerValidation <<<'

IF EXISTS (select * from sysobjects where name='MMDataServerIPControllerValidation')
	drop procedure MMDataServerIPControllerValidation
IF EXISTS (select * from GxQscripts where name='MMDataServerIPControllerValidation')
	delete from GxQscripts where name = 'MMDataServerIPControllerValidation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDataServerIPControllerValidation')
	delete from GXDBVersions where aliasname = 'MMDataServerIPControllerValidation'
GO
print '... Creating Procedure: MMDataServerIPControllerValidation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMDataServerIPControllerValidation
  @i_Operation integer,
  @i_MountPathId integer,
  @i_MediaAgentId integer,
  @i_DeviceAccessType integer
AS
  DECLARE @o_ExitCode BIGINT
DECLARE     @releaseId		integer
DECLARE 	@dataServerBits INT = 16 | 32 |128
SET	@o_ExitCode = 0
DECLARE @deviceControllers TABLE(deviceControllerId INT, deviceAccessType INT, clientId INT, folder varchar(1024), userName varchar(1024))
INSERT INTO @deviceControllers
SELECT DISTINCT DC.DeviceControllerId, DC.DeviceAccessType, DC.ClientId, DC.folder,
				CASE DC.CredentialAssocId
				WHEN 0 THEN	DC.UserName
				ELSE AC.userName
				END
		FROM MMDeviceController DC WITH (READUNCOMMITTED)
							JOIN MMMountPathToStorageDevice MPSD WITH (READUNCOMMITTED) ON MPSD.DeviceId = DC.DeviceId
							JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.MountPathId = MPSD.MountPathId
		LEFT OUTER JOIN APP_CredentialAssoc ACA WITH(READUNCOMMITTED) ON ACA.assocId = DC.CredentialAssocId
		LEFT OUTER JOIN APP_Credentials AC WITH(READUNCOMMITTED) ON AC.credentialId = ACA.credentialId
		WHERE MP.MountPathId = @i_MountPathId
--OPERATION MM_CONTROLLER_ADD
IF @i_Operation = 1
BEGIN
	--Following checks are when DataServer IP MA is added.
	--So if the MA being added is not DataServerIP MA return SUCCESS
IF (@i_DeviceAccessType & 16 <= 0)
	BEGIN
		GOTO EXITSP
	END
	--Check for MA release. Cannot be older than 11.0
	SET @releaseId = (SELECT releaseId FROM APP_CLIENT WITH (READUNCOMMITTED) WHERE id = @i_MediaAgentId)
IF @releaseId < 16
	BEGIN
SET	@o_ExitCode = (854 | (CAST(POWER(2, 24) AS BIGINT) * 36))
		GOTO EXITSP
	END
	IF EXISTS (SELECT 1 FROM App_Client as CL WITH (READUNCOMMITTED), simOperatingSystem OS WITH (READUNCOMMITTED)
				WHERE   cl.Id = @i_MediaAgentId AND
						cl.simOperatingSystemId = os.Id AND
						os.Type <> 'Windows' AND (os.SubType <> 'Linux' OR (os.SubType = 'Linux' AND os.PlatformType IN ('PPC', 'PPC64')) ) )
	BEGIN
SET	@o_ExitCode = (855 | (CAST(POWER(2, 24) AS BIGINT) * 36))
		GOTO EXITSP
	END
	--Before adding DataServer IP MA, check if there is atleast one MA with local path in the given MountPath
IF NOT EXISTS(SELECT 1 FROM @deviceControllers WHERE  userName = '' AND folder <> '' AND (deviceAccessType & (@dataServerBits|4)) = 4)
	BEGIN
SET	@o_ExitCode = (852 | (CAST(POWER(2, 24) AS BIGINT) * 36))
		GOTO EXITSP
	END
	GOTO EXITSP
END
--DELETE CONTROLLER MM_CONTROLLER_DELETE
IF @i_Operation = 3
BEGIN
	--First check if the MountPath has any DataServer IP controllers.
	--If none then the following checks are not applicable
IF NOT EXISTS(SELECT 1 FROM @deviceControllers WHERE deviceAccessType & 16 > 0)
	BEGIN
		GOTO EXITSP
	END
	--Check if the Controller being deleted is the only controller with local path
	--For a DataServer too after sharing the folder may contain value. exclude that too in the query
	IF EXISTS (SELECT 1 FROM @deviceControllers WHERE userName = '' AND folder <> '' AND clientId = @i_MediaAgentId AND deviceAccessType & @dataServerBits = 0)
	BEGIN
		DECLARE @numLocalPath	integer = 0
		SET @numLocalPath = (SELECT COUNT(*) FROM @deviceControllers WHERE  userName = '' AND folder <> '' AND deviceAccessType & @dataServerBits = 0)
		IF (@numLocalPath = 1)
		BEGIN
SET	@o_ExitCode = (853 | (CAST(POWER(2, 24) AS BIGINT) * 36))
		END
	END
	GOTO EXITSP
END
EXITSP:
SELECT @o_ExitCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMDataServerIPControllerValidation')
	delete from GxQscripts where name = 'MMDataServerIPControllerValidation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDataServerIPControllerValidation')
	delete from GXDBVersions where aliasname = 'MMDataServerIPControllerValidation'
GO

insert into GXDBVersions values(2, 'MMDataServerIPControllerValidation',  '00010001000400080000', 'MMDataServerIPControllerValidation', '00010001000400080000')
GO

