

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMDDBSnapMaintenance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMDDBSnapMaintenance.sp,v $ $Id: MMDDBSnapMaintenance.sp,v 1.2.88.2 2018/03/22 03:13:12 jiechen Exp $";
--
--  +========================================================================+
--  |      SP:  MMDDBSnapMaintenance
--  |
--  | Description:  Updates the least of lastSnapTime of substores for a store
--  |		    and cleans up the MMTempDeletedAF table
--  |
--  |       Input:  SubStoreId
--  |
--  |      Output:  always returns the SIDB Store id, otherwise 0
--  |
--  |      Notes:	None at this time
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   	   anarulkar
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMDDBSnapMaintenance <<<'

IF EXISTS (select * from sysobjects where name='MMDDBSnapMaintenance')
	drop procedure MMDDBSnapMaintenance
IF EXISTS (select * from GxQscripts where name='MMDDBSnapMaintenance')
	delete from GxQscripts where name = 'MMDDBSnapMaintenance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDDBSnapMaintenance')
	delete from GXDBVersions where aliasname = 'MMDDBSnapMaintenance'
GO
print '... Creating Procedure: MMDDBSnapMaintenance'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMDDBSnapMaintenance
  @i_subStoreId integer
AS
  DECLARE @o_errorCode integer
  DECLARE @o_errorString nvarchar(256)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
-- .. :PARAM input lines
	SET NOCOUNT ON
	DECLARE @errCode			integer = 0
	DECLARE @errStr				nvarchar(256) = ''
	DECLARE @l_sidbStoreId			integer	= 0
	DECLARE @l_commCellId			integer	= 0
	DECLARE @l_mmConfigVal			integer = 0
	DECLARE @l_additionalTimeToCleanup	integer = 0
	DECLARE @l_minLastSnapTime		integer = 0
	DECLARE @l_storeLastSnapTime		integer = 0
	DECLARE @l_reconSIDBs TABLE (SIDBStoreId INTEGER)
	SELECT	@l_sidbStoreId	= SIDBStoreId,
		@l_commCellId	= commCellId
	FROM IdxSIDBSubStore WITH (NOLOCK)
	WHERE SubStoreId = @i_subStoreId
	IF (@l_sidbStoreId = 0)
	BEGIN
		SET @errCode = 1
		SET @errStr = 'No SIDB Found for SubStore'
		GOTO EXIT_PROC
	END
	SET @l_mmConfigVal = ISNULL((select value from MMConfigs WITH (NOLOCK) where name = 'MMS2_MMCONFIG_ADDITIONAL_MINUTES_FROM_LASTSNAPTIME_FOR_DDB_RECOVER'), 30)
	IF @l_mmConfigVal = 0
		SET @l_mmConfigVal = 30
	SET @l_additionalTimeToCleanup = (@l_mmConfigVal * 60)
	SELECT @l_minLastSnapTime = MIN(LastSnapTime)
	FROM IdxSIDBSubStore
	WHERE SIDBStoreId = @l_sidbStoreId
	SELECT @l_storeLastSnapTime = LastSnapTime
	FROM IdxSIDBStore
	WHERE SIDBStoreId = @l_sidbStoreId
	IF (@l_storeLastSnapTime <> @l_minLastSnapTime)
	BEGIN
		UPDATE IdxSIDBStore
		SET LastSnapTime = @l_minLastSnapTime
		WHERE SIDBStoreId = @l_sidbStoreId
		SELECT @errCode = @@ERROR
		IF @errCode <> 0
		BEGIN
			SET @errStr = 'Error while updating IdxSIDBStore'
			GOTO EXIT_PROC
		END
		INSERT  INTO @l_reconSIDBs
        	     SELECT  dbo.GetJobOption(jobId, 1777365717/* DEDUPDBSYNCOPTION__SIDBSTORE_ID */)
	             FROM    JMJobInfo
	             WHERE   commCellId = 2 /* Local Commcell ID*/ AND opType = 80  /* DEDUPDBSYNC */
		SELECT @errCode = @@ERROR
		IF @errCode <> 0
		BEGIN
			SET @errStr = 'Error while getting store list in recon'
			GOTO EXIT_PROC
		END
 	        IF NOT EXISTS (SELECT SIDBStoreId FROM @l_reconSIDBs WHERE SIDBStoreId = @l_sidbStoreId)
		BEGIN
                	DELETE  FROM MMTempDeletedAF
	                WHERE   SIDBStoreId = @l_sidbStoreId
                         AND CreatedTime < (@l_minLastSnapTime - @l_additionalTimeToCleanup)
			SELECT @errCode = @@ERROR
			IF @errCode <> 0
			BEGIN
				SET @errStr = 'Error while deleting rows from MMTempDeletedAF'
				GOTO EXIT_PROC
			END
		END
	END
EXIT_PROC:
	SELECT @errCode, @errStr
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMDDBSnapMaintenance')
	delete from GxQscripts where name = 'MMDDBSnapMaintenance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDDBSnapMaintenance')
	delete from GXDBVersions where aliasname = 'MMDDBSnapMaintenance'
GO

insert into GXDBVersions values(2, 'MMDDBSnapMaintenance',  '00010002008800020000', 'MMDDBSnapMaintenance', '00010002008800020000')
GO

