

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMDDBSetVerifyProgressStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMDDBSetVerifyProgressStatus.sp,v $ $Id: MMDDBSetVerifyProgressStatus.sp,v 1.3.54.5 2019/04/26 14:56:59 gharidas Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMDDBSetVerifyProgressStatus')
BEGIN
	print '>>> Drop Stored Procedure: MMDDBSetVerifyProgressStatus <<<'
	drop procedure MMDDBSetVerifyProgressStatus
END
IF EXISTS (select * from GxQscripts where name='MMDDBSetVerifyProgressStatus')
	delete from GxQscripts where name = 'MMDDBSetVerifyProgressStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDDBSetVerifyProgressStatus')
	delete from GXDBVersions where aliasname = 'MMDDBSetVerifyProgressStatus'
GO
print '... Creating Procedure: MMDDBSetVerifyProgressStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMDDBSetVerifyProgressStatus
  @i_SIDBStoreId INTEGER,
  @i_SetDVProgressFlag INTEGER,
  @i_SetDVProgressAllowBackupsFlag INTEGER
AS
  DECLARE @o_StoreId INT
  DECLARE @o_ErrorCode INT
DECLARE @errorCode INTEGER = 0
DECLARE @Status INTEGER = 0
DECLARE @Flags INTEGER = 0
-- Reset the DV job progress flag
DECLARE @FlagMask INT
SET @FlagMask = 67108864
IF @i_SetDVProgressFlag = 0
BEGIN
SET @FlagMask = @FlagMask | 268435456
	UPDATE IdxSIDBStore
	SET Flags = Flags & (~@FlagMask)
	WHERE SIDBStoreId = @i_SIDBStoreId
	GOTO CV_EXIT
END
-- Set the DV job progress flag
ELSE
BEGIN
	IF (@i_SetDVProgressAllowBackupsFlag = 1)
SET @FlagMask = @FlagMask | 268435456
	SELECT	@Status = Status, @Flags = Flags
	FROM	IdxSIDBStore WITH (NOLOCK)
	WHERE	SIDBStoreId = @i_SIDBStoreId
IF (@Status = 1) OR (EXISTS (SELECT * FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = @i_SIDBStoreId AND Status = 1))
	BEGIN
SET	@ErrorCode = 68001
		GOTO CV_EXIT
	END
IF ((@Flags & 1024) = 1024
OR EXISTS(SELECT * FROM IdxSIDBSubStore WITH (NOLOCK) WHERE SIDBStoreId = @i_SIDBStoreId AND flags & 1024 = 1024))
	BEGIN
SET	@ErrorCode = 68002
		GOTO CV_EXIT
	END
IF ((@Flags & 16777216) = 16777216)
	BEGIN
SET	@ErrorCode = 68003
		GOTO CV_EXIT
	END
	-- Allow DV2 when AF validation is in progress.
	-- 1) We are already disallowing DV when MAINTENANCE bit is set. So DV will not interfere with resync.
	-- 2) So when below condition is true, it means AF validate & prune is running on this store.
	--		But this doesnt interfere with DV as pruning will be halted once DV starts.
	-- If we continue to disallow DV2 due to RESYNC_IN_PROGRESS, with daily/monthly AF validation & prune,
	-- DV2 will be allowed on much more instances, than required.
-- IF ((@Flags & 1073741824) = 1073741824)
	-- BEGIN
--	SET	@ErrorCode = 68045
	--	GOTO CV_EXIT
	-- END
	IF (@i_SetDVProgressAllowBackupsFlag = 0) AND EXISTS (
				SELECT	J.jobId
				FROM	MMVolume MV WITH (NOLOCK), MMResource MR WITH (NOLOCK), MMResourceToJob MRJ WITH (NOLOCK), JMJobInfo J WITH (NOLOCK)
				WHERE	MV.SIDBStoreID = @i_SIDBStoreId
						AND MR.Volumeid = MV.VolumeId
						AND MR.ReservationId = MRJ.ReservationId
						AND MRJ.ReleaseTime = 0
						AND MRJ.ReservationType = 2
						AND MRJ.JobId_l = J.jobId
						AND J.state IN (1, -- RUNNING
										3, -- WAITING
										6, -- KILLPENDING
										7, -- STOPPENDING
										8, -- INTERRUPTPENDING
										13, -- SYSTEMKILLPENDING
										14, -- DORMANT
										15, -- DORMANTSCHEDWAIT
										16, -- RUNNING_UNVERIFIABLE
										17  --DANGLINGJOBCLEANUP
										)
				)
	BEGIN
SET	@ErrorCode = 68004
		GOTO CV_EXIT
	END
	UPDATE IdxSIDBStore
	SET Flags = Flags | @FlagMask
	WHERE SIDBStoreId = @i_SIDBStoreId
END
CV_EXIT:
	SELECT @i_SIDBStoreId, @errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'MMDDBSetVerifyProgressStatus')
	delete from GxQscripts where name = 'MMDDBSetVerifyProgressStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDDBSetVerifyProgressStatus')
	delete from GXDBVersions where aliasname = 'MMDDBSetVerifyProgressStatus'
GO

insert into GXDBVersions values(2, 'MMDDBSetVerifyProgressStatus',  '00010003005400050000', 'MMDDBSetVerifyProgressStatus', '00010003005400050000')
GO

