

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMDDBSetMaintenanceStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMDDBSetMaintenanceStatus')
BEGIN
	print '>>> Drop Stored Procedure: MMDDBSetMaintenanceStatus <<<'
	drop procedure MMDDBSetMaintenanceStatus
END
IF EXISTS (select * from GxQscripts where name='MMDDBSetMaintenanceStatus')
	delete from GxQscripts where name = 'MMDDBSetMaintenanceStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDDBSetMaintenanceStatus')
	delete from GXDBVersions where aliasname = 'MMDDBSetMaintenanceStatus'
GO
print '... Creating Procedure: MMDDBSetMaintenanceStatus'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMDDBSetMaintenanceStatus
  @SIDBStoreId INTEGER,
  @MaintStatus INTEGER,
  @MaintReason INTEGER,
  @NeedResync INTEGER
AS
  DECLARE @StoreId INT
  DECLARE @StoreName VARCHAR (256)
  DECLARE @Flags INT
  DECLARE @StoreSelected INT
  DECLARE @ReasonString VARCHAR(256)
-- Bring store back from maintenance. Can process only one store at a time.
IF @MaintStatus = 0 AND @NeedResync = 0
BEGIN
	DECLARE @FlagMask INT
SET @FlagMask = (16777216|33554432|134217728|1073741824)
	UPDATE IdxSIDBStore
	SET Flags = Flags & (~@FlagMask)
	WHERE SIDBStoreId = @SIDBStoreId
	DELETE FROM MMEntityProp
	WHERE
		EntityId = @SIDBStoreId AND
EntityType = 3 AND
		PropertyName = 'DDBMaintenanceReason' AND
		CommcellId = 2
	UPDATE IdxSIDBSubStore
	SET Flags = Flags & (~@FlagMask)
	WHERE SIDBStoreId = @SIDBStoreId
	SELECT SIDBStoreId, SIDBStoreName, Flags, 1, ''
	FROM IdxSIDBStore
	WHERE SIDBStoreId = @SIDBStoreId
END
-- Put store in maintenance. Will consider all stores when SIDBStoreId is -1.
ELSE
BEGIN
	IF OBJECT_ID ('tempdb.dbo.#MinRelMAInfo') IS NOT NULL
		DROP TABLE #MinRelMAInfo
	IF OBJECT_ID ('tempdb.dbo.#StoresToMaint') IS NOT NULL
		DROP TABLE #StoresToMaint
	IF OBJECT_ID ('tempdb.dbo.#ResultSetSink') IS NOT NULL
		DROP TABLE #ResultSetSink
	BEGIN TRY
		BEGIN TRAN;
		-- Dont add code between the DECLARE and WITH statements (semicolon required for WITH stmts).
		DECLARE @DummySemiColonStmt INT;
		WITH MAINFODUPL AS
		(
			SELECT
				SUBSTORE.SIDBStoreId AS SIDBStoreId,
				CLIENT.ReleaseId AS ReleaseId,
				PKG.HighestSP AS HighestSP,
				PKG.SpMinorVersion AS SpMinorVersion,
				ROW_NUMBER() OVER (PARTITION BY SIDBStoreId
									ORDER BY SIDBStoreId, ReleaseId, HighestSP, SpMinorVersion) AS RowNum
			FROM
				IdxSIDBSubStore SUBSTORE
				INNER JOIN APP_Client CLIENT ON CLIENT.id = SUBSTORE.ClientId
				-- Cluster clients do not have a SimInstallPackges entry. So, find the physical clients.
				LEFT OUTER JOIN APP_VMToPMMap MAP ON MAP.VMClientId = CLIENT.id
				INNER JOIN SimInstalledPackages PKG ON PKG.ClientId = ISNULL(MAP.PMClientId, CLIENT.id)
			WHERE
PKG.simPackageID in (51, 1301) AND
				SUBSTORE.CommcellId = 2
		)
		SELECT SIDBStoreId, ReleaseId, HighestSP, SpMinorVersion
		INTO #MinRelMAInfo
		FROM MAINFODUPL
		WHERE RowNum = 1
		-- Pick all stores. We will eliminate ineligible stores.
		CREATE TABLE #StoresToMaint
		(
			SIDBStoreId INT,
			StoreFlags INT,
			ReasonString VARCHAR(256),
			StoreSelected AS (CASE WHEN LEN([ReasonString]) = 0 THEN 1
				ELSE 0 END),
			MaintReason INT
			CONSTRAINT TempStoresToMaint_SIDBStoreId_PK PRIMARY KEY (SIDBStoreId)
		)
		IF @SIDBStoreId = -1
			INSERT INTO #StoresToMaint
			SELECT
				[SIDBStoreId] = STORE.SIDBStoreId,
				[StoreFlags] = STORE.Flags,
				[ReasonString] = '',
				[MaintReason] = NULL
			FROM IdxSIDBStore STORE
			WHERE CommcellId = 2
		ELSE
			INSERT INTO #StoresToMaint
			SELECT
				[SIDBStoreId] = STORE.SIDBStoreId,
				[StoreFlags] = STORE.Flags,
				[ReasonString] = '',
				[MaintReason] = NULL
			FROM IdxSIDBStore STORE
			WHERE SIDBStoreId = @SIDBStoreId AND
				  CommcellId = 2
		-- Populate maintenance reason too for easy lookup.
		UPDATE #StoresToMaint
SET MaintReason = ISNULL(PROP.IntVal, 0)
		FROM
			[#StoresToMaint] ELIG
				LEFT OUTER JOIN
			MMEntityProp PROP ON
				PROP.EntityId = ELIG.SIDBStoreId AND PROP.CommcellId = 2 AND
				PROP.EntityType = 3 AND
				PROP.PropertyName = 'DDBMaintenanceReason'
		-- 1. Find all eligible stores.
		-- 1A. Store based eliminations.
		UPDATE #StoresToMaint
		SET ReasonString = (CASE
									WHEN STORE.SIDBStoreId = 0									THEN 'Invalid store'
									WHEN STORE.Version = -1										THEN 'Uninitialized store'
									WHEN STORE.Status <> 0										THEN 'Corrupt store'
WHEN STORE.flags & 256 <> 0	THEN 'Aged store'
WHEN STORE.flags & 2097152 <> 0 AND (STORE.SealedReason <> 0 OR STORE.SealedTime <> 0)
																								THEN 'Sealed silo-enabled store'
WHEN STORE.flags & 2097152 <> 0 AND @MaintStatus = 0
																								THEN 'Non-maintenance operation on a silo store.'
									ELSE ''
								END)
		FROM #StoresToMaint ELIG, IdxSIDBStore STORE
		WHERE
			ELIG.SIDBStoreId = STORE.SIDBStoreId AND STORE.CommcellId = 2 AND
			ELIG.StoreSelected = 1
		-- 1B. Copy based eliminations.
		UPDATE #StoresToMaint
		SET ReasonString = 'Orphaned store'
		FROM #StoresToMaint ELIG
			LEFT OUTER JOIN ArchCopySIDBStore COPYSTORE ON
				COPYSTORE.SIDBStoreId = ELIG.SIDBStoreId AND COPYSTORE.CommcellId = 2
		WHERE
			COPYSTORE.SIDBStoreId IS NULL AND
			ELIG.StoreSelected = 1
		-- 1C. Retired maintenance reasons.
IF @MaintReason = 10
		BEGIN
			-- Is not allowed anymore. Replaced with controlled AF validation.
			UPDATE #StoresToMaint
			SET ReasonString = 'Not a supported maintenance reason'
			FROM #StoresToMaint ELIG
			WHERE
				ELIG.StoreSelected = 1
		END
		-- 1D. MA based eliminations.
IF @MaintReason IN (1, 3,
4, 7,
12,
9, 11,
13)
		BEGIN
			UPDATE #StoresToMaint
			SET ReasonString = 'MA on unsupported release/service pack'
			FROM #StoresToMaint ELIG, [#MinRelMAInfo] MAINFO
			WHERE
				MAINFO.SIDBStoreId = ELIG.SIDBStoreId AND
(MAINFO.ReleaseId < 15 OR
(MAINFO.ReleaseId = 15 AND MAINFO.HighestSP < 6) OR
(MAINFO.ReleaseId = 15 AND MAINFO.HighestSP = 6 AND MAINFO.SpMinorVersion < 1)) AND
				ELIG.StoreSelected = 1
		END
		-- 1E. Maintenance reason based eliminations.
		-- First, make sure maintenance reason is consistent with maintenance status.
		UPDATE #StoresToMaint
		SET ReasonString = 'Incorrect input. Store has to be put in maintenance mode for this maintenance reason.'
		FROM #StoresToMaint ELIG
		WHERE
			@MaintStatus = 0 AND
@MaintReason NOT IN (9, 11,
13) AND
			ELIG.StoreSelected = 1
		UPDATE #StoresToMaint
		SET ReasonString = 'Incorrect input. Store cannot be resync-ed with this maintenance reason.'
		FROM #StoresToMaint ELIG
		WHERE
			@NeedResync = 1 AND
@MaintReason NOT IN (4, 7,
12,
9, 11,
13) AND
			ELIG.StoreSelected = 1
		-- 1F. Maintenance reason specific checks.
IF @MaintReason = 1
		BEGIN
			-- If the store has already been marked for resync after CV failover,
			-- it will anyway be resync-ed, so do not reset the resync bit,
			-- and warrant the user action to initiate resync.
			UPDATE #StoresToMaint
			SET ReasonString = 'Store is already waiting to be resync-ed after CVFailover.'
			FROM #StoresToMaint ELIG, MMEntityProp PROP, IdxSIDBStore STORE
			WHERE
				PROP.EntityId = ELIG.SIDBStoreId AND PROP.CommcellId = 2 AND
PROP.EntityType = 3 AND PropertyName = 'DDBMaintenanceReason' AND
PROP.IntVal = 12 AND
				ELIG.SIDBStoreId = STORE.SIDBStoreId AND STORE.CommcellId = 2 AND
STORE.Flags & 16777216 = 16777216 AND
STORE.Flags & 33554432 = 33554432
		END
ELSE IF @MaintReason IN (3, 7)
		BEGIN
			-- Highest priority so far.
			-- When there is a DR restore or timestamp mismatch on SIDB side,
			-- we have to do the resync to get the store online.
			-- So, reset all kinds of old maintenance status/reason.
			-- Dummy statement to keep code more readable.
			UPDATE #StoresToMaint
			SET ReasonString = ''
			FROM #StoresToMaint ELIG
			WHERE 1 = 0
		END
ELSE IF @MaintReason = 8
		BEGIN
			-- If store is in maintenance due to DR restore or resync, then we cannot allow DDB upgrade.
			-- We have to go thru resync first to clear out invalid AFs and prevent data loss.
			UPDATE #StoresToMaint
			SET ReasonString = 'Store is waiting to be resync-ed.'
			FROM #StoresToMaint ELIG
			WHERE
StoreFlags & 16777216 <> 0 AND
MaintReason IN (1, 3,
4, 7,
12) AND
				ELIG.StoreSelected = 1
		END
ELSE IF @MaintReason = 4
		BEGIN
			-- Store has to be already in maintenance for this.
			UPDATE #StoresToMaint
			SET ReasonString = 'Store not in maintenance or invalid maintenance reason for forcing resync'
			FROM #StoresToMaint ELIG
			WHERE
(StoreFlags & 16777216 = 0 OR
MaintReason NOT IN (1, 3)) AND
				ELIG.StoreSelected = 1
		END
ELSE IF @MaintReason = 12
		BEGIN
			-- Store has to be already in maintenance for this.
			UPDATE #StoresToMaint
			SET ReasonString = 'Store not in maintenance or invalid maintenance reason for resync after CVFailover'
			FROM #StoresToMaint ELIG
			WHERE
(StoreFlags & 16777216 = 0 OR
MaintReason <> 3) AND
				ELIG.StoreSelected = 1
		END
ELSE IF @MaintReason IN (9, 11,
13)
		BEGIN
			-- Store cannot already be in maintenance for this.
			UPDATE #StoresToMaint
			SET ReasonString = 'Store is in maintenance mode'
			FROM #StoresToMaint ELIG
			WHERE
StoreFlags & 16777216 <> 0 AND
				ELIG.StoreSelected = 1
			-- Verification cannot already be in progress.
			UPDATE #StoresToMaint
			SET ReasonString = 'Store is in verification'
			FROM #StoresToMaint ELIG
			WHERE
StoreFlags & 67108864 <> 0 AND
				ELIG.StoreSelected = 1
IF @MaintReason IN (11, 13)
			BEGIN
				-- If the store has already been marked for regular AF validation,
				-- then we should let regular AF validation happen.
				UPDATE #StoresToMaint
				SET ReasonString = 'Store is in regular/controlled archive file validation'
				FROM #StoresToMaint ELIG
				WHERE
StoreFlags & 33554432 <> 0 AND
					ELIG.StoreSelected = 1
				-- Make sure the MA is of sufficient service pack.
				UPDATE #StoresToMaint
				SET ReasonString = 'MA on unsupported release/service pack'
				FROM #StoresToMaint ELIG, [#MinRelMAInfo] MAINFO
				WHERE
					MAINFO.SIDBStoreId = ELIG.SIDBStoreId AND
(MAINFO.ReleaseId < 16 OR
(MAINFO.ReleaseId = 16 AND MAINFO.HighestSP < 12)) AND
					ELIG.StoreSelected = 1
IF @MaintReason = 11
				BEGIN
					-- If controlled DDB AF validation is disabled, then do not proceed.
					DECLARE @IsControlledAFValidateEnabled INT = 1
					SELECT @IsControlledAFValidateEnabled = ISNULL (Value, 0) FROM MMConfigs
					WHERE
						Name = 'MMS2_CONFIG_ENABLE_CONTROLLED_DDB_AF_VALIDATION'
					UPDATE #StoresToMaint
					SET ReasonString = 'Controlled AF validation is disabled.'
					FROM #StoresToMaint ELIG
					WHERE
						@IsControlledAFValidateEnabled = 0 AND
						ELIG.StoreSelected = 1
					-- Make sure the store is older than 30 days.
					UPDATE #StoresToMaint
					SET ReasonString = 'Store is not older than 30 days'
					FROM #StoresToMaint ELIG, IdxSIDBStore STORE
					WHERE
						ELIG.SIDBStoreId = STORE.SIDBStoreId AND STORE.CommcellId = 2 AND
						(dbo.GetUnixTime(GETUTCDATE()) - CreatedTime) < 30*24*60*60 AND
						ELIG.StoreSelected = 1
					-- If there has been an successful resync/AF validation with prune
					-- in the last 30 days, then we do not need to a controlled validation and pruned now.
					UPDATE #StoresToMaint
					SET ReasonString = 'AF validation with prune/resync has been performed in the last 30 days'
					FROM #StoresToMaint ELIG
					WHERE
						(
							SELECT (dbo.GetUnixTime(GETUTCDATE()) - MAX(ISNULL(ResyncStartTime,0))) FROM IdxSIDBResyncHistory HIST
							WHERE HIST.SIDBStoreId = ELIG.SIDBStoreId AND HIST.CommcellId = 2 AND
HIST.MaintenanceReason IN (4, 7, 9, 12) AND
							HIST.ResyncStatus = 0
						) < 30*24*60*60 AND
						ELIG.StoreSelected = 1
					-- Elimination based on most recent Controlled AF validation.
					;WITH LASTVALIDATESTART AS
					(
						SELECT SIDBStoreId, CommcellId, MAX(MaintenanceTime) AS MaintenanceTime
						FROM IdxSIDBResyncHistory
WHERE MaintenanceReason = 11 AND
						  ResyncStatus = 0 AND
						  CommcellId = 2
						GROUP BY SIDBStoreId, CommcellId
					),
					LASTVALIDATEATTEMPT AS
					(
						SELECT HIST.SIDBStoreId, HIST.CommcellId, HIST.MaintenanceTime, MAX(HIST.AttemptNo) AS AttemptNo
						FROM IdxSIDBResyncHistory HIST, LASTVALIDATESTART
						WHERE HIST.SIDBStoreId = LASTVALIDATESTART.SIDBStoreId AND HIST.CommcellId = LASTVALIDATESTART.CommcellId AND HIST.MaintenanceTime = LASTVALIDATESTART.MaintenanceTime AND
HIST.MaintenanceReason = 11 AND
							  HIST.ResyncStatus = 0 AND
							  HIST.CommcellId = 2
						GROUP BY HIST.SIDBStoreId, HIST.CommcellId, HIST.MaintenanceTime
					)
					UPDATE #StoresToMaint
					SET ReasonString = (CASE
										-- If pruning backlog was cleared within the last 30 days, we will try again only after 30 days.
										WHEN (LASTVALIDATE.NumResyncedAfIds = 0) AND (dbo.GetUnixTime(GETUTCDATE()) - (LASTVALIDATE.ResyncStartTime + LASTVALIDATE.TurnAroundTime)) < 30*24*60*60
											THEN 'Controlled AF validation has been performed in the last 30 days.'
										-- If backlog is less than 30000 AFs, we will run validation every 24 hours.
										WHEN (LASTVALIDATE.NumResyncedAfIds < 30000) AND (dbo.GetUnixTime(GETUTCDATE()) - (LASTVALIDATE.ResyncStartTime + LASTVALIDATE.TurnAroundTime)) < 24*60*60
											THEN 'Backlog is less than 30000 AFs, but controlled AF validation has been performed in the last 24 hours'
										-- If backlog is more than 30000 AFs, we will run validation every 3 hours.
										WHEN (LASTVALIDATE.NumResyncedAfIds >= 30000) AND (dbo.GetUnixTime(GETUTCDATE()) - (LASTVALIDATE.ResyncStartTime + LASTVALIDATE.TurnAroundTime)) < 3*60*60
											THEN 'Backlog is more than 30000 AFs, but controlled AF validation has been performed in the last 3 hours'
										ELSE ''
									END)
					FROM #StoresToMaint ELIG, LASTVALIDATEATTEMPT, IdxSIDBResyncHistory LASTVALIDATE
					WHERE
						LASTVALIDATEATTEMPT.SIDBStoreId = LASTVALIDATE.SIDBStoreId AND LASTVALIDATEATTEMPT.CommcellId = LASTVALIDATE.CommcellId AND
						LASTVALIDATEATTEMPT.MaintenanceTime = LASTVALIDATE.MaintenanceTime AND LASTVALIDATEATTEMPT.AttemptNo = LASTVALIDATE.AttemptNo AND
						ELIG.SIDBStoreId = LASTVALIDATEATTEMPT.SIDBStoreId AND ELIG.StoreSelected = 1
				END
			END
		END
		ELSE
		BEGIN
			UPDATE #StoresToMaint
			SET ReasonString = 'Invalid maintenance reason'
			FROM #StoresToMaint
			WHERE
				StoreSelected = 1
		END
CX_END_OF_STORE_SELECTION:
		-- 2. Reset flags.
		DECLARE STORECUR CURSOR LOCAL FOR
		SELECT SIDBStoreId FROM #StoresToMaint WHERE StoreSelected = 1
		OPEN STORECUR
		DECLARE @SIDBStoreId2 INT
		FETCH NEXT FROM STORECUR INTO @SIDBStoreId2
CREATE TABLE #ResultSetSink (SIDBStoreId INT, SIDBStoreName VARCHAR(256), Flags INT,
			StoreSelected INT, ReasonString VARCHAR(256))
		WHILE @@FETCH_STATUS = 0
		BEGIN
			INSERT INTO #ResultSetSink
			EXEC MMDDBSetMaintenanceStatus @SIDBStoreId2, 0, 0, 0
			FETCH NEXT FROM STORECUR INTO @SIDBStoreId2
		END
		CLOSE STORECUR
		DEALLOCATE STORECUR
		-- 3. Set flags.
		DECLARE @FlagMask2 INT = 0
		IF @MaintStatus = 1
SET @FlagMask2 = @FlagMask2 | 16777216
		IF @NeedResync = 1
SET @FlagMask2 = @FlagMask2 | 33554432
		UPDATE IdxSIDBStore
		SET
			Flags = Flags | @FlagMask2,
			-- Delete DDB backup info when marking for maintenance, unless it is for just validation.
			LastSnapTime = (CASE
WHEN @MaintReason IN (9,
11)
								THEN LastSnapTime
							ELSE -1 END)
		WHERE SIDBStoreId IN (SELECT SIDBStoreId FROM #StoresToMaint WHERE StoreSelected = 1) AND CommcellId = 2
		DELETE FROM MMEntityProp
		WHERE
			EntityId in (SELECT SIDBStoreId FROM #StoresToMaint WHERE StoreSelected = 1) AND
EntityType = 3 AND
			PropertyName = 'DDBMaintenanceReason' AND
			CommcellId = 2
		INSERT INTO MMEntityProp
SELECT SIDBStoreId, 3, 'DDBMaintenanceReason', 1, @MaintReason,
			0, '', dbo.GetUnixTime (GETUTCDATE()), 0, 2
		FROM #StoresToMaint WHERE StoreSelected = 1
		SELECT STORE.SIDBStoreId, STORE.SIDBStoreName, STORE.Flags, ELIG.StoreSelected, ELIG.ReasonString
		FROM IdxSIDBStore STORE, #StoresToMaint ELIG
		WHERE
			STORE.SIDBStoreId = ELIG.SIDBStoreId AND
			STORE.CommcellId = 2
		COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		IF @@TRANCOUNT > 0
			ROLLBACK TRAN
		DECLARE @ErrMsg NVARCHAR(4000) = ERROR_MESSAGE()
		DECLARE @ErrSev INT = ERROR_SEVERITY()
		DECLARE @ErrState INT = ERROR_STATE()
		RAISERROR (@ErrMsg, @ErrSev, @ErrState)
	END CATCH
	IF OBJECT_ID ('tempdb.dbo.#MinRelMAInfo') IS NOT NULL
		DROP TABLE #MinRelMAInfo
	IF OBJECT_ID ('tempdb.dbo.#StoresToMaint') IS NOT NULL
		DROP TABLE #StoresToMaint
	IF OBJECT_ID ('tempdb.dbo.#ResultSetSink') IS NOT NULL
		DROP TABLE #ResultSetSink
END
GO

IF EXISTS (select * from GxQscripts where name = 'MMDDBSetMaintenanceStatus')
	delete from GxQscripts where name = 'MMDDBSetMaintenanceStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMDDBSetMaintenanceStatus')
	delete from GXDBVersions where aliasname = 'MMDDBSetMaintenanceStatus'
GO

insert into GXDBVersions values(2, 'MMDDBSetMaintenanceStatus',  '00000000000000000000', 'MMDDBSetMaintenanceStatus', '00000000000000000000')
GO

