

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCreateStoragePoolInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2011  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCreateStoragePoolInfo.sp,v $ $Id: MMCreateStoragePoolInfo.sp,v 1.1.2.9 2019/07/17 20:47:21 syadav Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCreateStoragePoolInfo')
BEGIN
	print '>>> Drop Stored Procedure: MMCreateStoragePoolInfo <<<'
	drop procedure MMCreateStoragePoolInfo
END
IF EXISTS (select * from GxQscripts where name='MMCreateStoragePoolInfo')
	delete from GxQscripts where name = 'MMCreateStoragePoolInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCreateStoragePoolInfo')
	delete from GXDBVersions where aliasname = 'MMCreateStoragePoolInfo'
GO
print '... Creating Procedure: MMCreateStoragePoolInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCreateStoragePoolInfo
  @i_reserveParam integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_errorCode integer
  DECLARE @o_errorString nvarchar(1024)
DECLARE @err INT = 0
DECLARE @errStr nvarchar(1024) = ''
IF NOT EXISTS (SELECT * from APP_ClientGroup A, APP_AdvanceSettings B where A.id = B.EntityId AND B.EntityType = 28 AND B.keyName = 'StoragePool' AND B.relativePath = 'CommServDB.MediaAgent')
BEGIN
	DECLARE @nowTime                      int
	SET     @nowTime                      =  datediff(second, '01/01/1970', GetUTCdate())
BEGIN TRY
BEGIN TRAN WEBSCALE
	DECLARE @MediaAgentsGroupRuleQuery nvarchar (max) -- = 'select id from app_client where (id != 1) and ( ( (  (dbo.scgCheckPackageInstalled(id,  ''='', ''<?xml version="1.0" encoding="UTF-8"?><App_AdvanceKeyInfo><packages val="1139" /></App_AdvanceKeyInfo>'' ) = 1) ) )  )'
	DECLARE @scgId INT = 0
	DECLARE @allCapability bigint = ISNULL((SELECT CAST(CAST(value AS NVARCHAR(MAX)) AS BIGINT) FROM GXGlobalParam WHERE name = 'SystemOwnerCapibilities' ),(select SUM(POWER(2.0, id-1)) FROM UMCapability))
	DECLARE @ownerId int = ISNULL((SELECT TOP(1) id from UMUsers where (flags & 0x40 = 0x40)), 1)
	DECLARE @masterRoleId INT = ISNULL((SELECT id FROM UMRoles WHERE name = 'Master' AND flags & (1 | 2) <> 0), 1)
DECLARE @disperseFactor INT = ISNULL((SELECT TOP(1) value FROM MMConfigs WHERE name = 'MMCONFIG_WEBSCALE_STORAGE_DISPERSE_FACTOR'), 6)
DECLARE @redundancyFactor INT = ISNULL((SELECT TOP(1) value FROM MMConfigs WHERE name = 'MMCONFIG_WEBSCALE_STORAGE_REDUNDANCY_FACTOR'), 2)
DECLARE @hostsFactor INT = ISNULL((SELECT TOP(1) value FROM MMConfigs WHERE name = 'MMCONFIG_WEBSCALE_STORAGE_NUM_HOSTS_FACTOR'), 3)
	INSERT INTO APP_ClientGroup(name, description, flag, status, userId, refTime, modified, origCCId, fwPorts)
VALUES ('StoragePool', 'Media Agents in storage pool configuration', 4096 /*CV_FLAG_SMART_CLIENT_GROUP*/, 0, 1, @nowTime, 0, 2, ' ')
	SET @scgId = SCOPE_IDENTITY()
	-- refer vaultcx\Source\Include\AppMgr\AppClientGroupPropDefines.h
	INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@scgId, 'Client Group Unique Id', 7, 7, @nowTime, 0),
(@scgId, 'System Created', 7, 0, @nowTime, 0)
	--SCG_PKID_PACKAGE_INSTALLED=9=prodId
	DECLARE @MediaAgentsGroupRuleXML varchar(max) = '<scgRule op="0"><rules><rule op="0"><rules><rule filterID="108" propID="9" propType="6" value="&lt;?xml version=''1.0'' encoding=''UTF-8''?&gt;&lt;App_AdvanceKeyInfo&gt;&lt;packages val=&quot;1139&quot; /&gt;&lt;/App_AdvanceKeyInfo&gt;" /></rules></rule></rules></scgRule>'
	DECLARE @scgExitCode INT = 0
	DECLARE @scgExitMsg VARCHAR(1024) = ''
	EXEC APPSCGV2GenerateQueryParams @MediaAgentsGroupRuleXML, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @MediaAgentsGroupRuleQuery OUTPUT
	IF (@scgExitCode <> 0)
	BEGIN
		SET @err = @scgExitCode
		SET @errStr = @scgExitMsg
		RAISERROR(@errStr, 16, 1)
	END
    INSERT INTO App_SCGRule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
    VALUES(@scgId,
		@MediaAgentsGroupRuleXML,
        @MediaAgentsGroupRuleQuery,
        @ownerId, @nowTime, 0)
    INSERT INTO [UMUserandGroupEntityAssociation]
    ([userId] ,[groupId] ,[providerId] ,[capabilities] ,[entityType] ,[objectId] ,[ownerUserId])
    VALUES (@ownerId ,0 ,0 ,@allCapability ,2572 ,@scgId , 0)
	 INSERT INTO [UMSecurityAssociations] (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId)
                        SELECT @masterRoleId, 0, @ownerID, 1, 28, @scgId, 1, 1
	INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@scgId, 'StoragePool', N'BOOLEAN', 'CommServDB.MediaAgent', 'true', 1, 0, 28, 0, 0)
	INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@scgId, 'Disperse Factor', N'INTEGER', 'CommServDB.MediaAgent', cast(@disperseFactor as nvarchar(10)), 1, 0, 28, 0, 0)
	INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@scgId, 'Redundancy factor', N'INTEGER', 'CommServDB.MediaAgent', cast(@redundancyFactor as nvarchar(10)), 1, 0, 28, 0, 0)
	INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@scgId, 'No. of MediaAgents', N'INTEGER', 'CommServDB.MediaAgent', cast(@hostsFactor as nvarchar(10)), 1, 0, 28, 0, 0)
COMMIT TRAN WEBSCALE
END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        IF @@TRANCOUNT > 0
            ROLLBACK TRAN WEBSCALE
	SET @err = 1
        SET @errStr = N'Failed to create system defined StoragePool client group. ERROR_NUMBER: '+ cast(ISNULL(ERROR_NUMBER(), 0) as nvarchar(10))+' ERROR_LINE: '+cast(ISNULL(ERROR_LINE(), 0) as nvarchar(10))+ ' ERROR_MESSAGE: '+ISNULL(ERROR_MESSAGE(), '')+ ' ERROR_PROCEDURE: '+ISNULL(ERROR_PROCEDURE(), '')
        RAISERROR(@errStr, 16, 1)
 END CATCH
END
SELECT @err, @errStr

IF EXISTS (select * from GxQscripts where name = 'MMCreateStoragePoolInfo')
	delete from GxQscripts where name = 'MMCreateStoragePoolInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCreateStoragePoolInfo')
	delete from GXDBVersions where aliasname = 'MMCreateStoragePoolInfo'
GO

insert into GXDBVersions values(2, 'MMCreateStoragePoolInfo',  '00010001000200090000', 'MMCreateStoragePoolInfo', '00010001000200090000')
GO

