

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMConfigGetMountPathList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMConfigGetMountPathList.sp,v $ $Id: MMConfigGetMountPathList.sp,v 1.7.188.2 2018/03/20 19:59:19 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMediaAgentList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMConfigGetMountPathList <<<'

IF EXISTS (select * from sysobjects where name='MMConfigGetMountPathList')
	drop procedure MMConfigGetMountPathList
IF EXISTS (select * from GxQscripts where name='MMConfigGetMountPathList')
	delete from GxQscripts where name = 'MMConfigGetMountPathList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetMountPathList')
	delete from GXDBVersions where aliasname = 'MMConfigGetMountPathList'
GO
print '... Creating Procedure: MMConfigGetMountPathList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMConfigGetMountPathList
  @i_MAList nvarchar(2048)
AS
  DECLARE @o_mountPathID int
  DECLARE @o_libID int
  DECLARE @o_pathName varchar(1024)
  DECLARE @o_flags int
  DECLARE @o_availSpace int
  DECLARE @o_numReaders int
  DECLARE @o_numWriters int
  DECLARE @o_maxReaders int
  DECLARE @o_maxWriters int
  DECLARE @o_maxReadersAndWriters int
  DECLARE @o_userName varchar(1024)
  DECLARE @o_userPassword varchar(2048)
  DECLARE @o_mediaID int
  DECLARE @o_mediaSideID int
  DECLARE @o_isOffline int
  DECLARE @o_offlineReason int
  DECLARE @o_mountPathType int
  DECLARE @o_foreignAgantId int
  DECLARE @o_mountPathSpaceReservedInMb int
  DECLARE @o_maxDataToWriteMB int
  DECLARE @o_sizeOfValidData int
  DECLARE @o_attribute int
  DECLARE @o_NumItems int
  DECLARE @o_magneticChunkFileIncrSizeMB int 
	declare @SqlQuery	nvarchar(2048)
	declare @l_numItems	int
	set @l_numItems		= 0
	create table #tmpMountPath(
								mountPathID				int,
								libID					int,
								pathName				varchar(1024),
								flags					int,
								availSpace				bigint,
								numReaders				int,
								numWriters				int,
								maxReaders				int,
								maxWriters				int,
								maxReadersAndWriters	int,
								userName				varchar(1024),
								userPassword			varchar(2048),
								mediaID					int,
								mediaSideID				int,
								isOffline				int,
								offlineReason			int,
								mountPathType			int,
								foreignAgantId			int,
								mountPathSpaceReservedInMb	int,
								maxDataToWriteMB		int,
								sizeOfValidData			int,
								attribute				int,
								magneticChunkFileIncrSizeMB		int
								)
	DECLARE @maxIntVal INT = 2147483647
	IF len(@i_MAList) > 4
	BEGIN
		set @SqlQuery = ' insert into #tmpMountPath
						select MMP.MountPathID, MMP.LibraryId, MMP.MountPathName,
						MMP.ISEnabled, MMS.FreeBytesMB, -1, MMP.NumberOfWriters, -1,
						MMP.MaxConcurrentWriters, -1, MMP.UserName, MMP.UserPassword,
						MMS.MediaId, MMP.MediaSideId, MMP.IsOffLine, MMP.OfflineReason,
						MMP.MountPathTypeId, 0, MMP.MagneticSpaceRsrvInMB,
						MMP.MaxDataToWriteMB, 0, MMP.Attribute, MMP.MagneticChunkFileIncrSizeMB
						from MMMountPath as MMP, MMMediaSide as MMS
						where MountPathId > 0 AND MMP.MediaSideId = MMS.MediaSideId
						AND MasterPoolId IN(select MasterPoolId from MMDrivePool as MD, App_Client as CL
						WHERE CL.net_HostName IN ' + @i_MAList + 'AND Cl.Id = MD.CLientID)'
		EXEC(@SqlQuery)
	END
	ELSE
	BEGIN
		insert into #tmpMountPath
		select MMP.MountPathID, MMP.LibraryId, MMP.MountPathName,
		MMP.ISEnabled, MMS.FreeBytesMB, -1, MMP.NumberOfWriters, -1,
		MMP.MaxConcurrentWriters, -1, MMP.UserName, MMP.UserPassword,
		MMS.MediaId, MMP.MediaSideId, MMP.IsOffLine, MMP.OfflineReason,
		MMP.MountPathTypeId, 0, MMP.MagneticSpaceRsrvInMB,
		MMP.MaxDataToWriteMB, 0, MMP.Attribute, MMP.MagneticChunkFileIncrSizeMB
		from MMMountPath as MMP, MMMediaSide as MMS
		where MountPathId > 0 AND MMP.MediaSideId = MMS.MediaSideId
	END
	set @l_numItems = (select count(*) from #tmpMountPath)
	update #tmpMountPath
	set maxReaders = MMT.MaxConcurrentReaders, maxWriters = MMT.MaxConcurrentWriters,
	maxReadersAndWriters = MaxConcurrentReadersAndWriters
	From MMMediaType as MMT, MMMedia as MM
	where #tmpMountPath.maxWriters = -1 AND #tmpMountPath.MediaId = MM.MediaId
	AND MM.MediaTypeID = MMT.MediaTypeId
	update #tmpMountPath
	set foreignAgantId = CenteraId
	from MMMountPathToStorageDevice as MPS
	where #tmpMountPath.MountPathType = 1 AND #tmpMountPath.MountPathId = MPS.MountPathId
	update #tmpMountPath
	set foreignAgantId = DeviceId
	from MMMountPathToStorageDevice as MPS
	-- MOUNT_PATH_DYNAMIC_SHARED, MOUNT_PATH_TAPE,	MOUNT_PATH_SHARED_STATIC, MOUNT_PATH_SHARED_REPLICA, MOUNT_PATH_DRU, MOUNT_PATH_EXTERNAL_REMOTE_HOST
	where #tmpMountPath.MountPathType IN(2, 3, 4, 5, 6, 7)AND #tmpMountPath.MountPathId = MPS.MountPathId
	select mountPathID, libID, pathName, flags, (CASE WHEN (availSpace < @maxIntVal) THEN availSpace ELSE @maxIntVal END) AS availSpace,
	numReaders, numWriters,	maxReaders, maxWriters, maxReadersAndWriters, userName, userPassword, mediaID,
	mediaSideID, isOffline, offlineReason, mountPathType, foreignAgantId,
	mountPathSpaceReservedInMb, maxDataToWriteMB, sizeOfValidData, attribute, @l_numItems, magneticChunkFileIncrSizeMB
	from #tmpMountPath
	drop table #tmpMountPath
GO

IF EXISTS (select * from GxQscripts where name = 'MMConfigGetMountPathList')
	delete from GxQscripts where name = 'MMConfigGetMountPathList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetMountPathList')
	delete from GXDBVersions where aliasname = 'MMConfigGetMountPathList'
GO

insert into GXDBVersions values(2, 'MMConfigGetMountPathList',  '00010007018800020000', 'MMConfigGetMountPathList', '00010007018800020000')
GO

