

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMConfigGetMediaAgentList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMConfigGetMediaAgentList.sp,v $ $Id: MMConfigGetMediaAgentList.sp,v 1.18.36.2 2018/03/20 19:50:25 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMediaAgentList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMConfigGetMediaAgentList <<<'

IF EXISTS (select * from sysobjects where name='MMConfigGetMediaAgentList')
	drop procedure MMConfigGetMediaAgentList
IF EXISTS (select * from GxQscripts where name='MMConfigGetMediaAgentList')
	delete from GxQscripts where name = 'MMConfigGetMediaAgentList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetMediaAgentList')
	delete from GXDBVersions where aliasname = 'MMConfigGetMediaAgentList'
GO
print '... Creating Procedure: MMConfigGetMediaAgentList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMConfigGetMediaAgentList
  @i_MAList nvarchar(2048)
AS
  DECLARE @o_ClientId integer
  DECLARE @o_netHostName nvarchar(255)
  DECLARE @o_clientName nvarchar(255)
  DECLARE @o_hostType integer
  DECLARE @o_softState integer
  DECLARE @o_enabled integer
  DECLARE @o_MAOfflineReason integer
  DECLARE @o_SimOsId integer
  DECLARE @o_NumItems integer
  DECLARE @o_MAInstallDir nvarchar(255)
  DECLARE @o_MAAttribute integer
	declare @SqlQuery	nvarchar(2048)
	declare @l_numItems	int
	set @l_numItems		= 0
	create table #tmpMAListForConfig(	ClientId		int,
										net_HostName	nvarchar(255),
										ClientName		nvarchar(255),
										HostType		int,
										HostSoftState	int,
										HostEnabled		int,
										OfflineReason	int,
										SystemOSId		int,
										MAInstallDir	nvarchar(255),
										Attribute		int
									)
	IF len(@i_MAList) > 4
	BEGIN
		set @SqlQuery = ' insert into #tmpMAListForConfig
		select	MH.ClientId, CL.net_hostName, CL.name, MH.MMHostType, MH.MMHostSoftState,
				MH.MMHostEnabled, MH.OfflineReason, CL.simOperatingSystemId, '', MH.Attribute
		from MMHost as MH, App_client as CL
		where CL.Net_HostName IN ' + @i_MAList + ' AND CL.id = MH.ClientId'
		EXEC(@SqlQuery)
	END
	ELSE
	BEGIN
		insert into #tmpMAListForConfig
		select	MH.ClientId, CL.net_hostName, CL.name, MH.MMHostType, MH.MMHostSoftState,
				MH.MMHostEnabled, MH.OfflineReason, CL.simOperatingSystemId, '', MH.Attribute
		from MMHost as MH, App_client as CL
		where MH.ClientId > 1 AND MH.ClientId = CL.id
	END
	update #tmpMAListForConfig
	set MAInstallDir = (select top 1 P.install_dir from APP_Platform P where P.ClientId = #tmpMAListForConfig.ClientId)
	--Do not send the unlicensed MediaAgents in the list.
	delete from #tmpMAListForConfig
	where ClientId NOT IN(select cId from LicUsage where AppType = 1002 AND Lictype NOT IN (71, 10, 26))
	AND ClientId NOT IN(select ClientId from MMLibraryController)
	AND ClientId NOT IN(select ClientId from MMDriveController)
	AND ClientId NOT IN(select ClientId from MMDrivePool)
	AND ClientId NOT IN(select ClientId from MMDeviceController)
AND (Attribute & 8192) <> 8192
	set @l_numItems = (select count(*) from #tmpMAListForConfig)
	select ClientId, net_HostName, ClientName, HostType, HostSoftState,
	HostEnabled, OfflineReason, SystemOSId, @l_numItems as NumItems, MAInstallDir, Attribute
	from #tmpMAListForConfig
	drop table #tmpMAListForConfig
GO

IF EXISTS (select * from GxQscripts where name = 'MMConfigGetMediaAgentList')
	delete from GxQscripts where name = 'MMConfigGetMediaAgentList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetMediaAgentList')
	delete from GXDBVersions where aliasname = 'MMConfigGetMediaAgentList'
GO

insert into GXDBVersions values(2, 'MMConfigGetMediaAgentList',  '00010018003600020000', 'MMConfigGetMediaAgentList', '00010018003600020000')
GO

