

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMConfigGetMasterPoolList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMConfigGetMasterPoolList.sp,v $ $Id: MMConfigGetMasterPoolList.sp,v 1.4.294.2 2018/03/20 19:43:36 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMediaAgentList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMConfigGetMasterPoolList <<<'

IF EXISTS (select * from sysobjects where name='MMConfigGetMasterPoolList')
	drop procedure MMConfigGetMasterPoolList
IF EXISTS (select * from GxQscripts where name='MMConfigGetMasterPoolList')
	delete from GxQscripts where name = 'MMConfigGetMasterPoolList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetMasterPoolList')
	delete from GXDBVersions where aliasname = 'MMConfigGetMasterPoolList'
GO
print '... Creating Procedure: MMConfigGetMasterPoolList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMConfigGetMasterPoolList
  @i_MAList nvarchar(2048)
AS
  DECLARE @o_MasterPoolId int
  DECLARE @o_MasterPoolName NVARCHAR(64)
  DECLARE @o_MPSoftState int
  DECLARE @o_MPEnabled int
  DECLARE @o_LibraryId int
  DECLARE @o_TotalDrives int
  DECLARE @o_ReservedDrives int
  DECLARE @o_MaxSwitchForHost int
  DECLARE @o_DriveTypeId int
  DECLARE @o_NumItems int
	declare @SqlQuery	nvarchar(2048)
	declare @l_numItems	int
	set @l_numItems		= 0
	create table #tmpMP	(		MasterPoolId		int,
								MasterPoolName		nvarchar(64),
								MPSoftState			int,
								MPEnabled			int,
								LibraryId			int,
								TotalDrives			int,
								ReservedDrives		int,
								MaxSwitchForHost	int,
								DriveTypeId			int
							)
	IF len(@i_MAList) > 4
	BEGIN
		set @SqlQuery = ' insert into #tmpMP
		select distinct MM.MasterPoolId, MM.MasterPoolName, MM.MasterPoolSoftState, MM.MasterPoolEnabled, MM.LibraryId,
		MM.TotalDrives, MM.ReservedDrives, MM.MaxSwitchForHost, MM.DriveTypeId
		from MMMasterPool as MM, MMDrivePool as MD, App_Client as CL
		where CL.net_HostName IN ' + @i_MAList + ' AND CL.id = MD.ClientId
		AND MD.MasterPoolId = MM.MasterPoolId '
		EXEC(@SqlQuery)
		INSERT INTO #tmpMP
		select MM.MasterPoolId, MM.MasterPoolName, MM.MasterPoolSoftState, MM.MasterPoolEnabled, MM.LibraryId,
		MM.TotalDrives, MM.ReservedDrives, MM.MaxSwitchForHost, MM.DriveTypeId
		from MMMasterPool as MM
		where EXISTS(select MDP.DrivePoolId
						from MMLibraryController as MLC, MMDrivePool as MDP
						where MM.LibraryId = MLC.LibraryId AND MDP.MasterPoolId =MM.MasterPoolId
						AND MDP.ClientId <> MLC.ClientId)
		AND NOT EXISTS(select #tmpMP.MasterPoolId from #tmpMP where #tmpMP.MasterPoolId = MM.MasterPoolId)
	END
	ELSE
	BEGIN
		insert into #tmpMP
		select distinct MM.MasterPoolId, MM.MasterPoolName, MM.MasterPoolSoftState, MM.MasterPoolEnabled, MM.LibraryId,
		MM.TotalDrives, MM.ReservedDrives, MM.MaxSwitchForHost, MM.DriveTypeId
		from MMMasterPool as MM
		where MM.MasterPoolId > 0
	END
	UPDATE #tmpMP
	SET ReservedDrives = ISNULL((select count(*) from MMResource as R where R.MasterPoolId = #tmpMP.MasterPoolId), 0)
	UPDATE #tmpMP
	SET MaxSwitchForHost = TotalDrives
	WHERE MaxSwitchForHost = -1
	set @l_numItems = (select count(*) from #tmpMP)
	select MasterPoolId, MasterPoolName, MPSoftState, MPEnabled, LibraryId, TotalDrives, ReservedDrives,
	MaxSwitchForHost, DriveTypeId, @l_numItems as NumItems
	from #tmpMP
	drop table #tmpMP
GO

IF EXISTS (select * from GxQscripts where name = 'MMConfigGetMasterPoolList')
	delete from GxQscripts where name = 'MMConfigGetMasterPoolList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetMasterPoolList')
	delete from GXDBVersions where aliasname = 'MMConfigGetMasterPoolList'
GO

insert into GXDBVersions values(2, 'MMConfigGetMasterPoolList',  '00010004029400020000', 'MMConfigGetMasterPoolList', '00010004029400020000')
GO

