

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMConfigGetLibraryList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMConfigGetLibraryList.sp,v $ $Id: MMConfigGetLibraryList.sp,v 1.8.292.2 2018/03/20 19:57:42 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMediaAgentList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMConfigGetLibraryList <<<'

IF EXISTS (select * from sysobjects where name='MMConfigGetLibraryList')
	drop procedure MMConfigGetLibraryList
IF EXISTS (select * from GxQscripts where name='MMConfigGetLibraryList')
	delete from GxQscripts where name = 'MMConfigGetLibraryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetLibraryList')
	delete from GXDBVersions where aliasname = 'MMConfigGetLibraryList'
GO
print '... Creating Procedure: MMConfigGetLibraryList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMConfigGetLibraryList
  @i_MAList nvarchar(2048)
AS
  DECLARE @o_LibraryId integer
  DECLARE @o_LibraryName varchar(128)
  DECLARE @o_AliasName NVARCHAR(128)
  DECLARE @o_LibraryTypeId integer
  DECLARE @o_SubType integer
  DECLARE @o_vendor varchar(128)
  DECLARE @o_model varchar(128)
  DECLARE @o_firmware varchar(128)
  DECLARE @o_serialNumber varchar(128)
  DECLARE @o_WWN varchar(128)
  DECLARE @o_GUID varchar(128)
  DECLARE @o_BaseAddress int
  DECLARE @o_DriveCount int
  DECLARE @o_IsBarCodeReaderPresent int
  DECLARE @o_PrivateData varchar(256)
  DECLARE @o_TURInterval int
  DECLARE @o_ConfigParam varchar(256)
  DECLARE @o_Attribute int
  DECLARE @o_ExtendedAttributes int
  DECLARE @o_DefaultMediaTypeId int
  DECLARE @o_LowWaterMarkMB int
  DECLARE @o_VTLType int
  DECLARE @o_ClientId int
  DECLARE @o_net_HostName nvarchar(1024)
  DECLARE @o_NumItems integer
	declare @SqlQuery	nvarchar(2048)
	declare @l_numItems	int
	set @l_numItems		= 0
	create table #tmpLibrary	(	LibId					int,
									libName					varchar(128),
									AliasNAme				nvarchar(128),
									libType					int,
									subType					int,
									vendor					varchar(128),
									model					varchar(128),
									firmware				varchar(128),
									serialNumber			varchar(128),
									WWN						varchar(128),
									GUID					varchar(128),
									BaseAddress				int,
									DriveCount				int,
									IsBarCodeReaderPresent	int,
									PrivateData				varchar(256),
									TURInterval				int,
									ConfigParam				varchar(256),
									Attribute				int,
									ExtendedAttributes		int,
									DefaultMediaTypeId		int,
									LowWaterMarkMB			int,
									VTLType					int,
									ClientId				int,
									net_HostName			nvarchar(1024)
								)
	IF len(@i_MAList) > 4
	BEGIN
		set @SqlQuery = ' insert into #tmpLibrary
			select ML.LibraryId, ML.LibraryName, ML.AliasName, ML.LibraryTypeId, ML.LibrarySubType,
			ML.LibraryVendor, ML.LibraryModel, ML.FirmwareRevision, ML.SerialNumber, ML.WWNNumber,
			ML.ExternalGUID, ML.BaseAddress, ML.DriveCount, ML.BarCodeReaderPresent, ML.PrivateData,
			ML.TURIntervalinSec, ML.ConfigParams, ML.LibraryAttribute, ML.ExtendedAttributes, ML.DefaultMediaTypeId,
			ML.LowWaterMarkMB, ML.VTLType, 0,' + '''' + '''' +
			'from MMLibrary as ML, MMLibraryController as LC, App_Client as CL
			where CL.net_HostName IN' + @i_MAList +
			'AND CL.id = LC.ClientId AND LC.LibraryId = ML.LibraryId AND ML.LibraryId > 0'
		EXEC(@SqlQuery)
		insert into #tmpLibrary
		select ML.LibraryId, ML.LibraryName, ML.AliasName, ML.LibraryTypeId, ML.LibrarySubType,
			ML.LibraryVendor, ML.LibraryModel, ML.FirmwareRevision, ML.SerialNumber, ML.WWNNumber,
			ML.ExternalGUID, ML.BaseAddress, ML.DriveCount, ML.BarCodeReaderPresent, ML.PrivateData,
			ML.TURIntervalinSec, ML.ConfigParams, ML.LibraryAttribute, ML.ExtendedAttributes, ML.DefaultMediaTypeId,
			ML.LowWaterMarkMB, ML.VTLType, 0, ''
		from MMLibraryController as MLC, MMLibrary as ML
		where EXISTS(select MDP.DrivePoolId
						from MMMasterPool as MM, MMDrivePool as MDP
						where MM.LibraryId = MLC.LibraryId AND MDP.MasterPoolId =MM.MasterPoolId
						AND MDP.ClientId <> MLC.ClientId)
		AND MLC.LibraryId = ML.LibraryId
		AND NOT EXISTS(Select LibId from #tmpLibrary where LibId = ML.LibraryId)
	END
	ELSE
	BEGIN
		insert into #tmpLibrary
			select ML.LibraryId, ML.LibraryName, ML.AliasName, LibraryTypeId, LibrarySubType,
			ML.LibraryVendor, ML.LibraryModel, ML.FirmwareRevision, ML.SerialNumber, ML.WWNNumber,
			ML.ExternalGUID, ML.BaseAddress, ML.DriveCount, ML.BarCodeReaderPresent, ML.PrivateData,
			ML.TURIntervalinSec, ML.ConfigParams, ML.LibraryAttribute, ML.ExtendedAttributes, ML.DefaultMediaTypeId,
			ML.LowWaterMarkMB, ML.VTLType, 0, ''
			from MMLibrary as ML
			WHERE ML.LibraryId > 0
	END
	set @l_numItems = (select count(*) from #tmpLibrary)
	Update #tmpLibrary
	set ClientId = CL.id, net_HostName = CL.net_HostName
	from MMMountPath as MMP, MMDrivePool as MDP, App_Client as CL
	where #tmpLibrary.LibType = 3 AND #tmpLibrary.LibId = MMP.LibraryId
	AND MMP.MasterPoolId = MDP.MasterPoolId AND MDP.ClientId = CL.id
	--When there are no MOunt Paths configured, then there is no drive pool
	--So, in this case, get the client name from the libraryController table
	Update #tmpLibrary
	set ClientId = CL.id, net_HostName = CL.net_HostName
	from MMMountPath as MMP, MMLibraryController as MLC, App_Client as CL
	where #tmpLibrary.LibType = 3 AND #tmpLibrary.ClientId = 0 AND #tmpLibrary.LibId = MLC.LibraryId
	AND MLC.ClientId = CL.id
	select LibId, libName, AliasNAme, libType, subType, vendor, model, firmware,
	serialNumber, WWN, GUID, BaseAddress, DriveCount, IsBarCodeReaderPresent,
	PrivateData, TURInterval, ConfigParam, Attribute, ExtendedAttributes, DefaultMediaTypeId, LowWaterMarkMB,
	VTLType, ClientId, net_HostName, @l_numItems as NumItems
	from #tmpLibrary
	drop table #tmpLibrary
GO

IF EXISTS (select * from GxQscripts where name = 'MMConfigGetLibraryList')
	delete from GxQscripts where name = 'MMConfigGetLibraryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetLibraryList')
	delete from GXDBVersions where aliasname = 'MMConfigGetLibraryList'
GO

insert into GXDBVersions values(2, 'MMConfigGetLibraryList',  '00010008029200020000', 'MMConfigGetLibraryList', '00010008029200020000')
GO

