

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMConfigGetLCPList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMConfigGetLCPList.sp,v $ $Id: MMConfigGetLCPList.sp,v 1.4.304.3 2018/03/20 19:52:58 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetLCPList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMConfigGetLCPList <<<'

IF EXISTS (select * from sysobjects where name='MMConfigGetLCPList')
	drop procedure MMConfigGetLCPList
IF EXISTS (select * from GxQscripts where name='MMConfigGetLCPList')
	delete from GxQscripts where name = 'MMConfigGetLCPList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetLCPList')
	delete from GXDBVersions where aliasname = 'MMConfigGetLCPList'
GO
print '... Creating Procedure: MMConfigGetLCPList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMConfigGetLCPList
  @i_MAList nvarchar(2048)
AS
  DECLARE @o_LibraryControllerId int
  DECLARE @o_clientId int
  DECLARE @o_LCPSoftState int
  DECLARE @o_LCPActive int
  DECLARE @o_LCPAlive int
  DECLARE @o_LCPEnabled int
  DECLARE @o_LCPType int
  DECLARE @o_clientHostName nvarchar(255)
  DECLARE @o_SCSIId varchar(32)
  DECLARE @o_LCPName varchar(144)
  DECLARE @o_ConnectionType int
  DECLARE @o_sServerVersion varchar(32)
  DECLARE @o_sNetHostName varchar(255)
  DECLARE @o_sDeviceName varchar(64)
  DECLARE @o_LibraryId int
  DECLARE @o_NumItems int
	declare @SqlQuery	nvarchar(2048)
	declare @l_numItems	int
	set @l_numItems		= 0
	create table #tmpLCP	(	LibraryControllerId	int,
								clientId			int,
								LCPSoftState		int,
								LCPActive			int,
								LCPAlive			int,
								LCPEnabled			int,
								LCPType				int,
								clientHostName		nvarchar(1024),
								SCSIId				varchar(32),
								LCPName				varchar(144),
								ConnectionType		int,
								sServerVersion		varchar(32),
								sNetHostName		varchar(1024),
								sDeviceName			varchar(64),
								LibraryId			int
							)
	IF len(@i_MAList) > 4
	BEGIN
		set @SqlQuery = ' insert into #tmpLCP
		select	LC.LibraryControllerId, LC.ClientId, LC.LibraryControllerSoftState, LC.LibraryControllerActive,
		LC.LibraryControllerEnabled, LC.LibraryControllerEnabled, LC.LibraryControllerType, CL.net_hostName,
		LC.SCSIId, LC.LibraryControllerName, LC.ConnectionType,' + '''' + '''' + ', ' +
		'''' + '''' + ', ' + '''' + '''' + ', ' + 'LC.LibraryId
		from App_client as CL, MMLibraryController as LC
		where CL.Net_HostName IN ' + @i_MAList + ' AND CL.id = LC.ClientId AND LC.LibraryControllerType <> 4'
		EXEC(@SqlQuery)
		INSERT INTO #tmpLCP
		select LC.LibraryControllerId, LC.ClientId, LC.LibraryControllerSoftState, LC.LibraryControllerActive,
		LC.LibraryControllerEnabled, LC.LibraryControllerEnabled, LC.LibraryControllerType, CL.net_hostName,
		LC.SCSIId, LC.LibraryControllerName, LC.ConnectionType, '', '', '', LC.LibraryId
		from MMLibraryController as LC, App_Client as CL
		where EXISTS(select MDP.DrivePoolId
						from MMMasterPool as MM, MMDrivePool as MDP
						where MM.LibraryId = LC.LibraryId AND MDP.MasterPoolId =MM.MasterPoolId
						AND MDP.ClientId <> LC.ClientId)
		AND NOT EXISTS(Select LibraryControllerId from #tmpLCP
						where #tmpLCP.LibraryControllerId = LC.LibraryControllerId)
		AND LC.ClientId = Cl.id
		AND LC.LibraryControllerType <> 4
	END
	ELSE
	BEGIN
		insert into #tmpLCP
		select	LC.LibraryControllerId, LC.ClientId, LC.LibraryControllerSoftState, LC.LibraryControllerActive,
		LC.LibraryControllerEnabled, LC.LibraryControllerEnabled, LC.LibraryControllerType, CL.net_hostName,
		LC.SCSIId, LC.LibraryControllerName, LC.ConnectionType, '', '', '', LC.LibraryId
		from App_client as CL, MMLibraryController as LC
		where LC.LibraryControllerId > 0 AND CL.id = LC.ClientId
		AND LC.LibraryControllerType <> 4
	END
	UPDATE #tmpLCP
	SET sServerVersion = MM.ServerVersion, sNetHostName	= CL.name, sDeviceName = MM.DeviceName
	FROM MMLibraryHostInfo as MM, MMNDMPHostInfo as NDMP, APP_Client AS CL
	WHERE ConnectionType > 0 AND MM.LibraryControllerId = #tmpLCP.LibraryControllerId
	AND MM.NDMPHostId = NDMP.NDMPHostId
	AND NDMP.ClientId = CL.Id
	set @l_numItems = (select count(*) from #tmpLCP)
	select LibraryControllerId, clientId, LCPSoftState, LCPActive, LCPAlive, LCPEnabled, LCPType,
	clientHostName, SCSIId, LCPName, ConnectionType, sServerVersion, sNetHostName, sDeviceName, LibraryId,
	@l_numItems as NumItems
	from #tmpLCP
	drop table #tmpLCP
GO

IF EXISTS (select * from GxQscripts where name = 'MMConfigGetLCPList')
	delete from GxQscripts where name = 'MMConfigGetLCPList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetLCPList')
	delete from GXDBVersions where aliasname = 'MMConfigGetLCPList'
GO

insert into GXDBVersions values(2, 'MMConfigGetLCPList',  '00010004030400030000', 'MMConfigGetLCPList', '00010004030400030000')
GO

