

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMConfigGetDrivePoolList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMConfigGetDrivePoolList.sp,v $ $Id: MMConfigGetDrivePoolList.sp,v 1.5.274.4 2018/03/20 19:58:03 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetDrivePoolList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMConfigGetDrivePoolList <<<'

IF EXISTS (select * from sysobjects where name='MMConfigGetDrivePoolList')
	drop procedure MMConfigGetDrivePoolList
IF EXISTS (select * from GxQscripts where name='MMConfigGetDrivePoolList')
	delete from GxQscripts where name = 'MMConfigGetDrivePoolList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetDrivePoolList')
	delete from GXDBVersions where aliasname = 'MMConfigGetDrivePoolList'
GO
print '... Creating Procedure: MMConfigGetDrivePoolList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMConfigGetDrivePoolList
  @i_MAList nvarchar(2048)
AS
  DECLARE @o_llDrivePoolId int
  DECLARE @o_sDrivePoolName NVARCHAR(255)
  DECLARE @o_MAClientId int
  DECLARE @o_sMediaAgentHostname nvarchar(255)
  DECLARE @o_llLibraryId int
  DECLARE @o_iDrivePoolType int
  DECLARE @o_masterDrivePoolId int
  DECLARE @o_NDMPHostId int
  DECLARE @o_sProxyClientHost nvarchar(255)
  DECLARE @o_sProxyClientLogin varchar(1024)
  DECLARE @o_sProxyClientPassword varchar(2048)
  DECLARE @o_copyManagerCtrlId int
  DECLARE @o_CostCategoryID int
  DECLARE @o_NumItems int
	declare @SqlQuery	nvarchar(2048)
	declare @l_numItems	int
	set @l_numItems		= 0
	create table #tmpDP	(
						llDrivePoolId				int,
						sDrivePoolName				nvarchar(255),
						clientId					int,
						sMediaAgentHostname			nvarchar(510),
						llLibraryId					int,
						iDrivePoolType				int,
						masterDrivePoolId			int,
						NDMPHostId					int,
						sProxyClientHost			nvarchar(510),
						sProxyClientLogin			varchar(1024),
						sProxyClientPassword		varchar(2048),
						copyManagerCtrlId			int,
						CostCategoryID				int,
						)
	IF len(@i_MAList) > 4
	BEGIN
		set @SqlQuery = ' insert into #tmpDP
		select distinct MD.DrivePoolId, MD.DrivePoolName, CL.id, CL.Net_hostName, MM.LibraryId,
		MD.DrivePoolType, MD.MasterPoolId, MD.NDMPHostId, ' + '''' + '''' + ',' + '''' + '''' + ','
		+ '''' + '''' + ',  MD.CopyManagerCtrlId, MD.CostCategoryId
		from MMDrivePool as MD, App_Client as CL, MMMasterPool as MM
		where CL.net_HostName IN ' + @i_MAList + ' AND CL.id = MD.ClientId AND MD.MasterPoolId = MM.MasterPoolId '
		EXEC(@SqlQuery)
	END
	ELSE
	BEGIN
		insert into #tmpDP
		select distinct MD.DrivePoolId, MD.DrivePoolName, CL.id, CL.Net_hostName, MM.LibraryId,
		MD.DrivePoolType, MD.MasterPoolId, MD.NDMPHostId, '', '' , '',
		MD.CopyManagerCtrlId, MD.CostCategoryId
		from App_Client as CL, MMDrivePool as MD, MMMasterPool as MM
		where MD.DrivePoolId > 0 AND MD.MasterPoolId = MM.MasterPoolId AND MD.ClientId = CL.id
	END
	UPDATE 	#tmpDP
	SET sProxyClientHost = CL.name, sProxyClientLogin	= NDMP.Login,
	sProxyClientPassword = NDMP.Password
	FROM MMNDMPHostInfo as NDMP, App_Client AS CL
	WHERE #tmpDP.iDrivePoolType = 3 AND #tmpDP.NDMPHostId = NDMP.NDMPHostId
	AND NDMP.ClientId = CL.Id
	set @l_numItems = (select count(*) from #tmpDP)
	select llDrivePoolId, sDrivePoolName, clientId, sMediaAgentHostname, llLibraryId, iDrivePoolType,
	masterDrivePoolId, NDMPHostId, sProxyClientHost, sProxyClientLogin, sProxyClientPassword,
	copyManagerCtrlId, CostCategoryID, @l_numItems
	from #tmpDP
	drop table #tmpDP
GO

IF EXISTS (select * from GxQscripts where name = 'MMConfigGetDrivePoolList')
	delete from GxQscripts where name = 'MMConfigGetDrivePoolList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetDrivePoolList')
	delete from GXDBVersions where aliasname = 'MMConfigGetDrivePoolList'
GO

insert into GXDBVersions values(2, 'MMConfigGetDrivePoolList',  '00010005027400040000', 'MMConfigGetDrivePoolList', '00010005027400040000')
GO

