

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMConfigGetDriveList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMConfigGetDriveList.sp,v $ $Id: MMConfigGetDriveList.sp,v 1.6.292.2 2018/03/20 19:57:45 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMS2GetMediaAgentList"				|
--	|									|
--	| Execute the System stored procedure to fetch the physical files	|
--	| .. for the (current) database.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMConfigGetDriveList <<<'

IF EXISTS (select * from sysobjects where name='MMConfigGetDriveList')
	drop procedure MMConfigGetDriveList
IF EXISTS (select * from GxQscripts where name='MMConfigGetDriveList')
	delete from GxQscripts where name = 'MMConfigGetDriveList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetDriveList')
	delete from GXDBVersions where aliasname = 'MMConfigGetDriveList'
GO
print '... Creating Procedure: MMConfigGetDriveList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMConfigGetDriveList
  @i_MAList nvarchar(2048)
AS
  DECLARE @o_driveID int
  DECLARE @o_mediaID int
  DECLARE @o_drvName varchar(1024)
  DECLARE @o_drvAliasName NVARCHAR(1024)
  DECLARE @o_Values_driveType int
  DECLARE @o_Values_driveTypeString varchar(64)
  DECLARE @o_Values_numRestoresLifeTime int
  DECLARE @o_Values_numBackupsLifeTime int
  DECLARE @o_Values_numMountsLifeTime int
  DECLARE @o_Values_numSoftErrsSinceClean int
  DECLARE @o_Values_numSoftErrsLifeTime int
  DECLARE @o_Values_numHardErrsSinceClean int
  DECLARE @o_Values_numHardErrsLifeTime int
  DECLARE @o_Values_numMtsUsedSinceClean int
  DECLARE @o_Values_numMtsUsedLifeTime int
  DECLARE @o_Values_CleaningDurationSec int
  DECLARE @o_Values_lastCleanTime int
  DECLARE @o_Values_lastServiceTime int
  DECLARE @o_Values_driveCategory int
  DECLARE @o_thresholds_driveType int
  DECLARE @o_thresholds_driveTypeString varchar(64)
  DECLARE @o_thresholds_numRestoresLifeTime int
  DECLARE @o_thresholds_numBackupsLifeTime int
  DECLARE @o_thresholds_numMountsLifeTime int
  DECLARE @o_thresholds_numSoftErrsSinceClean int
  DECLARE @o_thresholds_numSoftErrsLifeTime int
  DECLARE @o_thresholds_numHardErrsSinceClean int
  DECLARE @o_thresholds_numHardErrsLifeTime int
  DECLARE @o_thresholds_numMtsUsedSinceClean int
  DECLARE @o_thresholds_numMtsUsedLifeTime int
  DECLARE @o_thresholds_CleaningDurationSec int
  DECLARE @o_thresholds_lastCleanTime int
  DECLARE @o_thresholds_lastServiceTime int
  DECLARE @o_thresholds_driveCategory int
  DECLARE @o_MasterPoolId int
  DECLARE @o_LibraryId int
  DECLARE @o_libName varchar(256)
  DECLARE @o_libAliasName NVARCHAR(256)
  DECLARE @o_manufacturer varchar(64)
  DECLARE @o_model varchar(64)
  DECLARE @o_description NVARCHAR(64)
  DECLARE @o_serialNumber varchar(64)
  DECLARE @o_wwn varchar(64)
  DECLARE @o_driveNumber int
  DECLARE @o_drvBroken int
  DECLARE @o_drvEnabled int
  DECLARE @o_cleaningRequired int
  DECLARE @o_offlineReason int
  DECLARE @o_softState int
  DECLARE @o_driveGuid varchar(64)
  DECLARE @o_attribute int
  DECLARE @o_privateData varchar(256)
  DECLARE @o_ElementAddress int
  DECLARE @o_isOccupied int
  DECLARE @o_SCSIDeviceIdentifier varchar(256)
  DECLARE @o_NumItems int
	declare @SqlQuery	nvarchar(2048)
	declare @l_numItems	int
	set @l_numItems		= 0
	create table #tmpDrive(
							driveID	int,
							mediaID	int,
							drvName	varchar(1024),
							drvAliasName nvarchar(1024),
							Values_driveType	int,
							Values_driveTypeString varchar(64),
							Values_numRestoresLifeTime	int,
							Values_numBackupsLifeTime	int,
							Values_numMountsLifeTime	int,
							Values_numSoftErrsSinceClean	int,
							Values_numSoftErrsLifeTime	int,
							Values_numHardErrsSinceClean	int,
							Values_numHardErrsLifeTime	int,
							Values_numMtsUsedSinceClean	int,
							Values_numMtsUsedLifeTime	int,
							Values_CleaningDurationSec	int,
							Values_lastCleanTime	int,
							Values_lastServiceTime	int,
							Values_driveCategory	int,
							thresholds_driveType	int,
							thresholds_driveTypeString	varchar(64),
							thresholds_numRestoresLifeTime	int,
							thresholds_numBackupsLifeTime	int,
							thresholds_numMountsLifeTime	int,
							thresholds_numSoftErrsSinceClean	int,
							thresholds_numSoftErrsLifeTime	int,
							thresholds_numHardErrsSinceClean	int,
							thresholds_numHardErrsLifeTime	int,
							thresholds_numMtsUsedSinceClean	int,
							thresholds_numMtsUsedLifeTime	int,
							thresholds_CleaningDurationSec	int,
							thresholds_lastCleanTime	int,
							thresholds_lastServiceTime int,
							thresholds_driveCategory int,
							MasterPoolId	int,
							LibraryId	int,
							libName	varchar(256),
							libAliasName nvarchar(256),
							manufacturer varchar(64),
							model varchar(64),
							description	nvarchar(64),
							serialNumber varchar(64),
							wwn varchar(64),
							driveNumber	int,
							drvBroken	int,
							drvEnabled	int,
							cleaningRequired	int,
							offlineReason	int,
							softState	int,
							driveGuid	varchar(64),
							attribute	int,
							privateData	varchar(256),
							ElementAddress	int,
							isOccupied	int,
							SCSIDeviceIdentifier varchar(256)
						)
	IF len(@i_MAList) > 4
	BEGIN
		set @SqlQuery = 'insert into #tmpDrive
			select MD.DriveId, MD.MediaId, Md.DriveName, MD.AliasName, MD.DriveTypeId, MDT.DriveTypeName,
			MD.NumRestoresLifeTime, MD.NumBackupsLifeTime, MD.NumMountsLifeTime, MD.NumSoftErrsSinceClean,
			MD.NumSoftErrsLifeTime, MD.NumHardErrsSinceClean, MD.NumHardErrsLifeTime, MD.MinutesUsedSinceClean,
			MD.MinutesUsedLifeTime, MDT.CleaningDurationSec, MD.LastCleantime, MD.LastServiceTime, MDT.TypeOfDrive,
			MD.DriveTypeId, MDT.DriveTypeName, MD.NumRestoresLifeTime, MD.NumBackupsLifeTime, MD.NumMountsLifeTime,
			MDT.SoftErrsSinceCleanThreshold, MDT.SoftErrsLifeTimeThreshold, MDT.HardErrsSinceCleanThreshold,
			MDT.HardErrsLifeTimeThreshold, MDT.MtsUsedSinceCleanThreshold, MDT.MtsUsedLifeTimeThreshold,
			MDT.CleaningDurationSec, MD.LastCleantime, MD.LastServiceTime, MDT.TypeOfDrive, MD.MasterPoolId,
			0,' + '''' + '''' + ' , ' +  '''' + '''' + ', MD.DriveVendor, MD.DriveModel, MD.FirmwareRevision, MD.SerialNumber, MD.WWNNumber,
			MD.DriveNumber, MD.DriveBroken, MD.DriveEnabled, MD.CleaningRequired, MD.OfflineReason,
			MD.DriveSoftState, MD.ExternalGUID, MD.Attributes, MD.PrivateData, 0,
			MD.DriveOccupied, MD.SCSIDeviceIdentifier
			from MMDrive AS MD, MMDriveType as MDT
			where MD.DriveTypeId <> 10001 AND MD.DriveId > 0
			AND MD.DriveTypeId = MDT.DriveTypeId AND MD.MasterPoolId IN
				(select distinct MDP.MasterPoolId from MMDrivePool as MDP, App_Client as CL where
				Cl.Net_HostName IN ' + @i_MAList + ' AND Cl.id = MDP.ClientId) '
		EXEC(@SqlQuery)
	END
	ELSE
	BEGIN
		insert into #tmpDrive
		select MD.DriveId, MD.MediaId, Md.DriveName, MD.AliasName, MD.DriveTypeId, MDT.DriveTypeName,
		MD.NumRestoresLifeTime, MD.NumBackupsLifeTime, MD.NumMountsLifeTime, MD.NumSoftErrsSinceClean,
		MD.NumSoftErrsLifeTime, MD.NumHardErrsSinceClean, MD.NumHardErrsLifeTime, MD.MinutesUsedSinceClean,
		MD.MinutesUsedLifeTime, MDT.CleaningDurationSec, MD.LastCleantime, MD.LastServiceTime, MDT.TypeOfDrive,
		MD.DriveTypeId, MDT.DriveTypeName, MD.NumRestoresLifeTime, MD.NumBackupsLifeTime, MD.NumMountsLifeTime,
		MDT.SoftErrsSinceCleanThreshold, MDT.SoftErrsLifeTimeThreshold, MDT.HardErrsSinceCleanThreshold,
		MDT.HardErrsLifeTimeThreshold, MDT.MtsUsedSinceCleanThreshold, MDT.MtsUsedLifeTimeThreshold,
		MDT.CleaningDurationSec, MD.LastCleantime, MD.LastServiceTime, MDT.TypeOfDrive, MD.MasterPoolId,
		0, '', '', MD.DriveVendor, MD.DriveModel, MD.FirmwareRevision, MD.SerialNumber, MD.WWNNumber,
		MD.DriveNumber, MD.DriveBroken, MD.DriveEnabled, MD.CleaningRequired, MD.OfflineReason,
		MD.DriveSoftState, MD.ExternalGUID, MD.Attributes, MD.PrivateData, 0,
		MD.DriveOccupied, MD.SCSIDeviceIdentifier
		from MMDrive AS MD, MMDriveType as MDT
		where MD.DriveTypeId <> 10001 AND MD.DriveId > 0
		AND MD.DriveTypeId = MDT.DriveTypeId
	END
	update #tmpDrive
	set LibraryId = ML.LibraryId, libName = Ml.LibraryName, libAliasName = ML.AliasName
	from MMLibrary as ML, MMMasterPool as MMP
	Where #tmpDrive.MasterPoolId = MMp.MasterPoolId AND MMP.LibraryId = ML.LibraryId
	update #tmpDrive
	set ElementAddress = (MD.DriveNumber + ML.BaseAddress -1)
	from MMDrive as MD, MMMasterPool AS MMP, MMLibrary as ML, #tmpDrive as tt
	where MD.DriveId = tt.DriveId AND MD.MasterPoolId = MMP.MasterPoolId
	AND MMP.LibraryId = ML.LibraryId
	set @l_numItems = (select count(*) from #tmpDrive)
	select driveID, mediaID, drvName, drvAliasName, Values_driveType, Values_driveTypeString,
	Values_numRestoresLifeTime, Values_numBackupsLifeTime, Values_numMountsLifeTime,
	Values_numSoftErrsSinceClean, Values_numSoftErrsLifeTime, Values_numHardErrsSinceClean,
	Values_numHardErrsLifeTime, Values_numMtsUsedSinceClean, Values_numMtsUsedLifeTime,
	Values_CleaningDurationSec, Values_lastCleanTime, Values_lastServiceTime,
	Values_driveCategory, thresholds_driveType, thresholds_driveTypeString,
	thresholds_numRestoresLifeTime, thresholds_numBackupsLifeTime, thresholds_numMountsLifeTime,
	thresholds_numSoftErrsSinceClean, thresholds_numSoftErrsLifeTime, thresholds_numHardErrsSinceClean,
	thresholds_numHardErrsLifeTime, thresholds_numMtsUsedSinceClean, thresholds_numMtsUsedLifeTime,
	thresholds_CleaningDurationSec, thresholds_lastCleanTime, thresholds_lastServiceTime,
	thresholds_driveCategory, MasterPoolId, LibraryId, libName, libAliasName, manufacturer,
	model, description, serialNumber, wwn, driveNumber, drvBroken, drvEnabled, cleaningRequired,
	offlineReason, softState, driveGuid, attribute, privateData, ElementAddress, isOccupied,
	SCSIDeviceIdentifier, @l_numItems
	from #tmpDrive
	drop table #tmpDrive
GO

IF EXISTS (select * from GxQscripts where name = 'MMConfigGetDriveList')
	delete from GxQscripts where name = 'MMConfigGetDriveList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMConfigGetDriveList')
	delete from GXDBVersions where aliasname = 'MMConfigGetDriveList'
GO

insert into GXDBVersions values(2, 'MMConfigGetDriveList',  '00010006029200020000', 'MMConfigGetDriveList', '00010006029200020000')
GO

