

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCollectHistoryData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCollectHistoryData.sp,v $ $Id: MMCollectHistoryData.sp,v 1.1.2.2 2019/01/16 01:47:18 vikashkumar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "MMCollectHistoryData"				|
--	|									|
--	| Execute the System stored procedure to fetch history data				|
--	| .. for the given entity.					|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCollectHistoryData')
BEGIN
	print '>>> Drop Stored Procedure: MMCollectHistoryData <<<'
	drop procedure MMCollectHistoryData
END
IF EXISTS (select * from GxQscripts where name='MMCollectHistoryData')
	delete from GxQscripts where name = 'MMCollectHistoryData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCollectHistoryData')
	delete from GXDBVersions where aliasname = 'MMCollectHistoryData'
GO
print '... Creating Procedure: MMCollectHistoryData'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCollectHistoryData
  @i_historyDataType integer,
  @i_entityId integer
AS
  DECLARE @o_entityId integer = 0
  DECLARE @o_historyCollectTime integer = 0
  DECLARE @o_data bigint = 0
  DECLARE @o_properties nvarchar(255) = ''
/*
enum HistoryDataType {
	mountpath_space_history = 1,
	library_space_history = 2,
	sidb_prune_history_by_hour = 3,
	sidb_prune_history_by_day = 4,
};
*/
DECLARE @lastRunTime int = 0
DECLARE @nextRunTime int = 0
DECLARE @runTimeInterval int = 0
DECLARE @currentTime int = 0
DECLARE @now int = dbo.getUnixTime(GETUTCDATE())
-- When history data type is 0, do collection for all the data type
IF @i_historyDataType = 0  OR @i_historyDataType = 1 OR @i_historyDataType = 2
BEGIN
	SELECT	@nextRunTime = intVal,
			@lastRunTime = longlongVal
	FROM	MMEntityProp WITH (READUNCOMMITTED)
WHERE	EntityId = 1
AND		EntityType = 16
AND		propertyName = 'historycollectiontime'
	SELECT @runTimeInterval = intVal
	FROM	MMEntityProp WITH (READUNCOMMITTED)
WHERE	EntityId = 1
AND		EntityType = 16
AND		propertyName = 'historycollectioninterval'
	IF ((@nextRunTime = 0 AND @lastRunTime != 0)
	OR (@nextRunTime > 0 AND @now < @nextRunTime)
	OR (@lastRunTIme > 0 AND @now < (@lastRunTime + @runTimeInterval * 60 * 60)))
	BEGIN
		GOTO END_OF_COLLECT_LIBRARY_MOUNT_PATH
	END
	EXEC MMS2CheckMountPathsForOutOfSpaceCondition 2, 30, 0
	IF object_id('tempdb.dbo.#MountPathList') is not null
	BEGIN
		IF @i_entityId > 0 AND @i_historyDataType = 1
		BEGIN
			DELETE HistoryDB..MMMountPathSpaceHistory
			WHERE	(DATEDIFF(day, timestamp, @currentTime) > 120
					OR		DATEDIFF(day, timestamp, @currentTime) =  0
					)
			AND		MountPathId = @i_entityId
			INSERT INTO HistoryDB..MMMountPathSpaceHistory
			SELECT @currentTime,
					MountPathId, MountPathName, LibraryId, LibraryName,
					mediaId, MediaSideId, FreeBytesMB, MagneticSpaceRsrvInMB,
					MaxDataToWriteMB, TotalSpaceMB, ValidData
			FROM #MountPathList
			WHERE	MountPathId = @i_entityId
		END
		ELSE
		BEGIN
			DELETE HistoryDB..MMMountPathSpaceHistory
			WHERE	DATEDIFF(day, timestamp, @currentTime) > 120
			OR		DATEDIFF(day, timestamp, @currentTime) =  0
			INSERT INTO HistoryDB..MMMountPathSpaceHistory
			SELECT @currentTime,
					MountPathId, MountPathName, LibraryId, LibraryName,
					mediaId, MediaSideId, FreeBytesMB, MagneticSpaceRsrvInMB,
					MaxDataToWriteMB, TotalSpaceMB, ValidData
			FROM #MountPathList
		END
		DROP TABLE #MountPathList
	END
	IF object_id('tempdb.dbo.#tmpLibList') is not null
	BEGIN
		IF @i_entityId > 0 AND @i_historyDataType = 2
		BEGIN
			DELETE HistoryDB..MMLibrarySpaceHistory
			WHERE	(DATEDIFF(day, timestamp, @currentTime) > 120
						OR		DATEDIFF(day, timestamp, @currentTime) =  0
					)
			AND	LibraryId = @i_entityId
			INSERT INTO HistoryDB..MMLibrarySpaceHistory
			SELECT @currentTime,
					LibraryId, LibraryName, FreespaceMB, LowWaterMarkMB, WarningWaterMarkMB, OutOfSpaceAlertInDays,
					ClientId, ClientName, totalCapMB, DataWrittenMBForAvg, capacityFreedMBForAvg, lastNumDays
			FROM #tmpLibList
			WHERE LibraryId = @i_entityId
			drop table #tmpLibList
		END
		ELSE
		BEGIN
			DELETE HistoryDB..MMLibrarySpaceHistory
			WHERE	DATEDIFF(day, timestamp, @currentTime) > 120
			OR		DATEDIFF(day, timestamp, @currentTime) =  0
			INSERT INTO HistoryDB..MMLibrarySpaceHistory
			SELECT @currentTime,
					LibraryId, LibraryName, FreespaceMB, LowWaterMarkMB, WarningWaterMarkMB, OutOfSpaceAlertInDays,
					ClientId, ClientName, totalCapMB, DataWrittenMBForAvg, capacityFreedMBForAvg, lastNumDays
			FROM #tmpLibList
			drop table #tmpLibList
		END
	END
	IF @nextRunTime > (@lastRunTime + @runTimeInterval * 60 * 60)
	BEGIN
		SET @nextRunTime = (@lastRunTime + @runTimeInterval * 60 * 60)
	END
	ELSE
	BEGIN
		SET @nextRunTime = (@nextRunTime + @runTimeInterval * 60 * 60)
	END
	WHILE (@nextRunTime < @now)
	BEGIN
	    SET @nextRunTime = (@nextRunTime + (@runTimeInterval * 60 * 60))
		CONTINUE
	END
	-- Update the next collection time in entityProp
	UPDATE	MMEntityProp
	SET		intVal = @nextRunTime,
			longlongVal = @now
WHERE	EntityId = 1
AND		EntityType = 16
AND		propertyName = 'historycollectiontime'
END
END_OF_COLLECT_LIBRARY_MOUNT_PATH:
/*
IF @i_historyDataType = 0 OR @i_historyDataType = 3
BEGIN
	-- Data collected in table idxsidbusagehistory with history type 0
END
IF @i_historyDataType = 0  OR @i_historyDataType = 4
BEGIN
	-- Data collected in table idxsidbusagehistory with history type 2
END
*/
CX_EXIT:
	select @o_entityId, @o_historyCollectTime, @o_data, @o_properties
	return;
GO

IF EXISTS (select * from GxQscripts where name = 'MMCollectHistoryData')
	delete from GxQscripts where name = 'MMCollectHistoryData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCollectHistoryData')
	delete from GXDBVersions where aliasname = 'MMCollectHistoryData'
GO

insert into GXDBVersions values(2, 'MMCollectHistoryData',  '00010001000200020000', 'MMCollectHistoryData', '00010001000200020000')
GO

