

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCleanDeletedAF.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCleanDeletedAF.sp,v $ $Id: MMCleanDeletedAF.sp,v 1.1.2.2 2020/02/28 03:15:06 pkrishnan Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCleanDeletedAF')
BEGIN
	print '>>> Drop Stored Procedure: MMCleanDeletedAF <<<'
	drop procedure MMCleanDeletedAF
END
IF EXISTS (select * from GxQscripts where name='MMCleanDeletedAF')
	delete from GxQscripts where name = 'MMCleanDeletedAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCleanDeletedAF')
	delete from GXDBVersions where aliasname = 'MMCleanDeletedAF'
GO
print '... Creating Procedure: MMCleanDeletedAF'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCleanDeletedAF
  @i_dummyId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @errorCode integer;
SET NOCOUNT ON
DECLARE @errVal INTEGER = 0
DECLARE @rowCnt INTEGER  = 0
DECLARE @TotalRowsPruned        INTEGER = 0
SET @errorCode = 0
DECLARE @substoreBits TABLE (SIDBStoreId int, SubStoreId int, subStoreBits int)
DECLARE @storeBits TABLE (SIDBStoreId int, subStoreBits int, allPartitionBits int)
-- Clean up MMDeletedAF for sealed partitions which have 1 or 2 partitions marked as corrupt but not the whole store.
-- We want to cleanup only those rows from the MMDeletedAF which have not been processed by the corrupted partitions only.
-- Other rows should remain there so that phase 1 and phase 2 from online partitions can be done and space reclaimed.
-- Otherwise we have to wait for the entire store to become prunable and macro pruning kick in.
-- Get sealed and corrupted partitions with bits (which are not yet prunable stores)
INSERT INTO @substoreBits
SELECT I.SIDBStoreId, I.SubStoreId, T.subStoreBit
FROM IdxSIDBSubStore I,
(	SELECT SIDBStoreId, SubStoreId, POWER(2, ((ROW_NUMBER() OVER (PARTITION BY SIDBStoreId ORDER BY SubStoreId ASC)) -1)) as subStoreBit
	FROM    IdxSIDBSubStore WITH (READUNCOMMITTED)
	WHERE SealedTime > 0
) T
WHERE I.SIDBStoreId = T.SIDBStoreId
AND I.SubStoreId = T.SubStoreId
AND I.SealedTime > 0
AND I.Status = 1
AND (I.flags & 256) = 0
INSERT INTO @storeBits
SELECT SIDBStoreId, SUM(subStoreBits), 0
FROM @substoreBits
GROUP BY SIDBStoreId
UPDATE @storeBits
SET allPartitionBits = T2.allPartBits
FROM @storeBits T1,
(
SELECT T.SIDBStoreId, SUM(T.SubStoreBit) as allPartBits
FROM
(
	select I.SIDBStoreId, POWER(2, ((ROW_NUMBER() OVER (PARTITION BY I.SIDBStoreId ORDER BY I.SubStoreId ASC)) -1)) as SubStoreBit
	from IdxSIDBSubStore I WITH (READUNCOMMITTED), @storeBits S where I.SIDBStoreId = S.SIDBStoreId
) T
GROUP BY T.SIDBStoreId
) T2
WHERE T1.SIDBStoreId = T2.SIDBStoreId
-- Check what rows in MMDAF for this store are done for other partitions but not for this and cleanup.
-- DELETE FROM MMDeletedAF
WHILE (1=1)
BEGIN
	DELETE TOP (500) D
	FROM MMDeletedAF D
		INNER JOIN @storeBits I ON D.SIDBStoreId = I.SIDBStoreId
	WHERE D.subStoreBitField | I.subStoreBits = I.allPartitionBits
	SELECT @errVal = @@ERROR, @rowCnt = @@ROWCOUNT
	IF @errVal <> 0
	BEGIN
		GOTO FINISH
	END
	IF @rowCnt = 0
	    BREAK
END
FINISH:
SELECT	@errorCode
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMCleanDeletedAF')
	delete from GxQscripts where name = 'MMCleanDeletedAF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCleanDeletedAF')
	delete from GXDBVersions where aliasname = 'MMCleanDeletedAF'
GO

insert into GXDBVersions values(2, 'MMCleanDeletedAF',  '00010001000200020000', 'MMCleanDeletedAF', '00010001000200020000')
GO

