

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCleanArchFileSubStore.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCleanArchFileSubStore.sp,v $ $Id: MMCleanArchFileSubStore.sp,v 1.2.12.2 2019/03/02 03:17:12 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCleanArchFileSubStore')
BEGIN
	print '>>> Drop Stored Procedure: MMCleanArchFileSubStore <<<'
	drop procedure MMCleanArchFileSubStore
END
IF EXISTS (select * from GxQscripts where name='MMCleanArchFileSubStore')
	delete from GxQscripts where name = 'MMCleanArchFileSubStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCleanArchFileSubStore')
	delete from GXDBVersions where aliasname = 'MMCleanArchFileSubStore'
GO
print '... Creating Procedure: MMCleanArchFileSubStore'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCleanArchFileSubStore
  @i_storeId integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @errorCode integer;
SET NOCOUNT ON
DECLARE @errVal INTEGER = 0
DECLARE @rowCnt INTEGER  = 0
DECLARE @TotalRowsPruned        INTEGER = 0
SET @errorCode = 0
DECLARE @maxJobsToPruneInBatch  INTEGER = 2000
SELECT @maxJobsToPruneInBatch = isnull(value, 2000)
FROM mmconfigs
WHERE name = 'DA_CONFIG_MAX_JOB_HISTORIES_TO_PRUNE_IN_BATCH'
IF OBJECT_ID('tempdb.dbo.#tempAFs') IS NOT NULL DROP TABLE #tempAFs
CREATE TABLE #tempAFs ( archFileId int NOT NULL, CommCellID int NOT NULL, SIDBStoreID int NOT NULL)
IF (@i_storeId > 0)
BEGIN
	INSERT INTO #tempAFs
	SELECT  DISTINCT S.archFileId, S.CommCellId, S.SIDBStoreId
	FROM    archFileSubStore S WITH (READUNCOMMITTED) LEFT OUTER JOIN archFileCopyDedup C WITH (READUNCOMMITTED)
                                ON              S.archFileId = C.archFileId
                                                AND S.CommCellid = C.CommCellid
                                                AND S.SIDBStoreId = C.SIDBStoreId
	WHERE   C.archFileID IS NULL
	AND S.SIDBStoreId = @i_storeId
END
ELSE
BEGIN
	INSERT INTO #tempAFs
	SELECT  DISTINCT S.archFileId, S.CommCellId, S.SIDBStoreId
	FROM    archFileSubStore S WITH (READUNCOMMITTED) LEFT OUTER JOIN archFileCopyDedup C WITH (READUNCOMMITTED)
                                ON              S.archFileId = C.archFileId
                                                AND S.CommCellid = C.CommCellid
                                                AND S.SIDBStoreId = C.SIDBStoreId
	WHERE   C.archFileID IS NULL
END
ALTER TABLE #tempAFs ADD PRIMARY KEY (archFileId, SIDBStoreID, CommCellId)
DELETE FROM T
FROM    #tempAFs T INNER JOIN MMDeletedAF D WITH (READUNCOMMITTED)
                                ON              T.archFileId = D.archFileId
                                                -- AND T.CommCellId = D.CommCellId
                                                AND T.SIDBStoreId = D.SIDBStoreId
WHILE (1 = 1)
BEGIN
        DELETE TOP (@maxJobsToPruneInBatch) S
        FROM    archFileSubStore S, #tempAFs T
        WHERE   S.archFileId = T.archFileID
                        AND S.CommCellId = T.CommCellId
                        AND S.SIDBStoreId = T.SIDBStoreId
        SELECT @errVal = @@ERROR,  @rowCnt = @@ROWCOUNT
        IF @errVal <> 0
        BEGIN
                SET @errorCode = @errVal
                BREAK
        END
        IF @rowCnt = 0
                BREAK
        ELSE
                SET @TotalRowsPruned = @TotalRowsPruned + @rowCnt
END
IF OBJECT_ID('tempdb.dbo.#tempAFs') IS NOT NULL DROP TABLE #tempAFs
FINISH:
SELECT	@errorCode
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'MMCleanArchFileSubStore')
	delete from GxQscripts where name = 'MMCleanArchFileSubStore'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCleanArchFileSubStore')
	delete from GXDBVersions where aliasname = 'MMCleanArchFileSubStore'
GO

insert into GXDBVersions values(2, 'MMCleanArchFileSubStore',  '00010002001200020000', 'MMCleanArchFileSubStore', '00010002001200020000')
GO

