

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCheckOnlineMountPathAndMAForPruning.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: anarulkar
--	Date:   03/06/2017
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCheckOnlineMountPathAndMAForPruning.sp,v $ $Id: MMCheckOnlineMountPathAndMAForPruning.sp,v 1.1.2.10 2020/09/30 12:27:26 anarulkar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCheckOnlineMountPathAndMAForPruning')
BEGIN
	print '>>> Drop Stored Procedure: MMCheckOnlineMountPathAndMAForPruning <<<'
	drop procedure MMCheckOnlineMountPathAndMAForPruning
END
IF EXISTS (select * from GxQscripts where name='MMCheckOnlineMountPathAndMAForPruning')
	delete from GxQscripts where name = 'MMCheckOnlineMountPathAndMAForPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckOnlineMountPathAndMAForPruning')
	delete from GXDBVersions where aliasname = 'MMCheckOnlineMountPathAndMAForPruning'
GO
print '... Creating Procedure: MMCheckOnlineMountPathAndMAForPruning'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MMCheckOnlineMountPathAndMAForPruning
  @i_computeNew integer,
  @i_reserve integer
AS
  DECLARE @o_MountPathId INTEGER
  DECLARE @o_MountPathName NVARCHAR(1024)
  DECLARE @o_MountPathTypeId INTEGER
  DECLARE @o_MediaSideId INTEGER
  DECLARE @o_DeviceId INTEGER
  DECLARE @o_UserName varchar(1024)
  DECLARE @o_UserPassword varchar(2048)
  DECLARE @o_Folder varchar(1024)
  DECLARE @o_ClientId INTEGER
  DECLARE @o_rn INTEGER
  DECLARE @o_MPAttribute INTEGER
  DECLARE @o_DCFlags INTEGER
  DECLARE @o_MasterPoolId INTEGER
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @ErrVal INTEGER = 0
DECLARE @RowCount INTEGER = 0
if object_id('tempdb.dbo.#tempMAOpWindow') is not null DROP TABLE #tempMAOpWindow
CREATE TABLE #tempMAOpWindow(
		HostId		INT,
		IsOperationAllowed INT
		)
if object_id('tempdb.dbo.#NoPruningLibrary') is not null DROP TABLE #NoPruningLibrary
CREATE TABLE #NoPruningLibrary(
		LibraryId	INT,
		MountPathId	INT,
		MediaSideId	INT
		)
IF @i_computeNew = 0
	GOTO CX_EXIT
ELSE
BEGIN
	DELETE FROM MMMountPathOnlineStatus
	DELETE FROM MMMountPathToDDBMediaAgent
END
INSERT INTO #NoPruningLibrary
SELECT L.LibraryId, M.MountPathId, M.MediaSideId
FROM MMLibrary L WITH (READUNCOMMITTED), MMMountPath M WITH (READUNCOMMITTED)
WHERE L.LibraryId = M.LibraryId
AND (L.ExtendedAttributes & 1073741824) > 0
INSERT INTO #tempMAOpWindow
SELECT DISTINCT D.ClientId, 0
FROM MMDeviceController D WITH (READUNCOMMITTED)
UPDATE T
SET IsOperationAllowed = dbo.IsOperationAllowed(131072,2,T.HostId,0,0,0,0)
FROM #tempMAOpWindow T
IF OBJECT_ID('tempdb.dbo.#tmpMMMountPathOnlineStatus') IS NOT NULL
DROP TABLE #tmpMMMountPathOnlineStatus
-- Create a temp table exactly in the structure of MMMountPathOnlineStatus
SELECT * INTO #tmpMMMountPathOnlineStatus FROM MMMountPathOnlineStatus where 1 = 0
ALTER TABLE #tmpMMMountPathOnlineStatus ADD credentialAssocId  INTEGER
INSERT INTO #tmpMMMountPathOnlineStatus
SELECT MountPathId, MountPathName, MountPathTypeId, MediaSideId, DeviceId, UserName, UserPassword, Folder, HostClientId,
		ROW_NUMBER() OVER (PARTITION BY MountPathId ORDER BY DeviceControllerId), MPAttribute, DeviceControllerFlags, MasterPoolId,
		0, 0, 0, 0, 0, '', CredentialAssocId
FROM MMMountPathPrunerView
WHERE MountPathTypeId IN (4 /*MOUNT_PATH_SHARED_STATIC*/, 5 /*MOUNT_PATH_SHARED_REPLICA*/, 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/)
AND MPEnabled = 1 AND MPOffline = 0 AND PruningEnabled = 1 AND MPRefreshInProgress = 0 AND DeviceControllerEnabled = 1 AND DeviceAccessible = 1
AND HasPruneAccessType = 1 AND HostOnline = 1 AND PruningOpAllowed = 1
SET @ErrVal = @@ERROR
IF @ErrVal != 0
	GOTO CX_EXIT
DELETE M
FROM #tmpMMMountPathOnlineStatus M
	INNER JOIN #NoPruningLibrary T ON M.MountPathId = T.MountPathId
-- Update user name and password for entries that use credentials
EXEC MMS2GetDeviceControllerCredentials '#tmpMMMountPathOnlineStatus', 'credentialAssocId', 'UserName', 'UserPassword'
SET @ErrVal = @@ERROR
IF @ErrVal != 0
	GOTO CX_EXIT
-- DROP column credentialAssocId before inserting into MMMountPathOnlineStatus
-- as that table wouldn't have this column
ALTER TABLE #tmpMMMountPathOnlineStatus DROP COLUMN credentialAssocId
INSERT INTO MMMountPathOnlineStatus
SELECT * FROM #tmpMMMountPathOnlineStatus
SET @ErrVal = @@ERROR
IF @ErrVal != 0
	GOTO CX_EXIT
IF OBJECT_ID('tempdb.dbo.#tmpMMMountPathOnlineStatus') IS NOT NULL
DROP TABLE #tmpMMMountPathOnlineStatus
-- We have all the online available deviceControllers. Now see if there are any controllers which can be specifically used to prune data for particular DDB.
INSERT INTO MMMountPathToDDBMediaAgent
SELECT distinct M.MountPathId, I.ClientId, I.SIDBStoreId
FROM 	MMMountPathOnlineStatus M WITH (READUNCOMMITTED),
		IdxSIDBSubStore I WITH (READUNCOMMITTED), archCopySIDBStore AC WITH (READUNCOMMITTED),
		MMDataPath D WITH (READUNCOMMITTED), MMDrivePool DP WITH (READUNCOMMITTED)
WHERE I.SIDBStoreID = AC.SIDBStoreId AND I.FirstBackupTime > 0
AND I.flags & 256 = 0
AND I.ClientId = M.HostId
AND AC.copyId = D.CopyId
AND D.DrivePoolId = DP.DrivePoolId
AND M.MasterPoolId = DP.MasterPoolId
AND M.MountPathTypeId <> 7 /*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/-- Device Controller for cloud pruning has to be picked only via useCount check on devCtrl
SET @ErrVal = @@ERROR
IF @ErrVal != 0
	GOTO CX_EXIT
CX_EXIT:
if object_id('tempdb.dbo.#tempMAOpWindow') is not null DROP TABLE #tempMAOpWindow
if object_id('tempdb.dbo.#NoPruningLibrary') is not null DROP TABLE #NoPruningLibrary
IF @ErrVal = 0
BEGIN
	IF OBJECT_ID('tempdb..#tblResult_MMCheckOnlineMountPathAndMAForPruning') IS NOT NULL
		INSERT INTO #tblResult_MMCheckOnlineMountPathAndMAForPruning
		SELECT MountPathId, MountPathName, MountPathTypeId, MediaSideId, DeviceId, UserName, UserPassword, Folder, HostId,
				rn, MPAttribute, DeviceControllerFlags, MasterPoolId
		FROM MMMountPathOnlineStatus WITH (READUNCOMMITTED)
	ELSE
		SELECT MountPathId, MountPathName, MountPathTypeId, MediaSideId, DeviceId, UserName, UserPassword, Folder, HostId,
				rn, MPAttribute, DeviceControllerFlags, MasterPoolId
		FROM MMMountPathOnlineStatus WITH (READUNCOMMITTED)
END
ELSE
BEGIN
	IF OBJECT_ID('tempdb..#tblResult_MMCheckOnlineMountPathAndMAForPruning') IS NOT NULL
		INSERT INTO #tblResult_MMCheckOnlineMountPathAndMAForPruning
		SELECT	@ErrVal, '', 0, 0, 0, '', '', '', 0,
				0, 0, 0, 0
	ELSE
		SELECT	@ErrVal, '', 0, 0, 0, '', '', '', 0,
				0, 0, 0, 0
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MMCheckOnlineMountPathAndMAForPruning')
	delete from GxQscripts where name = 'MMCheckOnlineMountPathAndMAForPruning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckOnlineMountPathAndMAForPruning')
	delete from GXDBVersions where aliasname = 'MMCheckOnlineMountPathAndMAForPruning'
GO

insert into GXDBVersions values(2, 'MMCheckOnlineMountPathAndMAForPruning',  '00010001000200100000', 'MMCheckOnlineMountPathAndMAForPruning', '00010001000200100000')
GO

