

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCheckMPCanDelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCheckMPCanDelete.sp,v $ $Id: MMCheckMPCanDelete.sp,v 1.1.2.7 2020/09/30 21:53:26 jswaminathan Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMCheckMPCanDelete"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='MMCheckMPCanDelete')
BEGIN
	print '>>> Drop Stored Procedure: MMCheckMPCanDelete <<<'
	drop procedure MMCheckMPCanDelete
END
IF EXISTS (select * from GxQscripts where name='MMCheckMPCanDelete')
	delete from GxQscripts where name = 'MMCheckMPCanDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckMPCanDelete')
	delete from GXDBVersions where aliasname = 'MMCheckMPCanDelete'
GO
print '... Creating Procedure: MMCheckMPCanDelete'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCheckMPCanDelete
  @i_MountpathId Integer,
  @i_LibraryId Integer,
  @i_localeId Integer = 0
AS
  DECLARE @o_errorCode INTEGER
  DECLARE @o_errorString VARCHAR(MAX)
  DECLARE @o_JobsListXML XML
  DECLARE @o_SIDBListXML XML
DECLARE @errorCode INTEGER = 0
DECLARE @JobsListXML XML = ''
DECLARE @SIDBListXML XML = ''
DECLARE @errorString VARCHAR(MAX) = ''
DECLARE @MountPathId  INTEGER = 0
DECLARE @MountPaths TABLE(MountPathId INTEGER, isControllerAccessible INTEGER)
IF @i_MountpathId = 0
BEGIN
	INSERT INTO @MountPaths
	SELECT MountPathId, 0 FROM MMMountPath WITH(NOLOCK) WHERE LibraryId = @i_LibraryId
END
ELSE
BEGIN
	INSERT INTO @MountPaths
	SELECT @i_MountpathId, 0
END
IF NOT EXISTS(SELECT 1 FROM @MountPaths)
BEGIN
	GOTO EXIT1
END
-- Check for valid jobs
DECLARE @jobsList TABLE(jobId INTEGER)
INSERT INTO @jobsList
SELECT DISTINCT ACM.jobId FROM archChunk AC WITH(NOLOCK)
INNER JOIN MMVolume MV WITH(NOLOCK) ON MV.VolumeId = AC.volumeId AND (AC.flags & 256) = 0 AND (AC.physicalSize <> 0 OR AC.logicalSize <> 0)
INNER JOIN archChunkMapping ACM WITH(NOLOCK) ON ACM.archChunkId = AC.id AND ACM.chunkCommCellId = AC.commCellId
INNER JOIN MMMountpath MP WITH(NOLOCK) ON MP.MediaSideId = MV.MediaSideId
INNER JOIN @MountPaths TMP ON TMP.MountPathId = MP.MountPathId
IF EXISTS(SELECT TOP 1 1 FROM @jobsList)
BEGIN
	SET @JobsListXML = (select DISTINCT JobId from @jobsList FOR XML PATH(''))
SET @errorCode = @errorCode | 2
END
-- Check for worm data
IF ( (@errorCode & 2) > 0 AND
	EXISTS (SELECT top 1 1 FROM @MountPaths TMP
	INNER JOIN MMMountPath MP WITH (NOLOCK) ON TMP.MountPathId = MP.MountPathId
	INNER JOIN MMVolume MV WITH (NOLOCK) ON MV.MediaSideId = MP.MediaSideId
	INNER JOIN archStream ASM WITH (NOLOCK)ON MV.MediaGroupId = ASM.mediaGroupId
INNER JOIN archGroupCopy AGC WITH (NOLOCK) ON ASM.archGroupCopyId = AGC.id AND (AGC.flags & 16777216)  > 0)
	)
BEGIN
SET @errorCode = @errorCode | 4 | 8
	GOTO EXIT1
END
-- Check for SIDB association, otherwise valid data error is good enough
IF OBJECT_ID('tempdb..#SingleInstancedResultTable') IS NOT NULL DROP TABLE #SingleInstancedResultTable
CREATE TABLE #SingleInstancedResultTable (isSingleInstanced INTEGER, StoreList XML, reserveField INTEGER)
DECLARE mp_cursor CURSOR FOR
SELECT MountPathId
FROM @MountPaths
OPEN mp_cursor
FETCH NEXT FROM mp_cursor
INTO @MountPathId
WHILE @@FETCH_STATUS = 0
BEGIN
	EXEC MMIsMountPathSingleInstanced @MountPathId, 0
	IF EXISTS(SELECT 1 FROM #SingleInstancedResultTable WHERE isSingleInstanced = 1)
	BEGIN
		SELECT TOP 1 @SIDBListXML = StoreList from #SingleInstancedResultTable
SET @errorCode = @errorCode | 2
		BREAK
	END
    ELSE
	BEGIN
		FETCH NEXT FROM mp_cursor
		INTO @MountPathId
    END
END
CLOSE mp_cursor;
DEALLOCATE mp_cursor;
-- Check for subclient dump
IF EXISTS(SELECT 1 FROM APP_SubclientToMountpathMapping SCM WITH (READUNCOMMITTED)
			INNER JOIN @MountPaths TMP ON SCM.mountPathId = TMP.MountpathId)
BEGIN
SET @errorCode = @errorCode | 2
END
-- Check for online device controllers
DECLARE @DeviceControllersTempTable TABLE(MountPathId INTEGER, DeviceControllerId INTEGER, clientId INTEGER)
INSERT INTO @DeviceControllersTempTable
SELECT DISTINCT TMP.MountPathId, MDC.DeviceControllerId, MDC.clientId
FROM @MountPaths TMP
INNER JOIN MMMountPathToStorageDevice MP2SD WITH(NOLOCK) ON MP2SD.MountPathId = TMP.MountpathId
INNER JOIN MMDeviceController MDC WITH(NOLOCK) ON MDC.DeviceId = MP2SD.DeviceId
INNER JOIN MMHost MH WITH(NOLOCK) ON MH.ClientId = MDC.ClientId
WHERE MDC.DeviceAccessible = 1 AND MDC.DeviceControllerEnabled = 1 AND MH.MmHostEnabled = 1 AND MH.MmHostSoftState = 1
AND (MDC.DeviceAccessType & 2) = 2
AND (MDC.DeviceAccessType & ( 16 | 32 | 128)) = 0
IF NOT EXISTS( SELECT 1 FROM @DeviceControllersTempTable )
BEGIN
SET @errorCode = @errorCode | 1
END
-- if MP has data then only need check MA version for physical cleanup of volumes
if ((@errorCode & 2) > 0)
BEGIN
	-- Check for MediaAgent support for physical cleanup
	DELETE TMP
	FROM @DeviceControllersTempTable TMP
	INNER JOIN APP_Client CL WITH(NOLOCK) ON CL.id = TMP.clientId
INNER JOIN simInstalledPackages SIM WITH(NOLOCK) ON CL.id = SIM.ClientId AND SIM.simPackageID IN ( 51,1301 )
WHERE CL.releaseId < 16 OR (CL.releaseId = 16 AND SIM.HighestSP < 21)
END
UPDATE TMP
SET isControllerAccessible = 1
FROM @MountPaths TMP
INNER JOIN @DeviceControllersTempTable TDC ON TMP.MountPathId = TDC.MountPathId
IF EXISTS( SELECT 1 FROM @MountPaths WHERE isControllerAccessible = 0)
BEGIN
SET @errorCode = @errorCode | 1
END
-- For Hyperscale MountPath force delete not supported, so it has any data then send force delete not supported error.
IF EXISTS(SELECT 1 FROM MMMountPath MP WITH(NOLOCK)
INNER JOIN @MountPaths TMP ON MP.MountPathId = TMP.MountpathId AND (MP.Attribute & 64) > 0)
BEGIN
SET @errorCode = @errorCode | 1
END
EXIT1:
	IF @errorCode > 0
	BEGIN
		DECLARE @outMsgStr VARCHAR(MAX) = ''
IF ((@errorCode & 4) > 0)
		BEGIN
IF ((@errorCode & 8) > 0)
			BEGIN
SELECT @outMsgStr = message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (3045 | (CAST(POWER(2, 24) AS BIGINT) * 62)) and localeId = @i_localeId
				SET @errorString = @errorString + @outMsgStr + '<br>';
			END
SELECT @outMsgStr = message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (3044 | (CAST(POWER(2, 24) AS BIGINT) * 62)) and localeId = @i_localeId
			SET @errorString = REPLACE(@outMsgStr, '^1%s', @errorString)
		END
		ELSE
		BEGIN
if ((@errorCode & 2) > 0)
			BEGIN
SELECT @outMsgStr = message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (3024 | (CAST(POWER(2, 24) AS BIGINT) * 62)) and localeId = @i_localeId
				SET @errorString = @errorString + @outMsgStr + '<br>';
			END
if ((@errorCode & 1) > 0)
			BEGIN
SELECT @outMsgStr = message FROM EvLocaleMsgs WITH(READUNCOMMITTED) WHERE messageId = (3021 | (CAST(POWER(2, 24) AS BIGINT) * 62)) and localeId = @i_localeId
				SET @errorString = @errorString + @outMsgStr + '<br>';
			END
		END
	END
EXIT2:
IF object_id('tempdb.dbo.#tempMMCheckMPCanDeleteTbl') IS NOT null
BEGIN -- if output temp table is present, populate result
	INSERT INTO #tempMMCheckMPCanDeleteTbl
	select @errorCode, @errorString, @JobsListXML, @SIDBListXML
END
ELSE
BEGIN
	select @errorCode, @errorString, @JobsListXML, @SIDBListXML
END
IF OBJECT_ID('tempdb..#SingleInstancedResultTable') IS NOT NULL DROP TABLE #SingleInstancedResultTable
GO

IF EXISTS (select * from GxQscripts where name = 'MMCheckMPCanDelete')
	delete from GxQscripts where name = 'MMCheckMPCanDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckMPCanDelete')
	delete from GXDBVersions where aliasname = 'MMCheckMPCanDelete'
GO

insert into GXDBVersions values(2, 'MMCheckMPCanDelete',  '00010001000200070000', 'MMCheckMPCanDelete', '00010001000200070000')
GO

