

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCheckJobsRunningToCloudMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCheckJobsRunningToCloudMA.sp,v $ $Id: MMCheckJobsRunningToCloudMA.sp,v 1.1.2.6 2018/05/29 06:58:04 prasanthm Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMCheckJobsRunningToCloudMA"               				|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
This will check and return VM can power off.
0- VM can power off
1 - VM can not power off
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMCheckJobsRunningToCloudMA <<<'

IF EXISTS (select * from sysobjects where name='MMCheckJobsRunningToCloudMA')
	drop procedure MMCheckJobsRunningToCloudMA
IF EXISTS (select * from GxQscripts where name='MMCheckJobsRunningToCloudMA')
	delete from GxQscripts where name = 'MMCheckJobsRunningToCloudMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckJobsRunningToCloudMA')
	delete from GXDBVersions where aliasname = 'MMCheckJobsRunningToCloudMA'
GO
print '... Creating Procedure: MMCheckJobsRunningToCloudMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCheckJobsRunningToCloudMA
  @i_HostId Integer
AS
  DECLARE @o_JobsRunning INTEGER
  DECLARE @o_listOfJobs VARCHAR(MAX)
DECLARE @JobsRunning INTEGER = 0
DECLARE @JobsListTbl TABLE(JobId INTEGER)
DECLARE @sJobsList VARCHAR(MAX) = ''
-- state  STOPPED = 5 (suspended jobs)
INSERT INTO @JobsListTbl
	SELECT DISTINCT JMI.JobId FROM JMJobInfo JMI WITH (NOLOCK)
INNER JOIN MMPowerMgmtJobToVMMap PH WITH (NOLOCK) ON PH.EntityId = JMI.JobId AND PH.EntityCommCellId = JMI.commCellId AND PH.EntityType = 1 AND JMI.state <> 5
					INNER JOIN MMHost MH WITH (NOLOCK) ON MH.clientId = PH.HostId
WHERE (MH.Attribute & 32768) = 32768 AND MH.ClientId = @i_HostId
SELECT @JobsRunning = COUNT(*) FROM @JobsListTbl
IF @JobsRunning > 0
BEGIN
	SELECT @sJobsList = @sJobsList + CONVERT(VARCHAR(100), JobId) + ',' FROM @JobsListTbl
	SELECT @sJobsList = LEFT(@sJobsList, LEN(@sJobsList) - 1)
END
SELECT @JobsRunning, @sJobsList
GO

IF EXISTS (select * from GxQscripts where name = 'MMCheckJobsRunningToCloudMA')
	delete from GxQscripts where name = 'MMCheckJobsRunningToCloudMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckJobsRunningToCloudMA')
	delete from GXDBVersions where aliasname = 'MMCheckJobsRunningToCloudMA'
GO

insert into GXDBVersions values(2, 'MMCheckJobsRunningToCloudMA',  '00010001000200060000', 'MMCheckJobsRunningToCloudMA', '00010001000200060000')
GO

