

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCheckIsPruningTimeForCloudVM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCheckIsPruningTimeForCloudVM.sp,v $ $Id: MMCheckIsPruningTimeForCloudVM.sp,v 1.1.2.4 2018/03/19 23:59:14 jiechen Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"MMCheckIsPruningTimeForCloudVM"               	|
--  |       Author	    :	prasanthm                            			|
--  | Execute the System stored procedure to fetch the physical files   	|
--  | .. for the (current) database.                    					|
--  +-----------------------------------------------------------------------+
/*
This will check pruning is on process right now.
*/
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMCheckIsPruningTimeForCloudVM <<<'

IF EXISTS (select * from sysobjects where name='MMCheckIsPruningTimeForCloudVM')
	drop procedure MMCheckIsPruningTimeForCloudVM
IF EXISTS (select * from GxQscripts where name='MMCheckIsPruningTimeForCloudVM')
	delete from GxQscripts where name = 'MMCheckIsPruningTimeForCloudVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckIsPruningTimeForCloudVM')
	delete from GXDBVersions where aliasname = 'MMCheckIsPruningTimeForCloudVM'
GO
print '... Creating Procedure: MMCheckIsPruningTimeForCloudVM'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCheckIsPruningTimeForCloudVM
  @i_HostId INTEGER,
  @i_IdleTime INTEGER
AS
  DECLARE @o_isPruningTime INTEGER
  DECLARE @o_minsToPruningComplete INTEGER
DECLARE @returnCode INTEGER = 0
DECLARE @minsToPruningComplete INTEGER = 0
DECLARE @PruningStartTimeInSec INTEGER
DECLARE @PruningEndTimeInSec INTEGER
DECLARE @CurrentUnixDate BIGINT
-- Checking Pruning interval set by user in GUI
SELECT @CurrentUnixDate = dbo.GETUNIXTIME(CONVERT(date,GETUTCDATE()))
SELECT @PruningStartTimeInSec = CAST(attrVal AS INTEGER) FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @i_HostId AND attrName = 'Cloud VM Managment Pruning Start Time'
SELECT @PruningEndTimeInSec = CAST(attrVal AS INTEGER) FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @i_HostId AND attrName = 'Cloud VM Managment Pruning End Time'
IF (dbo.GetUnixTime(CURRENT_TIMESTAMP) > (@CurrentUnixDate + @PruningStartTimeInSec - (@i_IdleTime * 60))) AND
	(dbo.GetUnixTime(CURRENT_TIMESTAMP) < (@CurrentUnixDate + @PruningEndTimeInSec + (@i_IdleTime * 60)))
BEGIN
	SET @returnCode = 1
	SET @minsToPruningComplete = (((@CurrentUnixDate + @PruningEndTimeInSec) - dbo.GetUnixTime(CURRENT_TIMESTAMP)) / 60) + @i_IdleTime
END
IF OBJECT_ID('tempdb.dbo.#CloudVMMgmtPruningTimeCheck') IS NOT NULL
	INSERT INTO #CloudVMMgmtPruningTimeCheck SELECT @returnCode, @minsToPruningComplete
ELSE
	SELECT @returnCode, @minsToPruningComplete
RETURN @minsToPruningComplete
GO

IF EXISTS (select * from GxQscripts where name = 'MMCheckIsPruningTimeForCloudVM')
	delete from GxQscripts where name = 'MMCheckIsPruningTimeForCloudVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckIsPruningTimeForCloudVM')
	delete from GXDBVersions where aliasname = 'MMCheckIsPruningTimeForCloudVM'
GO

insert into GXDBVersions values(2, 'MMCheckIsPruningTimeForCloudVM',  '00010001000200040000', 'MMCheckIsPruningTimeForCloudVM', '00010001000200040000')
GO

