

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCheckForDRRestoreEvent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMCheckForDRRestoreEvent <<<'

IF EXISTS (select * from sysobjects where name='MMCheckForDRRestoreEvent')
	drop procedure MMCheckForDRRestoreEvent
IF EXISTS (select * from GxQscripts where name='MMCheckForDRRestoreEvent')
	delete from GxQscripts where name = 'MMCheckForDRRestoreEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckForDRRestoreEvent')
	delete from GXDBVersions where aliasname = 'MMCheckForDRRestoreEvent'
GO
print '... Creating Procedure: MMCheckForDRRestoreEvent'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCheckForDRRestoreEvent
AS
  DECLARE @DRRestoreDetected INT
  DECLARE @LastRestoreInMSDB INT
  DECLARE @LastRestoreInCSDB INT
  DECLARE @LastRestoreInMSDBText NVARCHAR(64)
  DECLARE @LastRestoreInCSDBText NVARCHAR(64)
  DECLARE @LastChunkCreationTime INT
  DECLARE @LastChunkCreationTimeText NVARCHAR(64)
  DECLARE @GxGlobalParamStubbed INT
  DECLARE @DRBackupAgeInSecs INT
  DECLARE @DBMirroringDetected INT
  DECLARE @FailoverToStandby INT
SELECT TOP 1 @LastRestoreInMSDB = dbo.GetUnixTime(restore_date)
FROM MSDB..restoreHistory
WHERE destination_database_name = 'Commserv'
-- Verify only restores dont change any data on the DB. It would be a false alarm to put stores in maintenance for that.
AND restore_type <> 'V'
ORDER BY restore_date DESC
DECLARE @LastRestoreInMSDBStandby INT
SELECT TOP 1 @LastRestoreInMSDBStandby = dbo.GetUnixTime(restore_date)
FROM MSDB..restoreHistory
WHERE destination_database_name = 'Commserv_Standby'
-- Verify only restores dont change any data on the DB. It would be a false alarm to put stores in maintenance for that.
AND restore_type <> 'V'
ORDER BY restore_date DESC
-- If there is no standby database now (ie it is renamed to Commserv),
-- and the standby database is latest compared to Commserv,
-- then pick up standby database.
IF DB_ID ('Commserv_Standby') IS NULL AND ISNULL(@LastRestoreInMSDBStandby, 0) > ISNULL(@LastRestoreInMSDB, 0)
BEGIN
	SET @LastRestoreInMSDB = @LastRestoreInMSDBStandby
	SET @FailoverToStandby = 1
END
ELSE
	SET @FailoverToStandby = 0
SELECT @LastRestoreInCSDB = CONVERT(INT, value)
FROM GxGlobalParam
WHERE name = 'LastRestoreInCSDB' --change this into a macro
SET @DRRestoreDetected = 0
SET @GxGlobalParamStubbed = 0
SET @DBMirroringDetected = 0
IF @LastRestoreInMSDB IS NOT NULL
BEGIN
	IF @LastRestoreInCSDB IS NOT NULL
	BEGIN
		--Rather than checking for inequality, check if MSDB has a restore time later than that recorded in CSDB.
		--If there was a DR restore, MSDB is likely to have a restore timestamp later than that recorded in CSDB.
		--This is to suppress false alarm when failing over to a standby CommServe (esp. Database Mirroring).
		--The standby CommServe's MSDB will most probably have a different timestamp. But for cases like Mirroring,
		--this should not be counted as a DR restore which we will if we base detection on inequality.
		--IF @LastRestoreInCSDB <> @LastRestoreInMSDB
		IF @LastRestoreInMSDB > @LastRestoreInCSDB
		BEGIN
			IF EXISTS (SELECT * from sys.database_mirroring WHERE database_id = DB_ID()
							AND mirroring_role_sequence IS NOT NULL)
			BEGIN
				-- Case 0: Mirroring is configured. So, ignore this.
				-- We cannot prevent a false alarm in this case 100% - sys.database_mirroring table
				-- will not have a valid row when mirroring relation is broken. There is nothing we can do
				-- about that case.
				SET @DRRestoreDetected = 0
				SET @DBMirroringDetected = 1
			END
			ELSE IF EXISTS (SELECT * from sys.databases WHERE database_id = DB_ID()
							AND group_database_id IS NOT NULL)
			BEGIN
				-- Case 0.1. CSDB is replicated in an AlwaysOn availability group.
				-- Do not treat this as a DR restore for the same reason as database mirroring.
				SET @DRRestoreDetected = 0
				SET @DBMirroringDetected = 2
			END
			ELSE
			BEGIN
				-- Case 1: There was a DR restore detected
				-- DR restore event will be cleared after marking DDBs for resync, so that if there is a failure, the next service start can pick it up:
				SET @DRRestoreDetected = 1
			END
		END
	END
	ELSE
	BEGIN
		-- Case 2: There is no reference in CSDB
		-- LastRestoreInCSDB will be NULL only between the time resyncDDBs update is installed and services are started
		-- the first time this code is executed, we are ignore all restoreHistory entries as past occurrences
		-- and update CSDB to the time of latest restore event
		SET @DRRestoreDetected = 0
		INSERT INTO GXGlobalParam (name, value, created, modified)
		VALUES ('LastRestoreInCSDB', CONVERT(NVARCHAR(64), @LastRestoreInMSDB), dbo.GetUnixTime(CURRENT_TIMESTAMP), 0)
		SET @GxGlobalParamStubbed = 1
	END
END
ELSE
BEGIN
	-- Case 3: There are no DR restores yet
	-- Record this in CSDB so that the first DR restore will be detected
	SET @DRRestoreDetected = 0
	IF EXISTS (SELECT * FROM GXGlobalParam WHERE name = 'LastRestoreInCSDB')
	BEGIN
		UPDATE GXGlobalParam
		SET value = '0', modified = dbo.GetUnixTime(CURRENT_TIMESTAMP)
		WHERE name = 'LastRestoreInCSDB'
	END
	ELSE
	BEGIN
		INSERT INTO GXGlobalParam (name, value, created, modified)
		VALUES ('LastRestoreInCSDB', '0', dbo.GetUnixTime(CURRENT_TIMESTAMP), 0)
	END
	SET @GxGlobalParamStubbed = 1
	GOTO CX_EXIT
END
CX_EXIT:
	-- we return time as string to make troubleshooting easier - there would be no need for epoch conversion, time zone translation, etc
	SET @LastRestoreInMSDBText = CONVERT (NVARCHAR(64), DATEADD(second, @LastRestoreInMSDB, CAST('1970-01-01 00:00:00' AS DATETIME)))
	SET @LastRestoreInCSDBText = CONVERT (NVARCHAR(64), DATEADD(second, @LastRestoreInCSDB, CAST('1970-01-01 00:00:00' AS DATETIME)))
	SET @DRBackupAgeInSecs = 0
	IF @DRRestoreDetected = 1
	BEGIN
		SET @LastChunkCreationTime = ISNULL ((SELECT TOP 1 CreateTime FROM ArchChunk WHERE CommcellId = 2 ORDER BY id DESC), 0)
		SET @LastChunkCreationTimeText = CONVERT (NVARCHAR(64), dbo.GetDateTime (@LastChunkCreationTime))
		SET @DRBackupAgeInSecs = dbo.GetUnixTime(GETUTCDATE())-@LastChunkCreationTime
		IF NOT EXISTS (SELECT * FROM GXGlobalParam WHERE name = 'RestoredDRBackupAgeInSecs')
			INSERT INTO GXGlobalParam (name, value, created, modified)
			VALUES ('RestoredDRBackupAgeInSecs', CONVERT(NVARCHAR(64), @DRBackupAgeInSecs), dbo.GetUnixTime(CURRENT_TIMESTAMP), 0)
		ELSE
			UPDATE GXGlobalParam
			SET value = CONVERT(NVARCHAR(64), @DRBackupAgeInSecs), modified = dbo.GetUnixTime(CURRENT_TIMESTAMP)
			WHERE name = 'RestoredDRBackupAgeInSecs'
		SELECT @DRRestoreDetected, @LastRestoreInMSDB, @LastRestoreInCSDB, @LastRestoreInMSDBText, @LastRestoreInCSDBText,
			   @LastChunkCreationTime, @LastChunkCreationTimeText, @GxGlobalParamStubbed, @DRBackupAgeInSecs,
			   @DBMirroringDetected, @FailoverToStandby
	END
	ELSE
	BEGIN
		SELECT @DRRestoreDetected, @LastRestoreInMSDB, @LastRestoreInCSDB, @LastRestoreInMSDBText, @LastRestoreInCSDBText,
			   0, '', @GxGlobalParamStubbed, @DRBackupAgeInSecs, @DBMirroringDetected, @FailoverToStandby
	END
GO

IF EXISTS (select * from GxQscripts where name = 'MMCheckForDRRestoreEvent')
	delete from GxQscripts where name = 'MMCheckForDRRestoreEvent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckForDRRestoreEvent')
	delete from GXDBVersions where aliasname = 'MMCheckForDRRestoreEvent'
GO

insert into GXDBVersions values(2, 'MMCheckForDRRestoreEvent',  '00000000000000000000', 'MMCheckForDRRestoreEvent', '00000000000000000000')
GO

