

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MMCheckEntityAction.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MMCheckEntityAction.sp,v $ $Id: MMCheckEntityAction.sp,v 1.1.2.7 2018/06/21 03:46:28 rsivadas Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MMCheckEntityAction <<<'

IF EXISTS (select * from sysobjects where name='MMCheckEntityAction')
	drop procedure MMCheckEntityAction
IF EXISTS (select * from GxQscripts where name='MMCheckEntityAction')
	delete from GxQscripts where name = 'MMCheckEntityAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckEntityAction')
	delete from GXDBVersions where aliasname = 'MMCheckEntityAction'
GO
print '... Creating Procedure: MMCheckEntityAction'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MMCheckEntityAction
AS
  DECLARE @o_errorCode INT				= 0
  DECLARE @o_errorMsg VARCHAR(2048)	= ''
SET NOCOUNT ON
BEGIN TRANSACTION;
declare @EntityId int
declare @EntityString1 varchar(max)
declare @EntityString2 varchar(max)
declare @opMsgId int
declare @userId int = 1
declare @opEvMsgId int
declare @auditID int
DECLARE	@nowTime        INTEGER			= dbo.GetUnixTime (GetUTCdate())
BEGIN TRY
IF EXISTS (SELECT 1 FROM MMEntityAction WITH(READUNCOMMITTED) WHERE UNCEnableTime < @nowTime)
BEGIN
--------Bring MA out of maintenance mode
	if (object_id('tempdb.dbo.#ExpiredEntityActions') is not null) drop table #ExpiredEntityActions
	create table #ExpiredEntityActions (EntityId int, EntityString1 varchar(max), EntityString2 varchar(max))
UPDATE  MH SET attribute = attribute ^ 16
	OUTPUT	ME.EntityId, AC.name INTO #ExpiredEntityActions(EntityId, EntityString1)
    FROM    MMHost(nolock) MH
    JOIN    MMEntityAction(nolock) ME ON ME.EntityId = MH.ClientId
	join	APP_Client(nolock) AC on AC.id = MH.ClientId
    WHERE   UNCEnableTime > 0 AND UNCEnableTime < @nowTime
AND     EntityType = 10
AND     OperationType = 16
AND     attribute & 16 > 0
	declare cur cursor local for
		select EntityId, EntityString1, EntityString2
		from #ExpiredEntityActions
	open cur
	fetch next from cur into @EntityId, @EntityString1, @EntityString2
	while @@FETCH_STATUS = 0
	begin
set @opMsgId= (122 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		exec EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId output, @auditID output
set @opMsgId=(195 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		exec EvGuiAuditSetParamData @auditID, @EntityString1, @userId
		exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId
set @opMsgId=(832 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId
		fetch next from cur into @EntityId, @EntityString1, @EntityString2
	end
	close cur
	deallocate cur
	delete from #ExpiredEntityActions
--------Enable Pruning for SIDB Store
UPDATE  SS SET flags = flags ^ 536870912
	OUTPUT	ME.EntityId, INSERTED.SIDBStoreName INTO #ExpiredEntityActions(EntityId, EntityString1)
    FROM    IdxSIDBStore SS WITH(READUNCOMMITTED)
    JOIN    MMEntityAction ME WITH(READUNCOMMITTED) ON ME.EntityId = SS.SIDBStoreId
    WHERE   UNCEnableTime > 0 AND UNCEnableTime < @nowTime
AND     EntityType = 3
AND     OperationType = 536870912
AND     flags & 536870912 <> 536870912
	declare cur cursor local for
		select EntityId, EntityString1, EntityString2
		from #ExpiredEntityActions
	open cur
	fetch next from cur into @EntityId, @EntityString1, @EntityString2
	while @@FETCH_STATUS = 0
	begin
set @opMsgId= (444 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		exec EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId output, @auditID output
set @opMsgId=(1174 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		exec EvGuiAuditSetParamData @auditID, @EntityString1, @userId
		exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId
		fetch next from cur into @EntityId, @EntityString1, @EntityString2
	end
	close cur
	deallocate cur
	delete from #ExpiredEntityActions
--------Enable Data Aging For Copy
UPDATE  AAR SET flags = AAR.flags ^ 4
	OUTPUT	ME.EntityId, AG.name, AGC.name INTO #ExpiredEntityActions(EntityId, EntityString1, EntityString2)
    FROM    archAgingRule(nolock) AAR
    JOIN    MMEntityAction(nolock) ME ON ME.EntityId = AAR.copyId
	JOIN	archGroupCopy(nolock) AGC on AGC.id = AAR.copyid
	JOIN	archGroup(nolock) AG on AG.id = AGC.archGroupId
    WHERE   UNCEnableTime > 0 AND UNCEnableTime < @nowTime
AND     EntityType = 2
AND     OperationType = 4
AND     AAR.flags & 4 = 4
	declare cur cursor local for
		select EntityId, EntityString1, EntityString2
		from #ExpiredEntityActions
	open cur
	fetch next from cur into @EntityId, @EntityString1, @EntityString2
	while @@FETCH_STATUS = 0
	begin
set @opMsgId=(14 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		exec EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId output, @auditID output
set @opMsgId=(26 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		exec EvGuiAuditSetParamData @auditID, @EntityString1, @userId
		exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId
set @opMsgId=(27 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		exec EvGuiAuditSetParamData @auditID, @EntityString2, @userId
		exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId
set @opMsgId=(60 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		exec EvGuiAuditSetParameter @auditID, @opMsgId, @userId
		fetch next from cur into @EntityId, @EntityString1, @EntityString2
	end
	close cur
	deallocate cur
	delete from #ExpiredEntityActions
--------Clean Up Table
	DELETE 	FROM MMEntityAction
	WHERE 	UNCEnableTime > 0 AND UNCEnableTime < @nowTime
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @o_errorCode	= ERROR_NUMBER()
    SET @o_errorMsg		= ERROR_MESSAGE()
END CATCH
PROC_EXIT:
IF @o_errorCode <> 0
BEGIN
    ROLLBACK TRANSACTION
END
ELSE
BEGIN
    COMMIT TRANSACTION
END
SELECT 	@o_errorCode 	AS errorCode,
		@o_errorMsg 	AS errorString;
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'MMCheckEntityAction')
	delete from GxQscripts where name = 'MMCheckEntityAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MMCheckEntityAction')
	delete from GXDBVersions where aliasname = 'MMCheckEntityAction'
GO

insert into GXDBVersions values(2, 'MMCheckEntityAction',  '00010001000200070000', 'MMCheckEntityAction', '00010001000200070000')
GO

